/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.Comparators;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.text.PluralRules;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.SupplementalDataInfo;

public class WritePluralRules {
    private static final Comparator<PluralRules> PLURAL_RULES_COMPARATOR = Comparator.comparing(r -> r.getKeywords().size()).thenComparing(PluralRules::getKeywords, Comparators.lexicographical(Comparator.naturalOrder())).thenComparing(Object::toString);
    static SupplementalDataInfo sInfo = CLDRConfig.getInstance().getSupplementalDataInfo();
    static Map<String, Integer> HACK_ORDER_PLURALS = new HashMap<String, Integer>();
    static Map<String, Integer> HACK_ORDER_ORDINALS = new HashMap<String, Integer>();

    public static void main(String[] args) {
        Relation<PluralRules, String> rulesToLocales = Relation.of(new TreeMap(PLURAL_RULES_COMPARATOR), TreeSet.class);
        for (String locale : sInfo.getPluralLocales(SupplementalDataInfo.PluralType.cardinal)) {
            if (locale.equals("root")) continue;
            PluralRules rules = WritePluralRules.forLocale(locale);
            rulesToLocales.put(rules, locale);
        }
        System.out.println(WritePluralRules.formatPluralHeader(SupplementalDataInfo.PluralType.cardinal, "WritePluralRules"));
        TreeSet<Map.Entry<PluralRules, Set<String>>> sorted = new TreeSet<Map.Entry<PluralRules, Set<String>>>(new HackComparator());
        sorted.addAll(rulesToLocales.keyValuesSet());
        for (Map.Entry<PluralRules, Set<String>> entry : sorted) {
            PluralRules rules = entry.getKey();
            Set<String> values = entry.getValue();
            System.out.println(WritePluralRules.formatPluralRuleHeader(values));
            for (String keyword : rules.getKeywords()) {
                String rule = rules.getRules(keyword);
                if (rule == null) continue;
                System.out.println(WritePluralRules.formatPluralRule(keyword, rule, "", false));
            }
            System.out.println(WritePluralRules.formatPluralRuleFooter());
        }
        System.out.println(WritePluralRules.formatPluralFooter());
    }

    public static String formatPluralRuleFooter() {
        return "        </pluralRules>";
    }

    public static String formatPluralRule(String keyword, String rule, String samples, boolean newLine) {
        if (rule == null) {
            rule = "";
        } else {
            PluralRules rules = PluralRules.createRules(keyword + ":" + rule);
            rule = rules.getRules(keyword);
        }
        if (newLine) {
            rule = "\n                " + rule;
            samples = samples.replace("\t@", "\n                @");
        }
        String result = "            <pluralRule count=\"" + keyword + "\">" + rule + samples.replace('\t', ' ') + (newLine ? "\n            " : "") + "</pluralRule>";
        return result;
    }

    public static String formatPluralRuleHeader(Set<String> values) {
        String locales = Joiner.on(" ").join(values);
        String result = "        <pluralRules locales=\"" + locales + "\">";
        return result;
    }

    public static String formatPluralFooter() {
        return "    </plurals>\n</supplementalData>";
    }

    public static String formatPluralHeader(SupplementalDataInfo.PluralType type, String filename) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE supplementalData SYSTEM \"../../common/dtd/ldmlSupplemental.dtd\">\n<!--\n" + CldrUtility.getCopyrightString() + "\n-->\n<supplementalData>\n    <version number=\"$Revision$\"/>\n    <plurals type=\"" + (Object)((Object)type) + "\">\n        <!-- For a canonicalized list, use " + filename + " -->\n";
    }

    static PluralRules forLocale(String locale) {
        PluralRules override = null;
        return override != null ? override : sInfo.getPlurals(locale).getPluralRules();
    }

    static class HackComparator
    implements Comparator<Map.Entry<PluralRules, Set<String>>> {
        HackComparator() {
        }

        @Override
        public int compare(Map.Entry<PluralRules, Set<String>> o1, Map.Entry<PluralRules, Set<String>> o2) {
            Integer firstLocale1 = HACK_ORDER_PLURALS.get(o1.getValue().iterator().next());
            Integer firstLocale2 = HACK_ORDER_PLURALS.get(o2.getValue().iterator().next());
            if (firstLocale1 != null) {
                if (firstLocale2 != null) {
                    return firstLocale1 - firstLocale2;
                }
                return -1;
            }
            if (firstLocale2 != null) {
                return 1;
            }
            return PLURAL_RULES_COMPARATOR.compare(o1.getKey(), o2.getKey());
        }
    }
}

