/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.Multimap;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.util.TimeZone;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.util.SupplementalDataInfo;

public class Containment {
    private static final SupplementalDataInfo supplementalData = SupplementalDataInfo.getInstance();
    static final Relation<String, String> containmentCore = supplementalData.getContainmentCore();
    static final Set<String> continents = containmentCore.get("001");
    static final Set<String> subcontinents;
    static final Relation<String, String> containmentFull;
    static final Relation<String, String> containedToContainer;
    static final Relation<String, String> leavesToContainers;
    static final Relation<String, String> containedToContainerCore;
    static final Map<String, Integer> toOrder;
    static int level;
    static int order;

    public static String getRegionFromZone(String tzid) {
        if ("Etc/Unknown".equals(tzid)) {
            return "001";
        }
        try {
            return TimeZone.getRegion(tzid);
        }
        catch (IllegalArgumentException e) {
            return "ZZ";
        }
    }

    private static void addLeaves(String s2, Set<String> target, Set<String> nonLeaf) {
        Set<String> contained = supplementalData.getContained(s2);
        if (contained == null) {
            return;
        }
        for (String child : contained) {
            if (!nonLeaf.contains(child)) {
                target.add(child);
                continue;
            }
            Containment.addLeaves(child, target, nonLeaf);
        }
    }

    public static String getContainer(String territory) {
        Set<String> containers = containedToContainerCore.get(territory);
        if (containers == null) {
            containers = containedToContainer.get(territory);
        }
        String container = containers != null ? containers.iterator().next() : (territory.equals("001") ? "001" : "ZZ");
        return container;
    }

    public static Set<String> getContainers(String territory) {
        return containedToContainer.get(territory);
    }

    public static String getContinent(String territory) {
        while (!(territory == null || territory.equals("001") || territory.equals("ZZ") || continents.contains(territory))) {
            String newTerritory = Containment.getContainer(territory);
            if (newTerritory == null) {
                return territory;
            }
            territory = newTerritory;
        }
        return territory;
    }

    public static String getSubcontinent(String territory) {
        while (!(territory.equals("001") || territory.equals("ZZ") || continents.contains(territory) || subcontinents.contains(territory))) {
            territory = Containment.getContainer(territory);
        }
        return territory;
    }

    public static int getOrder(String territory) {
        Integer temp = toOrder.get(territory);
        return temp != null ? temp : level;
    }

    private static void initOrder(String territory) {
        Set<String> contained;
        if (!toOrder.containsKey(territory)) {
            toOrder.put(territory, ++level);
        }
        if ((contained = containmentFull.get(territory)) == null) {
            return;
        }
        for (String subitem : contained) {
            if (toOrder.containsKey(subitem)) continue;
            toOrder.put(subitem, ++level);
        }
        for (String subitem : contained) {
            Containment.initOrder(subitem);
        }
    }

    private static void resetOrder(String newTerritory, String oldTerritory) {
        Integer oldOrder = toOrder.get(oldTerritory);
        if (oldOrder == null) {
            throw new IllegalArgumentException(oldTerritory + " not yet defined");
        }
        toOrder.put(newTerritory, oldOrder);
    }

    public Set<String> getContinents() {
        return continents;
    }

    public Set<String> getSubontinents() {
        return subcontinents;
    }

    public static Set<List<String>> getAllDirected(Multimap<String, String> multimap, String lang) {
        LinkedHashSet<List<String>> result = new LinkedHashSet<List<String>>();
        Containment.getAllDirected(multimap, lang, new ArrayList<String>(), result);
        return result;
    }

    private static void getAllDirected(Multimap<String, String> multimap, String lang, ArrayList<String> target, Set<List<String>> targets) {
        target.add(lang);
        Collection<String> parents = multimap.get(lang);
        int size = parents.size();
        if (size == 0) {
            targets.add(target);
        } else if (size == 1) {
            for (String parent : parents) {
                Containment.getAllDirected(multimap, parent, target, targets);
            }
        } else {
            for (String parent : parents) {
                Containment.getAllDirected(multimap, parent, (ArrayList)target.clone(), targets);
            }
        }
    }

    public static Set<String> leafToContainer(String leaf) {
        return leavesToContainers.get(leaf);
    }

    public static boolean isLeaf(String region) {
        return leavesToContainers.containsKey(region);
    }

    static {
        LinkedHashSet<String> temp = new LinkedHashSet<String>();
        for (String continent : continents) {
            temp.addAll(containmentCore.get(continent));
        }
        subcontinents = Collections.unmodifiableSet(temp);
        containmentFull = supplementalData.getTerritoryToContained();
        containedToContainer = Relation.of(new HashMap(), HashSet.class).addAllInverted(containmentFull).freeze();
        leavesToContainers = Relation.of(new HashMap(), HashSet.class);
        Set<String> containers = supplementalData.getContainers();
        for (String s2 : containers) {
            HashSet<String> leaves = new HashSet<String>();
            Containment.addLeaves(s2, leaves, containers);
            leavesToContainers.putAll(leaves, s2);
        }
        leavesToContainers.freeze();
        containedToContainerCore = Relation.of(new HashMap(), HashSet.class).addAllInverted(containmentCore).freeze();
        toOrder = new LinkedHashMap<String, Integer>();
        level = 0;
        Containment.initOrder("001");
        Containment.resetOrder("003", "021");
        Containment.resetOrder("419", "005");
        Containment.resetOrder("CY", "BH");
    }
}

