/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.UnicodeSet;
import java.io.File;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.draft.ScriptMetadata;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.GrammarInfo;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.PreferredAndAllowedHour;
import org.unicode.cldr.util.SupplementalDataInfo;

public class CoreCoverageInfo {
    private static final CLDRConfig config = CLDRConfig.getInstance();
    private static final String CLDR_BASE_DIRECTORY = config.getCldrBaseDirectory().toString();
    private static final SupplementalDataInfo sdi = SupplementalDataInfo.getInstance();
    private static final LikelySubtags ls = new LikelySubtags();
    static UnicodeSet RTL = new UnicodeSet("[[:bc=R:][:bc=AL:]]").freeze();
    private static final String[][] ROMANIZATION_PATHS = new String[][]{{"", "-Latin"}, {"", "-Latin-BGN"}, {"Latin-", ""}};
    private static final Relation SCRIPT_NAMES = Relation.of(new HashMap(), HashSet.class);
    private static final Relation<SpecialDir, String> SPECIAL_FILES;

    public static Set<CoreItems> getCoreCoverageInfo(CLDRFile file, Multimap<CoreItems, String> detailedErrors) {
        Set<String> territories;
        detailedErrors.clear();
        if (file.isResolved()) {
            file = file.getUnresolved();
        }
        String locale = file.getLocaleID();
        LanguageTagParser ltp = new LanguageTagParser();
        locale = ltp.set(locale).getLanguageScript();
        String baseLanguage = ltp.getLanguage();
        String script = ltp.getScript();
        String region = ltp.getRegion();
        EnumSet<CoreItems> result = EnumSet.noneOf(CoreItems.class);
        UnicodeSet main = file.getExemplarSet(CLDRFile.ExemplarType.main, null);
        boolean isRtl = main.containsSome(RTL);
        String path = "//ldml/layout/orientation/characterOrder";
        String value = file.getStringValue(path);
        if ("right-to-left".equals(value) == isRtl) {
            result.add(CoreItems.orientation);
        } else {
            detailedErrors.put(CoreItems.orientation, path);
        }
        if (sdi.getPluralLocales(SupplementalDataInfo.PluralType.cardinal).contains(baseLanguage)) {
            result.add(CoreItems.plurals);
        } else {
            detailedErrors.put(CoreItems.plurals, "//supplementalData/plurals[@type=\"cardinal\"]/pluralRules[@locales=\"" + locale + "\"]/pluralRule[@count=\"other\"]");
        }
        if (sdi.getPluralLocales(SupplementalDataInfo.PluralType.ordinal).contains(baseLanguage)) {
            result.add(CoreItems.ordinals);
        } else {
            detailedErrors.put(CoreItems.ordinals, "//supplementalData/plurals[@type=\"ordinal\"]/pluralRules[@locales=\"" + locale + "\"]/pluralRule[@count=\"other\"]");
        }
        String defaultContent = sdi.getDefaultContentLocale(locale);
        if (defaultContent != null || locale.equals("no")) {
            result.add(CoreItems.default_content);
        } else {
            detailedErrors.put(CoreItems.default_content, "//supplementalData/supplementalMetadata/defaultContent");
        }
        String max = ls.maximize(locale);
        String maxLangScript = null;
        if (max != null) {
            ltp.set(max);
            maxLangScript = ltp.getLanguageScript();
            script = ltp.getScript();
            region = ltp.getRegion();
            if (!script.isEmpty() && !region.isEmpty()) {
                result.add(CoreItems.likely_subtags);
            }
        }
        if (!result.contains((Object)CoreItems.likely_subtags)) {
            detailedErrors.put(CoreItems.likely_subtags, "//supplementalData/likelySubtags");
        }
        if ((territories = sdi.getTerritoriesForPopulationData(locale)) == null) {
            territories = sdi.getTerritoriesForPopulationData(baseLanguage);
        }
        if (territories == null && maxLangScript != null) {
            territories = sdi.getTerritoriesForPopulationData(maxLangScript);
        }
        if (territories != null && territories.size() != 0) {
            result.add(CoreItems.country_data);
        } else {
            detailedErrors.put(CoreItems.country_data, "//supplementalData/territoryInfo");
            sdi.getTerritoriesForPopulationData(locale);
        }
        if (script.equals("Latn")) {
            result.add(CoreItems.romanization);
        } else {
            boolean found = false;
            Set<String> scriptNames = CoreCoverageInfo.getScriptNames(script);
            LinkedHashSet<String> tempErrors = new LinkedHashSet<String>();
            block0: for (String scriptName : scriptNames) {
                for (String[] pair : ROMANIZATION_PATHS) {
                    String filename = pair[0] + scriptName + pair[1];
                    if (CoreCoverageInfo.hasFile(SpecialDir.transforms, filename)) {
                        result.add(CoreItems.romanization);
                        found = true;
                        continue block0;
                    }
                    tempErrors.add(script);
                }
            }
            if (!found) {
                detailedErrors.put(CoreItems.romanization, "//supplementalData/transforms/transform[@source=\"und-" + script + "\"][@target=\"und-Latn\"]");
            }
        }
        ScriptMetadata.Info scriptData = ScriptMetadata.getInfo(script);
        if (scriptData.hasCase == ScriptMetadata.Trinary.YES) {
            if (CoreCoverageInfo.hasFile(SpecialDir.casing, baseLanguage)) {
                result.add(CoreItems.casing);
            } else {
                detailedErrors.put(CoreItems.casing, "//ldml/metadata/casingData/casingItem[@type=\"*\"]");
            }
        } else {
            result.add(CoreItems.casing);
        }
        if (CoreCoverageInfo.hasFile(SpecialDir.collation, baseLanguage)) {
            result.add(CoreItems.collation);
        } else {
            detailedErrors.put(CoreItems.collation, "//ldml/collations/collation[@type=\"standard\"]");
        }
        Map<String, PreferredAndAllowedHour> timeData = sdi.getTimeData();
        if (timeData.get(region) != null) {
            result.add(CoreItems.time_cycle);
        } else {
            detailedErrors.put(CoreItems.time_cycle, "//supplementalData/timeData/hours");
        }
        GrammarInfo grammarInfo = sdi.getGrammarInfo(locale);
        if (grammarInfo != null) {
            result.add(CoreItems.grammar);
        } else {
            detailedErrors.put(CoreItems.grammar, "//supplementalData/grammaticalData/grammaticalFeatures");
        }
        return ImmutableSet.copyOf(result);
    }

    private static Set<String> getScriptNames(String script) {
        Set<String> result = SCRIPT_NAMES.get(script);
        if (result != null) {
            return result;
        }
        result = new HashSet<String>();
        String name = UScript.getName(UScript.getCodeFromName(script));
        result.add(name);
        result.add(script);
        return result;
    }

    private static boolean hasFile(SpecialDir type, String filename) {
        return SPECIAL_FILES.get((Object)type).contains(filename);
    }

    static {
        SCRIPT_NAMES.putAll("Arab", Arrays.asList("Arabic", "Arab"));
        SCRIPT_NAMES.putAll("Jpan", Arrays.asList("Jpan", "Han"));
        SCRIPT_NAMES.putAll("Hant", Arrays.asList("Hant", "Han"));
        SCRIPT_NAMES.putAll("Hans", Arrays.asList("Hans", "Han"));
        SCRIPT_NAMES.putAll("Kore", Arrays.asList("Hang", "Hangul"));
        SCRIPT_NAMES.freeze();
        SPECIAL_FILES = Relation.of(new EnumMap(SpecialDir.class), HashSet.class);
        for (SpecialDir dir : SpecialDir.values()) {
            File realDir = new File(CLDR_BASE_DIRECTORY + "/common/" + (Object)((Object)dir));
            for (String s2 : realDir.list()) {
                if (s2.endsWith(".xml")) {
                    s2 = s2.substring(0, s2.length() - 4);
                }
                SPECIAL_FILES.put(dir, s2);
            }
        }
    }

    private static enum SpecialDir {
        transforms,
        collation,
        casing;

    }

    public static enum CoreItems {
        default_content(Level.CORE),
        likely_subtags(Level.CORE),
        country_data(Level.CORE),
        orientation(Level.CORE),
        time_cycle(Level.CORE),
        casing(Level.MODERATE),
        plurals(Level.MODERATE),
        ordinals(Level.MODERATE),
        collation(Level.MODERATE),
        grammar(Level.MODERN),
        romanization(Level.MODERN);

        public static Set<CoreItems> ONLY_RECOMMENDED;
        public static final int COUNT;
        public final Level desiredLevel;

        private CoreItems(Level desiredLevel) {
            this.desiredLevel = desiredLevel;
        }

        private CoreItems() {
            this(Level.CORE);
        }

        public String toString() {
            return this.desiredLevel.getAbbreviation() + "\u00a0" + this.name();
        }

        static {
            ONLY_RECOMMENDED = ImmutableSet.copyOf(EnumSet.of(romanization, ordinals));
            COUNT = CoreItems.values().length;
        }
    }
}

