/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.util.ULocale;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.DayPeriods;
import org.unicode.cldr.util.DayPeriodsOld;
import org.unicode.cldr.util.LanguageGroup;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.StandardCodes;

public class DayPeriodsCheck {
    private static final int HOUR = 3600000;
    static boolean html = false;
    static final Comparator<Enum<?>> ENUM_COMPARATOR = new Comparator<Enum<?>>(){

        @Override
        public int compare(Enum<?> o1, Enum<?> o2) {
            return o1.ordinal() - o2.ordinal();
        }
    };

    public static void main(String[] args) {
        LinkedHashSet<ULocale> localesToCheck = new LinkedHashSet<ULocale>();
        if (args.length == 0) {
            args = new String[]{"groups"};
        }
        html = false;
        block14: for (String arg : args) {
            localesToCheck.clear();
            switch (arg) {
                case "groups": {
                    Level level;
                    StandardCodes sc = StandardCodes.make();
                    CLDRFile english = CLDRConfig.getInstance().getEnglish();
                    english.getName(LanguageGroup.uralic.iso);
                    for (LanguageGroup group : LanguageGroup.values()) {
                        System.out.println((Object)((Object)group) + "\t" + group.iso + "\t" + english.getName(group.iso));
                    }
                    for (LanguageGroup group : LanguageGroup.values()) {
                        for (ULocale loc : LanguageGroup.getLocales(group)) {
                            Level level2 = sc.getLocaleCoverageLevel("cldr", loc.toString());
                            System.out.println((Object)((Object)group) + "\t" + loc + "\t" + loc.getDisplayLanguage(ULocale.ENGLISH) + "\t" + (Object)((Object)level2));
                        }
                    }
                    TreeSet<ULocale> missing = new TreeSet<ULocale>();
                    for (String s2 : CLDRConfig.getInstance().getCldrFactory().getAvailableLanguages()) {
                        ULocale loc = new ULocale(s2);
                        ULocale uLocale = loc = loc.getScript().isEmpty() ? loc : new ULocale(loc.getLanguage());
                        if (LanguageGroup.getExplicit().contains(loc)) continue;
                        missing.add(loc);
                    }
                    for (ULocale loc : missing) {
                        level = sc.getLocaleCoverageLevel("cldr", loc.toString());
                        if (level == Level.UNDETERMINED) continue;
                        System.out.println("?\t" + loc + "\t" + loc.getDisplayLanguage(ULocale.ENGLISH) + "\t" + (Object)((Object)level));
                    }
                    for (ULocale loc : missing) {
                        level = sc.getLocaleCoverageLevel("cldr", loc.toString());
                        if (level != Level.UNDETERMINED || "root".equals(loc.toString())) continue;
                        System.out.println("?\t" + loc + "\t" + loc.getDisplayLanguage(ULocale.ENGLISH) + "\t" + (Object)((Object)level));
                    }
                    continue block14;
                }
                case "chart": {
                    DayPeriods dayPeriods;
                    localesToCheck.addAll(DayPeriods.getAvailable());
                    localesToCheck.add(new ULocale("en-Arab"));
                    localesToCheck.add(new ULocale("und"));
                    for (ULocale locale : localesToCheck) {
                        dayPeriods = DayPeriods.getInstance(locale);
                        if (dayPeriods == null) {
                            System.out.println("No data for locale; not supported");
                            continue;
                        }
                        System.out.print(locale.getDisplayName(ULocale.ENGLISH));
                        for (int i = 0; i < 86400000; i += 3600000) {
                            DayPeriods.DayPeriod dayPeriod = dayPeriods.get(i);
                            System.out.print("\t" + (Object)((Object)dayPeriod));
                        }
                        System.out.println();
                    }
                    continue block14;
                }
                case "diff": {
                    DayPeriods dayPeriods;
                    for (ULocale locale : DayPeriods.getAvailable()) {
                        dayPeriods = DayPeriods.getInstance(locale);
                        DayPeriodsOld dayPeriodsOld = DayPeriodsOld.getInstance(locale);
                        System.out.println(locale.getDisplayName(ULocale.ENGLISH));
                        for (int i = 0; i < 86400000; i += 3600000) {
                            DayPeriods.DayPeriod dayPeriod = dayPeriods.get(i);
                            DayPeriodsOld.DayPeriod dayPeriodOld = dayPeriodsOld.get(i);
                            String sampleOld = dayPeriodsOld.getSample(dayPeriodOld);
                            String sample = dayPeriods.getSample(dayPeriod);
                            boolean needLn = false;
                            if (!dayPeriodOld.toString().equals(dayPeriod.toString())) {
                                System.out.print(locale + "\t" + i / 3600000 + "..\t" + (Object)((Object)dayPeriodOld) + " \u2192 " + (Object)((Object)dayPeriod));
                                needLn = true;
                                if (!sampleOld.equals(sample)) {
                                    System.out.print("\t\t" + sampleOld + "\t\u2192\t" + sample);
                                } else {
                                    System.out.print("\t\t" + sample);
                                }
                            } else if (!sampleOld.equals(sample)) {
                                System.out.print(locale + "\t" + i / 3600000 + "..\t" + (Object)((Object)dayPeriod) + "\t\t" + sampleOld + "\t\u2192\t" + sample);
                                needLn = true;
                            }
                            if (!needLn) continue;
                            System.out.println();
                        }
                    }
                    continue block14;
                }
                case "html": {
                    html = true;
                    System.out.println("<table border=\"1\" bordercolor=\"#888\" cellspacing=\"0\" style=\"border-collapse: collapse; border-color: rgb(136, 136, 136); border-width: 1px;\">\n<tbody>");
                }
                case "list": {
                    DayPeriods dayPeriods;
                    localesToCheck.addAll(DayPeriods.getAvailable());
                    for (ULocale locale : localesToCheck) {
                        dayPeriods = DayPeriods.getInstance(locale);
                        if (html) {
                            System.out.println("<tr><th>" + (Object)((Object)LanguageGroup.get(locale)) + "</th><th colSpan='2'><h4>" + locale.getDisplayName(ULocale.ENGLISH) + " (" + locale + ")</h4></tr></th></tr>");
                        } else {
                            System.out.println((Object)((Object)LanguageGroup.get(locale)) + "\t" + locale.getDisplayName(ULocale.ENGLISH) + "\t(" + locale + ")");
                        }
                        int start = 0;
                        DayPeriods.DayPeriod lastDayPeriod = dayPeriods.get(start * 3600000);
                        for (int i = 1; i < 24; ++i) {
                            DayPeriods.DayPeriod dayPeriod = dayPeriods.get(i * 3600000);
                            if (dayPeriod == lastDayPeriod) continue;
                            DayPeriodsCheck.show(locale, start, i - 1, dayPeriods, lastDayPeriod);
                            lastDayPeriod = dayPeriod;
                            start = i;
                        }
                        DayPeriodsCheck.show(locale, start, 23, dayPeriods, lastDayPeriod);
                    }
                    if (!html) continue block14;
                    System.out.println("</tbody>\n</table>");
                }
            }
        }
    }

    private static void show(ULocale locale, int start, int limit, DayPeriods dayPeriods, DayPeriods.DayPeriod dayPeriod) {
        if (html) {
            System.out.println("<tr><td>" + DayPeriodsCheck.format(start) + ":00 \u2013 " + DayPeriodsCheck.format(limit) + ":59</td><td>" + (Object)((Object)dayPeriod) + "</td><td>" + dayPeriods.getSample(dayPeriod) + "</td></tr>");
        } else {
            System.out.println("||" + (Object)((Object)LanguageGroup.get(locale)) + "||" + locale.getDisplayName(ULocale.ENGLISH) + "||" + locale + "||" + (Object)((Object)dayPeriod) + "||" + start + ":00 \u2013 " + limit + ":59||" + dayPeriods.getSample(dayPeriod) + "||");
        }
    }

    private static String format(int start) {
        return start < 10 ? "0" + start : "" + start;
    }
}

