/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Freezable;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MapComparator<K>
implements Comparator<K>,
Freezable<MapComparator<K>> {
    private Map<K, Integer> ordering = new TreeMap<K, Integer>();
    private List<K> rankToName = new ArrayList<K>();
    private boolean errorOnMissing = true;
    private volatile boolean locked = false;
    private int before = 1;
    private boolean fallback = true;
    private static final UnicodeSet numbers = new UnicodeSet("[\\-0-9.]").freeze();

    public boolean isErrorOnMissing() {
        return this.errorOnMissing;
    }

    public MapComparator<K> setErrorOnMissing(boolean errorOnMissing) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.errorOnMissing = errorOnMissing;
        return this;
    }

    public boolean isSortBeforeOthers() {
        return this.before == 1;
    }

    public MapComparator<K> setSortBeforeOthers(boolean sortBeforeOthers) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.before = sortBeforeOthers ? 1 : -1;
        return this;
    }

    public boolean isDoFallback() {
        return this.fallback;
    }

    public MapComparator<K> setDoFallback(boolean doNumeric) {
        if (this.locked) {
            throw new UnsupportedOperationException("Attempt to modify locked object");
        }
        this.fallback = doNumeric;
        return this;
    }

    public List<K> getOrder() {
        return Collections.unmodifiableList(this.rankToName);
    }

    public MapComparator() {
    }

    public MapComparator(K[] data) {
        this.add(data);
    }

    public MapComparator(Collection<K> c) {
        this.add(c);
    }

    public MapComparator<K> add(K newObject) {
        Integer already = this.ordering.get(newObject);
        if (already == null) {
            if (this.locked) {
                throw new UnsupportedOperationException("Attempt to modify locked object");
            }
            this.ordering.put(newObject, new Integer(this.rankToName.size()));
            this.rankToName.add(newObject);
        }
        return this;
    }

    public Integer getNumericOrder(K object) {
        return this.ordering.get(object);
    }

    public MapComparator<K> add(Collection<K> c) {
        Iterator<K> it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
        return this;
    }

    public MapComparator<K> add(K ... data) {
        for (int i = 0; i < data.length; ++i) {
            this.add(data[i]);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compare(K a, K b) {
        boolean bnumeric;
        Integer aa = this.ordering.get(a);
        Integer bb = this.ordering.get(b);
        if (aa != null && bb != null) {
            return aa.compareTo(bb);
        }
        if (this.errorOnMissing) {
            throw new IllegalArgumentException("Missing Map Comparator value(s): " + a.toString() + "(" + aa + "),\t" + b.toString() + "(" + bb + "),\t");
        }
        if (aa == null && bb != null) {
            return this.before;
        }
        if (aa != null && bb == null) {
            return -this.before;
        }
        if (!this.fallback) {
            return 0;
        }
        boolean anumeric = numbers.containsAll((String)a);
        double an = Double.NaN;
        double bn = Double.NaN;
        if (anumeric) {
            try {
                an = Double.parseDouble((String)a);
            }
            catch (NumberFormatException e) {
                anumeric = false;
            }
        }
        if (bnumeric = numbers.containsAll((String)b)) {
            try {
                bn = Double.parseDouble((String)b);
            }
            catch (NumberFormatException e) {
                bnumeric = false;
            }
        }
        if (anumeric && bnumeric) {
            if (an < bn) {
                return -1;
            }
            if (!(an > bn)) return 0;
            return 1;
        }
        if (!anumeric && bnumeric) {
            return 1;
        }
        if (anumeric && !bnumeric) {
            return -1;
        }
        if (!(a instanceof CharSequence)) return -1;
        if (!(b instanceof CharSequence)) return 1;
        int result = CollatorHelper.UCA.compare(a.toString(), b.toString());
        if (result == 0) return ((Comparable)a).compareTo(b);
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        boolean isFirst = true;
        for (K key : this.rankToName) {
            if (isFirst) {
                isFirst = false;
            } else {
                buffer.append(" ");
            }
            buffer.append("<").append(key).append(">");
        }
        return buffer.toString();
    }

    @Override
    public boolean isFrozen() {
        return this.locked;
    }

    @Override
    public MapComparator<K> freeze() {
        this.locked = true;
        return this;
    }

    @Override
    public MapComparator<K> cloneAsThawed() {
        try {
            MapComparator result = (MapComparator)super.clone();
            result.locked = false;
            result.ordering = (Map)((TreeMap)this.ordering).clone();
            result.rankToName = (List)((ArrayList)this.rankToName).clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("should never happen");
        }
    }

    public int getOrdering(K item) {
        Integer result = this.ordering.get(item);
        return result == null ? -1 : result;
    }

    private static final class CollatorHelper {
        public static final Collator UCA = CollatorHelper.getUCA();

        private CollatorHelper() {
        }

        private static Collator getUCA() {
            RuleBasedCollator newUca = (RuleBasedCollator)Collator.getInstance(ULocale.ROOT);
            newUca.setNumericCollation(true);
            return newUca.freeze();
        }
    }
}

