/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.util.LocaleNormalizer;
import org.unicode.cldr.util.LocaleSet;
import org.unicode.cldr.util.StandardCodes;

public enum Organization {
    adlam("Winden Jangen Adlam", new String[0]),
    adobe("Adobe", new String[0]),
    afghan_csa("Afghan CSA", new String[0]),
    afghan_mcit("Afghan MCIT", new String[0]),
    afrigen("Afrigen", new String[0]),
    apple("Apple", new String[0]),
    bangladesh("Bangladesh", "Bangladesh Computer Council"),
    bangor_univ("Bangor Univ.", new String[0]),
    bhutan("Bhutan DDC", new String[0]),
    breton("Office of Breton Lang", new String[0]),
    cherokee("Cherokee Nation", new String[0]),
    cldr("Cldr", new String[0]),
    facebook("Facebook", new String[0]),
    gaeilge("Foras na Gaeilge", new String[0]),
    georgia_isi("Georgia ISI", new String[0]),
    gnome("Gnome Foundation", new String[0]),
    google("Google", new String[0]),
    guest("Guest (Unicode)", new String[0]),
    ibm("IBM", new String[0]),
    india("India MIT", new String[0]),
    iran_hci("Iran HCI", new String[0]),
    kendra("Kendra (Nepal)", new String[0]),
    kotoistus("Kotoistus (Finnish IT Ctr)", new String[0]),
    kunsill_malti("Il-Kunsill Nazzjonali tal-Ilsien Malti", "National Council for the Maltese Language", "malta", "malti"),
    lakota_lc("Lakota LC", new String[0]),
    lao_dpt("Lao Posts/Telecom??", new String[0]),
    longnow("The Long Now Foundation", "Long Now", "PanLex", "Utilka Foundation"),
    microsoft("Microsoft", new String[0]),
    mozilla("Mozilla", new String[0]),
    netflix("Netflix", new String[0]),
    nyiakeng_puachue_hmong("Nyiakeng Puachue Hmong", new String[0]),
    openinstitute("Open Inst (Cambodia)", new String[0]),
    openoffice_org("Open Office", new String[0]),
    oracle("Oracle", "sun", "Sun Micro"),
    pakistan("Pakistan", new String[0]),
    rodakych("Rodakych", "Nigerian Pidgin"),
    rohingyazuban("Rohingya Language Council", "RLC", "Rohingya Zuban"),
    rumantscha("Lia Rumantscha", new String[0]),
    sardware("Sardware", "Sardware"),
    sil("SIL", "SIL International"),
    srilanka("Sri Lanka ICTA", "Sri Lanka"),
    surveytool("Survey Tool", new String[0]),
    welsh_lc("Welsh LC", new String[0]),
    wikimedia("Wikimedia Foundation", new String[0]),
    yahoo("Yahoo", new String[0]);

    public final String displayName;
    private final String[] names;
    static Map<String, Organization> OrganizationNameMap;
    private LocaleSet localeSet = null;

    public static Organization fromString(String name) {
        if (name == null) {
            throw new NullPointerException("Organization.fromString(null) called");
        }
        if (name.contains("Government of Pakistan")) {
            return pakistan;
        }
        if (name.contains("Utilika")) {
            return longnow;
        }
        name = name.toLowerCase().replace('-', '_').replace('.', '_');
        Organization org = OrganizationNameMap.get(name);
        return org;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    private Organization(String displayName, String ... names) {
        this.displayName = displayName;
        this.names = names;
    }

    public LocaleSet getCoveredLocales() {
        if (this.localeSet == null) {
            Set<String> localeNameSet = StandardCodes.make().getLocaleCoverageLocales(this);
            this.localeSet = localeNameSet.contains("*") ? LocaleNormalizer.ALL_LOCALES_SET : new LocaleSet(localeNameSet);
        }
        return this.localeSet;
    }

    static {
        OrganizationNameMap = new HashMap<String, Organization>();
        for (Organization x : Organization.values()) {
            OrganizationNameMap.put(x.displayName.toLowerCase().replace('-', '_').replace('.', '_'), x);
            for (String name : x.names) {
                OrganizationNameMap.put(name.toLowerCase().replace('-', '_').replace('.', '_'), x);
            }
            OrganizationNameMap.put(x.name().toLowerCase().replace('-', '_').replace('.', '_'), x);
        }
    }
}

