/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.DisplayAndInputProcessor;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.LocaleSet;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.VettingViewer;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class VoteResolver<T> {
    private static final boolean DEBUG = false;
    private static String NO_WINNING_VALUE = "no-winning-value";
    public static final int HIGH_BAR = Level.access$000(Level.tc);
    public static final int LOWER_BAR = 2 * Level.access$000(Level.vetter);
    private static Map<Integer, VoterInfo> voterToInfo;
    private static TreeMap<String, Map<Organization, Level>> localeToOrganizationToMaxVote;
    private T winningValue;
    private T oValue;
    private T nValue;
    private List<T> valuesWithSameVotes = new ArrayList<T>();
    private Counter<T> totals = null;
    private Status winningStatus;
    private EnumSet<Organization> conflictedOrganizations = EnumSet.noneOf(Organization.class);
    private OrganizationToValueAndVote<T> organizationToValueAndVote = new OrganizationToValueAndVote();
    private T baselineValue;
    private Status baselineStatus;
    private boolean resolved;
    private boolean valueIsLocked;
    private int requiredVotes = 0;
    private SupplementalDataInfo supplementalDataInfo = SupplementalDataInfo.getInstance();
    private CLDRLocale locale;
    private PathHeader pathHeader;
    private boolean usingKeywordAnnotationVoting = false;
    private static final Collator englishCollator;
    private final Comparator<T> objectCollator = new Comparator<T>(){

        @Override
        public int compare(T o1, T o2) {
            return englishCollator.compare(String.valueOf(o1), String.valueOf(o2));
        }
    };
    private int maxcounter = 100;
    private Set<T> values = new TreeSet<T>(this.objectCollator);
    private final Comparator<T> votesThenUcaCollator = new Comparator<T>(){

        @Override
        public int compare(T o1, T o2) {
            long v2;
            long v1 = VoteResolver.this.organizationToValueAndVote.totalVotes.get(o1);
            if (v1 != (v2 = VoteResolver.this.organizationToValueAndVote.totalVotes.get(o2))) {
                return v1 < v2 ? 1 : -1;
            }
            if (o1.equals(VoteResolver.this.baselineValue)) {
                return -1;
            }
            if (o2.equals(VoteResolver.this.baselineValue)) {
                return 1;
            }
            if (o1.equals(CldrUtility.INHERITANCE_MARKER)) {
                return -1;
            }
            if (o2.equals(CldrUtility.INHERITANCE_MARKER)) {
                return 1;
            }
            return englishCollator.compare(String.valueOf(o1), String.valueOf(o2));
        }
    };
    private boolean bothInheritanceAndBaileyHadVotes = false;

    public void setBaseline(T baselineValue, Status baselineStatus) {
        this.baselineValue = baselineValue;
        this.baselineStatus = baselineValue == null ? Status.missing : baselineStatus;
    }

    public T getBaselineValue() {
        return this.baselineValue;
    }

    public Status getBaselineStatus() {
        return this.baselineStatus;
    }

    public void setLocale(CLDRLocale locale, PathHeader pathHeader) {
        this.locale = locale;
        this.pathHeader = pathHeader;
    }

    public int getRequiredVotes() {
        if (this.requiredVotes == 0) {
            int preliminaryRequiredVotes = this.supplementalDataInfo.getRequiredVotes(this.locale, this.pathHeader);
            this.requiredVotes = preliminaryRequiredVotes == HIGH_BAR && this.baselineStatus != Status.approved ? LOWER_BAR : preliminaryRequiredVotes;
        }
        return this.requiredVotes;
    }

    public void clear() {
        this.baselineValue = null;
        this.baselineStatus = Status.missing;
        this.requiredVotes = 0;
        this.locale = null;
        this.pathHeader = null;
        this.setUsingKeywordAnnotationVoting(false);
        this.organizationToValueAndVote.clear();
        this.valueIsLocked = false;
        this.resolved = false;
        this.values.clear();
        this.oValue = null;
        this.winningValue = null;
        this.nValue = null;
    }

    public T getBaileyValue() {
        if (this.organizationToValueAndVote == null || !((OrganizationToValueAndVote)this.organizationToValueAndVote).baileySet) {
            throw new IllegalArgumentException("setBaileyValue must be called before getBaileyValue");
        }
        return (T)((OrganizationToValueAndVote)this.organizationToValueAndVote).baileyValue;
    }

    public void setBaileyValue(T baileyValue) {
        ((OrganizationToValueAndVote)this.organizationToValueAndVote).baileySet = true;
        ((OrganizationToValueAndVote)this.organizationToValueAndVote).baileyValue = baileyValue;
    }

    public void add(T value, int voter, Integer withVotes, Date date) {
        if (this.resolved) {
            throw new IllegalArgumentException("Must be called after clear, and before any getters.");
        }
        if (withVotes != null && withVotes == 2000) {
            this.valueIsLocked = true;
        }
        this.organizationToValueAndVote.add(value, voter, withVotes, date);
        this.values.add(value);
    }

    public void add(T value, int voter, Integer withVotes) {
        if (this.resolved) {
            throw new IllegalArgumentException("Must be called after clear, and before any getters.");
        }
        Date date = new Date();
        this.organizationToValueAndVote.add(value, voter, withVotes, date);
        this.values.add(value);
    }

    public void add(T value, int voter) {
        Date date = new Date(++this.maxcounter);
        this.add(value, voter, null, date);
    }

    public void add(T value) {
        if (this.resolved) {
            throw new IllegalArgumentException("Must be called after clear, and before any getters.");
        }
        this.values.add(value);
    }

    private void resolveVotes() {
        this.resolved = true;
        this.valuesWithSameVotes.clear();
        this.totals = this.organizationToValueAndVote.getTotals(this.conflictedOrganizations);
        Set<T> sortedValues = this.totals.getKeysetSortedByCount(false, this.votesThenUcaCollator);
        if (sortedValues.size() == 0) {
            if (this.baselineValue != null) {
                this.winningValue = this.baselineValue;
                this.winningStatus = this.baselineStatus;
            } else if (((OrganizationToValueAndVote)this.organizationToValueAndVote).baileySet) {
                this.winningValue = CldrUtility.INHERITANCE_MARKER;
                this.winningStatus = Status.missing;
            } else {
                this.winningValue = NO_WINNING_VALUE;
                this.winningStatus = Status.missing;
            }
            this.valuesWithSameVotes.add(this.winningValue);
            return;
        }
        if (this.values.size() == 0) {
            throw new IllegalArgumentException("No values added to resolver");
        }
        HashMap<T, Long> voteCount = this.makeVoteCountMap(sortedValues);
        this.bothInheritanceAndBaileyHadVotes = this.combineInheritanceWithBaileyForVoting(sortedValues, voteCount);
        if (this.isUsingKeywordAnnotationVoting()) {
            this.adjustAnnotationVoteCounts(sortedValues, voteCount);
        }
        long[] weights = this.setBestNextAndSameVoteValues(sortedValues, voteCount);
        this.oValue = this.winningValue;
        this.winningStatus = this.computeStatus(weights[0], weights[1]);
        if (this.baselineStatus != null && this.winningStatus.compareTo(this.baselineStatus) < 0) {
            this.winningStatus = this.baselineStatus;
            this.winningValue = this.baselineValue;
            this.valuesWithSameVotes.clear();
            this.valuesWithSameVotes.add(this.winningValue);
        }
    }

    private HashMap<T, Long> makeVoteCountMap(Set<T> sortedValues) {
        HashMap<T, Long> map = new HashMap<T, Long>();
        for (T value : sortedValues) {
            map.put(value, this.totals.getCount(value));
        }
        return map;
    }

    private boolean combineInheritanceWithBaileyForVoting(Set<T> sortedValues, HashMap<T, Long> voteCount) {
        if (this.organizationToValueAndVote == null || !((OrganizationToValueAndVote)this.organizationToValueAndVote).baileySet || ((OrganizationToValueAndVote)this.organizationToValueAndVote).baileyValue == null) {
            return false;
        }
        Object hardValue = ((OrganizationToValueAndVote)this.organizationToValueAndVote).baileyValue;
        String softValue = CldrUtility.INHERITANCE_MARKER;
        if (!voteCount.containsKey(hardValue) || !voteCount.containsKey(softValue)) {
            return false;
        }
        long hardCount = voteCount.get(hardValue);
        long softCount = voteCount.get(softValue);
        if (hardCount == 0L || softCount == 0L) {
            return false;
        }
        this.reallyCombineInheritanceWithBailey(sortedValues, voteCount, hardValue, softValue, hardCount, softCount);
        return true;
    }

    private void reallyCombineInheritanceWithBailey(Set<T> sortedValues, HashMap<T, Long> voteCount, T hardValue, T softValue, long hardCount, long softCount) {
        T combValue = hardCount > softCount ? hardValue : softValue;
        T skipValue = hardCount > softCount ? softValue : hardValue;
        long combinedCount = hardCount + softCount;
        voteCount.put(combValue, combinedCount);
        voteCount.put(skipValue, 0L);
        ArrayList<T> list = new ArrayList<T>(sortedValues);
        Collections.sort(list, (v1, v2) -> {
            long c2;
            long c1 = (Long)voteCount.get(v1);
            if (c1 != (c2 = ((Long)voteCount.get(v2)).longValue())) {
                return c1 < c2 ? 1 : -1;
            }
            return englishCollator.compare(String.valueOf(v1), String.valueOf(v2));
        });
        sortedValues.clear();
        for (Object value : list) {
            if (value.equals(skipValue)) continue;
            sortedValues.add(value);
        }
    }

    public void adjustAnnotationVoteCounts(Set<T> sortedValues, HashMap<T, Long> voteCount) {
        if (voteCount == null || sortedValues == null) {
            return;
        }
        HashMap<T, Long> compMap = this.makeAnnotationComponentMap(sortedValues, voteCount);
        HashMap<T, Long> rawVoteCount = new HashMap<T, Long>(voteCount);
        this.calculateNewCountsBasedOnAnnotationComponents(sortedValues, voteCount, compMap);
        this.resortValuesBasedOnAdjustedVoteCounts(sortedValues, voteCount);
        this.promoteSuperiorAnnotationSuperset(sortedValues, voteCount, rawVoteCount);
    }

    private HashMap<T, Long> makeAnnotationComponentMap(Set<T> sortedValues, HashMap<T, Long> voteCount) {
        HashMap<T, Long> compMap = new HashMap<T, Long>();
        for (T value : sortedValues) {
            Long count = voteCount.get(value);
            List<T> comps = this.splitAnnotationIntoComponentsList(value);
            for (T comp : comps) {
                if (compMap.containsKey(comp)) {
                    compMap.replace(comp, (Long)compMap.get(comp) + count);
                    continue;
                }
                compMap.put(comp, count);
            }
        }
        return compMap;
    }

    private void calculateNewCountsBasedOnAnnotationComponents(Set<T> sortedValues, HashMap<T, Long> voteCount, HashMap<T, Long> compMap) {
        voteCount.clear();
        for (T value : sortedValues) {
            List<T> comps = this.splitAnnotationIntoComponentsList(value);
            double product = 1.0;
            for (T comp : comps) {
                product *= (double)compMap.get(comp).longValue();
            }
            Long newCount = Math.round(Math.pow(product, 1.0 / (double)comps.size()));
            voteCount.put(value, newCount);
        }
    }

    private List<T> splitAnnotationIntoComponentsList(T value) {
        return DisplayAndInputProcessor.SPLIT_BAR.splitToList((CharSequence)value);
    }

    private void resortValuesBasedOnAdjustedVoteCounts(Set<T> sortedValues, HashMap<T, Long> voteCount) {
        ArrayList<T> list = new ArrayList<T>(sortedValues);
        Collections.sort(list, (v1, v2) -> {
            int size2;
            long c2;
            long c1 = (Long)voteCount.get(v1);
            if (c1 != (c2 = ((Long)voteCount.get(v2)).longValue())) {
                return c1 < c2 ? 1 : -1;
            }
            int size1 = this.splitAnnotationIntoComponentsList(v1).size();
            if (size1 != (size2 = this.splitAnnotationIntoComponentsList(v2).size())) {
                return size1 < size2 ? -1 : 1;
            }
            return englishCollator.compare(String.valueOf(v1), String.valueOf(v2));
        });
        sortedValues.clear();
        for (Object value : list) {
            sortedValues.add(value);
        }
    }

    private void promoteSuperiorAnnotationSuperset(Set<T> sortedValues, HashMap<T, Long> voteCount, HashMap<T, Long> rawVoteCount) {
        long requiredGap = 2L;
        Object oldWinner = null;
        long oldWinnerRawCount = 0L;
        LinkedHashSet<T> oldWinnerComps = null;
        LinkedHashSet<T> superiorSupersets = null;
        for (T value : sortedValues) {
            if (oldWinner == null) {
                oldWinner = value;
                oldWinnerRawCount = rawVoteCount.get(value);
                oldWinnerComps = new LinkedHashSet<T>(this.splitAnnotationIntoComponentsList(value));
                continue;
            }
            LinkedHashSet<T> comps = new LinkedHashSet<T>(this.splitAnnotationIntoComponentsList(value));
            if (comps.size() > 16 || !comps.containsAll(oldWinnerComps) || rawVoteCount.get(value) < oldWinnerRawCount + 2L) continue;
            if (superiorSupersets == null) {
                superiorSupersets = new LinkedHashSet<T>();
            }
            superiorSupersets.add(value);
        }
        if (superiorSupersets != null) {
            this.resortValuesBasedOnAdjustedVoteCounts(superiorSupersets, rawVoteCount);
            Object newWinner = null;
            Object newSecond = null;
            for (Object value : superiorSupersets) {
                if (newWinner == null) {
                    newWinner = value;
                    voteCount.put(newWinner, voteCount.get(oldWinner) + 2L);
                    continue;
                }
                if (newSecond != null) continue;
                newSecond = value;
                voteCount.put(newSecond, voteCount.get(oldWinner) + 1L);
                break;
            }
            this.resortValuesBasedOnAdjustedVoteCounts(sortedValues, voteCount);
        }
    }

    private long[] setBestNextAndSameVoteValues(Set<T> sortedValues, HashMap<T, Long> voteCount) {
        long[] weightArray = new long[]{0L, 0L};
        this.nValue = null;
        int i = -1;
        Iterator<T> iterator = sortedValues.iterator();
        for (T value : sortedValues) {
            long valueWeight = voteCount.get(value);
            if (++i == 0) {
                this.winningValue = value;
                weightArray[0] = valueWeight;
                this.valuesWithSameVotes.add(value);
                continue;
            }
            if (i == 1 && iterator.hasNext()) {
                this.nValue = value;
                weightArray[1] = valueWeight;
            }
            if (valueWeight != weightArray[0]) break;
            this.valuesWithSameVotes.add(value);
        }
        return weightArray;
    }

    private Status computeStatus(long weight1, long weight2) {
        if (weight1 > weight2 && weight1 >= (long)this.getRequiredVotes()) {
            return Status.approved;
        }
        if (weight1 > weight2 && (weight1 >= 4L && Status.contributed.compareTo(this.baselineStatus) > 0 || weight1 >= 2L && this.organizationToValueAndVote.getOrgCount(this.winningValue) >= 2)) {
            return Status.contributed;
        }
        if (weight1 >= weight2 && weight1 >= 2L) {
            return Status.provisional;
        }
        return Status.unconfirmed;
    }

    private Status getPossibleWinningStatus() {
        Status possibleStatus;
        if (!this.resolved) {
            this.resolveVotes();
        }
        return (possibleStatus = this.computeStatus(((OrganizationToValueAndVote)this.organizationToValueAndVote).getBestPossibleVote(), 0L)).compareTo(this.winningStatus) > 0 ? possibleStatus : this.winningStatus;
    }

    public boolean isDisputed() {
        if (!this.resolved) {
            this.resolveVotes();
        }
        if (this.winningStatus.compareTo(Status.contributed) >= 0) {
            return false;
        }
        Status possibleStatus = this.getPossibleWinningStatus();
        return possibleStatus.compareTo(Status.contributed) >= 0;
    }

    public Status getWinningStatus() {
        if (!this.resolved) {
            this.resolveVotes();
        }
        return this.winningStatus;
    }

    private T getOValue() {
        if (!this.resolved) {
            this.resolveVotes();
        }
        return this.oValue;
    }

    private T getNValue() {
        if (!this.resolved) {
            this.resolveVotes();
        }
        return this.nValue;
    }

    public T getWinningValue() {
        if (!this.resolved) {
            this.resolveVotes();
        }
        return this.winningValue;
    }

    public List<T> getValuesWithSameVotes() {
        if (!this.resolved) {
            this.resolveVotes();
        }
        return new ArrayList<T>(this.valuesWithSameVotes);
    }

    public EnumSet<Organization> getConflictedOrganizations() {
        if (!this.resolved) {
            this.resolveVotes();
        }
        return this.conflictedOrganizations;
    }

    public T getOrgVote(Organization org) {
        return this.organizationToValueAndVote.getOrgVote(org);
    }

    public Map<T, Long> getOrgToVotes(Organization org) {
        return this.organizationToValueAndVote.getOrgToVotes(org);
    }

    public Map<String, Long> getNameTime() {
        return this.organizationToValueAndVote.getNameTime();
    }

    public String toString() {
        return "{bailey: " + (((OrganizationToValueAndVote)this.organizationToValueAndVote).baileySet ? "\u201c" + ((OrganizationToValueAndVote)this.organizationToValueAndVote).baileyValue + "\u201d " : "none ") + "baseline: {" + this.baselineValue + ", " + (Object)((Object)this.baselineStatus) + "}, " + this.organizationToValueAndVote + ", sameVotes: " + this.valuesWithSameVotes + ", O: " + this.getOValue() + ", N: " + this.getNValue() + ", totals: " + this.totals + ", winning: {" + this.getWinningValue() + ", " + (Object)((Object)this.getWinningStatus()) + "}}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Integer, VoterInfo> getVoterToInfo() {
        Class<VoteResolver> clazz = VoteResolver.class;
        synchronized (VoteResolver.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return voterToInfo;
        }
    }

    public static VoterInfo getInfoForVoter(int voter) {
        return VoteResolver.getVoterToInfo().get(voter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setVoterToInfo(Map<Integer, VoterInfo> testVoterToInfo) {
        Class<VoteResolver> clazz = VoteResolver.class;
        synchronized (VoteResolver.class) {
            voterToInfo = testVoterToInfo;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            VoteResolver.computeMaxVotes();
            return;
        }
    }

    public static void setVoterToInfo(String fileName) {
        MyHandler myHandler = new MyHandler();
        XMLFileReader xfr = new XMLFileReader().setHandler(myHandler);
        xfr.read(fileName, XMLFileReader.CONTENT_HANDLER | XMLFileReader.ERROR_HANDLER, false);
        VoteResolver.setVoterToInfo(myHandler.testVoterToInfo);
        VoteResolver.computeMaxVotes();
    }

    private static synchronized void computeMaxVotes() {
        localeToOrganizationToMaxVote = new TreeMap();
        for (int voter : VoteResolver.getVoterToInfo().keySet()) {
            VoterInfo info = VoteResolver.getVoterToInfo().get(voter);
            if (info.getLevel() == Level.tc || info.getLevel() == Level.locked) continue;
            for (CLDRLocale loc : info.locales) {
                Level maxVote;
                String locale = loc.getBaseName();
                Map<Organization, Level> organizationToMaxVote = localeToOrganizationToMaxVote.get(locale);
                if (organizationToMaxVote == null) {
                    organizationToMaxVote = new TreeMap<Organization, Level>();
                    localeToOrganizationToMaxVote.put(locale, organizationToMaxVote);
                }
                if ((maxVote = organizationToMaxVote.get((Object)info.getOrganization())) != null && info.getLevel().compareTo(maxVote) <= 0) continue;
                organizationToMaxVote.put(info.getOrganization(), info.getLevel());
            }
        }
        CldrUtility.protectCollection(localeToOrganizationToMaxVote);
    }

    public static Map<Integer, String> getIdToPath(String fileName) {
        XPathTableHandler myHandler = new XPathTableHandler();
        XMLFileReader xfr = new XMLFileReader().setHandler(myHandler);
        xfr.read(fileName, XMLFileReader.CONTENT_HANDLER | XMLFileReader.ERROR_HANDLER, false);
        return myHandler.pathIdToPath;
    }

    public static Map<Integer, Map<Integer, CandidateInfo>> getBaseToAlternateToInfo(String fileName) {
        try {
            VotesHandler myHandler = new VotesHandler();
            XMLFileReader xfr = new XMLFileReader().setHandler(myHandler);
            xfr.read(fileName, XMLFileReader.CONTENT_HANDLER | XMLFileReader.ERROR_HANDLER, false);
            return myHandler.basepathToInfo;
        }
        catch (Exception e) {
            throw (RuntimeException)new IllegalArgumentException("Can't handle file: " + fileName).initCause(e);
        }
    }

    public static Map<Organization, Level> getOrganizationToMaxVote(String locale) {
        Map<Organization, Level> result = localeToOrganizationToMaxVote.get(locale = locale.split("_")[0]);
        if (result == null) {
            result = Collections.emptyMap();
        }
        return result;
    }

    public static Map<Organization, Level> getOrganizationToMaxVote(Set<Integer> voters) {
        TreeMap<Organization, Level> orgToMaxVoteHere = new TreeMap<Organization, Level>();
        for (int voter : voters) {
            Level maxVote;
            VoterInfo info = VoteResolver.getInfoForVoter(voter);
            if (info == null || (maxVote = (Level)((Object)orgToMaxVoteHere.get((Object)info.getOrganization()))) != null && info.getLevel().compareTo(maxVote) <= 0) continue;
            orgToMaxVoteHere.put(info.getOrganization(), info.getLevel());
        }
        return orgToMaxVoteHere;
    }

    private static String fixBogusDraftStatusValues(String attributeValue) {
        if (attributeValue == null) {
            return "approved";
        }
        if ("confirmed".equals(attributeValue)) {
            return "approved";
        }
        if ("true".equals(attributeValue)) {
            return "unconfirmed";
        }
        if ("unknown".equals(attributeValue)) {
            return "unconfirmed";
        }
        return attributeValue;
    }

    public int size() {
        return this.values.size();
    }

    public Map<T, Long> getResolvedVoteCounts() {
        if (!this.resolved) {
            this.resolveVotes();
        }
        LinkedHashMap<T, Long> result = new LinkedHashMap<T, Long>();
        if (this.winningValue != null && !this.totals.containsKey(this.winningValue)) {
            result.put(this.winningValue, 0L);
        }
        for (T value : this.totals.getKeysetSortedByCount(false, this.votesThenUcaCollator)) {
            result.put(value, this.totals.get(value));
        }
        if (this.baselineValue != null && !this.totals.containsKey(this.baselineValue)) {
            result.put(this.baselineValue, 0L);
        }
        for (T value : ((OrganizationToValueAndVote)this.organizationToValueAndVote).totalVotes.getMap().keySet()) {
            if (result.containsKey(value)) continue;
            result.put(value, 0L);
        }
        return result;
    }

    public VettingViewer.VoteStatus getStatusForOrganization(Organization orgOfUser) {
        T orgVote;
        if (!this.resolved) {
            this.resolveVotes();
        }
        if (!this.equalsOrgVote(this.winningValue, orgVote = this.organizationToValueAndVote.getOrgVoteRaw(orgOfUser))) {
            return VettingViewer.VoteStatus.losing;
        }
        int itemsWithVotes = this.countDistinctValuesWithVotes();
        if (itemsWithVotes > 1) {
            return VettingViewer.VoteStatus.disputed;
        }
        Object singleVotedItem = ((OrganizationToValueAndVote)this.organizationToValueAndVote).getSingleVotedItem();
        if (!this.equalsOrgVote(this.winningValue, singleVotedItem)) {
            return VettingViewer.VoteStatus.disputed;
        }
        if (Status.provisional.compareTo(this.winningStatus) >= 0) {
            return VettingViewer.VoteStatus.provisionalOrWorse;
        }
        if (itemsWithVotes == 0) {
            return VettingViewer.VoteStatus.ok_novotes;
        }
        return VettingViewer.VoteStatus.ok;
    }

    private boolean equalsOrgVote(T value, T orgVote) {
        return orgVote == null || orgVote.equals(value) || CldrUtility.INHERITANCE_MARKER.equals(value) && orgVote.equals(((OrganizationToValueAndVote)this.organizationToValueAndVote).baileyValue) || CldrUtility.INHERITANCE_MARKER.equals(orgVote) && value.equals(((OrganizationToValueAndVote)this.organizationToValueAndVote).baileyValue);
    }

    private int countDistinctValuesWithVotes() {
        if (!this.resolved) {
            throw new RuntimeException("countDistinctValuesWithVotes !resolved");
        }
        int count = ((OrganizationToValueAndVote)this.organizationToValueAndVote).totalVotes.size();
        if (count > 1 && this.bothInheritanceAndBaileyHadVotes) {
            return count - 1;
        }
        return count;
    }

    public boolean isUsingKeywordAnnotationVoting() {
        return this.usingKeywordAnnotationVoting;
    }

    public void setUsingKeywordAnnotationVoting(boolean usingKeywordAnnotationVoting) {
        this.usingKeywordAnnotationVoting = usingKeywordAnnotationVoting;
    }

    public boolean isValueLocked() {
        return this.valueIsLocked;
    }

    public boolean canFlagOnLosing() {
        return this.valueIsLocked || this.getRequiredVotes() == HIGH_BAR;
    }

    static {
        englishCollator = Collator.getInstance(ULocale.ENGLISH).freeze();
    }

    public static class UnknownVoterException
    extends RuntimeException {
        private static final long serialVersionUID = 3430877787936678609L;
        int voter;

        public UnknownVoterException(int voter) {
            this.voter = voter;
        }

        @Override
        public String toString() {
            return "Unknown voter: " + this.voter;
        }
    }

    static class VotesHandler
    extends XMLFileReader.SimpleHandler {
        Map<Integer, Map<Integer, CandidateInfo>> basepathToInfo = new TreeMap<Integer, Map<Integer, CandidateInfo>>();

        VotesHandler() {
        }

        @Override
        public void handlePathValue(String path, String value) {
            block8: {
                try {
                    int itemId;
                    CandidateInfo candidateInfo;
                    XPathParts parts = XPathParts.getFrozenInstance(path);
                    if (parts.size() < 2) {
                        return;
                    }
                    int baseId = Integer.parseInt(parts.getAttributeValue(1, "baseXpath"));
                    Map<Integer, CandidateInfo> info = this.basepathToInfo.get(baseId);
                    if (info == null) {
                        info = new TreeMap<Integer, CandidateInfo>();
                        this.basepathToInfo.put(baseId, info);
                    }
                    if ((candidateInfo = info.get(itemId = Integer.parseInt(parts.getAttributeValue(2, "xpath")))) == null) {
                        candidateInfo = new CandidateInfo();
                        info.put(itemId, candidateInfo);
                        candidateInfo.surveyType = Type.valueOf(parts.getAttributeValue(2, "type"));
                        candidateInfo.surveyStatus = Status.valueOf(VoteResolver.fixBogusDraftStatusValues(parts.getAttributeValue(2, "status")));
                    }
                    if (parts.size() < 4) {
                        return;
                    }
                    String lastElement = parts.getElement(3);
                    if (lastElement.equals("old")) {
                        candidateInfo.oldStatus = Status.valueOf(VoteResolver.fixBogusDraftStatusValues(parts.getAttributeValue(3, "status")));
                        break block8;
                    }
                    if (lastElement.equals("vote")) {
                        candidateInfo.voters.add(Integer.parseInt(parts.getAttributeValue(3, "user")));
                        break block8;
                    }
                    throw new IllegalArgumentException("unknown option: " + path);
                }
                catch (Exception e) {
                    throw (RuntimeException)new IllegalArgumentException("Can't handle path: " + path).initCause(e);
                }
            }
        }
    }

    public static class CandidateInfo {
        public Status oldStatus;
        public Type surveyType;
        public Status surveyStatus;
        public Set<Integer> voters = new TreeSet<Integer>();

        public String toString() {
            StringBuilder voterString = new StringBuilder("{");
            for (int voter : this.voters) {
                VoterInfo voterInfo = VoteResolver.getInfoForVoter(voter);
                if (voterString.length() > 1) {
                    voterString.append(" ");
                }
                voterString.append(voter);
                if (voterInfo == null) continue;
                voterString.append(" ").append(voterInfo);
            }
            voterString.append("}");
            return "{oldStatus: " + (Object)((Object)this.oldStatus) + ", surveyType: " + (Object)((Object)this.surveyType) + ", surveyStatus: " + (Object)((Object)this.surveyStatus) + ", voters: " + voterString + "};";
        }
    }

    public static enum Type {
        proposal,
        optimal;

    }

    static class XPathTableHandler
    extends XMLFileReader.SimpleHandler {
        Matcher matcher = Pattern.compile("id=\"([0-9]+)\"").matcher("");
        Map<Integer, String> pathIdToPath = new HashMap<Integer, String>();

        XPathTableHandler() {
        }

        @Override
        public void handlePathValue(String path, String value) {
            if (!this.matcher.reset(path).find()) {
                throw new IllegalArgumentException("Unknown path " + path);
            }
            this.pathIdToPath.put(Integer.parseInt(this.matcher.group(1)), value);
        }
    }

    static class MyHandler
    extends XMLFileReader.SimpleHandler {
        private static final Pattern userPathMatcher = Pattern.compile("//users(?:[^/]*)/user\\[@id=\"([^\"]*)\"](?:[^/]*)/(org|name|level\\[@n=\"([^\"]*)\"]\\[@type=\"([^\"]*)\"]|locales\\[@type=\"([^\"]*)\"](?:/locale\\[@id=\"([^\"]*)\"])?)", 4);
        private static final boolean DEBUG_HANDLER = false;
        Map<Integer, VoterInfo> testVoterToInfo = new TreeMap<Integer, VoterInfo>();
        Matcher matcher = userPathMatcher.matcher("");

        MyHandler() {
        }

        @Override
        public void handlePathValue(String path, String value) {
            if (this.matcher.reset(path).matches()) {
                String localeIdString;
                String mainType;
                int id = Integer.parseInt(Group.userId.get(this.matcher));
                VoterInfo voterInfo = this.testVoterToInfo.get(id);
                if (voterInfo == null) {
                    voterInfo = new VoterInfo();
                    this.testVoterToInfo.put(id, voterInfo);
                }
                if ((mainType = Group.mainType.get(this.matcher)).equals("org")) {
                    Organization org = Organization.fromString(value);
                    voterInfo.setOrganization(org);
                    value = org.name();
                } else if (mainType.equals("name")) {
                    voterInfo.setName(value);
                } else if (mainType.startsWith("level")) {
                    String level = Group.levelType.get(this.matcher).toLowerCase();
                    voterInfo.setLevel(Level.valueOf(level));
                } else if (mainType.startsWith("locale") && (localeIdString = Group.localeId.get(this.matcher)) != null) {
                    CLDRLocale locale = CLDRLocale.getInstance(localeIdString.split("_")[0]);
                    voterInfo.addLocale(locale);
                }
            } else {
                System.out.println("\tFailed match with " + path + "=" + value);
            }
        }

        static enum Group {
            all,
            userId,
            mainType,
            n,
            levelType,
            localeType,
            localeId;


            String get(Matcher matcher) {
                return matcher.group(this.ordinal());
            }
        }
    }

    private static class OrganizationToValueAndVote<T> {
        private final Map<Organization, MaxCounter<T>> orgToVotes = new EnumMap<Organization, MaxCounter<T>>(Organization.class);
        private final Counter<T> totalVotes = new Counter();
        private final Map<Organization, Integer> orgToMax = new EnumMap<Organization, Integer>(Organization.class);
        private final Counter<T> totals = new Counter(true);
        private Map<String, Long> nameTime = new LinkedHashMap<String, Long>();
        private final Map<Organization, T> orgToAdd = new EnumMap<Organization, T>(Organization.class);
        private T baileyValue;
        private boolean baileySet;

        OrganizationToValueAndVote() {
            for (Organization org : Organization.values()) {
                this.orgToVotes.put(org, new MaxCounter(true));
            }
        }

        public void clear() {
            for (Map.Entry<Organization, MaxCounter<T>> entry : this.orgToVotes.entrySet()) {
                entry.getValue().clear();
            }
            this.orgToAdd.clear();
            this.orgToMax.clear();
            this.totalVotes.clear();
            this.baileyValue = null;
            this.baileySet = false;
        }

        private T getSingleVotedItem() {
            return this.totalVotes.size() != 1 ? null : (T)this.totalVotes.iterator().next();
        }

        public Map<String, Long> getNameTime() {
            return this.nameTime;
        }

        public void add(T value, int voter, Integer withVotes, Date date) {
            VoterInfo info = (VoterInfo)VoteResolver.getVoterToInfo().get(voter);
            if (info == null) {
                throw new UnknownVoterException(voter);
            }
            Level level = info.getLevel();
            if (withVotes == null || !level.canVoteWithCount(withVotes)) {
                withVotes = level.getVotes();
            }
            this.addInternal(value, info, withVotes, date);
        }

        private void addInternal(T value, VoterInfo info, int votes, Date time) {
            if (!this.baileySet) {
                throw new IllegalArgumentException("setBaileyValue must be called before add");
            }
            this.totalVotes.add(value, (long)votes, time.getTime());
            this.nameTime.put(info.getName(), time.getTime());
            Organization organization = info.getOrganization();
            this.orgToVotes.get((Object)organization).add((Object)value, (long)votes, time.getTime());
            Integer max = this.orgToMax.get((Object)info.getOrganization());
            if (max == null || max < votes) {
                this.orgToMax.put(organization, votes);
            }
        }

        public Counter<T> getTotals(EnumSet<Organization> conflictedOrganizations) {
            if (conflictedOrganizations != null) {
                conflictedOrganizations.clear();
            }
            this.totals.clear();
            for (Map.Entry<Organization, MaxCounter<T>> entry : this.orgToVotes.entrySet()) {
                Object value2;
                long weight2;
                Iterator iterator;
                Object value;
                long weight;
                Counter items = entry.getValue();
                if (items.size() == 0 || (weight = items.getCount(value = (iterator = items.getKeysetSortedByCount(false).iterator()).next())) == 0L) continue;
                Organization org = entry.getKey();
                if (iterator.hasNext() && weight == (weight2 = items.getCount(value2 = iterator.next())) && conflictedOrganizations != null) {
                    conflictedOrganizations.add(org);
                }
                this.orgToAdd.put(org, value);
                long maxCount = 0L;
                Object considerItem = null;
                long considerCount = 0L;
                long maxtime = 0L;
                long considerTime = 0L;
                for (Object item : items.keySet()) {
                    long count = items.getCount(item);
                    long time = items.getTime(item);
                    if (count > maxCount) {
                        maxCount = count;
                        maxtime = time;
                        considerItem = item;
                        considerCount = items.getCount(considerItem);
                        considerTime = items.getTime(considerItem);
                        continue;
                    }
                    if (time <= maxtime || count != maxCount) continue;
                    maxCount = count;
                    maxtime = time;
                    considerItem = item;
                    considerCount = items.getCount(considerItem);
                    considerTime = items.getTime(considerItem);
                }
                this.orgToAdd.put(org, considerItem);
                this.totals.add(considerItem, considerCount, considerTime);
            }
            return this.totals;
        }

        public int getOrgCount(T winningValue) {
            int orgCount = 0;
            for (Map.Entry<Organization, MaxCounter<T>> entry : this.orgToVotes.entrySet()) {
                Counter counter = entry.getValue();
                long count = counter.getCount(winningValue);
                if (count <= 0L) continue;
                ++orgCount;
            }
            return orgCount;
        }

        private int getBestPossibleVote() {
            int total = 0;
            for (Map.Entry<Organization, Integer> entry : this.orgToMax.entrySet()) {
                total += entry.getValue().intValue();
            }
            return total;
        }

        public String toString() {
            String orgToVotesString = "";
            for (Map.Entry<Organization, MaxCounter<T>> entry : this.orgToVotes.entrySet()) {
                Counter counter = entry.getValue();
                if (counter.size() == 0) continue;
                if (orgToVotesString.length() != 0) {
                    orgToVotesString = orgToVotesString + ", ";
                }
                Organization org = entry.getKey();
                orgToVotesString = orgToVotesString + org.toString() + "=" + counter.toString();
            }
            EnumSet<Organization> conflicted = EnumSet.noneOf(Organization.class);
            return "{orgToVotes: " + orgToVotesString + ", totals: " + this.getTotals(conflicted) + ", conflicted: " + conflicted.toString() + "}";
        }

        @Deprecated
        public T getOrgVote(Organization org) {
            return this.orgToAdd.get((Object)org);
        }

        public T getOrgVoteRaw(Organization orgOfUser) {
            return this.orgToAdd.get((Object)orgOfUser);
        }

        public Map<T, Long> getOrgToVotes(Organization org) {
            LinkedHashMap result = new LinkedHashMap();
            MaxCounter counter = this.orgToVotes.get((Object)org);
            for (Object item : counter) {
                result.put(item, counter.getCount(item));
            }
            return result;
        }
    }

    static class MaxCounter<T>
    extends Counter<T> {
        public MaxCounter(boolean b) {
            super(b);
        }

        @Override
        public MaxCounter<T> add(T obj, long countValue, long time) {
            long value = this.getCount(obj);
            if (value <= countValue) {
                super.add(obj, countValue - value, time);
            }
            return this;
        }
    }

    public static class VoterInfo {
        private Organization organization;
        private Level level;
        private String name;
        private Set<CLDRLocale> locales = new TreeSet<CLDRLocale>();

        public VoterInfo(Organization organization, Level level, String name, LocaleSet localeSet) {
            this.setOrganization(organization);
            this.setLevel(level);
            this.setName(name);
            if (!localeSet.isAllLocales()) {
                this.locales.addAll(localeSet.getSet());
            }
        }

        public VoterInfo(Organization organization, Level level, String name) {
            this.setOrganization(organization);
            this.setLevel(level);
            this.setName(name);
        }

        public VoterInfo() {
        }

        public String toString() {
            return "{" + this.getName() + ", " + (Object)((Object)this.getLevel()) + ", " + (Object)((Object)this.getOrganization()) + "}";
        }

        public void setOrganization(Organization organization) {
            this.organization = organization;
        }

        public Organization getOrganization() {
            return this.organization;
        }

        public void setLevel(Level level) {
            this.level = level;
        }

        public Level getLevel() {
            return this.level;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        private void addLocale(CLDRLocale locale) {
            this.locales.add(locale);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            VoterInfo other = (VoterInfo)obj;
            return this.organization.equals((Object)other.organization) && this.level.equals((Object)other.level) && this.name.equals(other.name) && Objects.equal(this.locales, other.locales);
        }

        public int hashCode() {
            return this.organization.hashCode() ^ this.level.hashCode() ^ this.name.hashCode();
        }
    }

    public static enum Level {
        locked(0, 999),
        street(1, 10),
        anonymous(0, 8),
        vetter(4, 5),
        manager(4, 2),
        tc(20, 1),
        admin(100, 0);

        public static final int PERMANENT_VOTES = 1000;
        public static final int LOCKING_VOTES = 2000;
        private final int votes;
        private final int stlevel;
        private ImmutableSet<Integer> voteCountMenu = null;

        private Level(int votes, int stlevel) {
            this.votes = votes;
            this.stlevel = stlevel;
        }

        public int getVotes() {
            return this.votes;
        }

        public int getSTLevel() {
            return this.stlevel;
        }

        public static Level fromSTLevel(int stlevel) {
            for (Level l : Level.values()) {
                if (l.getSTLevel() != stlevel) continue;
                return l;
            }
            return null;
        }

        public boolean isManagerFor(Organization myOrg, Level otherLevel, Organization otherOrg) {
            return this == admin || this.canManageSomeUsers() && myOrg == otherOrg && this.getSTLevel() <= otherLevel.getSTLevel();
        }

        public boolean canManageSomeUsers() {
            return this.getSTLevel() <= manager.getSTLevel();
        }

        public boolean canCreateOrSetLevelTo(Level otherLevel) {
            return this.canManageSomeUsers() && otherLevel.getSTLevel() >= this.getSTLevel();
        }

        public boolean canVoteWithCount(int withVotes) {
            if (withVotes == 2000 && this == admin) {
                return true;
            }
            ImmutableSet<Integer> menu = this.getVoteCountMenu();
            return menu == null ? withVotes == this.votes : menu.contains(withVotes);
        }

        public ImmutableSet<Integer> getVoteCountMenu() {
            return this.voteCountMenu;
        }

        static /* synthetic */ int access$000(Level x0) {
            return x0.votes;
        }

        static {
            Level.admin.voteCountMenu = ImmutableSet.of(Integer.valueOf(Level.vetter.votes), Integer.valueOf(Level.admin.votes));
            Level.tc.voteCountMenu = ImmutableSet.of(Integer.valueOf(Level.vetter.votes), Integer.valueOf(Level.tc.votes), Integer.valueOf(1000));
        }
    }

    public static enum Status {
        missing,
        unconfirmed,
        provisional,
        contributed,
        approved;


        public static Status fromString(String source) {
            return source == null ? missing : Status.valueOf(source);
        }
    }
}

