/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.util.PatternCache;

public class FixArchaic {
    static final int blockEnum = UCharacter.getPropertyEnum("block");
    static final int scriptEnum = UCharacter.getPropertyEnum("script");

    public static void main(String[] args) {
        FixArchaic.checkRegex();
    }

    private static void checkRegex() {
        FixArchaic.checkRegex(true);
        FixArchaic.checkRegex(false);
    }

    private static void checkRegex(boolean escaped) {
        UnicodeSet failed = new UnicodeSet();
        for (int i = 0; i <= 0x10FFFF; ++i) {
            Matcher m3;
            String stri = UTF16.valueOf(i);
            Object uset = i < 65536 ? new UnicodeSet(i, i).toPattern(escaped) : (escaped ? "[\\u" + Integer.toHexString(stri.charAt(0)) + "\\u" + Integer.toHexString(stri.charAt(1)) + "]" : "[" + stri + "]");
            try {
                m3 = PatternCache.get((String)uset).matcher(stri);
            }
            catch (Exception e) {
                failed.add(i);
                continue;
            }
            if (!m3.matches()) {
                failed.add(i);
                continue;
            }
            if (!FixArchaic.otherRegexSucceeds(m3, i)) continue;
            failed.add(i);
        }
        System.out.println("UnicodeSet/Java Regex differences " + escaped + ": " + failed);
    }

    private static boolean otherRegexSucceeds(Matcher m3, int skip) {
        for (int i = 1; i <= 0x10FFFF; i += i) {
            if (i == skip || !m3.reset(UTF16.valueOf(i)).matches()) continue;
            return true;
        }
        return false;
    }
}

