/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard.test;

import com.google.common.collect.ImmutableList;
import com.ibm.icu.dev.test.TestFmwk;
import org.unicode.cldr.draft.keyboard.CharacterMap;
import org.unicode.cldr.draft.keyboard.IsoLayoutPosition;

public class CharacterMapTest
extends TestFmwk {
    public void testCharacterMap() {
        ImmutableList<String> longPress = ImmutableList.of("a", "b", "c");
        CharacterMap character = CharacterMap.of(IsoLayoutPosition.B04, "a", longPress);
        this.assertEquals("", (Object)IsoLayoutPosition.B04, (Object)character.position());
        this.assertEquals("", "a", character.output());
        this.assertEquals("", ImmutableList.of("a", "b", "c"), character.longPressKeys());
    }

    public void testCompareTo() {
        CharacterMap character1 = CharacterMap.of(IsoLayoutPosition.B00, "test1");
        CharacterMap character2 = CharacterMap.of(IsoLayoutPosition.B01, "test2");
        CharacterMap character3 = CharacterMap.of(IsoLayoutPosition.A03, "test3");
        CharacterMap character4 = CharacterMap.of(IsoLayoutPosition.A03, "test4");
        int result = character1.compareTo(character3);
        this.assertTrue("", result < 0);
        result = character1.compareTo(character2);
        this.assertTrue("", result < 0);
        result = character3.compareTo(character4);
        this.assertTrue("", result == 0);
    }

    public void testEqualsTrue() {
        CharacterMap characterMap1 = CharacterMap.of(IsoLayoutPosition.A01, "Output", ImmutableList.of("A", "B"));
        CharacterMap characterMap2 = CharacterMap.of(IsoLayoutPosition.A01, "Output", ImmutableList.of("A", "B"));
        this.assertTrue("", characterMap1.equals(characterMap2));
        this.assertTrue("", characterMap1.hashCode() == characterMap2.hashCode());
    }

    public void testEqualsFalse() {
        CharacterMap characterMap1 = CharacterMap.of(IsoLayoutPosition.A01, "Output", ImmutableList.of("A", "B"));
        CharacterMap characterMap2 = CharacterMap.of(IsoLayoutPosition.A01, "Output");
        this.assertFalse("", characterMap1.equals(characterMap2));
    }
}

