/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import java.util.List;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.XPathParts;
import org.unicode.cldr.util.personname.PersonNameFormatter;

public class CheckPersonNames
extends CheckCLDR {
    static final String MISSING = "\u2205\u2205\u2205";
    public static final ImmutableMultimap<PersonNameFormatter.SampleType, String> REQUIRED = ImmutableMultimap.builder().putAll(PersonNameFormatter.SampleType.givenOnly, "given").putAll(PersonNameFormatter.SampleType.givenSurnameOnly, (String[])new String[]{"given", "surname"}).putAll(PersonNameFormatter.SampleType.given12Surname, (String[])new String[]{"given", "given2", "surname"}).putAll(PersonNameFormatter.SampleType.full, (String[])new String[]{"prefix", "given", "given-informal", "given2", "surname", "surname2", "suffix"}).build();
    public static final ImmutableMultimap<PersonNameFormatter.SampleType, String> REQUIRED_EMPTY = ImmutableMultimap.builder().putAll(PersonNameFormatter.SampleType.givenOnly, "prefix", "given-informal", "given2", "surname", "surname-prefix", "surname-core", "surname2", "suffix").putAll(PersonNameFormatter.SampleType.givenSurnameOnly, (String[])new String[]{"prefix", "given2", "surname-prefix", "surname-core", "surname2", "suffix"}).build();
    boolean isRoot = false;

    @Override
    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        this.isRoot = cldrFileToCheck.getLocaleID().equals("root");
        return super.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
    }

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (value == null || this.isRoot || !path.startsWith("//ldml/personNames/")) {
            return this;
        }
        XPathParts parts = XPathParts.getFrozenInstance(path);
        String category = parts.getElement(2);
        if (category.equals("sampleName")) {
            CheckCLDR.CheckStatus.Type status = CheckCLDR.CheckStatus.warningType;
            String message = null;
            PersonNameFormatter.SampleType item = PersonNameFormatter.SampleType.valueOf(parts.getAttributeValue(2, "item"));
            String modifiedField = parts.getAttributeValue(3, "type");
            boolean isMissing = value.equals(MISSING);
            if (isMissing) {
                String surname2;
                if (((ImmutableCollection)REQUIRED.get((Object)item)).contains(modifiedField)) {
                    message = "This value must not be empty (\u2205\u2205\u2205)";
                } else if (modifiedField.equals("surname") && !(surname2 = this.getCldrFileToCheck().getStringValue(path.replace("surname", "surname2"))).equals(MISSING)) {
                    message = "The value for 'surname' must not be empty (\u2205\u2205\u2205) unless 'surname2' is.";
                }
            } else {
                status = CheckCLDR.CheckStatus.errorType;
                if (((ImmutableCollection)REQUIRED_EMPTY.get((Object)item)).contains(modifiedField)) {
                    message = "This value must be empty (\u2205\u2205\u2205)";
                } else if (modifiedField.equals("multiword") && !value.contains(" ")) {
                    message = "All multiword fields must have 2 (or more) words separated by spaces";
                }
            }
            if (message != null) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(status).setSubtype(CheckCLDR.CheckStatus.Subtype.badSamplePersonName).setMessage(message));
            }
        }
        return this;
    }
}

