/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.Currency;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Iso639Data;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.VariantFolder;
import org.unicode.cldr.util.XPathParts;
import org.unicode.cldr.util.props.BagFormatter;

public class TestMisc {
    static Currency SWISS_FRANC = Currency.getInstance("CHF");
    static int[] extraCJK = new int[]{12294, 12330, 12331, 12332, 12333, 12334, 12335, 12337, 12338, 12339, 12340, 12341, 12348, 12441, 12442, 12443, 12444, 12448, 12540, 65392, 65438, 65439};
    private static final Map<String, String> language_territory_hack_map = new HashMap<String, String>();
    private static final String[][] language_territory_hack = new String[][]{{"af", "ZA"}, {"am", "ET"}, {"ar", "SA"}, {"as", "IN"}, {"ay", "PE"}, {"az", "AZ"}, {"bal", "PK"}, {"be", "BY"}, {"bg", "BG"}, {"bn", "IN"}, {"bs", "BA"}, {"ca", "ES"}, {"ch", "MP"}, {"cpe", "SL"}, {"cs", "CZ"}, {"cy", "GB"}, {"da", "DK"}, {"de", "DE"}, {"dv", "MV"}, {"dz", "BT"}, {"el", "GR"}, {"en", "US"}, {"es", "ES"}, {"et", "EE"}, {"eu", "ES"}, {"fa", "IR"}, {"fi", "FI"}, {"fil", "PH"}, {"fj", "FJ"}, {"fo", "FO"}, {"fr", "FR"}, {"ga", "IE"}, {"gd", "GB"}, {"gl", "ES"}, {"gn", "PY"}, {"gu", "IN"}, {"gv", "GB"}, {"ha", "NG"}, {"he", "IL"}, {"hi", "IN"}, {"ho", "PG"}, {"hr", "HR"}, {"ht", "HT"}, {"hu", "HU"}, {"hy", "AM"}, {"id", "ID"}, {"is", "IS"}, {"it", "IT"}, {"ja", "JP"}, {"ka", "GE"}, {"kk", "KZ"}, {"kl", "GL"}, {"km", "KH"}, {"kn", "IN"}, {"ko", "KR"}, {"kok", "IN"}, {"ks", "IN"}, {"ku", "TR"}, {"ky", "KG"}, {"la", "VA"}, {"lb", "LU"}, {"ln", "CG"}, {"lo", "LA"}, {"lt", "LT"}, {"lv", "LV"}, {"mai", "IN"}, {"men", "GN"}, {"mg", "MG"}, {"mh", "MH"}, {"mk", "MK"}, {"ml", "IN"}, {"mn", "MN"}, {"mni", "IN"}, {"mo", "MD"}, {"mr", "IN"}, {"ms", "MY"}, {"mt", "MT"}, {"my", "MM"}, {"na", "NR"}, {"nb", "NO"}, {"nd", "ZA"}, {"ne", "NP"}, {"niu", "NU"}, {"nl", "NL"}, {"nn", "NO"}, {"no", "NO"}, {"nr", "ZA"}, {"nso", "ZA"}, {"ny", "MW"}, {"om", "KE"}, {"or", "IN"}, {"pa", "IN"}, {"pau", "PW"}, {"pl", "PL"}, {"ps", "PK"}, {"pt", "BR"}, {"qu", "PE"}, {"rn", "BI"}, {"ro", "RO"}, {"ru", "RU"}, {"rw", "RW"}, {"sd", "IN"}, {"sg", "CF"}, {"si", "LK"}, {"sk", "SK"}, {"sl", "SI"}, {"sm", "WS"}, {"so", "DJ"}, {"sq", "CS"}, {"sr", "CS"}, {"ss", "ZA"}, {"st", "ZA"}, {"sv", "SE"}, {"sw", "KE"}, {"ta", "IN"}, {"te", "IN"}, {"tem", "SL"}, {"tet", "TL"}, {"th", "TH"}, {"ti", "ET"}, {"tg", "TJ"}, {"tk", "TM"}, {"tkl", "TK"}, {"tvl", "TV"}, {"tl", "PH"}, {"tn", "ZA"}, {"to", "TO"}, {"tpi", "PG"}, {"tr", "TR"}, {"ts", "ZA"}, {"uk", "UA"}, {"ur", "IN"}, {"uz", "UZ"}, {"ve", "ZA"}, {"vi", "VN"}, {"wo", "SN"}, {"xh", "ZA"}, {"zh", "CN"}, {"zh_Hant", "TW"}, {"zu", "ZA"}, {"aa", "ET"}, {"byn", "ER"}, {"eo", "DE"}, {"gez", "ET"}, {"haw", "US"}, {"iu", "CA"}, {"kw", "GB"}, {"sa", "IN"}, {"sh", "HR"}, {"sid", "ET"}, {"syr", "SY"}, {"tig", "ER"}, {"tt", "RU"}, {"wal", "ET"}};

    public static void main(String[] args) {
        TestMisc.checkAliases();
    }

    private static void checkAliases() {
        Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        CLDRFile en = cldrFactory.make("root", true);
        CLDRFile.Status status = new CLDRFile.Status();
        Matcher m3 = PatternCache.get("gregorian.*dayPeriods").matcher("");
        Iterator<String> it = en.iterator(null, en.getComparator());
        while (it.hasNext()) {
            String path = it.next();
            if (!m3.reset(path).find()) continue;
            String value = en.getStringValue(path);
            String fullPath = en.getFullXPath(path);
            System.out.println("value:\t" + value + "\tpath:\t" + fullPath);
            if (!path.equals(status.pathWhereFound)) {
                System.out.println("\torigin:\t" + status);
            }
            System.out.println();
        }
    }

    private static void testWeights() {
        Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        CLDRFile english = cldrFactory.make("en", true);
        TreeSet<Pair<Integer, String>> rel = new TreeSet<Pair<Integer, String>>();
        for (String string : cldrFactory.getAvailable()) {
            int vote = Level.getDefaultWeight("google", string);
            rel.add(new Pair<Integer, String>(vote, string));
        }
        for (Pair pair : rel) {
            System.out.println(pair + "\t" + english.getName((String)pair.getSecond()));
        }
    }

    private static void testScripts() {
        int script;
        BagFormatter bf = new BagFormatter();
        UnicodeSet caseFolded = new UnicodeSet();
        UnicodeSet simpleCaseFolded = new UnicodeSet();
        for (int i = 0; i < 0x10FFFF; ++i) {
            String form = UTF16.valueOf(i);
            if (UCharacter.foldCase(form, true).equals(form)) {
                caseFolded.add(i);
            }
            if (UCharacter.foldCase(i, true) != i) continue;
            simpleCaseFolded.add(i);
        }
        caseFolded.freeze();
        simpleCaseFolded.freeze();
        UnicodeSet functionalExceptCase = new UnicodeSet("[[:L:][:Mc:][:Mn:][:Nd:]&[:^NFKC_QuickCheck=No:]&[:^default_ignorable_code_point:]]").freeze();
        UnicodeSet asciiIdn = new UnicodeSet("[-A-Z0-9]").freeze();
        UnicodeSet archaic = new UnicodeSet("[[:script=Bugi:][:script=Copt:][:script=Cprt:][:script=Dsrt:][:script=Glag:][:script=Goth:][:script=Hano:][:script=Ital:][:script=Khar:][:script=Linb:][:script=Ogam:][:script=Osma:][:script=Phag:][:script=Phnx:][:script=Runr:][:script=Shaw:][:script=Sylo:][:script=Syrc:][:script=Tagb:][:script=Tglg:][:script=Ugar:][:script=Xpeo:][:script=Xsux:][:block=Combining_Diacritical_Marks _for_Symbols:][:block=Musical_Symbols:][:block=Ancient_Greek_Musical_Notation:]]").freeze();
        System.out.println("functionalExceptCase: " + functionalExceptCase);
        System.out.println("archaic: " + archaic);
        System.out.println("SimpleCaseFolded & !CaseFolded & Functional & !Archaic:\n" + bf.showSetNames(new UnicodeSet(simpleCaseFolded).removeAll(caseFolded).retainAll(functionalExceptCase).removeAll(archaic).removeAll(asciiIdn)));
        UnicodeSet functional = new UnicodeSet(functionalExceptCase).retainAll(caseFolded).freeze();
        System.out.println("functional: " + functional.size());
        UnicodeSet functionalAndNotArchaic = new UnicodeSet(functional).removeAll(archaic).freeze();
        System.out.println("archaic: " + archaic.size());
        System.out.println("functionalAndNotArchaic: " + functionalAndNotArchaic.size());
        UnicodeSet functionalCommon = new UnicodeSet("[:script=common:]").retainAll(functional).removeAll(archaic).removeAll(asciiIdn);
        System.out.println("Common & Functional & !Archaic:\n" + bf.showSetNames(functionalCommon));
        UnicodeSet functionalInherited = new UnicodeSet("[:script=inherited:]").retainAll(functional).removeAll(archaic).removeAll(asciiIdn);
        System.out.println("Inherited & Functional & !Archaic:\n" + bf.showSetNames(functionalInherited));
        UnicodeSet nl = new UnicodeSet("[:Nl:]").retainAll(functional).removeAll(archaic);
        System.out.println("Nl:\n" + bf.showSetNames(new UnicodeSet("[:Nl:]")));
        System.out.println("Nl & Functional & !Archaic:\n" + bf.showSetNames(nl));
        UnicodeSet restrictedXidContinue = new UnicodeSet("[[:xid_continue:]&[:^NFKC_QuickCheck=No:]&[:^default_ignorable_code_point:]&[:^Pc:]]").retainAll(caseFolded);
        System.out.println(bf.showSetDifferences("IDNA Functional", functional, "Unicode XID & NFKC &!DefaultIgnorable &! Pc", restrictedXidContinue));
        Transliterator t = Transliterator.getInstance("lower");
        System.out.println("ABC " + t.transliterate("ABC"));
        BitSet scripts = new BitSet();
        for (int cp = 0; cp < 0x10FFFF; ++cp) {
            script = UScript.getScript(cp);
            if (script == 0 || script == 103 || script == 1) continue;
            scripts.set(script);
        }
        TreeSet<CallSite> toPrint = new TreeSet<CallSite>();
        for (script = 0; script < scripts.size(); ++script) {
            if (!scripts.get(script)) continue;
            String string = UScript.getShortName(script);
            String name = UScript.getName(script);
            if (StandardCodes.isScriptModern(string)) {
                toPrint.add((CallSite)((Object)("modern\t" + string + "\t" + name)));
                continue;
            }
            toPrint.add((CallSite)((Object)("archaic\t" + string + "\t" + name)));
        }
        for (String string : toPrint) {
            System.out.println(string);
        }
    }

    private static void checkCollections() {
        System.out.println("Collections");
        new CldrUtility.Apply<String>(){

            @Override
            public void apply(String item) {
                if (Iso639Data.getScope(item.toString()) != Iso639Data.Scope.Collection) {
                    return;
                }
                System.out.println(item + "\t" + CldrUtility.join(Iso639Data.getNames(item), ", "));
            }
        }.applyTo(Iso639Data.getAvailable());
        System.out.println("\nMacrolanguages");
        new CldrUtility.Apply<String>(){

            @Override
            public void apply(String item) {
                if (Iso639Data.getScope(item.toString()) != Iso639Data.Scope.Macrolanguage) {
                    return;
                }
                System.out.println(item + "\t" + CldrUtility.join(Iso639Data.getNames(item), ", "));
            }
        }.applyTo(Iso639Data.getAvailable());
    }

    static void testToRegex() {
        String[] tests = new String[]{"\\-", "a", "d-f", "\\u2000", "\\uAC00-\\uAC12", "{AB}", "{CDE}", "\\uFFF0-\\U0010000F", "\\U0010100F-\\U0010300F"};
        for (int i = (1 << tests.length) - 1; i >= 0; --i) {
            Object test = "[";
            for (int j = 0; j < tests.length; ++j) {
                if ((i & 1 << j) == 0) continue;
                test = (String)test + tests[j];
            }
            test = (String)test + "]";
            TestMisc.testToRegex(new UnicodeSet((String)test));
        }
    }

    private static void testToRegex(UnicodeSet test) {
        String formatted = CldrUtility.toRegex(test);
        System.out.println(test + "\t->\t" + formatted);
        Matcher newTest = PatternCache.get(formatted).matcher("");
        UnicodeSet failures = new UnicodeSet();
        UnicodeSetIterator it = new UnicodeSetIterator(test);
        while (it.next()) {
            if (newTest.reset(it.getString()).matches()) continue;
            failures.add(it.getString());
        }
        if (failures.size() != 0) {
            System.out.println("\tFailed on: " + failures);
        }
        System.out.flush();
    }

    static void checkEastAsianWidth() {
        UnicodeSet dontCares = new UnicodeSet("[[:surrogate:][:unassigned:][:control:]]").freeze();
        UnicodeSet dontCares2 = new UnicodeSet("[:^letter:]").freeze();
        UnicodeSet strongL = new UnicodeSet("[[:BidiClass=L:]-[:unassigned:]]").freeze();
        TestMisc.showSpans("Bidi L", strongL, dontCares);
        TestMisc.showSpans("Bidi L*", strongL, dontCares2);
        UnicodeSet strongRAL = new UnicodeSet("[[:BidiClass=R:][:BidiClass=AL:]-[:unassigned:]]").freeze();
        TestMisc.showSpans("Bidi R,AL", strongRAL, dontCares);
        TestMisc.showSpans("Bidi R,AL*", strongRAL, dontCares2);
        UnicodeSet strong = new UnicodeSet("[[:BidiClass=L:][:BidiClass=R:][:BidiClass=AL:]-[:unassigned:]]").freeze();
        TestMisc.showSpans("Strong", strong, dontCares);
        TestMisc.showSpans("Strong*", strong, dontCares2);
    }

    private static void showSpans(String title, UnicodeSet sourceSet, UnicodeSet dontCares) {
        System.out.println(title);
        System.out.format("\tSource Set: %s\n", sourceSet);
        System.out.format("\tDon't Cares: %s\n", dontCares);
        UnicodeSet spanned = new UnicodeSet(sourceSet).addBridges(dontCares);
        spanned = spanned.complement().complement();
        String spannedString = spanned.toString();
        String unescapedString = spanned.toPattern(false);
        System.out.format("\tRanges: %d\n", spanned.getRangeCount());
        System.out.format("\tStrlen(\\u): %d\n", spannedString.length());
        System.out.format("\tStrlen(!\\u): %d\n", unescapedString.length());
        String title2 = "Result";
        String sample = spannedString;
        System.out.format("\t%s: %s\n", title2, sample);
        System.out.println();
    }

    void checkCFK() {
    }

    private static void checkDistinguishing() {
        Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        Set<String> cldrFiles = cldrFactory.getAvailableLanguages();
        TreeSet<CallSite> distinguishing = new TreeSet<CallSite>();
        TreeSet<CallSite> nondistinguishing = new TreeSet<CallSite>();
        Iterator<String> it = cldrFiles.iterator();
        while (it.hasNext()) {
            CLDRFile cldrFile = cldrFactory.make(it.next(), false);
            DtdType dtdType = null;
            if (cldrFile.isNonInheriting()) continue;
            for (String path : cldrFile) {
                String fullPath;
                if (dtdType == null) {
                    dtdType = DtdType.fromPath(path);
                }
                if (path.equals(fullPath = cldrFile.getFullXPath(path))) continue;
                XPathParts parts = XPathParts.getFrozenInstance(fullPath);
                for (int i = 0; i < parts.size(); ++i) {
                    Map<String, String> m3 = parts.getAttributes(i);
                    if (m3.size() == 0) continue;
                    String element = parts.getElement(i);
                    for (String attribute : m3.keySet()) {
                        if (CLDRFile.isDistinguishing(dtdType, element, attribute)) {
                            distinguishing.add((CallSite)((Object)(attribute + "\tD\t" + element)));
                            continue;
                        }
                        nondistinguishing.add((CallSite)((Object)(attribute + "\tN\t" + element)));
                    }
                }
            }
        }
        System.out.println("Distinguishing");
        it = distinguishing.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
        System.out.println();
        System.out.println("Non-Distinguishing");
        it = nondistinguishing.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }

    private static void showEnglish() {
        Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        String requestedLocale = "en";
        CLDRFile cldrFile = cldrFactory.make(requestedLocale, true);
        CLDRFile.Status status = new CLDRFile.Status();
        for (String requestedPath : cldrFile) {
            String localeWhereFound = cldrFile.getSourceLocaleID(requestedPath, status);
            if (localeWhereFound.equals(requestedLocale) && status.pathWhereFound.equals(requestedPath)) continue;
            System.out.println("requested path:\t" + requestedPath + "\tfound locale:\t" + localeWhereFound + "\tsame?\t" + localeWhereFound.equals(requestedLocale) + "\tfound path:\t" + status.pathWhereFound + "\tsame?\t" + status.pathWhereFound.equals(requestedPath));
        }
    }

    private static void checkPrivateUse() {
        List<String> data;
        Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        String requestedLocale = "en";
        CLDRFile cldrFile = cldrFactory.make(requestedLocale, true);
        StandardCodes sc = StandardCodes.make();
        HashSet<String> careAbout = new HashSet<String>(Arrays.asList("language", "script", "territory", "variant"));
        HashMap<String, TreeSet<String>> foundItems = new HashMap<String, TreeSet<String>>();
        TreeSet<CallSite> problems = new TreeSet<CallSite>();
        Iterator<String> it = cldrFile.iterator("", new UTF16.StringComparator(true, false, 0));
        while (it.hasNext()) {
            String type;
            String requestedPath = it.next();
            XPathParts parts = XPathParts.getFrozenInstance(requestedPath);
            String element = parts.getElement(-1);
            if (!careAbout.contains(element) || (type = parts.getAttributeValue(-1, "type")) == null) continue;
            TreeSet<String> foundSet = (TreeSet<String>)foundItems.get(element);
            if (foundSet == null) {
                foundSet = new TreeSet<String>();
                foundItems.put(element, foundSet);
            }
            foundSet.add(type);
            data = sc.getFullData(element, type);
            if (data == null) {
                problems.add((CallSite)((Object)("No RFC3066bis data for: " + element + "\t" + type + "\t" + cldrFile.getStringValue(requestedPath))));
                continue;
            }
            if (!TestMisc.isPrivateOrDeprecated(data)) continue;
            problems.add((CallSite)((Object)("Private/Deprecated Data for: " + element + "\t" + type + "\t" + cldrFile.getStringValue(requestedPath) + "\t" + data)));
        }
        it = problems.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
        for (String element : careAbout) {
            Set<String> real = sc.getAvailableCodes(element);
            TreeSet<String> notFound = new TreeSet<String>(real);
            notFound.removeAll((Collection)foundItems.get(element));
            for (String type : notFound) {
                data = sc.getFullData(element, type);
                if (TestMisc.isPrivateOrDeprecated(data)) continue;
                System.out.println("Missing Translation for: " + element + "\t" + type + "\t\t" + data);
            }
        }
    }

    static boolean isPrivateOrDeprecated(List<String> data) {
        if (data.toString().indexOf("PRIVATE") >= 0) {
            return true;
        }
        if ("PRIVATE USE".equals(data.get(0))) {
            return true;
        }
        if (data.size() < 3) {
            return false;
        }
        if (data.get(2) == null) {
            return false;
        }
        return data.get(2).toString().length() != 0;
    }

    static void testPopulous() {
        Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        CLDRFile supp = cldrFactory.make("supplementalData", false);
        CLDRFile temp = SimpleFactory.makeFile("supplemental");
        temp.setNonInheriting(true);
        Iterator<String> it = supp.iterator(null, supp.getComparator());
        while (it.hasNext()) {
            String path = it.next();
            String value = supp.getStringValue(path);
            String fullPath = supp.getFullXPath(path);
            XPathParts parts = XPathParts.getFrozenInstance(fullPath);
            String type = parts.getAttributeValue(-1, "type");
            String pop = language_territory_hack_map.get(type);
            if (pop != null) {
                parts = parts.cloneAsThawed();
                parts.putAttributeValue(-1, "mostPopulousTerritory", pop);
                fullPath = parts.toString();
            }
            temp.add(fullPath, value);
        }
        PrintWriter pw = new PrintWriter(System.out);
        temp.write(pw);
        pw.close();
    }

    static {
        for (int i = 0; i < language_territory_hack.length; ++i) {
            language_territory_hack_map.put(language_territory_hack[i][0], language_territory_hack[i][1]);
        }
    }

    static class MyXSymbolTable
    extends UnicodeSet.XSymbolTable {
        static VariantFolder caseFolder = new VariantFolder(new VariantFolder.CaseVariantFolder());
        static VariantFolder canonicalFolder = new VariantFolder(new VariantFolder.CanonicalFolder());
        static VariantFolder compatibilityFolder = new VariantFolder(new VariantFolder.CompatibilityFolder());

        MyXSymbolTable() {
        }

        @Override
        public boolean applyPropertyAlias(String propertyName, String propertyValue, UnicodeSet result) {
            if (propertyName.equalsIgnoreCase("close")) {
                if (propertyValue.equalsIgnoreCase("case")) {
                    result.addAll(caseFolder.getClosure(result));
                } else if (propertyValue.equalsIgnoreCase("canonical")) {
                    result.addAll(canonicalFolder.getClosure(result));
                } else if (propertyValue.equalsIgnoreCase("compatibility")) {
                    result.addAll(compatibilityFolder.getClosure(result));
                }
                return true;
            }
            if (propertyName.equalsIgnoreCase("reduce")) {
                if (propertyValue.equalsIgnoreCase("case")) {
                    UnicodeSet temp = caseFolder.reduce(result);
                    result.clear().addAll(temp);
                } else if (propertyValue.equalsIgnoreCase("canonical")) {
                    UnicodeSet temp = canonicalFolder.reduce(result);
                    result.clear().addAll(temp);
                } else if (propertyValue.equalsIgnoreCase("compatibility")) {
                    UnicodeSet temp = compatibilityFolder.reduce(result);
                    result.clear().addAll(temp);
                }
                return true;
            }
            if (propertyName.equalsIgnoreCase("reduceCase")) {
                UnicodeSet temp = caseFolder.reduce(new UnicodeSet(propertyValue.replace("\u00b7]", ":]")));
                result.clear().addAll(temp);
                return true;
            }
            if (propertyName.equalsIgnoreCase("reduceCanonical")) {
                UnicodeSet temp = canonicalFolder.reduce(new UnicodeSet(propertyValue.replace("\u00b7]", ":]")));
                result.clear().addAll(temp);
                return true;
            }
            if (propertyName.equalsIgnoreCase("reduceCase")) {
                UnicodeSet temp = caseFolder.reduce(new UnicodeSet(propertyValue.replace("\u00b7]", ":]")));
                result.clear().addAll(temp);
                return true;
            }
            return false;
        }
    }

    static enum Foo {
        A,
        M,
        Z;

    }

    static class Lists {
        Lists() {
        }

        public static <E extends Comparable> List<E> sortedCopy(Collection<E> iterable) {
            ArrayList<E> list = new ArrayList<E>();
            list.addAll(iterable);
            Collections.sort(list);
            return list;
        }
    }
}

