/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.PrettyPath;
import org.unicode.cldr.util.XPathParts;

public class DiffWithParent {
    private static Matcher fileMatcher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        try {
            fileMatcher = PatternCache.get(CldrUtility.getProperty("FILE", ".*")).matcher("");
            Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
            CLDRFile english = cldrFactory.make("en", true);
            TablePrinter table = new TablePrinter().addColumn("Path").setSpanRows(true).addColumn("Locale").addColumn("Value").addColumn("FullPath");
            PrettyPath pp = new PrettyPath();
            for (String locale : cldrFactory.getAvailable()) {
                if (!fileMatcher.reset(locale).matches()) continue;
                System.out.println(locale + "\t" + english.getName(locale));
                CLDRFile file = cldrFactory.make(locale, false);
                String parentLocale = LocaleIDParser.getParent(locale);
                CLDRFile parent = cldrFactory.make(parentLocale, true);
                for (String path : file) {
                    String value = file.getStringValue(path);
                    String fullPath = file.getFullXPath(path);
                    String pvalue = parent.getStringValue(path);
                    String pfullPath = parent.getFullXPath(path);
                    if (value.equals(pvalue) && fullPath.equals(pfullPath)) continue;
                    String pathName = pp.getPrettyPath(path);
                    table.addRow().addCell((Comparable)((Object)pathName)).addCell((Comparable)((Object)locale)).addCell((Comparable)((Object)value)).addCell((Comparable)((Object)DiffWithParent.showDistinguishingAttributes(fullPath))).finishRow();
                    if (pvalue == null) {
                        pvalue = "<i>none</i>";
                    }
                    pfullPath = pfullPath == null ? "<i>none</i>" : DiffWithParent.showDistinguishingAttributes(pfullPath);
                    table.addRow().addCell((Comparable)((Object)pathName)).addCell((Comparable)((Object)parentLocale)).addCell((Comparable)((Object)pvalue)).addCell((Comparable)((Object)pfullPath)).finishRow();
                }
                PrintWriter out = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, locale + "_diff.html");
                String title = locale + " " + english.getName(locale) + " Diff with Parent";
                out.println("<!doctype HTML PUBLIC '-//W3C//DTD HTML 4.0 Transitional//EN'><html><head><meta http-equiv='Content-Type' content='text/html; charset=utf-8'><title>" + title + "</title></head><body>");
                out.println("<h1>" + title + "</h1>");
                out.println("<table  border='1' style='border-collapse: collapse' bordercolor='blue'>");
                out.println(table.toString());
                out.println("</table>");
                out.println("<script>\nvar gaJsHost = ((\"https:\" == document.location.protocol) ? \"https://ssl.\" : \"http://www.\");\ndocument.write(unescape(\"%3Cscript src='\" + gaJsHost + \"google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E\"));\n</script>\n<script>\ntry {\nvar pageTracker = _gat._getTracker(\"UA-7672775-1\");\npageTracker._trackPageview();\n} catch(err) {}</script>");
                out.println("</body></html>");
                out.close();
            }
        }
        finally {
            System.out.println("DONE");
        }
    }

    private static String showDistinguishingAttributes(String fullPath) {
        XPathParts fullParts = XPathParts.getFrozenInstance(fullPath);
        String path = CLDRFile.getDistinguishingXPath(fullPath, null);
        XPathParts parts = XPathParts.getFrozenInstance(path);
        TreeSet<Pair<String, String>> s2 = new TreeSet<Pair<String, String>>();
        for (int i = 0; i < fullParts.size(); ++i) {
            for (String key : fullParts.getAttributeKeys(i)) {
                s2.add(new Pair<String, String>(key, fullParts.getAttributeValue(i, key)));
            }
            for (String key : parts.getAttributeKeys(i)) {
                s2.remove(new Pair<String, String>(key, parts.getAttributeValue(i, key)));
            }
        }
        return ((Object)s2).toString();
    }
}

