/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Objects;
import com.ibm.icu.impl.Row;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.ShowLanguages;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.tool.ToolUtilities;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.CoverageInfo;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.FileCopier;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

public class GenerateChangeChart {
    private static final boolean QUICK_TEST = false;
    private static final String SEP = " \u2022 ";
    private static final String BY_PATH = "by path";
    private static final CLDRConfig CONFIG = CLDRConfig.getInstance();
    private static final SupplementalDataInfo SUP = CONFIG.getSupplementalDataInfo();
    private static CLDRFile ENGLISH = CONFIG.getEnglish();

    public static void main(String[] args) throws IOException {
        Factory current = CONFIG.getCldrFactory();
        Factory old = Factory.make(CLDRPaths.ARCHIVE_DIRECTORY + "/cldr-25.0/common/main", ".*");
        PathHeader.Factory phf = PathHeader.getFactory(ENGLISH);
        TreeSet<Row.R5<PathHeader, CLDRLocale, String, String, String>> data = new TreeSet<Row.R5<PathHeader, CLDRLocale, String, String, String>>();
        CLDRFile currentRoot = current.make("root", true);
        CLDRFile oldRoot = old.make("root", true);
        Set<String> locales = StandardCodes.make().getLocaleCoverageLocales(Organization.cldr, EnumSet.of(Level.MODERN));
        String dir = CLDRPaths.CHART_DIRECTORY + "changes/";
        CoverageInfo coverage = CONFIG.getCoverageInfo();
        EnumSet<PathHeader.SectionId> sections = EnumSet.noneOf(PathHeader.SectionId.class);
        FileCopier.ensureDirectoryExists(dir);
        FileCopier.copy(ShowLanguages.class, "index.css", dir);
        try (PrintWriter out = FileUtilities.openUTF8Writer(dir, "summary.txt");){
            Counter<PathHeader.SectionId> counter = new Counter<PathHeader.SectionId>();
            for (String locale : locales) {
                CLDRLocale cloc = CLDRLocale.getInstance(locale);
                CLDRFile currentFile = current.make(locale, true);
                if (currentFile == null) continue;
                CLDRFile oldFile = old.make(locale, true);
                CLDRFile.Status status = new CLDRFile.Status();
                counter.clear();
                for (PathHeader.SectionId s2 : PathHeader.SectionId.values()) {
                    counter.add(s2, 0L);
                }
                for (String string : oldFile) {
                    String newValue;
                    Level level = coverage.getCoverageLevel(string, locale);
                    if (level.compareTo(Level.MODERN) > 0) continue;
                    String oldValue = oldFile.getStringValue(string);
                    String source = oldFile.getSourceLocaleID(string, status);
                    if (source.equals("code-fallback") || source.equals("root") || oldValue.equals(oldRoot.getStringValue(string)) || Objects.equal(oldValue, newValue = currentFile.getStringValue(string))) continue;
                    String engValue = ENGLISH.getStringValue(string);
                    PathHeader ph = phf.fromPath(string);
                    sections.add(ph.getSectionId());
                    Row.R5<PathHeader, CLDRLocale, String, String, String> key = Row.of(ph, cloc, oldValue, newValue, engValue);
                    data.add(key);
                    counter.add(ph.getSectionId(), 1L);
                }
                String summaryLine = locale + "\t" + ENGLISH.getName(locale) + "\t" + counter;
                System.out.println(summaryLine);
                out.println(summaryLine);
            }
            String topLinks = GenerateChangeChart.buildLinks(sections);
            ChartWriter localeFirstOut = null;
            ChartWriter pathFirstOut = null;
            PathHeader.SectionId lastSectionId = null;
            PrintWriter summary = null;
            int count = 0;
            for (Row.R5 r5 : data) {
                PathHeader pathHeader = (PathHeader)r5.get0();
                PathHeader.SectionId sectionId = pathHeader.getSectionId();
                if (sectionId != lastSectionId) {
                    if (lastSectionId != null) {
                        localeFirstOut.write();
                        pathFirstOut.write();
                        System.out.println(lastSectionId + "\t" + count);
                        out.println(lastSectionId + "\t" + count);
                        count = 0;
                    }
                    localeFirstOut = new LocaleFirstChartWriter(summary, dir, sectionId.toString(), topLinks);
                    pathFirstOut = new PathFirstChartWriter(summary, dir, sectionId.toString() + " by path", topLinks);
                    lastSectionId = sectionId;
                }
                ++count;
                PathHeader.PageId pageId = pathHeader.getPageId();
                String header = pathHeader.getHeader();
                String code = pathHeader.getCode();
                CLDRLocale locale = (CLDRLocale)r5.get1();
                String oldValue = (String)r5.get2();
                String newValue = (String)r5.get3();
                String engValue = (String)r5.get4();
                int votes = SUP.getRequiredVotes(locale, pathHeader);
                ((LocaleFirstChartWriter)localeFirstOut).add(pathHeader, locale, oldValue, newValue, engValue, votes);
                ((PathFirstChartWriter)pathFirstOut).add(pathHeader, locale, oldValue, newValue, engValue, votes);
            }
            localeFirstOut.write();
            pathFirstOut.write();
            System.out.println(lastSectionId + "\t" + count);
            out.println(lastSectionId + "\t" + count);
        }
    }

    public static <T> String buildLinks(Set<T> sections) {
        StringBuilder topLinksBuilder = new StringBuilder("<p align='center'>");
        boolean first = true;
        for (T x : sections) {
            if (!first) {
                topLinksBuilder.append(SEP);
            }
            String xString = x.toString();
            topLinksBuilder.append("<a href='" + FileUtilities.anchorize(xString) + ".html'>" + xString + "</a>");
            topLinksBuilder.append(" (<a href='" + FileUtilities.anchorize(xString + " by path") + ".html'>by path</a>)");
            first = false;
        }
        String topLinks = topLinksBuilder.append("</p>").toString();
        return topLinks;
    }

    private static String getFileName(String string) {
        return string.replaceAll("[^.a-zA-Z0-9]+", "_");
    }

    public static class FormattedFileWriter
    extends Writer {
        private StringWriter out = new StringWriter();
        private String title;
        private String filename;
        private String dir;

        public FormattedFileWriter(PrintWriter indexFile, String dir, String title, String explanation, List<String> anchors) throws IOException {
            this.dir = dir;
            String anchor = FileUtilities.anchorize(title);
            this.filename = anchor + ".html";
            this.title = title;
            if (anchors != null) {
                anchors.add("<a name='" + anchor + "' href='" + this.getFilename() + "'>" + this.getTitle() + "</a></caption>");
            }
            if (explanation != null) {
                this.out.write(explanation);
            }
            this.out.write("<div align='center'>");
        }

        public String getFilename() {
            return this.filename;
        }

        public String getTitle() {
            return this.title;
        }

        @Override
        public void close() throws IOException {
            this.out.write("</div>");
            PrintWriter pw2 = FileUtilities.openUTF8Writer(this.dir, this.filename);
            String[] replacements = new String[]{"%header%", "", "%title%", this.title, "%version%", ToolConstants.CHART_DISPLAY_VERSION, "%date%", CldrUtility.isoFormatDateOnly(new Date()), "%body%", this.out.toString()};
            String templateFileName = "chart-template.html";
            FileUtilities.appendBufferedReader(ToolUtilities.getUTF8Data("chart-template.html"), pw2, replacements);
            pw2.close();
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.out.write(cbuf, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }
    }

    static class ChartWriter
    extends TablePrinter {
        private FormattedFileWriter out;

        public ChartWriter(PrintWriter summary, String dir, String title, String explanation) {
            try {
                this.out = new FormattedFileWriter(summary, dir, title.toString(), explanation, null);
            }
            catch (IOException e) {
                throw new ICUUncheckedIOException(e);
            }
        }

        public void write() {
            try {
                this.out.write(this.toTable());
                this.out.close();
            }
            catch (IOException e) {
                throw new ICUUncheckedIOException(e);
            }
        }
    }

    static class PathFirstChartWriter
    extends ChartWriter {
        public PathFirstChartWriter(PrintWriter summary, String dir, String title, String explanation) {
            super(summary, dir, title, explanation);
            this.addColumn("PageHeader", "class='source'", null, "class='source'", true).setSortPriority(0).setHidden(true).addColumn("Page", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).setSpanRows(true).setBreakSpans(true).addColumn("Header", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).setSpanRows(true).setBreakSpans(true).addColumn("Code", "class='source'", null, "class='source'", true).addColumn("Eng Value", "class='source'", null, "class='source'", true).setSpanRows(true).addColumn("Min Votes", "class='source'", null, "class='source'", true).setSpanRows(true).setSortPriority(1).setSortAscending(false).setBreakSpans(true).addColumn("Locale Name", "class='source'", null, "class='source'", true).setSortPriority(2).setBreakSpans(true).addColumn("Locale ID", "class='source'", null, "class='source'", true).addColumn("Old Value", "class='target'", null, "class='target'", true).addColumn("", "class='target'", null, "class='target'", true).addColumn("New Value", "class='target'", null, "class='target'", true);
        }

        void add(PathHeader pathHeader, CLDRLocale locale, String oldValue, String newValue, String engValue, int votes) {
            String name = ENGLISH.getName(locale.toString());
            PathHeader.PageId pageId = pathHeader.getPageId();
            String header = pathHeader.getHeader();
            String code = pathHeader.getCode();
            this.addRow().addCell(pathHeader).addCell((Comparable)((Object)pageId)).addCell((Comparable)((Object)(header == null ? "" : header))).addCell((Comparable)((Object)code)).addCell((Comparable)((Object)(engValue == null ? "\u2205" : engValue))).addCell(Integer.valueOf(votes)).addCell((Comparable)((Object)name)).addCell(locale).addCell((Comparable)((Object)oldValue)).addCell((Comparable)((Object)"\u2192")).addCell((Comparable)((Object)(newValue == null ? "\u2205" : newValue))).finishRow();
        }
    }

    static class LocaleFirstChartWriter
    extends ChartWriter {
        public LocaleFirstChartWriter(PrintWriter summary, String dir, String title, String explanation) {
            super(summary, dir, title, explanation);
            this.addColumn("Min Votes", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).setSpanRows(true).setSortPriority(0).setSortAscending(false).setBreakSpans(true).addColumn("Locale Name", "class='source'", null, "class='source'", true).setSortPriority(1).setBreakSpans(true).addColumn("Locale ID", "class='source'", null, "class='source'", true).addColumn("PageHeader", "class='source'", null, "class='source'", true).setSortPriority(3).setHidden(true).addColumn("Page", "class='source'", null, "class='source'", true).setSpanRows(true).setBreakSpans(true).addColumn("Header", "class='source'", null, "class='source'", true).setSpanRows(true).setBreakSpans(true).addColumn("Code", "class='source'", null, "class='source'", true).addColumn("Eng Value", "class='source'", null, "class='source'", true).setSpanRows(true).addColumn("Old Value", "class='target'", null, "class='target'", true).addColumn("", "class='target'", null, "class='target'", true).addColumn("New Value", "class='target'", null, "class='target'", true);
        }

        void add(PathHeader pathHeader, CLDRLocale locale, String oldValue, String newValue, String engValue, int votes) {
            String name = ENGLISH.getName(locale.toString());
            PathHeader.PageId pageId = pathHeader.getPageId();
            String header = pathHeader.getHeader();
            String code = pathHeader.getCode();
            this.addRow().addCell(Integer.valueOf(votes)).addCell((Comparable)((Object)name)).addCell(locale).addCell(pathHeader).addCell((Comparable)((Object)pageId)).addCell((Comparable)((Object)(header == null ? "" : header))).addCell((Comparable)((Object)code)).addCell((Comparable)((Object)(engValue == null ? "\u2205" : engValue))).addCell((Comparable)((Object)oldValue)).addCell((Comparable)((Object)"\u2192")).addCell((Comparable)((Object)(newValue == null ? "\u2205" : newValue))).finishRow();
        }
    }
}

