/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.ImmutableMap;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Iso639Data;
import org.unicode.cldr.util.Log;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.Validity;
import org.unicode.cldr.util.XPathParts;

public class GenerateEnums {
    private static final String CODE_INDENT = "  ";
    private static final String DATA_INDENT = "    ";
    private static final String LIST_INDENT = "              ";
    private StandardCodes sc = StandardCodes.make();
    private Factory factory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
    private Set<String> cldrCodes = new TreeSet<String>();
    private Map<String, String> enum_alpha3 = new TreeMap<String, String>();
    private Map<String, String> enum_UN = new TreeMap<String, String>();
    private CLDRFile english = this.factory.make("en", false);
    private CLDRFile supplementalMetadata = this.factory.make("supplementalMetadata", false);
    private CLDRFile supplementalData = this.factory.make("supplementalData", false);
    private Relation<String, String> unlimitedCurrencyCodes;
    private Set<String> scripts = new TreeSet<String>();
    private Set<String> languages = new TreeSet<String>();
    static NumberFormat threeDigit = new DecimalFormat("000");
    Map<String, List<String>> containment = new TreeMap<String, List<String>>();
    Set<String> corrigendum = new TreeSet<String>(Arrays.asList("QE", "833", "830", "172"));
    private ImmutableMap<String, String> extraNames = ImmutableMap.builder().put("BU", "Burma").put("TP", "East Timor").put("YU", "Yugoslavia").put("ZR", "Zaire").put("CD", "Congo (Kinshasa, Democratic Republic)").put("CI", "Ivory Coast (Cote d'Ivoire)").put("FM", "Micronesia (Federated States)").put("TL", "East Timor (Timor-Leste)").build();
    private Set<String> currencyCodes;
    private Set<String> validCurrencyCodes;
    static SupplementalDataInfo supplementalDataInfo = SupplementalDataInfo.getInstance(CLDRPaths.SUPPLEMENTAL_DIRECTORY);
    static NumberFormat nf = NumberFormat.getInstance(Locale.ENGLISH);
    static NumberFormat sf = NumberFormat.getScientificInstance(Locale.ENGLISH);
    static Transliterator doFallbacks;

    public static void main(String[] args) throws IOException {
        GenerateEnums gen = new GenerateEnums();
        gen.showLanguageInfo();
        gen.loadCLDRData();
        gen.showCounts();
        gen.showCurrencies();
        gen.showLanguages();
        gen.showScripts();
        gen.showRegionCodeInfo();
        System.out.println("DONE");
    }

    private void showCounts() {
        System.out.format("Language Subtags: %s\n", this.sc.getGoodAvailableCodes("language").size());
        System.out.format("Script Subtags: %s\n", this.sc.getGoodAvailableCodes("script").size());
        System.out.format("Territory Subtags: %s\n", this.sc.getGoodAvailableCodes("territory").size());
    }

    private void showCurrencies() throws IOException {
        Log.setLog(CLDRPaths.GEN_DIRECTORY + "/enum/currency_enum.txt");
        Log.println();
        Log.println("Currency Data");
        Log.println();
        this.showGeneratedCommentStart(CODE_INDENT);
        this.compareSets("currencies from sup.data", this.currencyCodes, "valid currencies", this.validCurrencyCodes);
        TreeSet<String> unused = new TreeSet<String>(this.validCurrencyCodes);
        unused.removeAll(this.currencyCodes);
        this.showCurrencies(this.currencyCodes);
        Log.println();
        this.showCurrencies(unused);
        TreeMap<Object, String> sorted = new TreeMap<Object, String>(Collator.getInstance(ULocale.ENGLISH));
        for (String code : this.validCurrencyCodes) {
            if (unused.contains(code) && !code.equals("CLF")) continue;
            sorted.put(this.getName(code), code);
        }
        int lineLength = "  /** Belgian Franc */                                            BEF,".length();
        for (String name : sorted.keySet()) {
            this.printRow(Log.getLog(), (String)sorted.get(name), name, "currency", null, lineLength);
        }
        this.showGeneratedCommentEnd(CODE_INDENT);
        Log.close();
    }

    private String getName(String code) {
        String result = this.english.getName(4, code);
        if (result == null) {
            result = code;
            System.out.println("Failed to find: " + code);
        }
        return result;
    }

    private void showCurrencies(Set<String> both) {
        for (String code : both) {
            String englishName = this.getName(code);
            if (englishName == null) {
                // empty if block
            }
            Set<String> regions = this.unlimitedCurrencyCodes.getAll(code);
            System.out.println(code + "\t" + englishName + "\t" + (this.validCurrencyCodes.contains(code) ? (this.currencyCodes.contains(code) ? "" : "valid-only") : "supp-only") + "\t" + (regions != null ? regions : "unused"));
        }
    }

    private void showScripts() throws IOException {
        Log.setLog(CLDRPaths.GEN_DIRECTORY + "/enum/script_enum.txt");
        Log.println();
        Log.println("Script Data");
        Log.println();
        this.showGeneratedCommentStart(CODE_INDENT);
        TreeMap<String, String> code_replacements = new TreeMap<String, String>();
        int len = "  /** Arabic */                                        Arab,".length();
        for (String code : this.scripts) {
            String englishName = this.english.getName(1, code);
            if (englishName == null) continue;
            this.printRow(Log.getLog(), code, null, "script", code_replacements, len);
        }
        this.showGeneratedCommentEnd(CODE_INDENT);
        Log.close();
    }

    private void showLanguageInfo() throws IOException {
        Log.setLog(CLDRPaths.GEN_DIRECTORY + "/enum/language_info.txt");
        System.out.println();
        System.out.println("Language Converter");
        System.out.println();
        StringBuilder buffer = new StringBuilder();
        for (String language : this.sc.getAvailableCodes("language")) {
            Iso639Data.Type type;
            Iso639Data.Scope scope = Iso639Data.getScope(language);
            if (scope == Iso639Data.Scope.PrivateUse) continue;
            buffer.setLength(0);
            String alpha3 = Iso639Data.toAlpha3(language);
            if (alpha3 != null) {
                buffer.append(".add(\"" + alpha3 + "\")");
            }
            if ((type = Iso639Data.getType(language)) != Iso639Data.Type.Living) {
                buffer.append(".add(Type." + type + ")");
            }
            if (scope != Iso639Data.Scope.Individual) {
                buffer.append(".add(Scope." + scope + ")");
            }
            if (buffer.length() <= 0) continue;
            Log.println("\t\tto(\"" + language + "\")" + buffer + ";");
        }
        Log.close();
    }

    private void showLanguages() throws IOException {
        Log.setLog(CLDRPaths.GEN_DIRECTORY + "/enum/language_enum.txt");
        System.out.println();
        System.out.println("Language Data");
        System.out.println();
        for (String code : this.languages) {
            String englishName = this.english.getName(0, code);
            if (englishName == null) continue;
            System.out.println("     /**" + englishName + "*/    " + code + ",");
        }
        this.showGeneratedCommentStart(LIST_INDENT);
        StringBuffer buffer = new StringBuffer();
        int lineLimit = 70 - LIST_INDENT.length();
        char lastChar = '\u0000';
        for (String code : this.languages) {
            if (code.equals("root")) continue;
            if (code.charAt(0) != lastChar || buffer.length() + 1 + code.length() > lineLimit) {
                if (buffer.length() != 0) {
                    Log.println("              + \"" + buffer + "\"");
                }
                buffer.setLength(0);
                lastChar = code.charAt(0);
            }
            buffer.append(code).append(' ');
        }
        if (buffer.charAt(buffer.length() - 1) == ' ') {
            buffer.setLength(buffer.length() - 1);
        }
        Log.println("              + \"" + buffer + "\"");
        this.showGeneratedCommentEnd(LIST_INDENT);
        Log.close();
    }

    private Object join(Collection collection, String separator) {
        if (collection == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        boolean first = true;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                result.append(separator);
            }
            result.append(it.next());
        }
        return result.toString();
    }

    public void loadCLDRData() throws IOException {
        String line;
        DecimalFormat threeDigits = new DecimalFormat("000");
        for (String value : supplementalDataInfo.getNumericTerritoryMapping().keySet()) {
            this.cldrCodes.add(value);
            if (GenerateEnums.isPrivateUseRegion(value)) continue;
            this.enum_UN.put(value, threeDigits.format(supplementalDataInfo.getNumericTerritoryMapping().getAll(value).iterator().next()));
        }
        for (String value : supplementalDataInfo.getAlpha3TerritoryMapping().keySet()) {
            this.cldrCodes.add(value);
            if (GenerateEnums.isPrivateUseRegion(value)) continue;
            this.enum_alpha3.put(value, supplementalDataInfo.getAlpha3TerritoryMapping().getAll(value).iterator().next());
        }
        BufferedReader codes = CldrUtility.getUTF8Data("UnMacroRegions.txt");
        TreeMap<String, String> macro_name = new TreeMap<String, String>();
        while ((line = codes.readLine()) != null) {
            if ((line = line.trim()).length() == 0) continue;
            if (line.charAt(0) < '0' || line.charAt(0) > '9') {
                System.out.println("GenerateEnums: Skipping: " + line);
                continue;
            }
            String[] sourceValues = line.split("\\s+");
            int code = Integer.parseInt(sourceValues[0]);
            String codeName = threeDigit.format(code);
            macro_name.put(codeName, line);
        }
        codes.close();
        Map<Validity.Status, Set<String>> validRegions = Validity.getInstance().getStatusToCodes(StandardCodes.LstrType.region);
        TreeSet regions = new TreeSet();
        regions.addAll(validRegions.get((Object)Validity.Status.regular));
        regions.addAll(validRegions.get((Object)Validity.Status.macroregion));
        for (String region : regions) {
            if (this.corrigendum.contains(region)) {
                System.out.println("Skipping " + region + "\t\t" + this.getEnglishName(region));
                continue;
            }
            if (GenerateEnums.isPrivateUseRegion(region)) continue;
            if (region.charAt(0) < 'A') {
                this.enum_UN.put(this.enumName(region), region);
                this.cldrCodes.add(region);
                continue;
            }
            if (this.enum_alpha3.get(region) != null) continue;
            System.out.println("Missing alpha3 for: " + region);
        }
        this.checkDuplicates(this.enum_UN);
        this.checkDuplicates(this.enum_alpha3);
        TreeSet<String> availableCodes = new TreeSet<String>(this.sc.getAvailableCodes("territory"));
        this.compareSets("RFC 4646", availableCodes, "CLDR", this.cldrCodes);
        TreeSet<String> missing = new TreeSet<String>((Collection<String>)availableCodes);
        missing.removeAll(this.cldrCodes);
        missing.remove("EA");
        missing.remove("EZ");
        missing.remove("IC");
        missing.remove("QU");
        missing.remove("UN");
        if (missing.size() != 0) {
            throw new IllegalArgumentException("Codes in Registry but not in CLDR: " + missing);
        }
        TreeSet<String> UNValues = new TreeSet<String>(this.enum_UN.values());
        for (Object key : macro_name.keySet()) {
            Object value = macro_name.get(key);
            if (UNValues.contains(key)) continue;
            System.out.println("Macro " + key + "\t" + value);
        }
        for (String region : this.enum_UN.keySet()) {
            String rfcName;
            String englishName = this.getEnglishName(region);
            if (englishName == null) {
                englishName = "NULL";
            }
            if (englishName.equals(rfcName = this.getRFC3066Name(region))) continue;
            System.out.println("Different names: {\"" + region + "\",\t\"" + englishName + " (" + rfcName + ")\"},");
        }
        this.getContainment();
        DateFormat[] simpleFormats = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyy-MM"), new SimpleDateFormat("yyyy")};
        Date today = new Date();
        Date longAgo = new Date(-900, 1, 1);
        this.currencyCodes = new TreeSet<String>();
        this.unlimitedCurrencyCodes = Relation.of(new TreeMap(), TreeSet.class, null);
        Iterator<String> it = this.supplementalData.iterator("//supplementalData/currencyData/region");
        while (it.hasNext()) {
            String code;
            block21: {
                String path = it.next();
                XPathParts parts = XPathParts.getFrozenInstance(path);
                String region = parts.findAttributeValue("region", "iso3166");
                code = parts.findAttributeValue("currency", "iso4217");
                String to = parts.findAttributeValue("currency", "to");
                if (to == null) {
                    this.unlimitedCurrencyCodes.put(code, region);
                } else {
                    for (int i = 0; i < simpleFormats.length; ++i) {
                        try {
                            Date foo = simpleFormats[i].parse(to);
                            if (foo.compareTo(longAgo) < 0) {
                                System.out.println("Date Error: can't parse " + to);
                            } else if (foo.compareTo(today) >= 0) {
                                this.unlimitedCurrencyCodes.put(code, region);
                            }
                            break block21;
                        }
                        catch (ParseException parseException) {
                            continue;
                        }
                    }
                    System.out.println("Date Error: can't parse " + to);
                }
            }
            this.currencyCodes.add(code);
        }
        this.validCurrencyCodes = new TreeSet<String>();
        Set<String> bcp47CurrencyCodes = supplementalDataInfo.getBcp47Keys().getAll("cu");
        for (String code : bcp47CurrencyCodes) {
            this.validCurrencyCodes.add(code.toUpperCase());
        }
        this.scripts = supplementalDataInfo.getCLDRScriptCodes();
        this.languages = supplementalDataInfo.getCLDRLanguageCodes();
    }

    public void getContainment() {
        Iterator<String> it = this.supplementalData.iterator("//supplementalData/territoryContainment/group");
        while (it.hasNext()) {
            String path = it.next();
            String fullPath = this.supplementalData.getFullXPath(path);
            XPathParts parts = XPathParts.getFrozenInstance(fullPath);
            String container = parts.getAttributeValue(parts.size() - 1, "type");
            String containedString = parts.getAttributeValue(-1, "contains");
            List<String> contained = Arrays.asList(containedString.trim().split("\\s+"));
            this.containment.put(container, contained);
        }
        TreeSet<String> startingFromWorld = new TreeSet<String>();
        this.addContains("001", startingFromWorld);
        this.compareSets("World", startingFromWorld, "CLDR", this.cldrCodes);
    }

    private void generateContains() {
        for (String region : this.containment.keySet()) {
            List<String> plain = this.containment.get(region);
            String setAsString = CldrUtility.join(plain, " ");
            Log.println("\t\tadd(\"" + region + "\", \"" + setAsString + "\");");
        }
    }

    private void addContains(String string, Set<String> startingFromWorld) {
        startingFromWorld.add(string);
        List<String> contained = this.containment.get(string);
        if (contained == null) {
            return;
        }
        Iterator<String> it = contained.iterator();
        while (it.hasNext()) {
            this.addContains(it.next(), startingFromWorld);
        }
    }

    private void compareSets(String name, Set availableCodes, String name2, Set cldrCodes) {
        TreeSet temp = new TreeSet();
        temp.addAll(availableCodes);
        temp.removeAll(cldrCodes);
        System.out.println("In " + name + " but not in " + name2 + ": " + temp);
        temp.clear();
        temp.addAll(cldrCodes);
        temp.removeAll(availableCodes);
        System.out.println("Not in " + name + " but in " + name2 + ": " + temp);
    }

    private void checkDuplicates(Map m3) {
        HashMap backMap = new HashMap();
        for (Object key : m3.keySet()) {
            Object o = m3.get(key);
            Object otherKey = backMap.get(o);
            if (otherKey != null) {
                System.out.println("Collision with: " + key + ",\t" + otherKey + ",\t" + o);
                continue;
            }
            backMap.put(o, key);
        }
    }

    private void showRegionCodeInfo() throws IOException {
        Log.setLog(CLDRPaths.GEN_DIRECTORY + "/enum/region_enum.txt");
        System.out.println();
        System.out.println("Data for RegionCode");
        System.out.println();
        this.showGeneratedCommentStart(CODE_INDENT);
        TreeSet<Object> reordered = new TreeSet<Object>(new LengthFirstComparator());
        reordered.addAll(this.enum_UN.keySet());
        TreeMap<String, String> code_replacements = new TreeMap<String, String>();
        int len = "  /** Polynesia */                                    UN061,".length();
        for (String string : reordered) {
            this.printRow(Log.getLog(), string, null, "territory", code_replacements, len);
        }
        this.showGeneratedCommentEnd(CODE_INDENT);
        Log.close();
        Log.setLog(CLDRPaths.GEN_DIRECTORY + "/enum/region_info.txt");
        Log.println();
        Log.println("Data for ISO Region Codes");
        Log.println();
        for (String string : supplementalDataInfo.getTerritoriesWithPopulationData()) {
            if (string.equals("ZZ")) continue;
            SupplementalDataInfo.PopulationData popData = supplementalDataInfo.getPopulationDataForTerritory(string);
            Log.formatln("    addRegion(RegionCode.%s, %s, %s, %s) // %s", string, this.format(popData.getPopulation()), this.format(popData.getLiteratePopulation() / popData.getPopulation()), this.format(popData.getGdp()), this.english.getName("territory", string));
            TreeSet<String> languages = new TreeSet<String>();
            for (String language : supplementalDataInfo.getLanguagesForTerritoryWithPopulationData(string)) {
                if (Iso639Data.getSource(language) == Iso639Data.Source.ISO_639_3 || (popData = supplementalDataInfo.getLanguageAndTerritoryPopulationData(language, string)).getPopulation() == 0.0 || Double.isNaN(popData.getLiteratePopulation() / popData.getPopulation())) continue;
                languages.add(language);
            }
            int count = languages.size();
            for (String language : languages) {
                popData = supplementalDataInfo.getLanguageAndTerritoryPopulationData(language, string);
                Log.formatln("    .addLanguage(\"%s\", %s, %s)%s // %s", language, this.format(popData.getPopulation()), this.format(popData.getLiteratePopulation() / popData.getPopulation()), --count == 0 ? ";" : "", this.english.getName(language));
            }
        }
        Log.close();
        Log.setLog(CLDRPaths.GEN_DIRECTORY + "/enum/region_converters.txt");
        Log.println();
        Log.println("Data for ISO Region Codes");
        Log.println();
        this.showGeneratedCommentStart(DATA_INDENT);
        reordered = new TreeSet<Object>(new DeprecatedAndLengthFirstComparator("territory"));
        reordered.addAll(this.enum_UN.keySet());
        for (String string : reordered) {
            String isoCode = this.enum_alpha3.get(string);
            if (isoCode == null) continue;
            Log.println("    add(" + GenerateEnums.quote(isoCode) + ", RegionCode." + string + ");");
        }
        this.doAliases(code_replacements);
        this.showGeneratedCommentEnd(DATA_INDENT);
        Log.println();
        Log.println("Data for M.49 Region Codes");
        Log.println();
        this.showGeneratedCommentStart(DATA_INDENT);
        for (String string : reordered) {
            int un = Integer.parseInt(this.enum_UN.get(string), 10);
            Log.println("    add(" + un + ", RegionCode." + string + ");");
        }
        this.doAliases(code_replacements);
        System.out.println("Plain list");
        for (String string : reordered) {
            String newCode = (String)code_replacements.get(string);
            if (newCode != null) continue;
            int un = Integer.parseInt(this.enum_UN.get(string), 10);
            System.out.println(un + "\t" + string + "\t" + this.english.getName("territory", string));
        }
        this.showGeneratedCommentEnd(DATA_INDENT);
        this.getContainment();
        Log.close();
    }

    private String format(double value) {
        double newValue = CldrUtility.roundToDecimals(value, 3);
        String option1 = nf.format(newValue);
        String option2 = sf.format(value);
        return option1.length() <= option2.length() ? option1 : option2;
    }

    private void doAliases(Map<String, String> code_replacements) {
        for (String code : code_replacements.keySet()) {
            String newCode = code_replacements.get(code);
            if (newCode.length() == 0) {
                newCode = "ZZ";
            }
            Log.println("    addAlias(RegionCode." + code + ", \"" + newCode + "\");");
        }
    }

    private void showGeneratedCommentEnd(String indent) {
        Log.println(indent + "/* End of generated code. */");
    }

    private void showGeneratedCommentStart(String indent) {
        Log.println(indent + "/*");
        Log.println(indent + " * The following information is generated from a tool,");
        Log.println(indent + " * as described on");
        Log.println(indent + " * http://wiki/Main/InternationalIdentifierUpdates.");
        Log.println(indent + " * Do not edit manually.");
        Log.println(indent + " * Start of generated code.");
        Log.println(indent + " */");
    }

    public String getDeprecatedReplacement(String type, String cldrTypeValue) {
        if (type.equals("currency")) {
            return null;
        }
        String path = this.supplementalMetadata.getFullXPath("//supplementalData/metadata/alias/" + type + "Alias[@type=\"" + cldrTypeValue + "\"]", true);
        if (path == null) {
            return null;
        }
        XPathParts parts = XPathParts.getFrozenInstance(path);
        String replacement = parts.findAttributeValue("territoryAlias", "replacement");
        if (replacement == null) {
            return "";
        }
        return replacement;
    }

    private void printRow(PrintWriter out, String codeName, String englishName, String type, Map<String, String> code_replacements, int lineLength) {
        String cldrName = codeName.length() < 5 ? codeName : codeName.substring(2);
        String replacement = this.getDeprecatedReplacement(type, cldrName);
        String resolvedEnglishName = englishName != null ? englishName : (type.equals("territory") ? this.getEnglishName(codeName) : (type.equals("currency") ? this.getName(codeName) : this.english.getName(1, codeName)));
        resolvedEnglishName = doFallbacks.transliterate(resolvedEnglishName);
        String prefix = "  /** " + resolvedEnglishName;
        Object printedCodeName = codeName;
        if (replacement != null) {
            code_replacements.put(codeName, replacement);
            out.println(prefix);
            prefix = "   * @deprecated" + (String)(replacement.length() == 0 ? "" : " see " + replacement);
            printedCodeName = "@Deprecated " + (String)printedCodeName;
        }
        prefix = prefix + " */";
        if (codeName.equals("UN001")) {
            out.println();
        }
        if (prefix.length() > lineLength - (((String)printedCodeName).length() + 1)) {
            int lastFit = prefix.lastIndexOf(32, lineLength - (((String)printedCodeName).length() + 1) - 2);
            out.println(prefix.substring(0, lastFit));
            prefix = "   *" + prefix.substring(lastFit);
        }
        out.print(prefix);
        out.print(Utility.repeat(" ", lineLength - (prefix.length() + ((String)printedCodeName).length() + 1)));
        out.println((String)printedCodeName + ",");
    }

    private String getEnglishName(String codeName) {
        String name;
        if (codeName.length() > 3) {
            codeName = codeName.substring(2);
        }
        if ((name = this.extraNames.get(codeName)) != null) {
            return name;
        }
        name = this.english.getName(2, codeName);
        if (name != null) {
            return name;
        }
        return codeName;
    }

    private String getRFC3066Name(String codeName) {
        List<String> list;
        if (codeName.length() > 2) {
            codeName = codeName.substring(2);
        }
        if ((list = this.sc.getFullData("territory", codeName)) == null) {
            return null;
        }
        return list.get(0);
    }

    private String enumName(String codeName) {
        return codeName.charAt(0) < 'A' ? "UN" + codeName : codeName;
    }

    static String quote(Object input) {
        if (input != null) {
            return "\"" + input.toString().trim() + "\"";
        }
        return null;
    }

    static boolean isPrivateUseRegion(String codeName) {
        if (codeName.equals("EU") || codeName.equals("QO") || codeName.equals("ZZ")) {
            return false;
        }
        if (codeName.equals("AA") || codeName.equals("ZZ")) {
            return true;
        }
        if (codeName.compareTo("QM") >= 0 && codeName.compareTo("QZ") <= 0) {
            return true;
        }
        return codeName.compareTo("XA") >= 0 && codeName.compareTo("XZ") <= 0;
    }

    static {
        nf.setMaximumFractionDigits(3);
        sf.setMaximumFractionDigits(3);
        nf.setGroupingUsed(false);
        doFallbacks = Transliterator.createFromRules("id", "[\u2019\u02bb] > ''; ", 0);
    }

    public final class DeprecatedAndLengthFirstComparator
    implements Comparator<Object> {
        String type;

        DeprecatedAndLengthFirstComparator(String type) {
            this.type = type;
        }

        @Override
        public int compare(Object a, Object b) {
            String as = a.toString();
            String bs = b.toString();
            String ar = GenerateEnums.this.getDeprecatedReplacement(this.type, as);
            String br = GenerateEnums.this.getDeprecatedReplacement(this.type, bs);
            if (ar != null && br == null) {
                return -1;
            }
            if (br != null && ar == null) {
                return 1;
            }
            if (as.length() < bs.length()) {
                return -1;
            }
            if (as.length() > bs.length()) {
                return 1;
            }
            return as.compareTo(bs);
        }
    }

    public static final class LengthFirstComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object a, Object b) {
            String as = a.toString();
            String bs = b.toString();
            if (as.length() < bs.length()) {
                return -1;
            }
            if (as.length() > bs.length()) {
                return 1;
            }
            return as.compareTo(bs);
        }
    }
}

