/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.Row;
import com.ibm.icu.text.UnicodeSet;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.PathDescription;
import org.unicode.cldr.util.PathHeader;

public class ShowPathHeaderDescriptions {
    public static void main(String[] args) {
        CLDRConfig config = CLDRConfig.getInstance();
        Factory factory = config.getCommonAndSeedAndMainAndAnnotationsFactory();
        CLDRFile english = factory.make("en", true);
        PathHeader.Factory phf = PathHeader.getFactory(english);
        String localeToTest = "cs";
        CLDRFile localeFile = factory.make(localeToTest, true);
        LinkedHashMultiset<CallSite> sectionPageHeader = LinkedHashMultiset.create();
        LinkedHashMultiset<CallSite> sectionPage = LinkedHashMultiset.create();
        TreeSet<PathHeader> pathHeaders = new TreeSet<PathHeader>();
        UnicodeSet emoji = new UnicodeSet("[:emoji:]");
        for (String path : localeFile.fullIterable()) {
            Level level;
            PathHeader pathHeader;
            if (emoji.containsSome(path)) {
                // empty if block
            }
            if ((pathHeader = phf.fromPath(path)).getSectionId() == PathHeader.SectionId.Characters) {
                System.out.println(pathHeader);
            }
            if ((level = config.getSupplementalDataInfo().getCoverageLevel(path, localeToTest)).compareTo(Level.MODERN) > 0) continue;
            pathHeaders.add(pathHeader);
        }
        for (PathHeader pathHeader : pathHeaders) {
            String base = pathHeader.getSectionId() + "\t" + pathHeader.getPageId();
            sectionPage.add((CallSite)((Object)base));
            String item = base + "\t" + pathHeader.getHeader();
            sectionPageHeader.add((CallSite)((Object)item));
        }
        int i = 0;
        for (Multiset.Entry entry : sectionPage.entrySet()) {
            System.out.println(++i + "\t" + (String)entry.getElement() + "\t" + entry.getCount());
        }
        i = 0;
        for (Multiset.Entry entry : sectionPageHeader.entrySet()) {
            System.out.println(++i + "\t" + (String)entry.getElement() + "\t" + entry.getCount());
        }
    }

    public static void showDescriptions(String[] args) {
        CLDRConfig config = CLDRConfig.getInstance();
        CLDRFile english = config.getEnglish();
        PathHeader.Factory phf = PathHeader.getFactory(english);
        PathDescription pathDescriptionFactory = new PathDescription(config.getSupplementalDataInfo(), english, null, null, PathDescription.ErrorHandling.CONTINUE);
        TreeMultimap<PathHeader.SectionId, String> sv = TreeMultimap.create();
        TreeMultimap<PathHeader.PageId, String> pv = TreeMultimap.create();
        TreeMultimap<Object, String> hv = TreeMultimap.create();
        TreeMultimap<Row.R2<PathHeader.SectionId, PathHeader.PageId>, String> spv = TreeMultimap.create();
        TreeMultimap<Row.R2<PathHeader.SectionId, Object>, String> shv = TreeMultimap.create();
        TreeMultimap<Row.R2<PathHeader.PageId, Object>, String> phv = TreeMultimap.create();
        TreeMultimap<Row.R3<PathHeader.SectionId, PathHeader.PageId, Object>, String> sphv = TreeMultimap.create();
        TreeMultimap<String, Row.R3<PathHeader.SectionId, PathHeader.PageId, String>> valueToKey = TreeMultimap.create();
        TreeSet<String> urls = new TreeSet<String>();
        for (String path : english) {
            PathHeader pathHeader = phf.fromPath(path);
            String pdx = pathDescriptionFactory.getRawDescription(path, "VALUE", null);
            String url = pdx == null ? "NONE" : ShowPathHeaderDescriptions.extractUrl(pdx);
            urls.add(url);
            PathHeader.SectionId sectionId = pathHeader.getSectionId();
            PathHeader.PageId pageId = pathHeader.getPageId();
            Object header = pathHeader.getHeader();
            int usingPos = ((String)header).indexOf(" using ");
            if (usingPos > 0) {
                header = ((String)header).substring(0, usingPos) + " using * Digits";
            }
            if (((String)header).startsWith("Append-Fallback-")) {
                header = "Append-Fallback-*(calendar)";
            }
            sv.put(sectionId, url);
            pv.put(pageId, url);
            hv.put(header, url);
            spv.put(Row.of(sectionId, pageId), url);
            shv.put(Row.of(sectionId, header), url);
            phv.put(Row.of(pageId, header), url);
            Row.R3<PathHeader.SectionId, PathHeader.PageId, Object> full = Row.of(sectionId, pageId, header);
            sphv.put(full, url);
            valueToKey.put(url, full);
        }
        HashSet<String> done = new HashSet<String>();
        ShowPathHeaderDescriptions.process(SphType.s, sv, done);
        ShowPathHeaderDescriptions.process(SphType.p, pv, done);
        ShowPathHeaderDescriptions.process(SphType.h, hv, done);
        ShowPathHeaderDescriptions.showProgress(done, valueToKey);
        ShowPathHeaderDescriptions.process(SphType.sp, spv, done);
        ShowPathHeaderDescriptions.process(SphType.sh, shv, done);
        ShowPathHeaderDescriptions.process(SphType.ph, phv, done);
        ShowPathHeaderDescriptions.process(SphType.sph, sphv, done);
        System.out.println(Joiner.on("\n").join(urls));
    }

    private static void showProgress(Set<String> done, Multimap<String, Row.R3<PathHeader.SectionId, PathHeader.PageId, String>> valueToKey) {
        TreeSet<String> temp = new TreeSet<String>(valueToKey.keys());
        temp.removeAll(done);
        System.out.println(temp);
    }

    private static <K> void process(SphType type, Multimap<K, String> sv, Set<String> done) {
        HashSet<String> newDone = new HashSet<String>();
        for (Map.Entry<K, Collection<String>> item : sv.asMap().entrySet()) {
            TreeSet<String> remaining = new TreeSet<String>();
            remaining.addAll(item.getValue());
            remaining.removeAll(done);
            if (remaining.size() != 1) continue;
            String value = (String)remaining.iterator().next();
            if (type == SphType.s || type == SphType.p || type == SphType.sp) {
                done.add(value);
            } else {
                newDone.add(value);
            }
            System.out.println(ShowPathHeaderDescriptions.getThree(type, item.getKey()) + "\t" + value);
        }
        done.addAll(newDone);
    }

    private static <K> String getThree(SphType type, K k) {
        switch (type) {
            case s: {
                return k + "\t*\t*";
            }
            case p: {
                return "*\t" + k + "\t*";
            }
            case h: {
                return "*\t*\t" + k;
            }
            case sp: {
                return ((Row.R2)k).get0() + "\t" + ((Row.R2)k).get1() + "\t*";
            }
            case sh: {
                return ((Row.R2)k).get0() + "\t*\t" + ((Row.R2)k).get2();
            }
            case ph: {
                return "*\t" + ((Row.R2)k).get1() + "\t" + ((Row.R2)k).get2();
            }
            case sph: {
                return ((Row.R3)k).get0() + "\t" + ((Row.R3)k).get1() + "\t" + ((Row.R3)k).get2();
            }
        }
        throw new IllegalArgumentException();
    }

    private static String extractUrl(String pd) {
        String value = pd.replaceAll("^.*(http://.*)$", "$1");
        if (value.endsWith(".")) {
            value = value.substring(0, value.length() - 1);
        }
        if (value.endsWith(" for details")) {
            value = value.substring(0, value.length() - " for details".length());
        }
        return value;
    }

    static enum SphType {
        s,
        p,
        h,
        sp,
        sh,
        ph,
        sph;

    }
}

