/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class TablePrinter {
    private List<Column> columns = new ArrayList<Column>();
    private String tableAttributes;
    private transient Column[] columnsFlat;
    private List<Comparable<Object>[]> rows = new ArrayList<Comparable<Object>[]>();
    private String caption;
    Collection<Comparable<Object>> partialRow;
    ColumnSorter<Comparable> columnSorter = new ColumnSorter();
    private boolean sort;
    static final UnicodeSet BIDI = new UnicodeSet("[[:bc=R:][:bc=AL:]]");
    static final char RLE = '\u202b';
    static final char PDF = '\u202c';
    private BitSet breaksSpans = new BitSet();

    public static void main(String[] args) {
        TablePrinter tablePrinter = new TablePrinter().setTableAttributes("style='border-collapse: collapse' border='1'").addColumn("Language").setSpanRows(true).setSortPriority(0).setBreakSpans(true).addColumn("Junk").setSpanRows(true).addColumn("Territory").setHeaderAttributes("bgcolor='green'").setCellAttributes("align='right'").setSpanRows(true).setSortPriority(1).setSortAscending(false);
        Comparable[][] data = new Comparable[][]{{"German", Double.valueOf(1.3), Integer.valueOf(3)}, {"French", Double.valueOf(1.3), Integer.valueOf(2)}, {"English", Double.valueOf(1.3), Integer.valueOf(2)}, {"English", Double.valueOf(1.3), Integer.valueOf(4)}, {"English", Double.valueOf(1.3), Integer.valueOf(6)}, {"English", Double.valueOf(1.3), Integer.valueOf(8)}, {"Arabic", Double.valueOf(1.3), Integer.valueOf(5)}, {"Zebra", Double.valueOf(1.3), Integer.valueOf(10)}};
        tablePrinter.addRows(data);
        tablePrinter.addRow().addCell((Comparable)((Object)"Foo")).addCell(Double.valueOf(1.5)).addCell(Integer.valueOf(99)).finishRow();
        String s2 = tablePrinter.toTable();
        System.out.println(s2);
    }

    public String getTableAttributes() {
        return this.tableAttributes;
    }

    public TablePrinter setTableAttributes(String tableAttributes) {
        this.tableAttributes = tableAttributes;
        return this;
    }

    public TablePrinter setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    public TablePrinter setSortPriority(int priority) {
        this.columnSorter.setSortPriority(this.columns.size() - 1, priority);
        this.sort = true;
        return this;
    }

    public TablePrinter setSortAscending(boolean ascending) {
        this.columnSorter.setSortAscending(this.columns.size() - 1, ascending);
        return this;
    }

    public TablePrinter setBreakSpans(boolean breaks) {
        this.breaksSpans.set(this.columns.size() - 1, breaks);
        return this;
    }

    public TablePrinter addColumn(String header, String headerAttributes, String cellPattern, String cellAttributes, boolean spanRows) {
        this.columns.add(new Column(header).setHeaderAttributes(headerAttributes).setCellPattern(cellPattern).setCellAttributes(cellAttributes).setSpanRows(spanRows));
        this.setSortAscending(true);
        return this;
    }

    public TablePrinter addColumn(String header) {
        this.columns.add(new Column(header));
        this.setSortAscending(true);
        return this;
    }

    public TablePrinter addRow(Comparable<Object>[] data) {
        if (data.length != this.columns.size()) {
            throw new IllegalArgumentException(String.format("Data size (%d) != column count (%d)", data.length, this.columns.size()));
        }
        if (this.rows.size() > 0) {
            Comparable<Object>[] data2 = this.rows.get(0);
            for (int i = 0; i < data.length; ++i) {
                try {
                    data[i].compareTo(data2[i]);
                    continue;
                }
                catch (RuntimeException e) {
                    throw new IllegalArgumentException("Can't compare column " + i + ", " + data[i] + ", " + data2[i]);
                }
            }
        }
        this.rows.add(data);
        return this;
    }

    public TablePrinter addRow() {
        if (this.partialRow != null) {
            throw new IllegalArgumentException("Cannot add partial row before calling finishRow()");
        }
        this.partialRow = new ArrayList<Comparable<Object>>();
        return this;
    }

    public TablePrinter addCell(Comparable cell) {
        if (this.rows.size() > 0) {
            int i = this.partialRow.size();
            Comparable<Object> cell0 = this.rows.get(0)[i];
            try {
                cell.compareTo(cell0);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Can't compare column " + i + ", " + cell + ", " + cell0);
            }
        }
        this.partialRow.add(cell);
        return this;
    }

    public TablePrinter finishRow() {
        if (this.partialRow.size() != this.columns.size()) {
            throw new IllegalArgumentException("Items in row (" + this.partialRow.size() + " not same as number of columns" + this.columns.size());
        }
        this.addRow(this.partialRow);
        this.partialRow = null;
        return this;
    }

    public TablePrinter addRow(Collection<Comparable<Object>> data) {
        this.addRow(data.toArray(new Comparable[data.size()]));
        return this;
    }

    public TablePrinter addRows(Collection data) {
        for (Object row : data) {
            if (row instanceof Collection) {
                this.addRow((Collection)row);
                continue;
            }
            this.addRow((Comparable[])row);
        }
        return this;
    }

    public TablePrinter addRows(Comparable[][] data) {
        for (Comparable[] row : data) {
            this.addRow(row);
        }
        return this;
    }

    public String toString() {
        return this.toTable();
    }

    public void toTsv(PrintWriter tsvFile) {
        Comparable[][] sortedFlat = (Comparable[][])this.rows.toArray((T[])new Comparable[this.rows.size()][]);
        this.toTsvInternal(sortedFlat, tsvFile);
    }

    public String toTable() {
        Comparable[][] sortedFlat = (Comparable[][])this.rows.toArray((T[])new Comparable[this.rows.size()][]);
        return this.toTableInternal(sortedFlat);
    }

    public void toTsvInternal(Comparable[][] sortedFlat, PrintWriter tsvFile) {
        String sep0 = "#";
        for (Column column : this.columns) {
            if (column.hidden) continue;
            tsvFile.print(sep0);
            tsvFile.print(column.header);
            sep0 = "\t";
        }
        tsvFile.println();
        Object[] patternArgs = new Object[this.columns.size() + 1];
        if (this.sort) {
            Arrays.sort(sortedFlat, this.columnSorter);
        }
        this.columnsFlat = this.columns.toArray(new Column[0]);
        for (int i = 0; i < sortedFlat.length; ++i) {
            System.arraycopy(sortedFlat[i], 0, patternArgs, 1, sortedFlat[i].length);
            String sep = "";
            for (int j = 0; j < sortedFlat[i].length; ++j) {
                if (this.columnsFlat[j].hidden) continue;
                Comparable value = sortedFlat[i][j];
                patternArgs[0] = value;
                tsvFile.append(sep).append(this.tsvFormat(value));
                sep = "\t";
            }
            tsvFile.println();
        }
    }

    private String tsvFormat(Comparable value) {
        String s2;
        if (value == null) {
            return "n/a";
        }
        if (value instanceof Number) {
            boolean bl = false;
        }
        return BIDI.containsNone(s2 = value.toString().replace("\n", " \u2022 ")) ? s2 : "\u202b" + s2 + "\u202c";
    }

    public String toTableInternal(Comparable[][] sortedFlat) {
        Object[] patternArgs = new Object[this.columns.size() + 1];
        if (this.sort) {
            Arrays.sort(sortedFlat, this.columnSorter);
        }
        this.columnsFlat = this.columns.toArray(new Column[0]);
        StringBuilder result = new StringBuilder();
        result.append("<table");
        if (this.tableAttributes != null) {
            result.append(' ').append(this.tableAttributes);
        }
        result.append(">" + System.lineSeparator());
        if (this.caption != null) {
            result.append("<caption>").append(this.caption).append("</caption>");
        }
        this.showHeader(result);
        int visibleWidth = 0;
        for (int j = 0; j < this.columns.size(); ++j) {
            if (this.columnsFlat[j].hidden) continue;
            ++visibleWidth;
        }
        for (int i = 0; i < sortedFlat.length; ++i) {
            System.arraycopy(sortedFlat[i], 0, patternArgs, 1, sortedFlat[i].length);
            if (i != 0) {
                boolean divider = false;
                for (int j = 0; j < sortedFlat[i].length; ++j) {
                    Column column = this.columns.get(j);
                    if (!column.repeatHeader || sortedFlat[i - 1][j].equals(sortedFlat[i][j])) continue;
                    this.showHeader(result);
                    break;
                }
                if (divider) {
                    result.append("\t<tr><td class='divider' colspan='" + visibleWidth + "'></td></tr>");
                }
            }
            result.append("\t<tr>");
            for (int j = 0; j < sortedFlat[i].length; ++j) {
                int identical = this.findIdentical(sortedFlat, i, j);
                if (identical == 0 || this.columnsFlat[j].hidden) continue;
                patternArgs[0] = sortedFlat[i][j];
                result.append(this.columnsFlat[j].isHeader ? "<th" : "<td");
                if (this.columnsFlat[j].cellAttributes != null) {
                    try {
                        result.append(' ').append(this.columnsFlat[j].cellAttributes.format(patternArgs));
                    }
                    catch (RuntimeException e) {
                        throw (RuntimeException)new IllegalArgumentException("cellAttributes<" + i + ", " + j + "> = " + sortedFlat[i][j]).initCause(e);
                    }
                }
                if (identical != 1) {
                    result.append(" rowSpan='").append(identical).append('\'');
                }
                result.append('>');
                if (this.columnsFlat[j].cellPattern != null) {
                    try {
                        patternArgs[0] = sortedFlat[i][j];
                        System.arraycopy(sortedFlat[i], 0, patternArgs, 1, sortedFlat[i].length);
                        result.append(this.format((Comparable)((Object)this.columnsFlat[j].cellPattern.format(patternArgs))));
                    }
                    catch (RuntimeException e) {
                        throw (RuntimeException)new IllegalArgumentException("cellPattern<" + i + ", " + j + "> = " + sortedFlat[i][j]).initCause(e);
                    }
                } else {
                    result.append(this.format(sortedFlat[i][j]));
                }
                result.append(this.columnsFlat[j].isHeader ? "</th>" : "</td>");
            }
            result.append("</tr>" + System.lineSeparator());
        }
        result.append("</table>");
        return result.toString();
    }

    private String format(Comparable comparable) {
        if (comparable == null) {
            return null;
        }
        String s2 = comparable.toString().replace("\n", "<br>");
        return BIDI.containsNone(s2) ? s2 : "\u202b" + s2 + "\u202c";
    }

    private void showHeader(StringBuilder result) {
        result.append("\t<tr>");
        for (int j = 0; j < this.columnsFlat.length; ++j) {
            if (this.columnsFlat[j].hidden) continue;
            result.append("<th");
            if (this.columnsFlat[j].headerAttributes != null) {
                result.append(' ').append(this.columnsFlat[j].headerAttributes);
            }
            result.append('>').append(this.columnsFlat[j].header).append("</th>");
        }
        result.append("</tr>" + System.lineSeparator());
    }

    private int findIdentical(Comparable[][] sortedFlat, int rowIndex, int colIndex) {
        if (!this.columnsFlat[colIndex].spanRows) {
            return 1;
        }
        Comparable item = sortedFlat[rowIndex][colIndex];
        if (rowIndex > 0 && item.equals(sortedFlat[rowIndex - 1][colIndex]) && !this.breakSpans(sortedFlat, rowIndex, colIndex)) {
            return 0;
        }
        for (int k = rowIndex + 1; k < sortedFlat.length; ++k) {
            if (item.equals(sortedFlat[k][colIndex]) && !this.breakSpans(sortedFlat, k, colIndex)) continue;
            return k - rowIndex;
        }
        return sortedFlat.length - rowIndex;
    }

    private boolean breakSpans(Comparable[][] sortedFlat, int rowIndex, int colIndex2) {
        int limit = Math.min(this.breaksSpans.length(), colIndex2);
        for (int colIndex = 0; colIndex < limit; ++colIndex) {
            if (!this.breaksSpans.get(colIndex) || sortedFlat[rowIndex][colIndex].compareTo(sortedFlat[rowIndex - 1][colIndex]) == 0) continue;
            return true;
        }
        return false;
    }

    public TablePrinter setCellAttributes(String cellAttributes) {
        this.columns.get(this.columns.size() - 1).setCellAttributes(cellAttributes);
        return this;
    }

    public TablePrinter setCellPattern(String cellPattern) {
        this.columns.get(this.columns.size() - 1).setCellPattern(cellPattern);
        return this;
    }

    public TablePrinter setHeaderAttributes(String headerAttributes) {
        this.columns.get(this.columns.size() - 1).setHeaderAttributes(headerAttributes);
        return this;
    }

    public TablePrinter setSpanRows(boolean spanRows) {
        this.columns.get(this.columns.size() - 1).setSpanRows(spanRows);
        return this;
    }

    public TablePrinter setRepeatHeader(boolean b) {
        this.columns.get(this.columns.size() - 1).setRepeatHeader(b);
        if (b) {
            this.breaksSpans.set(this.columns.size() - 1, true);
        }
        return this;
    }

    public static String bar(String htmlClass, double value, double max, boolean log) {
        double width = 100.0 * (log ? Math.log(value) / Math.log(max) : value / max);
        if (!(width >= 0.5)) {
            return "";
        }
        return "<table class='" + htmlClass + "' width='" + width + "%'><tr><td>\u200b</td></tr></table>";
    }

    public TablePrinter setHidden(boolean b) {
        this.columns.get(this.columns.size() - 1).setHidden(b);
        return this;
    }

    public TablePrinter setHeaderCell(boolean b) {
        this.columns.get(this.columns.size() - 1).setHeaderCell(b);
        return this;
    }

    public void clearRows() {
        this.rows.clear();
    }

    static class ColumnSorter<T extends Comparable>
    implements Comparator<T[]> {
        private int[] sortPriorities = new int[0];
        private BitSet ascending = new BitSet();
        Collator englishCollator = Collator.getInstance(ULocale.ENGLISH);

        ColumnSorter() {
        }

        @Override
        public int compare(T[] o1, T[] o2) {
            int result = 0;
            for (int curr : this.sortPriorities) {
                T c1 = o1[curr];
                T c2 = o2[curr];
                int n = result = c1 instanceof String ? this.englishCollator.compare((String)c1, (String)c2) : c1.compareTo(c2);
                if (0 == result) continue;
                if (this.ascending.get(curr)) {
                    return result;
                }
                return -result;
            }
            return 0;
        }

        public void setSortPriority(int column, int priority) {
            if (this.sortPriorities.length <= priority) {
                int[] temp = new int[priority + 1];
                System.arraycopy(this.sortPriorities, 0, temp, 0, this.sortPriorities.length);
                this.sortPriorities = temp;
            }
            this.sortPriorities[priority] = column;
        }

        public int[] getSortPriorities() {
            return this.sortPriorities;
        }

        public boolean getSortAscending(int bitIndex) {
            return this.ascending.get(bitIndex);
        }

        public void setSortAscending(int bitIndex, boolean value) {
            this.ascending.set(bitIndex, value);
        }
    }

    private static class Column {
        String header;
        String headerAttributes;
        MessageFormat cellAttributes;
        boolean spanRows;
        MessageFormat cellPattern;
        private boolean repeatHeader = false;
        private boolean hidden = false;
        private boolean isHeader = false;

        public Column(String header) {
            this.header = header;
        }

        public Column setCellAttributes(String cellAttributes) {
            this.cellAttributes = new MessageFormat(MessageFormat.autoQuoteApostrophe(cellAttributes), ULocale.ENGLISH);
            return this;
        }

        public Column setCellPattern(String cellPattern) {
            this.cellPattern = cellPattern == null ? null : new MessageFormat(MessageFormat.autoQuoteApostrophe(cellPattern), ULocale.ENGLISH);
            return this;
        }

        public Column setHeaderAttributes(String headerAttributes) {
            this.headerAttributes = headerAttributes;
            return this;
        }

        public Column setSpanRows(boolean spanRows) {
            this.spanRows = spanRows;
            return this;
        }

        public void setRepeatHeader(boolean b) {
            this.repeatHeader = b;
        }

        public void setHidden(boolean b) {
            this.hidden = b;
        }

        public void setHeaderCell(boolean b) {
            this.isHeader = b;
        }
    }
}

