/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.MoreObjects;
import com.ibm.icu.util.Freezable;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.GrammarInfo;

public class GrammarDerivation
implements Freezable<GrammarDerivation> {
    private Map<GrammarInfo.GrammaticalFeature, Map<CompoundUnitStructure, Values>> data = new TreeMap<GrammarInfo.GrammaticalFeature, Map<CompoundUnitStructure, Values>>();

    public void add(String featureStr, String structureStr, String ... values) {
        GrammarInfo.GrammaticalFeature feature = GrammarInfo.GrammaticalFeature.fromName(featureStr);
        CompoundUnitStructure structure = CompoundUnitStructure.valueOf(structureStr);
        Map<CompoundUnitStructure, Values> structureToValues = this.data.get((Object)feature);
        if (structureToValues == null) {
            structureToValues = new TreeMap<CompoundUnitStructure, Values>();
            this.data.put(feature, structureToValues);
        }
        structureToValues.put(structure, new Values(values));
    }

    public Values get(GrammarInfo.GrammaticalFeature feature, CompoundUnitStructure structure) {
        Map<CompoundUnitStructure, Values> structureToValues = this.data.get((Object)feature);
        if (structureToValues == null) {
            return null;
        }
        return structureToValues.get((Object)structure);
    }

    @Override
    public boolean isFrozen() {
        return this.data instanceof TreeMap;
    }

    @Override
    public GrammarDerivation freeze() {
        if (!this.isFrozen()) {
            this.data = CldrUtility.protectCollection(this.data);
        }
        return this;
    }

    @Override
    public GrammarDerivation cloneAsThawed() {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("data", this.data).toString();
    }

    public class Values {
        public final String value0;
        public final String value1;

        public Values(String ... values) {
            this.value0 = values[0];
            this.value1 = values.length == 2 ? values[0] : null;
        }

        public String toString() {
            MoreObjects.ToStringHelper temp = MoreObjects.toStringHelper(this.getClass()).add("value0", this.value0);
            if (this.value1 != null) {
                temp.add("value1", this.value1);
            }
            return temp.toString();
        }
    }

    public static enum CompoundUnitStructure {
        per,
        times,
        power,
        prefix;

    }
}

