/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.ibm.icu.util.Output;
import java.util.Iterator;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.SupplementalDataInfo;

public class UnitParser {
    private static final CLDRConfig CLDR_CONFIG;
    private static final CLDRConfig info;
    private static final SupplementalDataInfo SDI;
    public static final Splitter DASH_SPLITTER;
    public static final Joiner DASH_JOIN;
    private String bufferedItem = null;
    private SupplementalDataInfo.UnitIdComponentType bufferedType = null;
    private Iterator<String> source;

    public UnitParser set(Iterator<String> source) {
        this.bufferedItem = null;
        this.source = source;
        return this;
    }

    public UnitParser set(Iterable<String> source) {
        return this.set(source.iterator());
    }

    public UnitParser set(String source) {
        return this.set(DASH_SPLITTER.split(source).iterator());
    }

    public String nextParse(Output<SupplementalDataInfo.UnitIdComponentType> type) {
        String output = null;
        State state = State.start;
        SupplementalDataInfo.UnitIdComponentType outputType = null;
        while (true) {
            if (this.bufferedItem == null) {
                if (!this.source.hasNext()) break;
                this.bufferedItem = this.source.next();
                this.bufferedType = SDI.getUnitIdComponentType(this.bufferedItem);
            }
            block0 : switch (this.bufferedType) {
                case prefix: {
                    switch (state) {
                        case start: {
                            state = State.havePrefix;
                            break block0;
                        }
                        case havePrefix: {
                            break block0;
                        }
                        case haveBaseOrSuffix: {
                            type.value = outputType == SupplementalDataInfo.UnitIdComponentType.suffix ? SupplementalDataInfo.UnitIdComponentType.base : outputType;
                            return output;
                        }
                    }
                    break;
                }
                case base: {
                    switch (state) {
                        case start: 
                        case havePrefix: {
                            state = State.haveBaseOrSuffix;
                            break block0;
                        }
                        case haveBaseOrSuffix: {
                            type.value = outputType == SupplementalDataInfo.UnitIdComponentType.suffix ? SupplementalDataInfo.UnitIdComponentType.base : outputType;
                            return output;
                        }
                    }
                    break;
                }
                case suffix: {
                    switch (state) {
                        case start: 
                        case havePrefix: {
                            throw new IllegalArgumentException("Unit suffix must follow base: " + output + " \u274c " + this.bufferedItem);
                        }
                    }
                    break;
                }
                case and: 
                case per: 
                case power: {
                    switch (state) {
                        case start: {
                            output = this.bufferedItem;
                            this.bufferedItem = null;
                            type.value = outputType;
                            return output;
                        }
                        case havePrefix: {
                            throw new IllegalArgumentException("Unit prefix must be followed with base: " + output + " \u274c " + this.bufferedItem);
                        }
                        case haveBaseOrSuffix: {
                            type.value = outputType == SupplementalDataInfo.UnitIdComponentType.suffix ? SupplementalDataInfo.UnitIdComponentType.base : outputType;
                            return output;
                        }
                    }
                }
            }
            output = output == null ? this.bufferedItem : output + "-" + this.bufferedItem;
            this.bufferedItem = null;
            outputType = this.bufferedType;
        }
        switch (state) {
            default: {
                return null;
            }
            case havePrefix: {
                throw new IllegalArgumentException("Unit prefix must be followed with base: " + output + " \u274c " + this.bufferedItem);
            }
            case haveBaseOrSuffix: 
        }
        type.value = outputType == SupplementalDataInfo.UnitIdComponentType.suffix ? SupplementalDataInfo.UnitIdComponentType.base : outputType;
        return output;
    }

    public SupplementalDataInfo.UnitIdComponentType getUnitIdComponentType(String part) {
        return SDI.getUnitIdComponentType(part);
    }

    static {
        info = CLDR_CONFIG = CLDRConfig.getInstance();
        SDI = info.getSupplementalDataInfo();
        DASH_SPLITTER = Splitter.on('-');
        DASH_JOIN = Joiner.on('-');
    }

    private static enum State {
        start,
        havePrefix,
        haveBaseOrSuffix;

    }
}

