/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util.personname;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Comparators;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.google.common.collect.TreeMultiset;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.CaseMap;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.ULocale;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.ChainedMap;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.XPathParts;
import org.unicode.cldr.util.personname.SimpleNameObject;

public class PersonNameFormatter {
    public static final boolean DEBUG = System.getProperty("PersonNameFormatter.DEBUG") != null;
    public static final Splitter SPLIT_SPACE = Splitter.on(' ').trimResults();
    public static final Splitter SPLIT_DASH = Splitter.on('-').trimResults();
    public static final Splitter SPLIT_EQUALS = Splitter.on('=').trimResults();
    public static final Splitter SPLIT_COMMA = Splitter.on(',').trimResults();
    public static final Splitter SPLIT_SEMI = Splitter.on(';').trimResults();
    public static final Joiner JOIN_SPACE = Joiner.on(' ');
    public static final Joiner JOIN_DASH = Joiner.on('-');
    public static final Joiner JOIN_SEMI = Joiner.on("; ");
    public static final Joiner JOIN_COMMA = Joiner.on(", ");
    public static final Joiner JOIN_LFTB = Joiner.on("\n\t\t");
    private final NamePatternData namePatternMap;
    private final FallbackFormatter fallbackFormatter;
    private static final Map<String, SimpleNameObject> FOREIGN_NAME_FOR_NON_SPACING;
    private static final CaseMap.Title TO_TITLE_WHOLE_STRING_NO_LOWERCASE;

    public static Collection<NamePattern> getBestMatchSet(ListMultimap<FormatParameters, NamePattern> parameterMatcherToNamePattern, FormatParameters nameFormatParameters) {
        for (Map.Entry<FormatParameters, Collection<NamePattern>> parametersAndPatterns : parameterMatcherToNamePattern.asMap().entrySet()) {
            FormatParameters parameters = parametersAndPatterns.getKey();
            if (!parameters.matches(nameFormatParameters)) continue;
            return parametersAndPatterns.getValue();
        }
        return null;
    }

    public String toString() {
        return this.namePatternMap.toString();
    }

    public final NamePatternData getNamePatternData() {
        return this.namePatternMap;
    }

    public PersonNameFormatter(NamePatternData namePatternMap, FallbackFormatter fallbackFormatter) {
        this.namePatternMap = namePatternMap;
        this.fallbackFormatter = fallbackFormatter;
    }

    public PersonNameFormatter(CLDRFile cldrFile) {
        LinkedListMultimap<FormatParameters, NamePattern> formatParametersToNamePattern = LinkedListMultimap.create();
        TreeSet<Pair<FormatParameters, NamePattern>> ordered = new TreeSet<Pair<FormatParameters, NamePattern>>();
        String initialPattern = null;
        String initialSequencePattern = null;
        String foreignSpaceReplacement = null;
        TreeMap<ULocale, Order> _localeToOrder = new TreeMap<ULocale, Order>();
        block22: for (String string : cldrFile) {
            if (!string.startsWith("//ldml/personNames") || string.endsWith("/alias")) continue;
            String value = cldrFile.getStringValue(string);
            XPathParts parts = XPathParts.getFrozenInstance(string);
            block7 : switch (parts.getElement(2)) {
                case "personName": {
                    Pair<FormatParameters, NamePattern> pair = PersonNameFormatter.fromPathValue(parts, value);
                    boolean added = ordered.add(pair);
                    if (added) continue block22;
                    throw new IllegalArgumentException("Duplicate path/value " + pair);
                }
                case "initialPattern": {
                    String type = parts.getAttributeValue(-1, "type");
                    switch (type) {
                        case "initial": {
                            initialPattern = value;
                            break block7;
                        }
                        case "initialSequence": {
                            initialSequencePattern = value;
                            break block7;
                        }
                    }
                    throw new IllegalArgumentException("Unexpected path: " + string);
                }
                case "nameOrderLocales": {
                    for (String locale : SPLIT_SPACE.split(value)) {
                        Order order = Order.valueOf(parts.getAttributeValue(-1, "order"));
                        _localeToOrder.put(new ULocale(locale), order);
                    }
                    continue block22;
                }
                case "foreignSpaceReplacement": {
                    foreignSpaceReplacement = value;
                    break;
                }
                case "sampleName": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected path: " + string);
                }
            }
        }
        for (Pair pair : ordered) {
            formatParametersToNamePattern.put((FormatParameters)pair.getFirst(), (NamePattern)pair.getSecond());
        }
        PersonNameFormatter.addMissing(formatParametersToNamePattern);
        ImmutableMap<ULocale, Order> localeToOrder = ImmutableMap.copyOf(_localeToOrder);
        this.namePatternMap = new NamePatternData(localeToOrder, formatParametersToNamePattern);
        this.fallbackFormatter = new FallbackFormatter(new ULocale(cldrFile.getLocaleID()), initialPattern, initialSequencePattern, foreignSpaceReplacement, false);
    }

    private static void addMissing(ListMultimap<FormatParameters, NamePattern> formatParametersToNamePattern) {
        for (FormatParameters formatParameters : FormatParameters.all()) {
            Collection<NamePattern> namePatterns = PersonNameFormatter.getBestMatchSet(formatParametersToNamePattern, formatParameters);
            if (namePatterns != null) continue;
            for (FormatParameters fallback : formatParameters.getFallbacks()) {
                namePatterns = PersonNameFormatter.getBestMatchSet(formatParametersToNamePattern, fallback);
                if (namePatterns == null) continue;
                formatParametersToNamePattern.putAll(fallback, namePatterns);
                break;
            }
            if (namePatterns != null) continue;
            throw new IllegalArgumentException("Missing fallback for " + formatParameters);
        }
    }

    public String format(NameObject nameObject, FormatParameters nameFormatParameters) {
        NamePattern bestPattern = this.namePatternMap.getBestMatch(nameObject, nameFormatParameters);
        return bestPattern.format(nameObject, nameFormatParameters, this.fallbackFormatter);
    }

    public Collection<NamePattern> getBestMatchSet(FormatParameters nameFormatParameters) {
        return PersonNameFormatter.getBestMatchSet(this.namePatternMap.parameterMatcherToNamePattern, nameFormatParameters);
    }

    public static Pair<FormatParameters, NamePattern> fromPathValue(XPathParts parts, String value) {
        String altValue = parts.getAttributeValue(-1, "alt");
        int rank = altValue == null ? 0 : Integer.parseInt(altValue);
        FormatParameters pm = new FormatParameters(Order.from(parts.getAttributeValue(-2, "order")), Length.from(parts.getAttributeValue(-2, "length")), Usage.from(parts.getAttributeValue(-2, "usage")), Formality.from(parts.getAttributeValue(-2, "formality")));
        NamePattern np = NamePattern.from(rank, value);
        if (np.toString().isBlank()) {
            throw new IllegalArgumentException("No empty patterns allowed: " + pm);
        }
        return Pair.of(pm, np);
    }

    private static SimpleNameObject specialNameOf(String[] row) {
        return new SimpleNameObject(new ULocale("de_CH"), ImmutableMap.of(ModifiedField.from("given"), row[1], ModifiedField.from("surname"), row[2]));
    }

    public static Map<SampleType, SimpleNameObject> loadSampleNames(CLDRFile cldrFile) {
        ChainedMap.M3 names = ChainedMap.of(new TreeMap(), new TreeMap(), String.class);
        for (Object path : cldrFile) {
            String string;
            if (!((String)path).startsWith("//ldml/personNames/sampleName") || (string = cldrFile.getStringValue((String)path)) == null || string.equals("\u2205\u2205\u2205")) continue;
            XPathParts parts = XPathParts.getFrozenInstance((String)path);
            names.put(SampleType.valueOf(parts.getAttributeValue(-2, "item")), ModifiedField.from(parts.getAttributeValue(-1, "type")), string);
        }
        TreeMap<SampleType, SimpleNameObject> result = new TreeMap<SampleType, SimpleNameObject>();
        for (Map.Entry entry : names) {
            SimpleNameObject name = new SimpleNameObject(new ULocale(cldrFile.getLocaleID()), (Map)entry.getValue());
            result.put((SampleType)((Object)entry.getKey()), name);
        }
        LanguageTagParser ltp = new LanguageTagParser();
        SimpleNameObject simpleNameObject = FOREIGN_NAME_FOR_NON_SPACING.get(ltp.set(cldrFile.getLocaleID()).getLanguageScript());
        if (simpleNameObject != null) {
            result.put(SampleType.foreign, simpleNameObject);
        }
        return ImmutableMap.copyOf(result);
    }

    public static <T> int getIntersectionSize(Set<T> set1, Set<T> set2) {
        int size = 0;
        for (T e : set1) {
            if (!set2.contains(e)) continue;
            ++size;
        }
        return size;
    }

    public FallbackFormatter getFallbackInfo() {
        return this.fallbackFormatter;
    }

    static {
        String[][] specials = new String[][]{{"th", "\u0e2d\u0e31\u0e25\u0e40\u0e1a\u0e34\u0e23\u0e4c\u0e15", "\u0e44\u0e2d\u0e19\u0e4c\u0e2a\u0e44\u0e15\u0e19\u0e4c"}, {"my", "\u1021\u1032\u101c\u103a\u1018\u1010\u103a", "\u1021\u102d\u102f\u1004\u103a\u1038\u1005\u1010\u102d\u102f\u1004\u103a\u1038"}, {"km", "\u17a2\u17b6\u179b\u17cb\u1794\u17ba\u178f", "\u17a2\u17c2\u1784\u179f\u17d2\u178f\u17c2\u1784"}, {"ko", "\uc54c\ubca0\ub974\ud2b8", "\uc544\uc778\uc288\ud0c0\uc778"}, {"ja", "\u30a2\u30eb\u30d9\u30eb\u30c8", "\u30a2\u30a4\u30f3\u30b7\u30e5\u30bf\u30a4\u30f3"}, {"zh", "\u963f\u5c14\u4f2f\u7279", "\u7231\u56e0\u65af\u5766"}};
        LinkedHashMap<String, SimpleNameObject> temp = Maps.newLinkedHashMap();
        for (String[] row : specials) {
            temp.put(row[0], PersonNameFormatter.specialNameOf(row));
        }
        FOREIGN_NAME_FOR_NON_SPACING = ImmutableMap.copyOf(temp);
        TO_TITLE_WHOLE_STRING_NO_LOWERCASE = CaseMap.toTitle().wholeString().noLowercase();
    }

    public static interface NameObject {
        public ULocale getNameLocale();

        public ImmutableMap<ModifiedField, String> getModifiedFieldToValue();

        public Set<Field> getAvailableFields();

        public String getBestValue(ModifiedField var1, Set<Modifier> var2);
    }

    public static class NamePatternData {
        private final ImmutableMap<ULocale, Order> localeToOrder;
        private final ImmutableListMultimap<FormatParameters, NamePattern> parameterMatcherToNamePattern;

        public NamePattern getBestMatch(NameObject nameObject, FormatParameters nameFormatParameters) {
            if (nameFormatParameters.order == null) {
                Order mappedOrder = this.localeToOrder.get(nameObject.getNameLocale());
                nameFormatParameters = nameFormatParameters.setOrder(mappedOrder == null ? Order.givenFirst : mappedOrder);
            }
            NamePattern result = null;
            Collection<NamePattern> namePatterns = PersonNameFormatter.getBestMatchSet(this.parameterMatcherToNamePattern, nameFormatParameters);
            if (namePatterns == null) {
                throw new IllegalArgumentException("Can't find " + nameFormatParameters + " in " + this.parameterMatcherToNamePattern);
            }
            Set<Field> nameFields = nameObject.getAvailableFields();
            int bestMatchSize = -1;
            for (NamePattern pattern : namePatterns) {
                Set<Field> patternFields = pattern.getFields();
                int matchSize = PersonNameFormatter.getIntersectionSize(nameFields, patternFields);
                if (matchSize <= bestMatchSize && (matchSize != bestMatchSize || patternFields.size() >= result.getFieldsSize())) continue;
                bestMatchSize = matchSize;
                result = pattern;
            }
            return result;
        }

        public NamePatternData(ImmutableMap<ULocale, Order> localeToOrder, ListMultimap<FormatParameters, NamePattern> formatParametersToNamePattern) {
            if (formatParametersToNamePattern == null || formatParametersToNamePattern.isEmpty()) {
                throw new IllegalArgumentException("formatParametersToNamePattern must be non-null, non-empty");
            }
            this.localeToOrder = localeToOrder == null ? ImmutableMap.of() : localeToOrder;
            FormatParameters lastKey = null;
            LinkedHashSet<FormatParameters> remaining = new LinkedHashSet<FormatParameters>(FormatParameters.all());
            for (Map.Entry<FormatParameters, Collection<NamePattern>> entry : formatParametersToNamePattern.asMap().entrySet()) {
                FormatParameters key = entry.getKey();
                Collection<NamePattern> values = entry.getValue();
                int matchCount = 0;
                Iterator rest = remaining.iterator();
                while (rest.hasNext()) {
                    FormatParameters item = (FormatParameters)rest.next();
                    if (!key.matches(item)) continue;
                    rest.remove();
                    ++matchCount;
                    if (!DEBUG) continue;
                    System.out.println(" * " + item + " matches " + key);
                }
                if (matchCount == 0) {
                    key.equals(lastKey);
                    throw new IllegalArgumentException("key is masked by previous values: " + key + ",\n\t" + JOIN_LFTB.join(formatParametersToNamePattern.entries()));
                }
                if (values.isEmpty()) {
                    throw new IllegalArgumentException("key has no values: " + key);
                }
                lastKey = key;
            }
            if (!remaining.isEmpty()) {
                throw new IllegalArgumentException("values are not complete; they don't match:\n\t" + JOIN_LFTB.join(remaining));
            }
            this.parameterMatcherToNamePattern = ImmutableListMultimap.copyOf(formatParametersToNamePattern);
        }

        public Map<ULocale, Order> getLocaleToOrder() {
            return this.localeToOrder;
        }

        public NamePatternData(ImmutableMap<ULocale, Order> localeToOrder, String ... formatParametersToNamePatterns) {
            this(localeToOrder, NamePatternData.parseFormatParametersToNamePatterns(formatParametersToNamePatterns));
        }

        private static ListMultimap<FormatParameters, NamePattern> parseFormatParametersToNamePatterns(String ... formatParametersToNamePatterns) {
            int count = formatParametersToNamePatterns.length;
            if (count % 2 != 0) {
                throw new IllegalArgumentException("Must have even number of strings, fields => pattern: " + Arrays.asList(formatParametersToNamePatterns));
            }
            LinkedListMultimap<FormatParameters, NamePattern> _formatParametersToNamePatterns = LinkedListMultimap.create();
            int rank = 0;
            for (int i = 0; i < count; i += 2) {
                FormatParameters pm = FormatParameters.from(formatParametersToNamePatterns[i]);
                NamePattern np = NamePattern.from(rank++, formatParametersToNamePatterns[i + 1]);
                _formatParametersToNamePatterns.put(pm, np);
            }
            PersonNameFormatter.addMissing(_formatParametersToNamePatterns);
            return _formatParametersToNamePatterns;
        }

        public String toString() {
            return "{" + (String)(this.localeToOrder.isEmpty() ? "" : "localeToOrder=" + this.localeToOrder + "\n\t\t") + this.show(this.parameterMatcherToNamePattern) + "}";
        }

        private String show(ImmutableListMultimap<FormatParameters, NamePattern> multimap) {
            String result = ((ImmutableMap)multimap.asMap()).toString();
            return result.replace("], ", "],\n\t\t\t");
        }

        public ImmutableListMultimap<FormatParameters, NamePattern> getMatcherToPatterns() {
            return this.parameterMatcherToNamePattern;
        }
    }

    public static class FormatParameters
    implements Comparable<FormatParameters> {
        private final Order order;
        private final Length length;
        private final Usage usage;
        private final Formality formality;

        public FormatParameters setOrder(Order order) {
            return new FormatParameters(order, this.length, this.usage, this.formality);
        }

        public Order getOrder() {
            return this.order;
        }

        public Length getLength() {
            return this.length;
        }

        public Usage getUsage() {
            return this.usage;
        }

        public Formality getFormality() {
            return this.formality;
        }

        public boolean matches(FormatParameters other) {
            return this.matchesOrder(other.order) && this.matchesLength(other.length) && this.matchesUsage(other.usage) && this.matchesFormality(other.formality);
        }

        public boolean matchesOrder(Order otherOrder) {
            return this.order == null || otherOrder == null || this.order == otherOrder;
        }

        public boolean matchesFormality(Formality otherFormality) {
            return this.formality == null || otherFormality == null || this.formality == otherFormality;
        }

        public boolean matchesUsage(Usage otherUsage) {
            return this.usage == null || otherUsage == null || this.usage == otherUsage;
        }

        private boolean matchesLength(Length otherLength) {
            return this.length == null || otherLength == null || this.length == otherLength;
        }

        public FormatParameters(Order order, Length length, Usage usage, Formality formality) {
            this.order = order;
            this.length = length;
            this.usage = usage;
            this.formality = formality;
        }

        public String toString() {
            ArrayList<CallSite> items = new ArrayList<CallSite>();
            if (this.order != null) {
                items.add((CallSite)((Object)("order='" + this.order + "'")));
            }
            if (this.length != null) {
                items.add((CallSite)((Object)("length='" + this.length + "'")));
            }
            if (this.usage != null) {
                items.add((CallSite)((Object)("usage='" + this.usage + "'")));
            }
            if (this.formality != null) {
                items.add((CallSite)((Object)("formality='" + this.formality + "'")));
            }
            return JOIN_SPACE.join(items);
        }

        public String abbreviated() {
            ArrayList<String> items = new ArrayList<String>();
            if (this.order != null) {
                items.add(this.order.toString().substring(0, 3));
            }
            if (this.length != null) {
                items.add(this.length.toString().substring(0, 3));
            }
            if (this.usage != null) {
                items.add(this.usage.toString().substring(0, 3));
            }
            if (this.formality != null) {
                items.add(this.formality.toString().substring(0, 3));
            }
            return JOIN_DASH.join(items);
        }

        public String dashed() {
            ArrayList<String> items = new ArrayList<String>();
            if (this.order != null) {
                items.add(this.order.toString());
            }
            if (this.length != null) {
                items.add(this.length.toString());
            }
            if (this.usage != null) {
                items.add(this.usage.toString());
            }
            if (this.formality != null) {
                items.add(this.formality.toString());
            }
            return JOIN_DASH.join(items);
        }

        public static FormatParameters from(String string) {
            Order order = null;
            Length length = null;
            Usage usage = null;
            Formality formality = null;
            for (String part : SPLIT_SEMI.split(string)) {
                List<String> parts = SPLIT_EQUALS.splitToList(part);
                if (parts.size() != 2) {
                    throw new IllegalArgumentException("must be of form length=medium; formality=\u2026 : " + string);
                }
                String key = parts.get(0);
                String value = parts.get(1);
                switch (key) {
                    case "order": {
                        order = Order.valueOf(value);
                        break;
                    }
                    case "length": {
                        length = Length.from(value);
                        break;
                    }
                    case "usage": {
                        usage = Usage.valueOf(value);
                        break;
                    }
                    case "formality": {
                        formality = Formality.valueOf(value);
                    }
                }
            }
            return new FormatParameters(order, length, usage, formality);
        }

        public static ImmutableSet<FormatParameters> all() {
            return LazyEval.DATA;
        }

        public static ImmutableSet<FormatParameters> allCldr() {
            return LazyEval.CLDR_DATA;
        }

        @Override
        public int compareTo(FormatParameters other) {
            return ComparisonChain.start().compare((Comparable<?>)((Object)this.order), (Comparable<?>)((Object)other.order)).compare((Comparable<?>)((Object)this.length), (Comparable<?>)((Object)other.length)).compare((Comparable<?>)((Object)this.usage), (Comparable<?>)((Object)other.usage)).compare((Comparable<?>)((Object)this.formality), (Comparable<?>)((Object)other.formality)).result();
        }

        public String toLabel() {
            StringBuilder sb = new StringBuilder();
            this.addToLabel(this.order, sb);
            this.addToLabel(this.length, sb);
            this.addToLabel(this.usage, sb);
            this.addToLabel(this.formality, sb);
            return sb.length() == 0 ? "any" : sb.toString();
        }

        private <T> void addToLabel(T item, StringBuilder sb) {
            if (item != null) {
                if (sb.length() != 0) {
                    sb.append('-');
                }
                sb.append(item.toString());
            }
        }

        public Iterable<FormatParameters> getFallbacks() {
            return ImmutableList.of(new FormatParameters(this.order, this.length, null, this.formality), new FormatParameters(this.order, this.length, this.usage, null), new FormatParameters(this.order, this.length, null, null), new FormatParameters(this.order, null, null, null), new FormatParameters(null, null, null, null));
        }

        public boolean equals(Object obj) {
            FormatParameters that = (FormatParameters)obj;
            return Objects.equals((Object)this.order, (Object)that.order) && Objects.equals((Object)this.length, (Object)that.length) && Objects.equals((Object)this.usage, (Object)that.usage) && Objects.equals((Object)this.formality, (Object)that.formality);
        }

        public int hashCode() {
            return (this.length == null ? 0 : this.length.hashCode()) ^ (this.formality == null ? 0 : this.formality.hashCode()) ^ (this.usage == null ? 0 : this.usage.hashCode()) ^ (this.order == null ? 0 : this.order.hashCode());
        }

        private static class LazyEval {
            private static ImmutableSet<FormatParameters> DATA;
            private static ImmutableSet<FormatParameters> CLDR_DATA;

            private LazyEval() {
            }

            static {
                LinkedHashSet<FormatParameters> _data = new LinkedHashSet<FormatParameters>();
                LinkedHashSet<FormatParameters> _cldrdata = new LinkedHashSet<FormatParameters>();
                for (Order order : Order.values()) {
                    for (Length length : Length.values()) {
                        if (order == Order.sorting) {
                            _cldrdata.add(new FormatParameters(order, length, Usage.referring, Formality.formal));
                            _cldrdata.add(new FormatParameters(order, length, Usage.referring, Formality.informal));
                        }
                        for (Formality formality : Formality.values()) {
                            for (Usage usage : Usage.values()) {
                                _data.add(new FormatParameters(order, length, usage, formality));
                                if (order == Order.sorting) continue;
                                _cldrdata.add(new FormatParameters(order, length, usage, formality));
                            }
                        }
                    }
                }
                DATA = ImmutableSet.copyOf(_data);
                CLDR_DATA = ImmutableSet.copyOf(_cldrdata);
            }
        }
    }

    public static class NamePattern
    implements Comparable<NamePattern> {
        private final int rank;
        private final List<NamePatternElement> elements;
        private final Set<Field> fields;
        static final Pattern SPACES = Pattern.compile("\\s+");
        private static final Set<Character> ALLOWED_ESCAPED_CHARACTERS = new HashSet<Character>(Arrays.asList(Character.valueOf('\\'), Character.valueOf('{'), Character.valueOf('}')));
        private static String BAD_POSITION = "\u274c";
        public static final Comparator<Iterable<NamePattern>> ITERABLE_COMPARE = Comparators.lexicographical(Comparator.naturalOrder());

        public Set<Field> getFields() {
            return ImmutableSet.copyOf(this.fields);
        }

        public int getFieldsSize() {
            return this.fields.size();
        }

        public int getRank() {
            return this.rank;
        }

        public String format(NameObject nameObject, FormatParameters nameFormatParameters, FallbackFormatter fallbackInfo) {
            ULocale nameLocale;
            StringBuilder result = new StringBuilder();
            boolean seenLeadingField = false;
            boolean seenEmptyLeadingField = false;
            boolean seenEmptyField = false;
            StringBuilder literalTextBefore = new StringBuilder();
            StringBuilder literalTextAfter = new StringBuilder();
            for (NamePatternElement element : this.elements) {
                String literal = element.getLiteral();
                if (literal != null) {
                    if (seenEmptyLeadingField) continue;
                    if (seenEmptyField) {
                        literalTextAfter.append(literal);
                        continue;
                    }
                    literalTextBefore.append(literal);
                    continue;
                }
                String bestValue = this.getBestValueForNameObject(nameObject, element, nameFormatParameters, fallbackInfo);
                if (bestValue == null) {
                    if (!seenLeadingField) {
                        seenEmptyLeadingField = true;
                        literalTextBefore.setLength(0);
                        continue;
                    }
                    seenEmptyField = true;
                    literalTextAfter.setLength(0);
                    continue;
                }
                seenLeadingField = true;
                seenEmptyLeadingField = false;
                if (seenEmptyField) {
                    result.append(this.coalesceLiterals(literalTextBefore, literalTextAfter));
                    result.append(bestValue);
                    seenEmptyField = false;
                    continue;
                }
                result.append((CharSequence)literalTextBefore);
                literalTextBefore.setLength(0);
                result.append(bestValue);
            }
            if (!seenEmptyField) {
                result.append((CharSequence)literalTextBefore);
            }
            if (fallbackInfo.foreignSpaceReplacement != null && !fallbackInfo.foreignSpaceReplacement.equals(" ") && !this.sharesLanguageScript(nameLocale = nameObject.getNameLocale(), fallbackInfo.formatterLocale)) {
                return SPACES.matcher(result).replaceAll(fallbackInfo.foreignSpaceReplacement);
            }
            return result.toString();
        }

        private boolean sharesLanguageScript(ULocale nameLocale, ULocale formatterLocale) {
            return Objects.equals(nameLocale, formatterLocale);
        }

        private String getBestValueForNameObject(NameObject nameObject, NamePatternElement element, FormatParameters nameFormatParameters, FallbackFormatter fallbackInfo) {
            EnumSet<Modifier> remainingModifers = EnumSet.noneOf(Modifier.class);
            ModifiedField modifiedField = element.getModifiedField();
            String bestValue = nameObject.getBestValue(modifiedField, remainingModifers);
            if (bestValue == null) {
                return null;
            }
            if (!remainingModifers.isEmpty()) {
                bestValue = fallbackInfo.applyModifierFallbacks(nameFormatParameters, remainingModifers, bestValue);
            }
            return fallbackInfo.tweak(modifiedField, bestValue, nameFormatParameters);
        }

        private String coalesceLiterals(StringBuilder l1, StringBuilder l2) {
            int p2;
            int p1;
            for (p1 = 0; p1 < l1.length() && !Character.isWhitespace(l1.charAt(p1)); ++p1) {
            }
            for (p2 = l2.length() - 1; p2 >= 0 && !Character.isWhitespace(l2.charAt(p2)); --p2) {
            }
            if (p1 < l1.length()) {
                ++p1;
            } else if (p2 >= 0) {
                --p2;
            }
            String result = l1.substring(0, p1) + l2.substring(p2 + 1);
            l1.setLength(0);
            l2.setLength(0);
            return result;
        }

        public NamePattern(int rank, List<NamePatternElement> elements) {
            this.rank = rank;
            this.elements = elements;
            EnumSet<Field> result = EnumSet.noneOf(Field.class);
            for (NamePatternElement element : elements) {
                ModifiedField modifiedField = element.getModifiedField();
                if (modifiedField == null) continue;
                result.add(modifiedField.getField());
            }
            this.fields = ImmutableSet.copyOf(result);
        }

        public static NamePattern from(int rank, Object ... elements) {
            return new NamePattern(rank, NamePattern.makeList(elements));
        }

        public static NamePattern from(int rank, String patternString) {
            return new NamePattern(rank, NamePattern.parse(patternString));
        }

        private static List<NamePatternElement> parse(String patternString) {
            ArrayList<NamePatternElement> result = new ArrayList<NamePatternElement>();
            Object rawValue = "";
            Boolean curlyStarted = false;
            int patternLength = patternString.length();
            int i = 0;
            block7: while (i < patternLength) {
                Character currentCharacter = Character.valueOf(patternString.charAt(i));
                switch (currentCharacter.charValue()) {
                    case '\\': {
                        if (i + 1 < patternLength) {
                            Character nextCharacter = Character.valueOf(patternString.charAt(i + 1));
                            if (!ALLOWED_ESCAPED_CHARACTERS.contains(nextCharacter)) {
                                NamePattern.throwParseError(String.format("Escaping character '%c' is not supported", nextCharacter), patternString, i);
                            }
                            rawValue = (String)rawValue + nextCharacter;
                            i += 2;
                            continue block7;
                        }
                        NamePattern.throwParseError("Invalid character: ", patternString, i);
                    }
                    case '{': {
                        if (curlyStarted.booleanValue()) {
                            NamePattern.throwParseError("Unexpected {: ", patternString, i);
                        }
                        curlyStarted = true;
                        if (((String)rawValue).isEmpty()) break;
                        result.add(new NamePatternElement((String)rawValue));
                        rawValue = "";
                        break;
                    }
                    case '}': {
                        if (!curlyStarted.booleanValue()) {
                            NamePattern.throwParseError("Unexpected }", patternString, i);
                        }
                        curlyStarted = false;
                        if (((String)rawValue).isEmpty()) {
                            NamePattern.throwParseError("Empty field '{}' is not allowed ", patternString, i);
                            break;
                        }
                        try {
                            result.add(new NamePatternElement(ModifiedField.from((String)rawValue)));
                        }
                        catch (Exception e) {
                            NamePattern.throwParseError("Invalid field: ", (String)rawValue, 0);
                        }
                        rawValue = "";
                        break;
                    }
                    default: {
                        rawValue = (String)rawValue + currentCharacter;
                    }
                }
                ++i;
            }
            if (curlyStarted.booleanValue()) {
                NamePattern.throwParseError("Unmatched {", patternString, patternString.length());
            }
            if (!((String)rawValue).isEmpty()) {
                result.add(new NamePatternElement((String)rawValue));
            }
            return result;
        }

        private static void throwParseError(String message, String patternString, int i) {
            throw new IllegalArgumentException(message + ": \u00ab" + patternString.substring(0, i) + BAD_POSITION + patternString.substring(i) + "\u00bb");
        }

        private static List<NamePatternElement> makeList(Object ... elements2) {
            ArrayList<NamePatternElement> result = new ArrayList<NamePatternElement>();
            for (Object element : elements2) {
                result.add(NamePatternElement.from(element));
            }
            return result;
        }

        public String toString() {
            StringBuilder result = new StringBuilder("\"");
            for (NamePatternElement element : this.elements) {
                if (element.literal != null) {
                    char[] cArray = element.literal.toCharArray();
                    int n = cArray.length;
                    for (int i = 0; i < n; ++i) {
                        Character c = Character.valueOf(cArray[i]);
                        if (ALLOWED_ESCAPED_CHARACTERS.contains(c)) {
                            result.append('\\');
                        }
                        result.append(c);
                    }
                    continue;
                }
                result.append('{').append(element).append('}');
            }
            return result.append("\"").toString();
        }

        @Override
        public int compareTo(NamePattern o) {
            return ComparisonChain.start().compare(this.rank, o.rank).compare(this.fields, o.fields, Field.ITERABLE_COMPARE).compare(this.elements, o.elements, NamePatternElement.ITERABLE_COMPARE).result();
        }

        public boolean equals(Object obj) {
            return this.compareTo((NamePattern)obj) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.rank, this.fields, this.elements);
        }

        public Multimap<Field, Integer> getFieldPositions() {
            TreeMultimap<Field, Integer> result = TreeMultimap.create();
            int i = -1;
            for (NamePatternElement element : this.elements) {
                ++i;
                if (element.literal != null) continue;
                result.put(element.modifiedField.field, i);
            }
            return result;
        }

        public int getElementCount() {
            return this.elements.size();
        }

        public String getLiteral(int index) {
            return this.elements.get((int)index).literal;
        }

        public ModifiedField getModifiedField(int index) {
            return this.elements.get((int)index).modifiedField;
        }

        public String firstLiteralContaining(String item) {
            for (NamePatternElement element : this.elements) {
                String literal = element.literal;
                if (literal == null || !literal.contains(item)) continue;
                return literal;
            }
            return null;
        }
    }

    public static class FallbackFormatter {
        private final ULocale formatterLocale;
        private final BreakIterator characterBreakIterator;
        private final MessageFormat initialFormatter;
        private final MessageFormat initialSequenceFormatter;
        private final String foreignSpaceReplacement;
        private final boolean uppercaseSurnameIfSurnameFirst;

        public String getForeignSpaceReplacement() {
            return this.foreignSpaceReplacement;
        }

        public FallbackFormatter(ULocale uLocale, String initialPattern, String initialSequencePattern, String foreignSpaceReplacement, boolean uppercaseSurnameIfSurnameFirst) {
            this.formatterLocale = uLocale;
            this.characterBreakIterator = BreakIterator.getCharacterInstance(uLocale);
            this.initialFormatter = new MessageFormat(initialPattern);
            this.initialSequenceFormatter = new MessageFormat(initialSequencePattern);
            this.foreignSpaceReplacement = foreignSpaceReplacement;
            this.uppercaseSurnameIfSurnameFirst = uppercaseSurnameIfSurnameFirst;
        }

        public String applyModifierFallbacks(FormatParameters nameFormatParameters, Set<Modifier> remainingModifers, String bestValue) {
            for (Modifier modifier : remainingModifers) {
                switch (modifier) {
                    case initial: {
                        bestValue = this.formatInitial(bestValue, nameFormatParameters);
                        break;
                    }
                    case monogram: {
                        bestValue = this.formatMonogram(bestValue, nameFormatParameters);
                        break;
                    }
                    case initialCap: {
                        bestValue = TO_TITLE_WHOLE_STRING_NO_LOWERCASE.apply(this.formatterLocale.toLocale(), null, bestValue);
                        break;
                    }
                    case allCaps: {
                        bestValue = UCharacter.toUpperCase(this.formatterLocale, bestValue);
                        break;
                    }
                    case prefix: {
                        bestValue = null;
                        break;
                    }
                }
            }
            return bestValue;
        }

        public String formatInitial(String bestValue, FormatParameters nameFormatParameters) {
            String result = null;
            for (String part : SPLIT_SPACE.split(bestValue)) {
                String partFirst = this.getFirstGrapheme(part);
                bestValue = this.initialFormatter.format(new String[]{partFirst});
                if (result == null) {
                    result = bestValue;
                    continue;
                }
                result = this.initialSequenceFormatter.format(new String[]{result, bestValue});
            }
            return result;
        }

        public String formatMonogram(String bestValue, FormatParameters nameFormatParameters) {
            return this.getFirstGrapheme(bestValue);
        }

        private String getFirstGrapheme(String bestValue) {
            this.characterBreakIterator.setText(bestValue);
            bestValue = bestValue.substring(0, this.characterBreakIterator.next());
            return bestValue;
        }

        public String formatAllCaps(String bestValue) {
            return UCharacter.toUpperCase(this.formatterLocale, bestValue);
        }

        public String tweak(ModifiedField modifiedField, String bestValue, FormatParameters nameFormatParameters) {
            if (this.uppercaseSurnameIfSurnameFirst && nameFormatParameters.matchesOrder(Order.surnameFirst) && (modifiedField.getField() == Field.surname || modifiedField.getField() == Field.surname2)) {
                bestValue = UCharacter.toUpperCase(this.formatterLocale, bestValue);
            }
            return bestValue;
        }
    }

    public static class NamePatternElement
    implements Comparable<NamePatternElement> {
        private final String literal;
        private final ModifiedField modifiedField;
        public static final Comparator<Iterable<NamePatternElement>> ITERABLE_COMPARE = Comparators.lexicographical(Comparator.naturalOrder());

        public String getLiteral() {
            return this.literal;
        }

        public ModifiedField getModifiedField() {
            return this.modifiedField;
        }

        public NamePatternElement(ModifiedField modifiedField) {
            this.literal = null;
            this.modifiedField = modifiedField;
        }

        public NamePatternElement(String literal) {
            this.literal = literal;
            this.modifiedField = null;
        }

        public static NamePatternElement from(Object element) {
            if (element instanceof ModifiedField) {
                return new NamePatternElement((ModifiedField)element);
            }
            String string = element.toString();
            if (string.startsWith("{") && string.endsWith("}")) {
                return new NamePatternElement(ModifiedField.from(string.substring(1, string.length() - 1)));
            }
            return new NamePatternElement(string);
        }

        public String toString() {
            return this.literal != null ? this.literal.replace("\\", "\\\\").replace("{", "\\{") : this.modifiedField.toString();
        }

        @Override
        public int compareTo(NamePatternElement o) {
            if (this.literal != null && o.literal != null) {
                return this.literal.compareTo(o.literal);
            }
            if (this.modifiedField != null && o.modifiedField != null) {
                return this.modifiedField.compareTo(o.modifiedField);
            }
            return this.literal != null ? -1 : 1;
        }
    }

    public static class ModifiedField
    implements Comparable<ModifiedField> {
        private final Field field;
        private final Set<Modifier> modifiers;

        public Field getField() {
            return this.field;
        }

        public Set<Modifier> getModifiers() {
            return this.modifiers;
        }

        public ModifiedField(Field field, Collection<Modifier> modifiers) {
            this.field = field;
            Output<String> errorMessage = new Output<String>();
            this.modifiers = Modifier.getCleanSet(modifiers, errorMessage);
            if (errorMessage.value != null) {
                throw new IllegalArgumentException((String)errorMessage.value);
            }
        }

        public ModifiedField(Field field, Modifier ... modifiers) {
            this(field, Arrays.asList(modifiers));
        }

        public static ModifiedField from(String string) {
            Field field = null;
            ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
            for (String item : SPLIT_DASH.split(string)) {
                if (field == null) {
                    field = Field.valueOf(item);
                    continue;
                }
                modifiers.add(Modifier.valueOf(item));
            }
            return new ModifiedField(field, modifiers);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append((Object)this.field);
            if (!this.modifiers.isEmpty()) {
                result.append('-').append(JOIN_DASH.join(this.modifiers));
            }
            return result.toString();
        }

        public boolean equals(Object obj) {
            ModifiedField that = (ModifiedField)obj;
            return this.field == that.field && this.modifiers.equals(that.modifiers);
        }

        public int hashCode() {
            return this.field.hashCode() ^ this.modifiers.hashCode();
        }

        @Override
        public int compareTo(ModifiedField o) {
            return ComparisonChain.start().compare((Comparable<?>)((Object)this.field), (Comparable<?>)((Object)o.field)).compare(this.modifiers, o.modifiers, Modifier.ITERABLE_COMPARE).result();
        }
    }

    public static enum SampleType {
        givenOnly,
        givenSurnameOnly,
        given12Surname,
        full,
        foreign;

        public static final Set<SampleType> ALL;

        static {
            ALL = ImmutableSet.of(givenOnly, givenSurnameOnly, given12Surname, full);
        }
    }

    public static enum Modifier {
        informal,
        allCaps,
        initialCap,
        initial,
        monogram,
        prefix,
        core;

        public static final Comparator<Iterable<Modifier>> ITERABLE_COMPARE;
        public static final Comparator<Collection<Modifier>> LONGEST_FIRST;
        public static final Set<Modifier> ALL;
        public static final Set<Modifier> EMPTY;
        static final Set<Set<Modifier>> INCONSISTENT_SETS;

        public static Set<Modifier> getCleanSet(Collection<Modifier> modifierList, Output<String> errorMessage) {
            if (modifierList.isEmpty()) {
                return ImmutableSet.of();
            }
            EnumSet<Modifier> modifiers = EnumSet.copyOf(modifierList);
            String errorMessage1 = null;
            if (modifiers.size() != modifierList.size()) {
                TreeMultiset<Modifier> dupCheck = TreeMultiset.create();
                dupCheck.addAll(modifierList);
                for (Modifier m3 : modifiers) {
                    dupCheck.remove((Object)m3);
                }
                errorMessage1 = "Duplicate modifiers: " + JOIN_COMMA.join(dupCheck);
            }
            Object errorMessage2 = null;
            for (Set<Modifier> inconsistentSet : INCONSISTENT_SETS) {
                if (!modifiers.containsAll(inconsistentSet)) continue;
                errorMessage2 = errorMessage2 == null ? "Inconsistent modifiers: " : (String)errorMessage2 + ", ";
                errorMessage2 = (String)errorMessage2 + inconsistentSet;
            }
            errorMessage.value = errorMessage1 == null ? errorMessage2 : (errorMessage2 == null ? errorMessage1 : errorMessage1 + "; " + errorMessage1);
            return ImmutableSet.copyOf(modifiers);
        }

        public static String inconsistentPrefixCorePlainValues(String prefixValue, String coreValue, String plainValue) {
            String errorMessage2 = null;
            if (prefixValue != null) {
                if (coreValue != null) {
                    if (plainValue != null && !plainValue.replace(prefixValue, "").trim().equals(coreValue)) {
                        errorMessage2 = "-core value and -prefix value are inconsistent with plain value";
                    }
                } else {
                    errorMessage2 = "cannot have -prefix without -core";
                }
            } else if (coreValue != null && plainValue != null && !plainValue.equals(coreValue)) {
                errorMessage2 = "There is no -prefix, but there is a -core and plain that are unequal";
            }
            return errorMessage2;
        }

        static {
            ITERABLE_COMPARE = Comparators.lexicographical(Comparator.naturalOrder());
            LONGEST_FIRST = new Comparator<Collection<Modifier>>(){

                @Override
                public int compare(Collection<Modifier> o1, Collection<Modifier> o2) {
                    return ComparisonChain.start().compare(o2.size(), o1.size()).compare(o1, o2, ITERABLE_COMPARE).result();
                }
            };
            ALL = ImmutableSet.copyOf(Modifier.values());
            EMPTY = ImmutableSet.of();
            INCONSISTENT_SETS = ImmutableSet.of(ImmutableSet.of(core, prefix), ImmutableSet.of(initial, monogram), ImmutableSet.of(allCaps, initialCap));
        }
    }

    public static enum Formality {
        formal,
        informal;

        public static final Comparator<Iterable<Formality>> ITERABLE_COMPARE;
        public static final Set<Formality> ALL;

        public static Formality from(String item) {
            return item == null ? null : Formality.valueOf(item);
        }

        static {
            ITERABLE_COMPARE = Comparators.lexicographical(Comparator.naturalOrder());
            ALL = ImmutableSet.copyOf(Formality.values());
        }
    }

    public static enum Usage {
        referring,
        addressing,
        monogram;

        public static final Comparator<Iterable<Usage>> ITERABLE_COMPARE;
        public static final Set<Usage> ALL;

        public static Usage from(String item) {
            return item == null ? null : Usage.valueOf(item);
        }

        static {
            ITERABLE_COMPARE = Comparators.lexicographical(Comparator.naturalOrder());
            ALL = ImmutableSet.copyOf(Usage.values());
        }
    }

    public static enum Length {
        long_name,
        medium,
        short_name;

        private static ImmutableBiMap<String, Length> exceptionNames;
        public static final Comparator<Iterable<Length>> ITERABLE_COMPARE;
        public static final Set<Length> ALL;

        public static Length from(String item) {
            if (item == null) {
                return null;
            }
            Length result = (Length)((Object)exceptionNames.get(item));
            return result != null ? result : Length.valueOf(item);
        }

        public String toString() {
            String result = (String)((ImmutableMap)((Object)exceptionNames.inverse())).get((Object)this);
            return result != null ? result : this.name();
        }

        static {
            exceptionNames = ImmutableBiMap.of("long", long_name, "short", short_name);
            ITERABLE_COMPARE = Comparators.lexicographical(Comparator.naturalOrder());
            ALL = ImmutableSet.copyOf(Length.values());
        }
    }

    public static enum Order {
        givenFirst,
        surnameFirst,
        sorting;

        public static final Comparator<Iterable<Order>> ITERABLE_COMPARE;
        public static final Set<Order> ALL;

        public static Order from(String item) {
            return item == null ? null : Order.valueOf(item);
        }

        static {
            ITERABLE_COMPARE = Comparators.lexicographical(Comparator.naturalOrder());
            ALL = ImmutableSet.copyOf(Order.values());
        }
    }

    public static enum Field {
        prefix,
        given,
        given2,
        surname,
        surname2,
        suffix;

        public static final Comparator<Iterable<Field>> ITERABLE_COMPARE;
        public static final Set<Field> ALL;

        static {
            ITERABLE_COMPARE = Comparators.lexicographical(Comparator.naturalOrder());
            ALL = ImmutableSet.copyOf(Field.values());
        }
    }
}

