/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.dev.util.UnicodeMap;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.unicode.cldr.draft.StateMachine;

public class StateMachineBuilder<T> {
    private static final UnicodeSet WHITESPACE = new UnicodeSet("[:Pattern_Whitespace:]").freeze();
    private static final UnicodeSet XID_START = new UnicodeSet("[:XID_Start:]").freeze();
    private static final UnicodeSet XID_PART = new UnicodeSet("[-[:XID_Continue:]]").freeze();
    private short currentState = (short)-4;
    private UnicodeMap<StateMachine.StateAction> currentMap = null;
    private List<UnicodeMap> stateToData = new ArrayList<UnicodeMap>();
    private ParsePosition parsePosition = new ParsePosition(0);
    private Map<String, UnicodeSet> variables = new LinkedHashMap<String, UnicodeSet>();
    private Map<String, Short> stateToNumber = new LinkedHashMap<String, Short>();
    private List<String> numberToState = new ArrayList<String>();
    private Map<String, Short> actionToNumber = new LinkedHashMap<String, Short>();
    private List<String> numberToAction = new ArrayList<String>();
    private StateMachine.StateAction defaultAction;

    public StateMachineBuilder() {
        this.add("eof:=[\\uFFFF]");
    }

    public StateMachine<T> build(StateMachine.StateObjectBuilderFactory<T> factory) {
        HashSet<String> missingStates = new HashSet<String>();
        for (int i = 0; i < this.stateToData.size(); ++i) {
            UnicodeMap action = this.stateToData.get(i);
            if (action != null) continue;
            missingStates.add(this.numberToState.get(i));
        }
        if (missingStates.size() > 0) {
            throw new IllegalArgumentException("Missing states: " + missingStates);
        }
        this.fixDefaultAction();
        return new StateMachine<T>(this.stateToData, factory, this.numberToState, this.numberToAction);
    }

    void add(String rules) {
        for (String rule : rules.split("[\n]")) {
            int commentPos = (rule = rule.trim()).indexOf(35);
            if (commentPos >= 0 && !rule.startsWith("'#")) {
                rule = rule.substring(0, commentPos).trim();
            }
            if (rule.length() == 0) continue;
            this.parsePosition.setIndex(0);
            if (rule.endsWith(":")) {
                if (this.currentState >= 0) {
                    this.fixDefaultAction();
                }
                String stateString = StateMachineBuilder.scanForVariable(rule, this.parsePosition);
                StateMachineBuilder.scanOver(rule, WHITESPACE, this.parsePosition);
                this.checkAndSkip(rule, ":", "Malformed state label: ");
                this.currentState = this.getStateNumber(stateString);
                if (this.currentState < 0) {
                    throw new IllegalArgumentException("Cannot define reserved state: " + rule);
                }
                if (this.stateToData.size() > this.currentState && this.stateToData.get(this.currentState) != null) {
                    throw new IllegalArgumentException("Cannot define state twice: " + rule);
                }
                this.currentMap = new UnicodeMap();
                while (this.stateToData.size() <= this.currentState) {
                    this.stateToData.add(null);
                }
                this.stateToData.set(this.currentState, this.currentMap);
            } else if (rule.contains(":=")) {
                String variable = StateMachineBuilder.scanForVariable(rule, this.parsePosition);
                if (this.variables.containsKey(variable)) {
                    throw new IllegalArgumentException("Cannot redefine variable: " + rule);
                }
                StateMachineBuilder.scanOver(rule, WHITESPACE, this.parsePosition);
                this.checkAndSkip(rule, ":=", "Malformed variable rule: ");
                StateMachineBuilder.scanOver(rule, WHITESPACE, this.parsePosition);
                UnicodeSet value = this.getUnicodeSet(rule);
                this.variables.put(variable, value);
            } else {
                UnicodeSet set = this.getUnicodeSet(rule);
                StateMachine.StateAction action = new StateMachine.StateAction();
                StateMachineBuilder.scanOver(rule, WHITESPACE, this.parsePosition);
                String item = StateMachineBuilder.scanForVariable(rule, this.parsePosition);
                if (item.equals("n")) {
                    action.advanceToNextCodePoint = true;
                    StateMachineBuilder.scanOver(rule, WHITESPACE, this.parsePosition);
                    item = StateMachineBuilder.scanForVariable(rule, this.parsePosition);
                }
                action.nextState = this.getStateNumber(item);
                StateMachineBuilder.scanOver(rule, WHITESPACE, this.parsePosition);
                int index = this.parsePosition.getIndex();
                if (index < rule.length()) {
                    if (rule.charAt(index) == '^') {
                        this.parsePosition.setIndex(this.parsePosition.getIndex() + 1);
                        StateMachineBuilder.scanOver(rule, WHITESPACE, this.parsePosition);
                        item = StateMachineBuilder.scanForVariable(rule, this.parsePosition);
                        action.pushState = this.getStateNumber(item);
                        StateMachineBuilder.scanOver(rule, WHITESPACE, this.parsePosition);
                    }
                    if ((item = StateMachineBuilder.scanForVariable(rule, this.parsePosition)).length() > 0) {
                        action.action = this.getItemNumber(item, this.actionToNumber, this.numberToAction);
                    }
                }
                if (set == null) {
                    if (this.defaultAction != null) {
                        throw new IllegalArgumentException("Cannot have more than one defaultAction: " + rule);
                    }
                    this.defaultAction = action;
                } else {
                    this.currentMap.putAll(set, action);
                }
            }
            StateMachineBuilder.scanOver(rule, WHITESPACE, this.parsePosition);
            if (this.parsePosition.getIndex() == rule.length()) continue;
            throw new IllegalArgumentException("Extra stuff at end: " + rule);
        }
    }

    private short getStateNumber(String stateString) {
        if (stateString.equals("pop")) {
            return -2;
        }
        if (stateString.equals("exit")) {
            return -1;
        }
        if (stateString.equals("errorDeath")) {
            return -3;
        }
        return this.getItemNumber(stateString, this.stateToNumber, this.numberToState);
    }

    private void fixDefaultAction() {
        if (this.defaultAction == null) {
            throw new IllegalArgumentException("Missing default action for: " + this.numberToState.get(this.currentState));
        }
        this.currentMap.putAll(this.currentMap.keySet(null), this.defaultAction);
        this.defaultAction = null;
    }

    private void checkAndSkip(String rule, String checkAndSkip, String errorMessage) {
        if (!rule.regionMatches(this.parsePosition.getIndex(), checkAndSkip, 0, checkAndSkip.length())) {
            throw new IllegalArgumentException(errorMessage + rule);
        }
        this.parsePosition.setIndex(this.parsePosition.getIndex() + checkAndSkip.length());
    }

    private UnicodeSet getUnicodeSet(String rule) {
        UnicodeSet set;
        if (rule.startsWith("'")) {
            int cp = UTF16.charAt(rule, 1);
            int charCount = UTF16.getCharCount(cp);
            if (rule.charAt(1 + charCount) != '\'') {
                throw new IllegalArgumentException("Illegal literal character in: " + rule);
            }
            this.parsePosition.setIndex(2 + charCount);
            set = new UnicodeSet(cp, cp);
        } else if (UnicodeSet.resemblesPattern(rule, this.parsePosition.getIndex())) {
            set = new UnicodeSet(rule, this.parsePosition, null, 0);
        } else {
            String variable = StateMachineBuilder.scanForVariable(rule, this.parsePosition);
            if (variable.equals("default")) {
                return null;
            }
            set = this.variables.get(variable);
            if (set == null) {
                throw new IllegalArgumentException("Variable used before defined: " + rule);
            }
        }
        return set;
    }

    private short getItemNumber(String item, Map<String, Short> itemToNumber, List<String> numberToItem) {
        Short result = itemToNumber.get(item);
        if (result == null) {
            result = (short)itemToNumber.size();
            itemToNumber.put(item, result);
            numberToItem.add(item);
        }
        return result;
    }

    public static int scanOver(String string, UnicodeSet set, ParsePosition parsePosition) {
        int match;
        int i = parsePosition.getIndex();
        while (i < string.length() && (match = set.matchesAt(string, i)) >= i) {
            i = match;
        }
        parsePosition.setIndex(i);
        return i;
    }

    public static String scanForVariable(String rule, ParsePosition parsePosition) {
        int start = parsePosition.getIndex();
        if (start < 0 || start >= rule.length()) {
            return "";
        }
        int match = XID_START.matchesAt(rule, start);
        if (match <= start) {
            return "";
        }
        parsePosition.setIndex(match);
        StateMachineBuilder.scanOver(rule, XID_PART, parsePosition);
        return rule.substring(start, parsePosition.getIndex());
    }
}

