/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.ibm.icu.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.draft.keyboard.CharacterMap;
import org.unicode.cldr.draft.keyboard.IsoLayoutPosition;
import org.unicode.cldr.draft.keyboard.KeyMap;
import org.unicode.cldr.draft.keyboard.Keyboard;
import org.unicode.cldr.draft.keyboard.KeyboardId;
import org.unicode.cldr.draft.keyboard.ModifierKeyCombination;
import org.unicode.cldr.draft.keyboard.ModifierKeyCombinationSet;
import org.unicode.cldr.draft.keyboard.Transform;

public final class KeyboardBuilder {
    private final ImmutableSet.Builder<KeyboardId> keyboardIds = ImmutableSet.builder();
    private final ImmutableList.Builder<String> names = ImmutableList.builder();
    private final Map<String, String> transformSequenceToOutput = Maps.newHashMap();
    private final Table<ModifierKeyCombination, IsoLayoutPosition, CharacterMap> modifierAndPositionToCharacter = HashBasedTable.create();

    public KeyboardBuilder addKeyboardIds(Iterable<KeyboardId> keyboardIds) {
        this.keyboardIds.addAll((Iterable)keyboardIds);
        return this;
    }

    public KeyboardBuilder addName(String name) {
        this.names.add((Object)name);
        return this;
    }

    public KeyboardBuilder addTransform(String sequence, String output) {
        if (this.transformSequenceToOutput.containsKey(sequence) && !this.transformSequenceToOutput.get(sequence).equals(output)) {
            String errorMessage = String.format("Duplicate entry for [%s:%s]", sequence, output);
            throw new IllegalArgumentException(errorMessage);
        }
        this.transformSequenceToOutput.put(sequence, output);
        return this;
    }

    public KeyboardBuilder addCharacterMap(ModifierKeyCombination combination, CharacterMap characterMap) {
        Preconditions.checkNotNull(combination);
        if (this.modifierAndPositionToCharacter.contains(combination, (Object)characterMap.position())) {
            CharacterMap existing = this.modifierAndPositionToCharacter.get(combination, (Object)characterMap.position());
            Preconditions.checkArgument(existing.equals(characterMap), "Duplicate entry for [%s:%s:%s]", (Object)combination, (Object)characterMap, (Object)existing);
        }
        this.modifierAndPositionToCharacter.put(combination, characterMap.position(), characterMap);
        return this;
    }

    public KeyboardBuilder addCharacterMap(Collection<ModifierKeyCombination> combinations, CharacterMap characterMap) {
        for (ModifierKeyCombination combination : combinations) {
            this.addCharacterMap(combination, characterMap);
        }
        return this;
    }

    public ImmutableList<Keyboard> build() {
        ImmutableCollection keyboardIds = this.keyboardIds.build();
        Preconditions.checkArgument(keyboardIds.size() > 0, "KeyboardIds must contain at least one element");
        ArrayListMultimap charactersToCombinations = ArrayListMultimap.create();
        for (ModifierKeyCombination combination : this.modifierAndPositionToCharacter.rowKeySet()) {
            Collection<CharacterMap> characterMaps = this.modifierAndPositionToCharacter.row(combination).values();
            charactersToCombinations.put(ImmutableSet.copyOf(characterMaps), combination);
        }
        KeyboardId id = (KeyboardId)((ImmutableSet)keyboardIds).iterator().next();
        ImmutableSortedSet.Builder keyMaps = ImmutableSortedSet.naturalOrder();
        for (Object characterMaps : charactersToCombinations.keySet()) {
            Collection collection = charactersToCombinations.get(characterMaps);
            ModifierKeyCombinationSet combinationSet = ModifierKeyCombinationSet.of(ImmutableSet.copyOf(collection));
            keyMaps.add(KeyMap.of(combinationSet, (ImmutableSet<CharacterMap>)characterMaps));
        }
        ImmutableSortedSet.Builder<Transform> transforms = ImmutableSortedSet.orderedBy(KeyboardBuilder.collatorComparator(Collator.getInstance(id.locale())));
        for (Map.Entry entry : this.transformSequenceToOutput.entrySet()) {
            transforms.add((Object)Transform.of((String)entry.getKey(), (String)entry.getValue()));
        }
        ImmutableList.Builder keyboards = ImmutableList.builder();
        for (KeyboardId keyboardId : keyboardIds) {
            keyboards.add(Keyboard.of(keyboardId, (ImmutableList<String>)this.names.build(), (ImmutableSortedSet<KeyMap>)keyMaps.build(), (ImmutableSortedSet<Transform>)transforms.build()));
        }
        return keyboards.build();
    }

    public Set<String> transformSequences() {
        return this.transformSequenceToOutput.keySet();
    }

    private static Comparator<Transform> collatorComparator(final Collator collator) {
        return new Comparator<Transform>(){

            @Override
            public int compare(Transform o1, Transform o2) {
                return collator.compare(o1.sequence(), o2.sequence());
            }
        };
    }
}

