/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard.out;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.unicode.cldr.draft.keyboard.KeyboardId;
import org.unicode.cldr.draft.keyboard.KeycodeMap;
import org.unicode.cldr.draft.keyboard.out.XmlWriter;

public final class KeycodeMapToXml {
    private final KeycodeMap keycodeMap;
    private final KeyboardId.Platform platform;
    private final XmlWriter xmlWriter;

    private KeycodeMapToXml(KeycodeMap keycodeMap, KeyboardId.Platform platform, XmlWriter xmlWriter) {
        this.keycodeMap = Preconditions.checkNotNull(keycodeMap);
        this.platform = Preconditions.checkNotNull(platform);
        this.xmlWriter = Preconditions.checkNotNull(xmlWriter);
    }

    public static void writeToXml(KeycodeMap keycodeMap, KeyboardId.Platform platform, Writer writer) {
        XmlWriter xmlWriter = XmlWriter.newXmlWriter(writer);
        KeycodeMapToXml keycodeMapToXml = new KeycodeMapToXml(keycodeMap, platform, xmlWriter);
        keycodeMapToXml.toXml();
    }

    private void toXml() {
        this.xmlWriter.startDocument("platform", "../dtd/ldmlPlatform.dtd");
        this.xmlWriter.startElement("platform", ImmutableMap.of("id", this.platform));
        this.xmlWriter.startElement("hardwareMap");
        for (Map.Entry entry : this.keycodeMap.keycodeToIsoLayout().entrySet()) {
            this.xmlWriter.addElement("map", ImmutableMap.of("keycode", (Serializable)entry.getKey(), "iso", (Serializable)entry.getValue()));
        }
        this.xmlWriter.endElement();
        this.xmlWriter.endElement();
        this.xmlWriter.endDocument();
    }
}

