/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.DisplayAndInputProcessor;
import org.unicode.cldr.test.FactoryCheckCLDR;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.PluralRulesUtil;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

public class CheckNumbers
extends FactoryCheckCLDR {
    private static final Splitter SEMI_SPLITTER = Splitter.on(';');
    private static final Set<String> SKIP_TIME_SEPARATOR = ImmutableSet.of("nds", "fr_CA");
    private static final UnicodeSet FORBIDDEN_NUMERIC_PATTERN_CHARS = new UnicodeSet("[[:n:]-[0]]");
    private ICUServiceBuilder icuServiceBuilder = new ICUServiceBuilder();
    private Set<SupplementalDataInfo.PluralInfo.Count> pluralTypes;
    private Map<SupplementalDataInfo.PluralInfo.Count, Set<Double>> pluralExamples;
    private Set<String> validNumberingSystems;
    private String defaultNumberingSystem;
    private String defaultTimeSeparatorPath;
    private String patternForHm;
    private static NumberFormat english = NumberFormat.getNumberInstance(ULocale.ENGLISH);
    private static Random random;
    private static Pattern ALLOWED_INTEGER;
    private static Pattern COMMA_ABUSE;
    static String SampleList;
    boolean isPOSIX;

    public CheckNumbers(Factory factory) {
        super(factory);
    }

    @Override
    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        if (cldrFileToCheck == null) {
            return this;
        }
        super.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        this.icuServiceBuilder.setCldrFile(this.getResolvedCldrFileToCheck());
        this.isPOSIX = cldrFileToCheck.getLocaleID().indexOf("POSIX") >= 0;
        SupplementalDataInfo supplementalData = SupplementalDataInfo.getInstance(this.getFactory().getSupplementalDirectory());
        SupplementalDataInfo.PluralInfo pluralInfo = supplementalData.getPlurals(SupplementalDataInfo.PluralType.cardinal, cldrFileToCheck.getLocaleID());
        this.pluralTypes = pluralInfo.getCounts();
        this.pluralExamples = pluralInfo.getCountToExamplesMap();
        this.validNumberingSystems = supplementalData.getNumberingSystems();
        CLDRFile resolvedFile = this.getResolvedCldrFileToCheck();
        this.defaultNumberingSystem = resolvedFile.getWinningValue("//ldml/numbers/defaultNumberingSystem");
        if (this.defaultNumberingSystem == null || !this.validNumberingSystems.contains(this.defaultNumberingSystem)) {
            this.defaultNumberingSystem = "latn";
        }
        this.defaultTimeSeparatorPath = "//ldml/numbers/symbols[@numberSystem=\"" + this.defaultNumberingSystem + "\"]/timeSeparator";
        this.patternForHm = resolvedFile.getWinningValue("//ldml/dates/calendars/calendar[@type='gregorian']/dateTimeFormats/availableFormats/dateFormatItem[@id='Hm']");
        return this;
    }

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        UnicodeSet illegalChars;
        DisplayAndInputProcessor.NumericType type;
        if (fullPath == null || value == null) {
            return this;
        }
        if (path.indexOf("/currencyMatch") >= 0) {
            try {
                new UnicodeSet(value);
            }
            catch (Exception e) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidCurrencyMatchSet).setMessage("Error in creating UnicodeSet {0}; {1}; {2}", value, e.getClass().getName(), e));
            }
            return this;
        }
        if (path.indexOf("/minimumGroupingDigits") >= 0) {
            try {
                int mgd = Integer.valueOf(value);
                if (!CldrUtility.DIGITS.contains(value)) {
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.badMinimumGroupingDigits).setMessage("Minimum grouping digits can only contain Western digits [0-9]."));
                } else if (mgd > 4) {
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.badMinimumGroupingDigits).setMessage("Minimum grouping digits cannot be greater than 4."));
                } else if (mgd < 1) {
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.badMinimumGroupingDigits).setMessage("Minimum grouping digits cannot be less than 1."));
                } else if (mgd > 2) {
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.badMinimumGroupingDigits).setMessage("Minimum grouping digits > 2 is rare. Please double check this."));
                }
            }
            catch (NumberFormatException e) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.badMinimumGroupingDigits).setMessage("Minimum grouping digits must be a numeric value."));
            }
            return this;
        }
        if (!(path.indexOf("defaultNumberingSystem") < 0 && path.indexOf("otherNumberingSystems") < 0 || this.validNumberingSystems.contains(value))) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalNumberingSystem).setMessage("Invalid numbering system: " + value));
        }
        if (path.contains(this.defaultTimeSeparatorPath) && !path.contains("[@alt=") && value != null && this.patternForHm != null && !this.patternForHm.contains(value) && !SKIP_TIME_SEPARATOR.contains(this.getCldrFileToCheck().getLocaleID())) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidSymbol).setMessage("Invalid timeSeparator: " + value + "; must match what is used in Hm time pattern: " + this.patternForHm));
        }
        if ((type = DisplayAndInputProcessor.NumericType.getNumericType(path)) == DisplayAndInputProcessor.NumericType.NOT_NUMERIC) {
            return this;
        }
        XPathParts parts = XPathParts.getFrozenInstance(path);
        boolean isPositive = true;
        for (String patternPart : SEMI_SPLITTER.split(value)) {
            if (!isPositive && !"accounting".equals(parts.getAttributeValue(-2, "type")) && patternPart.indexOf(45) < 0) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.missingMinusSign).setMessage("Negative format must contain ASCII minus sign (-)."));
            }
            if (!(type != DisplayAndInputProcessor.NumericType.CURRENCY && type != DisplayAndInputProcessor.NumericType.CURRENCY_ABBREVIATED || type == DisplayAndInputProcessor.NumericType.CURRENCY_ABBREVIATED && value.equals("0"))) {
                if (path.contains("noCurrency")) {
                    if (patternPart.indexOf("\u00a4") >= 0) {
                        result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.currencyPatternUnexpectedCurrencySymbol).setMessage("noCurrency formatting pattern must not contain a currency symbol."));
                    }
                } else if (patternPart.indexOf("\u00a4") < 0) {
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.currencyPatternMissingCurrencySymbol).setMessage("Currency formatting pattern must contain a currency symbol."));
                }
            }
            if (type == DisplayAndInputProcessor.NumericType.PERCENT && patternPart.indexOf("%") < 0) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.percentPatternMissingPercentSymbol).setMessage("Percentage formatting pattern must contain a % symbol."));
            }
            isPositive = false;
        }
        if (FORBIDDEN_NUMERIC_PATTERN_CHARS.containsSome(value)) {
            UnicodeSet chars = new UnicodeSet().addAll(value);
            chars.retainAll(FORBIDDEN_NUMERIC_PATTERN_CHARS);
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalCharactersInNumberPattern).setMessage("Pattern contains forbidden characters: \u200e{0}\u200e", chars.toPattern(false)));
        }
        String lastType = parts.getAttributeValue(-1, "type");
        int zeroCount = 0;
        if (lastType != null && !lastType.equals("standard")) {
            Matcher matcher = ALLOWED_INTEGER.matcher(lastType);
            if (matcher.matches()) {
                zeroCount = matcher.end(1) - matcher.start(1);
            } else {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.badNumericType).setMessage("The type of a numeric pattern must be missing or of the form 10...."));
            }
        }
        if ((illegalChars = CheckNumbers.findUnquotedChars(type, value)) != null) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalCharactersInNumberPattern).setMessage("Pattern contains characters that must be escaped or removed: {0}", illegalChars));
            return this;
        }
        parts = parts.cloneAsThawed();
        try {
            if (type == DisplayAndInputProcessor.NumericType.DECIMAL_ABBREVIATED || type == DisplayAndInputProcessor.NumericType.CURRENCY_ABBREVIATED) {
                this.checkDecimalFormatConsistency(parts, path, value, result, type);
            } else {
                this.checkPattern(path, fullPath, value, result, false);
            }
            if (COMMA_ABUSE.matcher(value).find()) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.tooManyGroupingSeparators).setMessage("Grouping separator (,) should not be used to group tens. Check if a decimal symbol (.) should have been used instead."));
            } else {
                String pattern = CheckNumbers.getCanonicalPattern(value, type, zeroCount, this.isPOSIX);
                if (!pattern.equals(value)) {
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.numberPatternNotCanonical).setMessage("Value should be \u200e{0}\u200e", pattern));
                }
            }
        }
        catch (Exception e) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalNumberFormat).setMessage(e.getMessage() == null ? e.toString() : e.getMessage()));
        }
        return this;
    }

    private static UnicodeSet findUnquotedChars(DisplayAndInputProcessor.NumericType type, String value) {
        UnicodeSet chars = new UnicodeSet();
        UnicodeSet allowedChars = null;
        allowedChars = type == DisplayAndInputProcessor.NumericType.DECIMAL_ABBREVIATED ? new UnicodeSet("[0-9]") : new UnicodeSet("[0-9#@.,E+]");
        for (String subPattern : value.split(";")) {
            int firstIdx = -1;
            int len = subPattern.length();
            for (int i = 0; i < len; ++i) {
                char c = subPattern.charAt(i);
                if (c != '0' && c != '#') continue;
                firstIdx = i;
                break;
            }
            if (firstIdx == -1) continue;
            int lastIdx = Math.max(subPattern.lastIndexOf("0"), subPattern.lastIndexOf(35));
            chars.addAll(subPattern.substring(firstIdx, lastIdx));
        }
        chars.removeAll(allowedChars);
        return chars.size() > 0 ? chars : null;
    }

    public CheckCLDR handleGetExamples(String path, String fullPath, String value, CheckCLDR.Options options, List result) {
        if (path.indexOf("/numbers") < 0) {
            return this;
        }
        try {
            if (path.indexOf("/pattern") >= 0 && path.indexOf("/patternDigit") < 0) {
                this.checkPattern(path, fullPath, value, result, true);
            }
            if (path.indexOf("/currencies") >= 0 && path.endsWith("/symbol")) {
                this.checkCurrencyFormats(path, fullPath, value, result, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    private void checkDecimalFormatConsistency(XPathParts parts, String path, String value, List<CheckCLDR.CheckStatus> result, DisplayAndInputProcessor.NumericType type) {
        DecimalFormat format = new DecimalFormat(value);
        int numIntegerDigits = format.getMinimumIntegerDigits();
        String countString = parts.getAttributeValue(-1, "count");
        SupplementalDataInfo.PluralInfo.Count thisCount = null;
        try {
            thisCount = SupplementalDataInfo.PluralInfo.Count.valueOf(countString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CLDRFile resolvedFile = this.getResolvedCldrFileToCheck();
        TreeSet<String> inconsistentItems = new TreeSet<String>();
        HashSet<SupplementalDataInfo.PluralInfo.Count> otherCounts = new HashSet<SupplementalDataInfo.PluralInfo.Count>(this.pluralTypes);
        if (thisCount != null) {
            Set<Double> pe = this.pluralExamples.get((Object)thisCount);
            if (pe == null) {
                return;
            }
            if (!value.contains("0")) {
                switch (pe.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return;
                    }
                    default: {
                        result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.missingZeros).setMessage("Values without a zero must only be used where there is only one possible numeric form, but this has multiple: {0} ", pe.toString()));
                    }
                }
            }
            otherCounts.remove((Object)thisCount);
        }
        for (SupplementalDataInfo.PluralInfo.Count count : otherCounts) {
            parts.setAttribute("pattern", "count", count.toString());
            String otherPattern = resolvedFile.getWinningValue(parts.toString());
            if (otherPattern == null || CheckNumbers.findUnquotedChars(type, otherPattern) != null) continue;
            format = new DecimalFormat(otherPattern);
            int numIntegerDigitsOther = format.getMinimumIntegerDigits();
            if (this.pluralExamples.get((Object)count).size() == 1 && numIntegerDigitsOther <= 0 || count == SupplementalDataInfo.PluralInfo.Count.many && PluralRulesUtil.LOCALES_WITH_OPTIONAL_MANY.contains(LocaleIDParser.getSimpleBaseLanguage(resolvedFile.getLocaleID())) || numIntegerDigitsOther == numIntegerDigits) continue;
            PathHeader pathHeader = this.getPathHeaderFactory().fromPath(parts.toString());
            inconsistentItems.add(pathHeader.getHeaderCode());
        }
        if (inconsistentItems.size() > 0) {
            PathHeader pathHeader = this.getPathHeaderFactory().fromPath(path.substring(0, path.lastIndexOf(91)));
            String groupHeaderString = pathHeader.getHeaderCode();
            boolean isWinningValue = resolvedFile.getWinningValue(path).equals(value);
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(isWinningValue ? CheckCLDR.CheckStatus.errorType : CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.inconsistentPluralFormat).setMessage("All values for {0} must have the same number of digits. The number of zeros in this pattern is inconsistent with the following: {1}.", groupHeaderString, ((Object)inconsistentItems).toString()));
        }
    }

    private void checkPattern(String path, String fullPath, String value, List result, boolean generateExamples) throws ParseException {
        if (value.indexOf(164) >= 0) {
            DecimalFormat x = this.icuServiceBuilder.getCurrencyFormat("XXX");
            this.addOrTestSamples(x, x.toPattern(), value, result, generateExamples);
        } else {
            DecimalFormat x = this.icuServiceBuilder.getNumberFormat(value);
            this.addOrTestSamples(x, value, "", result, generateExamples);
        }
    }

    private void checkCurrencyFormats(String path, String fullPath, String value, List result, boolean generateExamples) throws ParseException {
        DecimalFormat x = this.icuServiceBuilder.getCurrencyFormat(CLDRFile.getCode(path));
        this.addOrTestSamples(x, x.toPattern(), value, result, generateExamples);
    }

    private void addOrTestSamples(DecimalFormat x, String pattern, String context, List result, boolean generateExamples) throws ParseException {
        if (generateExamples) {
            result.add(new MyCheckStatus().setFormat(x, context).setCause(this).setMainType(CheckCLDR.CheckStatus.demoType));
        }
    }

    private static double getRandomNumber() {
        double rand = random.nextDouble();
        double sample = (double)Math.round(rand * 100000.0 * 1000.0) / 1000.0 + 10000.0;
        if (random.nextBoolean()) {
            sample = -sample;
        }
        return sample;
    }

    public static String getCanonicalPattern(String inpattern, DisplayAndInputProcessor.NumericType type, int zeroCount, boolean isPOSIX) {
        String pattern;
        DecimalFormat df = new DecimalFormat(inpattern);
        if (zeroCount == 0) {
            int[] digits = isPOSIX ? type.getPosixDigitCount() : type.getDigitCount();
            df.setMinimumIntegerDigits(digits[0]);
            df.setMinimumFractionDigits(digits[1]);
            df.setMaximumFractionDigits(digits[2]);
            pattern = df.toPattern();
        } else {
            if (type == DisplayAndInputProcessor.NumericType.CURRENCY_ABBREVIATED || type == DisplayAndInputProcessor.NumericType.DECIMAL_ABBREVIATED) {
                if (!inpattern.contains("0")) {
                    return inpattern;
                }
                if (!inpattern.contains("0.0")) {
                    df.setMinimumFractionDigits(0);
                }
            }
            df.setMaximumFractionDigits(df.getMinimumFractionDigits());
            int minimumIntegerDigits = df.getMinimumIntegerDigits();
            if (minimumIntegerDigits < 1) {
                minimumIntegerDigits = 1;
            }
            df.setMaximumIntegerDigits(minimumIntegerDigits);
            pattern = df.toPattern();
        }
        return pattern;
    }

    static {
        english.setMaximumFractionDigits(5);
        random = new Random();
        ALLOWED_INTEGER = PatternCache.get("1(0+)");
        COMMA_ABUSE = PatternCache.get(",[0#]([^0#]|$)");
        SampleList = "{0} \u2192 \u201c\u200e{1}\u200e\u201d \u2192 {2}";
    }

    static class MyDemo
    extends CheckCLDR.FormatDemo {
        private DecimalFormat df;

        MyDemo() {
        }

        @Override
        protected String getPattern() {
            return this.df.toPattern();
        }

        @Override
        protected String getSampleInput() {
            return String.valueOf(123456.789);
        }

        public MyDemo setFormat(DecimalFormat df) {
            this.df = df;
            return this;
        }

        @Override
        protected void getArguments(Map<String, String> inout) {
            double d;
            this.currentReparsed = "?";
            this.currentFormatted = "?";
            this.currentInput = "?";
            this.currentPattern = "?";
            try {
                this.currentPattern = inout.get("pattern");
                if (this.currentPattern != null) {
                    this.df.applyPattern(this.currentPattern);
                } else {
                    this.currentPattern = this.getPattern();
                }
            }
            catch (Exception e) {
                this.currentPattern = "Use format like: ##,###.##";
                return;
            }
            try {
                this.currentInput = inout.get("input");
                if (this.currentInput == null) {
                    this.currentInput = this.getSampleInput();
                }
                d = Double.parseDouble(this.currentInput);
            }
            catch (Exception e) {
                this.currentInput = "Use English format: 1234.56";
                return;
            }
            try {
                this.currentFormatted = this.df.format(d);
            }
            catch (Exception e) {
                this.currentFormatted = "Can't format: " + e.getMessage();
                return;
            }
            try {
                this.parsePosition.setIndex(0);
                Number n = this.df.parse(this.currentFormatted, this.parsePosition);
                this.currentReparsed = this.parsePosition.getIndex() != this.currentFormatted.length() ? "Couldn't parse past: \u200e" + this.currentFormatted.substring(0, this.parsePosition.getIndex()) + "\u200e" : n.toString();
            }
            catch (Exception e) {
                this.currentReparsed = "Can't parse: " + e.getMessage();
            }
        }
    }

    public static class MyCheckStatus
    extends CheckCLDR.CheckStatus {
        private DecimalFormat df;
        String context;

        public MyCheckStatus setFormat(DecimalFormat df, String context) {
            this.df = df;
            this.context = context;
            return this;
        }

        @Override
        public CheckCLDR.SimpleDemo getDemo() {
            return new MyDemo().setFormat(this.df);
        }
    }
}

