/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.ExampleGenerator;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.XMLSource;

public class TestCache
implements XMLSource.Listener {
    private static final boolean DEBUG = false;
    private Cache<CheckCLDR.Options, TestResultBundle> testResultCache = CacheBuilder.newBuilder().maximumSize(CLDRConfig.getInstance().getProperty("CLDR_TESTCACHE_SIZE", 12)).softValues().build();
    private Factory factory = null;
    private String nameMatcher = null;
    private static Cache<String, ExampleGenerator> exampleGeneratorCache = CacheBuilder.newBuilder().softValues().build();

    public TestResultBundle getBundle(CheckCLDR.Options options) {
        TestResultBundle b = this.testResultCache.getIfPresent(options);
        if (b == null) {
            b = new TestResultBundle(options);
            this.testResultCache.put(options, b);
        }
        return b;
    }

    protected Factory getFactory() {
        return this.factory;
    }

    public void setFactory(Factory factory, String nameMatcher) {
        if (this.factory != null) {
            throw new InternalError("setFactory() can only be called once.");
        }
        this.factory = factory;
        this.nameMatcher = nameMatcher;
    }

    public String toString() {
        StringBuilder stats = new StringBuilder();
        stats.append("{" + this.getClass().getSimpleName() + super.toString() + " Size: " + this.testResultCache.size() + " (");
        int good = 0;
        int total = 0;
        for (Map.Entry k : this.testResultCache.asMap().entrySet()) {
            CheckCLDR.Options key = (CheckCLDR.Options)k.getKey();
            TestResultBundle bundle = (TestResultBundle)k.getValue();
            if (bundle != null) {
                ++good;
            }
            ++total;
        }
        stats.append(" " + good + "/" + total + "}");
        return stats.toString();
    }

    @Override
    public void valueChanged(String xpath, XMLSource source) {
        CLDRLocale locale = CLDRLocale.getInstance(source.getLocaleID());
        this.valueChangedInvalidateRecursively(xpath, locale);
    }

    private void valueChangedInvalidateRecursively(String xpath, CLDRLocale locale) {
        for (CLDRLocale sub : this.getFactory().subLocalesOf(locale)) {
            this.valueChangedInvalidateRecursively(xpath, sub);
        }
        this.updateTestResultCache(xpath, locale);
        TestCache.updateExampleGeneratorCache(xpath, locale);
    }

    private void updateTestResultCache(String xpath, CLDRLocale locale) {
        if (!this.testResultCache.asMap().isEmpty()) {
            ArrayList<CheckCLDR.Options> toRemove = new ArrayList<CheckCLDR.Options>();
            for (CheckCLDR.Options k : this.testResultCache.asMap().keySet()) {
                if (!k.getLocale().equals(locale)) continue;
                toRemove.add(k);
            }
            this.testResultCache.invalidateAll(toRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExampleGenerator getExampleGenerator(CLDRLocale locale, CLDRFile ourSrc, CLDRFile translationHintsFile, String englishPath) {
        boolean egCacheIsEnabled = true;
        if (!egCacheIsEnabled) {
            return new ExampleGenerator(ourSrc, translationHintsFile, englishPath);
        }
        String locString = locale.toString();
        ExampleGenerator eg = exampleGeneratorCache.getIfPresent(locString);
        if (eg == null) {
            Cache<String, ExampleGenerator> cache = exampleGeneratorCache;
            synchronized (cache) {
                eg = exampleGeneratorCache.getIfPresent(locString);
                if (eg == null) {
                    eg = new ExampleGenerator(ourSrc, translationHintsFile, englishPath);
                    exampleGeneratorCache.put(locString, eg);
                }
            }
        }
        return eg;
    }

    private static void updateExampleGeneratorCache(String xpath, CLDRLocale locale) {
        ExampleGenerator eg = exampleGeneratorCache.getIfPresent(locale.toString());
        if (eg != null) {
            eg.updateCache(xpath);
        }
    }

    public void invalidateAllCached() {
        this.testResultCache.invalidateAll();
        exampleGeneratorCache.invalidateAll();
    }

    public class TestResultBundle {
        private final CheckCLDR cc;
        final CLDRFile file;
        private final CheckCLDR.Options options;
        private final ConcurrentHashMap<Pair<String, String>, List<CheckCLDR.CheckStatus>> pathCache;
        protected final List<CheckCLDR.CheckStatus> possibleProblems;

        protected TestResultBundle(CheckCLDR.Options cldrOptions) {
            this.cc = CheckCLDR.getCheckAll(TestCache.this.getFactory(), TestCache.this.nameMatcher);
            this.possibleProblems = new ArrayList<CheckCLDR.CheckStatus>();
            this.options = cldrOptions;
            this.pathCache = new ConcurrentHashMap();
            this.file = TestCache.this.getFactory().make(this.options.getLocale().getBaseName(), true);
            this.cc.setCldrFileToCheck(this.file, this.options, this.possibleProblems);
        }

        public void check(String path, List<CheckCLDR.CheckStatus> result, String value) {
            result.clear();
            Pair<String, String> key = new Pair<String, String>(path, value);
            List<CheckCLDR.CheckStatus> cachedResult = this.pathCache.get(key);
            if (cachedResult != null) {
                result.addAll(cachedResult);
            } else {
                this.cc.check(path, this.file.getFullXPath(path), value, this.options, result);
                this.pathCache.put(key, ImmutableList.copyOf(result));
            }
        }

        public void getExamples(String path, String value, List<CheckCLDR.CheckStatus> result) {
            this.cc.getExamples(path, this.file.getFullXPath(path), value, this.options, result);
        }

        public List<CheckCLDR.CheckStatus> getPossibleProblems() {
            return this.possibleProblems;
        }
    }
}

