/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.StandardCodes;

public class CountryCodeConverter {
    private static final boolean SHOW_SKIP = CldrUtility.getProperty("SHOW_SKIP", false);
    private static Map<String, String> nameToCountryCode = new TreeMap<String, String>(new UTF16.StringComparator(true, true, 0));
    private static Set<String> parseErrors = new LinkedHashSet<String>();

    public static String getCodeFromName(String display, boolean showMissing) {
        return CountryCodeConverter.getCodeFromName(display, showMissing, null);
    }

    public static String getCodeFromName(String display, boolean showMissing, Set<String> missing) {
        String result;
        String trial = display.trim().toLowerCase(Locale.ENGLISH);
        if (trial.startsWith("\"") && trial.endsWith("\"")) {
            trial = trial.substring(1, trial.length() - 2);
        }
        if (trial.startsWith("the ")) {
            trial = trial.substring(4);
        }
        if ("skip".equals(result = nameToCountryCode.get(trial))) {
            return null;
        }
        if (result == null && (trial = CountryCodeConverter.reverseComma(display)) != null) {
            result = nameToCountryCode.get(trial);
        }
        if (result == null && (showMissing || SHOW_SKIP)) {
            System.err.println("ERROR: CountryCodeConverter missing code for " + display + ".\nTo fix: add to external/alternate_country_names.txt a line such as:\n\t<code>;\t<name>;\t" + display);
            if (missing != null) {
                missing.add(display);
            }
        }
        return result;
    }

    public static Set<String> names() {
        return nameToCountryCode.keySet();
    }

    private static String reverseComma(String display) {
        String trial = null;
        int comma = display.indexOf(44);
        if (comma >= 0) {
            trial = display.substring(comma + 1).trim() + " " + display.substring(0, comma).trim();
        }
        return trial;
    }

    static void loadNames() throws IOException {
        for (String country : ULocale.getISOCountries()) {
            CountryCodeConverter.addName(ULocale.getDisplayCountry("und-" + country, "en"), country);
        }
        StandardCodes sc = StandardCodes.make();
        Set<String> goodAvailableCodes = sc.getGoodAvailableCodes("territory");
        for (String country : goodAvailableCodes) {
            String description = sc.getFullData("territory", country).get(0);
            if (country.equals("057")) continue;
            CountryCodeConverter.addName(description, country);
        }
        CldrUtility.handleFile("external/alternate_country_names.txt", new MyHandler(goodAvailableCodes));
        nameToCountryCode = CldrUtility.protectCollection(nameToCountryCode);
        parseErrors = Collections.unmodifiableSet(parseErrors);
    }

    static void addName(String key, String code) {
        CountryCodeConverter.addName2(key, code);
        String trial = CountryCodeConverter.reverseComma(key);
        if (trial != null) {
            CountryCodeConverter.addName2(trial, code);
        }
    }

    private static void addName2(String key, String code) {
        String old;
        if ((key = key.toLowerCase(Locale.ENGLISH)).startsWith("the ")) {
            key = key.substring(4);
        }
        if ((old = nameToCountryCode.get(key)) != null && !code.equals(old)) {
            System.err.println("Conflict!!" + key + "\t" + old + "\t" + code);
            return;
        }
        nameToCountryCode.put(key, code);
    }

    public static Set<String> getParseErrors() {
        return parseErrors;
    }

    static {
        try {
            CountryCodeConverter.loadNames();
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    static class MyHandler
    implements CldrUtility.LineHandler {
        private Set<String> goodAvailableCodes;

        public MyHandler(Set<String> goodAvailableCodes) {
            this.goodAvailableCodes = goodAvailableCodes;
        }

        @Override
        public boolean handle(String line) {
            if (line.trim().length() == 0) {
                return true;
            }
            String[] pieces = line.split(";");
            String country = pieces[0].trim();
            if (!this.goodAvailableCodes.contains(country)) {
                // empty if block
            }
            CountryCodeConverter.addName(pieces[2].trim(), country);
            return true;
        }
    }
}

