/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.Comparators;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.unicode.cldr.test.CoverageLevel2;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.ChainedMap;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PathStarrer;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

public class ListCoverageLevels {
    public static void main(String[] args) {
        String starred;
        CLDRConfig config = CLDRConfig.getInstance();
        StandardCodes sc = StandardCodes.make();
        SupplementalDataInfo sdi = config.getSupplementalDataInfo();
        LanguageTagParser ltp = new LanguageTagParser();
        Set<String> defaultContents = sdi.getDefaultContentLocales();
        PathStarrer starrer = new PathStarrer().setSubstitutionPattern("*");
        Factory mainAndAnnotationsFactory = config.getMainAndAnnotationsFactory();
        Set<String> toTest = sc.getLocaleCoverageLocales(Organization.cldr, EnumSet.allOf(Level.class));
        LinkedHashSet _ALL = new LinkedHashSet();
        toTest.forEach(locale -> _ALL.add(CLDRLocale.getInstance(locale)));
        ImmutableSet<CLDRLocale> ALL = ImmutableSet.copyOf(_ALL);
        ChainedMap.M4 data = ChainedMap.of(new TreeMap(), new TreeMap(), new TreeMap(), Boolean.class);
        ChainedMap.M5 starredToLevels = ChainedMap.of(new TreeMap(), new TreeMap(), new TreeMap(), new HashMap(), Boolean.class);
        CLDRFile root = mainAndAnnotationsFactory.make("root", false);
        ImmutableSortedSet<String> testPaths = ImmutableSortedSet.copyOf(root.fullIterable());
        for (String string : testPaths) {
            if (string.endsWith("/alias")) continue;
            starred = starrer.set(string);
            List<String> plainAttrs = starrer.getAttributes();
            for (String string2 : toTest) {
                CLDRLocale cLoc = CLDRLocale.getInstance(string2);
                CoverageLevel2 coverageLeveler = CoverageLevel2.getInstance(string2);
                Level level = coverageLeveler.getLevel(string);
                Attributes attributes = new Attributes(cLoc, plainAttrs);
                data.put(level, starred, attributes, Boolean.TRUE);
                starredToLevels.put(starred, level, cLoc, plainAttrs, Boolean.TRUE);
            }
        }
        System.out.println("ALL=" + ListCoverageLevels.getLocaleName(null, ALL));
        for (Map.Entry entry : starredToLevels) {
            starred = (String)entry.getKey();
            LinkedHashSet<CallSite> items = new LinkedHashSet<CallSite>();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                Level level = (Level)((Object)entry2.getKey());
                LinkedHashSet<CLDRLocale> locales = new LinkedHashSet<CLDRLocale>();
                boolean mixed = false;
                Set lastAttrs = null;
                for (Map.Entry entry3 : ((Map)entry2.getValue()).entrySet()) {
                    CLDRLocale locale3 = (CLDRLocale)entry3.getKey();
                    Set attrs = ((Map)entry3.getValue()).keySet();
                    if (lastAttrs != null && !attrs.equals(lastAttrs)) {
                        mixed = true;
                    }
                    lastAttrs = attrs;
                    locales.add(locale3);
                }
                if (!mixed) {
                    boolean bl = false;
                }
                String localeName = ListCoverageLevels.getLocaleName(ALL, locales);
                items.add((CallSite)((Object)(level + ":" + (mixed ? "" : "\u00b0") + localeName)));
            }
            System.out.println(starred + "\t" + items.size() + "\t" + Joiner.on(" ").join(items));
        }
        for (Level level : data.keySet()) {
            ChainedMap.M3 data2 = data.get(level);
            for (String starred2 : data2.keySet()) {
                Set<Attributes> set = data2.get(starred2).keySet();
                Multimap<String, List<String>> localesToAttrs = Attributes.getLocaleNameToAttributeList(ALL, set);
                for (Map.Entry<String, Collection<List<String>>> entry : localesToAttrs.asMap().entrySet()) {
                    Collection<List<String>> attrs = entry.getValue();
                    System.out.println(level + "\t" + starred2 + "\t" + entry.getKey() + "\t" + attrs.size() + "\t" + Attributes.compact(attrs, new StringBuilder()));
                }
            }
        }
    }

    private static String getLocaleName(Set<CLDRLocale> all, Set<CLDRLocale> locales) {
        Function<Set, String> remainderName = x -> {
            LinkedHashSet y = new LinkedHashSet(all);
            y.removeAll((Collection<?>)x);
            return "AllLcs-(" + Joiner.on("|").join(y) + ")";
        };
        return all == null ? Joiner.on("|").join(locales) : (locales.equals(all) ? "AllLcs" : (locales.size() * 2 > all.size() ? remainderName.apply(locales) : Joiner.on("|").join(locales)));
    }

    static class Attributes
    implements Comparable<Attributes> {
        private static final Comparator<Iterable<String>> COLLECTION_COMPARATOR = Comparators.lexicographical(Comparator.naturalOrder());
        private final CLDRLocale cLoc;
        private final List<String> attributes;

        public Attributes(CLDRLocale cLoc, List<String> attributes2) {
            this.cLoc = cLoc;
            this.attributes = ImmutableList.copyOf(attributes2);
        }

        public static StringBuilder compact(Collection<List<String>> attrList, StringBuilder result) {
            Map<String, Map> map = Attributes.getMap(attrList);
            Attributes.getName(map, result);
            return result;
        }

        public static Multimap<String, List<String>> getLocaleNameToAttributeList(Set<CLDRLocale> all, Set<Attributes> attributeSet) {
            TreeMultimap localeNameToAttributeList = TreeMultimap.create(Comparator.naturalOrder(), COLLECTION_COMPARATOR);
            TreeMultimap attributesToLocales = TreeMultimap.create(COLLECTION_COMPARATOR, Comparator.naturalOrder());
            int count = 0;
            for (Attributes attributes : attributeSet) {
                count = attributes.attributes.size();
                attributesToLocales.put(attributes.attributes, attributes.cLoc);
            }
            if (count > 1) {
                boolean bl = false;
            }
            for (Map.Entry entry : attributesToLocales.asMap().entrySet()) {
                List attributeList = (List)entry.getKey();
                Set locales = (Set)entry.getValue();
                String localeName = ListCoverageLevels.getLocaleName(all, locales);
                localeNameToAttributeList.put(localeName, attributeList);
            }
            return localeNameToAttributeList;
        }

        private static void getName(Map<String, Map> map, StringBuilder result) {
            if (map.isEmpty()) {
                return;
            }
            result.append("(");
            boolean first = true;
            for (Map.Entry<String, Map> entry : map.entrySet()) {
                if (!first) {
                    result.append('|');
                } else {
                    first = false;
                }
                result.append(entry.getKey());
                Attributes.getName(entry.getValue(), result);
            }
            result.append(")");
        }

        private static <T, U extends Iterable<T>, V extends Iterable<U>> Map<T, Map> getMap(V source) {
            if (!source.iterator().hasNext()) {
                return Collections.emptyMap();
            }
            LinkedHashMap items = new LinkedHashMap();
            for (Iterable list : source) {
                LinkedHashMap top = items;
                for (Object item : list) {
                    LinkedHashMap value = (LinkedHashMap)top.get(item);
                    if (value == null) {
                        value = new LinkedHashMap();
                        top.put(item, value);
                    }
                    top = value;
                }
            }
            return items;
        }

        @Override
        public int compareTo(Attributes o) {
            return ComparisonChain.start().compare(this.cLoc, o.cLoc).compare(this.attributes, o.attributes, COLLECTION_COMPARATOR).result();
        }

        public String toString() {
            return this.attributes.isEmpty() ? this.cLoc.toString() : this.cLoc + "|" + Joiner.on("|").join(this.attributes);
        }
    }
}

