/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Stream;

public final class PreferredAndAllowedHour
implements Comparable<PreferredAndAllowedHour> {
    private static final Splitter SPACE_SPLITTER = Splitter.on(' ').trimResults();
    private static final Comparator<PreferredAndAllowedHour> COMPARATOR = Comparator.comparing(t -> t.preferred).thenComparing(t -> t.allowed, Comparators.lexicographical(Comparator.naturalOrder()));
    public final HourStyle preferred;
    public final ImmutableList<HourStyle> allowed;

    public PreferredAndAllowedHour(char preferred, Set<Character> allowed) {
        this(String.valueOf(preferred), allowed.stream().map(String::valueOf));
    }

    public PreferredAndAllowedHour(String preferred, String allowedString) {
        this(preferred, SPACE_SPLITTER.splitToList(allowedString).stream());
    }

    private PreferredAndAllowedHour(String preferredStyle, Stream<String> allowedStyles) {
        this.preferred = Preconditions.checkNotNull(HourStyle.valueOf(preferredStyle));
        this.allowed = allowedStyles.map(HourStyle::valueOf).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument(this.allowed.stream().distinct().count() == (long)this.allowed.size(), "Allowed (%s) must not contain duplicates", this.allowed);
        Preconditions.checkArgument(this.allowed.contains((Object)this.preferred), "Allowed (%s) must contain preferred (%s)", this.allowed, (Object)this.preferred);
    }

    @Override
    public int compareTo(PreferredAndAllowedHour other) {
        return COMPARATOR.compare(this, other);
    }

    public String toString() {
        return this.toString(ImmutableList.of("?"));
    }

    public String toString(Collection<String> regions) {
        Joiner withSpaces = Joiner.on(" ");
        return "<hours preferred=\"" + this.preferred + "\" allowed=\"" + withSpaces.join(this.allowed) + "\" regions=\"" + withSpaces.join(regions) + "\"/>";
    }

    public boolean equals(Object obj) {
        return obj instanceof PreferredAndAllowedHour && this.compareTo((PreferredAndAllowedHour)obj) == 0;
    }

    public static enum HourStyle {
        H,
        Hb(H),
        HB(H),
        k,
        h,
        hb(h),
        hB(h),
        K;

        public final HourStyle base;

        private HourStyle() {
            this.base = this;
        }

        private HourStyle(HourStyle base) {
            this.base = base;
        }

        public static boolean isHourCharacter(String c) {
            try {
                HourStyle.valueOf(c);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
    }
}

