/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedBreakIterator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.test.ExampleGenerator;
import org.unicode.cldr.tool.GenerateAttributeList;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.TimezoneFormatter;
import org.unicode.cldr.util.TransliteratorUtilities;
import org.unicode.cldr.util.XMLFileReader;

public class TestUtilities {
    String s;
    private static final String[][] language_territory_hack = new String[][]{{"af", "ZA"}, {"am", "ET"}, {"ar", "SA"}, {"as", "IN"}, {"ay", "PE"}, {"az", "AZ"}, {"bal", "PK"}, {"be", "BY"}, {"bg", "BG"}, {"bn", "IN"}, {"bs", "BA"}, {"ca", "ES"}, {"ch", "MP"}, {"cpe", "SL"}, {"cs", "CZ"}, {"cy", "GB"}, {"da", "DK"}, {"de", "DE"}, {"dv", "MV"}, {"dz", "BT"}, {"el", "GR"}, {"en", "US"}, {"es", "ES"}, {"et", "EE"}, {"eu", "ES"}, {"fa", "IR"}, {"fi", "FI"}, {"fil", "PH"}, {"fj", "FJ"}, {"fo", "FO"}, {"fr", "FR"}, {"ga", "IE"}, {"gd", "GB"}, {"gl", "ES"}, {"gn", "PY"}, {"gu", "IN"}, {"gv", "GB"}, {"ha", "NG"}, {"he", "IL"}, {"hi", "IN"}, {"ho", "PG"}, {"hr", "HR"}, {"ht", "HT"}, {"hu", "HU"}, {"hy", "AM"}, {"id", "ID"}, {"is", "IS"}, {"it", "IT"}, {"ja", "JP"}, {"ka", "GE"}, {"kk", "KZ"}, {"kl", "GL"}, {"km", "KH"}, {"kn", "IN"}, {"ko", "KR"}, {"kok", "IN"}, {"ks", "IN"}, {"ku", "TR"}, {"ky", "KG"}, {"la", "VA"}, {"lb", "LU"}, {"ln", "CG"}, {"lo", "LA"}, {"lt", "LT"}, {"lv", "LV"}, {"mai", "IN"}, {"men", "GN"}, {"mg", "MG"}, {"mh", "MH"}, {"mk", "MK"}, {"ml", "IN"}, {"mn", "MN"}, {"mni", "IN"}, {"mo", "MD"}, {"mr", "IN"}, {"ms", "MY"}, {"mt", "MT"}, {"my", "MM"}, {"na", "NR"}, {"nb", "NO"}, {"nd", "ZA"}, {"ne", "NP"}, {"niu", "NU"}, {"nl", "NL"}, {"nn", "NO"}, {"no", "NO"}, {"nr", "ZA"}, {"nso", "ZA"}, {"ny", "MW"}, {"om", "KE"}, {"or", "IN"}, {"pa", "IN"}, {"pau", "PW"}, {"pl", "PL"}, {"ps", "PK"}, {"pt", "BR"}, {"qu", "PE"}, {"rn", "BI"}, {"ro", "RO"}, {"ru", "RU"}, {"rw", "RW"}, {"sd", "IN"}, {"sg", "CF"}, {"si", "LK"}, {"sk", "SK"}, {"sl", "SI"}, {"sm", "WS"}, {"so", "DJ"}, {"sq", "CS"}, {"sr", "CS"}, {"ss", "ZA"}, {"st", "ZA"}, {"sv", "SE"}, {"sw", "KE"}, {"ta", "IN"}, {"te", "IN"}, {"tem", "SL"}, {"tet", "TL"}, {"th", "TH"}, {"ti", "ET"}, {"tg", "TJ"}, {"tk", "TM"}, {"tkl", "TK"}, {"tvl", "TV"}, {"tl", "PH"}, {"tn", "ZA"}, {"to", "TO"}, {"tpi", "PG"}, {"tr", "TR"}, {"ts", "ZA"}, {"uk", "UA"}, {"ur", "IN"}, {"uz", "UZ"}, {"ve", "ZA"}, {"vi", "VN"}, {"wo", "SN"}, {"xh", "ZA"}, {"zh", "CN"}, {"zh_Hant", "TW"}, {"zu", "ZA"}, {"aa", "ET"}, {"byn", "ER"}, {"eo", "DE"}, {"gez", "ET"}, {"haw", "US"}, {"iu", "CA"}, {"kw", "GB"}, {"sa", "IN"}, {"sh", "HR"}, {"sid", "ET"}, {"syr", "SY"}, {"tig", "ER"}, {"tt", "RU"}, {"wal", "ET"}};

    public static void main(String[] args) throws Exception {
        try {
            TestUtilities.checkStandardCodes();
            return;
        }
        finally {
            System.out.println("Done");
        }
    }

    private static void testNames() {
        String[] tests;
        Factory mainCldrFactory = Factory.make(CLDRPaths.COMMON_DIRECTORY + "main" + File.separator, ".*");
        CLDRFile english = mainCldrFactory.make("en", true);
        CLDRFile french = mainCldrFactory.make("fr", true);
        for (String test : tests = new String[]{"en", "en_AU", "de_CH", "de_Arab_CH", "gsw", "gsw_Arab", "zh_Hans", "zh_Hans_US", "zh_Hans_US_SAAHO"}) {
            System.out.println(test + "\t" + english.getName(test) + "\t" + french.getName(test));
        }
    }

    private static void testExampleGenerator() throws IOException {
        System.out.println("Creating English CLDRFile");
        Factory mainCldrFactory = Factory.make(CLDRPaths.COMMON_DIRECTORY + "main" + File.separator, ".*");
        CLDRFile english = mainCldrFactory.make("en", true);
        System.out.println("Creating Example Generator");
        ExampleGenerator englishExampleGenerator = new ExampleGenerator(english, english, CLDRPaths.DEFAULT_SUPPLEMENTAL_DIRECTORY);
        System.out.println("Processing paths");
        StringBuilder result = new StringBuilder();
        Relation<String, CallSite> message_paths = Relation.of(new TreeMap(), TreeSet.class);
        for (String path : english) {
            String helpText;
            String value = english.getStringValue(path);
            result.setLength(0);
            String examples = englishExampleGenerator.getExampleHtml(path, value);
            if (examples != null) {
                result.append(examples).append("<hr>");
            }
            if ((helpText = englishExampleGenerator.getHelpHtml(path, "@")) != null) {
                result.append(helpText).append("<hr>");
            } else {
                System.out.println("No help phrase for " + path);
            }
            if (result.length() != 0) {
                message_paths.put(result.toString(), (CallSite)((Object)(path + "\t:\t" + value)));
                continue;
            }
            message_paths.put("\ufffd<b>NO MESSAGE</b><hr>", (CallSite)((Object)(path + "\t:\t" + value)));
        }
        PrintWriter out = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY + "test/", "test_examples.html");
        out.println("<html><body><meta http-equiv='Content-Type' content='text/html; charset=utf-8'>");
        for (String message : message_paths.keySet()) {
            Set paths = message_paths.getAll(message);
            out.println("<p>");
            out.println(CldrUtility.join(paths, "<br>\n"));
            out.println("</p><blockquote>");
            out.println(message);
            out.println("</blockquote>");
        }
        out.println("<script>\nvar gaJsHost = ((\"https:\" == document.location.protocol) ? \"https://ssl.\" : \"http://www.\");\ndocument.write(unescape(\"%3Cscript src='\" + gaJsHost + \"google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E\"));\n</script>\n<script>\ntry {\nvar pageTracker = _gat._getTracker(\"UA-7672775-1\");\npageTracker._trackPageview();\n} catch(err) {}</script>");
        out.println("</body></html>");
        out.close();
    }

    private static void checkNumericTimezone() throws IOException {
        String line;
        String[] map_integer_zones = new String[1000];
        StandardCodes sc = StandardCodes.make();
        TreeSet<String> timezones = new TreeSet<String>(sc.getGoodAvailableCodes("tzid"));
        TreeMap<String, Integer> map_timezone_integer = new TreeMap<String, Integer>();
        BufferedReader input = CldrUtility.getUTF8Data("timezone_numeric.txt");
        int maxNumeric = -1;
        Map<String, String> fixOld = sc.zoneParser.getZoneLinkold_new();
        while ((line = input.readLine()) != null) {
            String[] parts = line.split(";\\s*");
            int numeric = Integer.parseInt(parts[0]);
            String originalTzid = parts[1].trim();
            Object fixedID = fixOld.get(originalTzid);
            if (fixedID == null) {
                if (!timezones.contains(originalTzid)) {
                    System.out.println(numeric + "\t" + originalTzid + "\tStrange ID: " + (String)fixedID);
                }
                fixedID = originalTzid;
            } else {
                System.out.println("Replacing " + originalTzid + " with " + (String)fixedID);
            }
            if (map_integer_zones[numeric] != null) {
                System.out.println("Duplicate number:" + numeric + ",\t" + (String)fixedID + ",\t" + originalTzid + ",\t" + map_integer_zones[numeric]);
                fixedID = "{" + originalTzid + "}";
            }
            if (map_timezone_integer.get(fixedID) != null) {
                System.out.println("Duplicate zone:" + numeric + ",\t" + (String)fixedID + ",\t" + originalTzid + ",\t" + map_timezone_integer.get(fixedID));
                fixedID = "{" + originalTzid + "}";
            }
            map_integer_zones[numeric] = fixedID;
            map_timezone_integer.put((String)fixedID, new Integer(numeric));
            if (maxNumeric >= numeric) continue;
            maxNumeric = numeric;
        }
        RuleBasedCollator eng = (RuleBasedCollator)Collator.getInstance();
        eng.setNumericCollation(true);
        TreeSet<Object> extra = new TreeSet<Object>(eng);
        extra.addAll(map_timezone_integer.keySet());
        extra.removeAll(timezones);
        System.out.println("Extra: " + extra);
        TreeSet<Object> needed = new TreeSet<Object>(eng);
        needed.addAll(timezones);
        needed.removeAll(map_timezone_integer.keySet());
        System.out.println("Needed: " + needed);
        int numeric = 1;
        ArrayList<Object> ordered = new ArrayList<Object>(needed);
        for (String string : ordered) {
            while (map_integer_zones[numeric] != null) {
                ++numeric;
            }
            if (maxNumeric < numeric) {
                maxNumeric = numeric;
            }
            map_integer_zones[numeric] = string;
            map_timezone_integer.put(string, new Integer(numeric));
        }
        Map<String, Set<String>> equiv = sc.zoneParser.getZoneLinkNew_OldSet();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 1; i <= maxNumeric; ++i) {
            Set<String> s2 = equiv.get(map_integer_zones[i]);
            if (s2 != null) {
                treeSet.clear();
                treeSet.addAll(s2);
            }
            System.out.println("\t\"" + map_integer_zones[i] + "\",");
        }
    }

    private static void checkTranslit() {
        for (int i = 0; i < 65535; ++i) {
            TestUtilities.checkTranslit(UTF16.valueOf(i));
        }
        PrintStream out = System.out;
        Transliterator toHTML = TransliteratorUtilities.toHTML;
        UnicodeSet a_out = new UnicodeSet("[:whitespace:]");
        UnicodeSetIterator it = new UnicodeSetIterator(a_out);
        while (it.next()) {
            int s2 = it.codepoint;
            String literal = toHTML.transliterate(UTF16.valueOf(s2));
            out.println(Utility.hex(s2, 4) + " (" + literal + ") " + UCharacter.getName(s2));
        }
    }

    private static void checkTranslit(String string) {
        String htmlAscii;
        String reverseAscii;
        String html = TransliteratorUtilities.toHTML.transliterate(string);
        String reverse = TransliteratorUtilities.fromHTML.transliterate(html);
        if (!reverse.equals(string)) {
            System.out.println(string + "\t=>\t" + html + "\t=>\t" + reverse + (!reverse.equals(string) ? " FAIL" : ""));
        }
        if (!(reverseAscii = TransliteratorUtilities.fromHTML.transliterate(htmlAscii = TransliteratorUtilities.toHTMLAscii.transliterate(string))).equals(string)) {
            System.out.println(string + "\t=>\t" + htmlAscii + "\t=>\t" + reverseAscii + (!reverseAscii.equals(string) ? " FAIL" : ""));
        }
    }

    private static void writeMetaData() throws IOException {
        int i;
        CLDRFile meta = SimpleFactory.makeFile("metaData").setNonInheriting(true);
        CharSequence[] elements = new String[]{"ldml", "identity", "alias", "localeDisplayNames", "layout", "characters", "delimiters", "measurement", "dates", "numbers", "collations", "posix", "segmentations", "references", "version", "generation", "language", "script", "territory", "variant", "languages", "scripts", "territories", "variants", "keys", "types", "measurementSystemNames", "key", "type", "measurementSystemName", "orientation", "inList", "exemplarCharacters", "mapping", "quotationStart", "quotationEnd", "alternateQuotationStart", "alternateQuotationEnd", "measurementSystem", "paperSize", "height", "width", "localizedPatternChars", "calendars", "timeZoneNames", "months", "monthNames", "monthAbbr", "days", "dayNames", "dayAbbr", "quarters", "week", "am", "pm", "eras", "dateFormats", "timeFormats", "dateTimeFormats", "fields", "month", "day", "quarter", "minDays", "firstDay", "weekendStart", "weekendEnd", "eraNames", "eraAbbr", "era", "pattern", "displayName", "dateFormatItem", "appendItem", "hourFormat", "hoursFormat", "gmtFormat", "regionFormat", "fallbackFormat", "abbreviationFallback", "preferenceOrdering", "singleCountries", "default", "calendar", "monthContext", "monthWidth", "dayContext", "dayWidth", "quarterContext", "quarterWidth", "dateFormatLength", "dateFormat", "timeFormatLength", "timeFormat", "dateTimeFormatLength", "availableFormats", "appendItems", "dateTimeFormat", "zone", "metazone", "long", "short", "usesMetazone", "exemplarCity", "generic", "standard", "daylight", "field", "relative", "symbols", "decimalFormats", "scientificFormats", "percentFormats", "currencyFormats", "currencies", "decimalFormatLength", "decimalFormat", "scientificFormatLength", "scientificFormat", "percentFormatLength", "percentFormat", "currencySpacing", "currencyFormatLength", "beforeCurrency", "afterCurrency", "currencyMatch", "surroundingMatch", "insertBetween", "currencyFormat", "currency", "symbol", "decimal", "group", "list", "percentSign", "nativeZeroDigit", "patternDigit", "plusSign", "minusSign", "exponential", "perMille", "infinity", "nan", "collation", "messages", "yesstr", "nostr", "yesexpr", "noexpr", "segmentation", "variables", "segmentRules", "special", "variable", "rule", "comment", "base", "settings", "suppress_contractions", "optimize", "rules"};
        String list = String.join((CharSequence)" ", elements);
        String prefix = "//supplementalData[@version=\"1.4\"]/metaData/";
        meta.add(prefix + "elementOrder", list);
        CharSequence[] attOrder = new String[]{"_q", "type", "key", "registry", "source", "target", "path", "day", "date", "version", "count", "lines", "characters", "before", "from", "to", "number", "time", "casing", "list", "uri", "iso4217", "digits", "rounding", "iso3166", "hex", "id", "request", "direction", "alternate", "backwards", "caseFirst", "caseLevel", "hiraganaQuarternary", "hiraganaQuaternary", "normalization", "numeric", "strength", "validSubLocales", "standard", "references", "elements", "element", "attributes", "attribute", "alt", "draft"};
        meta.add(prefix + "attributeOrder", String.join((CharSequence)" ", attOrder));
        CharSequence[] serialElements = new String[]{"variable", "comment", "tRule", "reset", "p", "pc", "s", "sc", "t", "tc", "i", "ic", "x", "extend", "first_variable", "last_variable", "first_tertiary_ignorable", "last_tertiary_ignorable", "first_secondary_ignorable", "last_secondary_ignorable", "first_primary_ignorable", "last_primary_ignorable", "first_non_ignorable", "last_non_ignorable", "first_trailing", "last_trailing"};
        meta.add(prefix + "serialElements", String.join((CharSequence)" ", serialElements));
        Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        GenerateAttributeList attributes = new GenerateAttributeList(cldrFactory);
        Map<String, Map<String, Set<String>[]>> element_attribute_valueSet = attributes.getElement_attribute_valueSet();
        for (String element : element_attribute_valueSet.keySet()) {
            Map<String, Set<String>[]> attribute_valueSet = element_attribute_valueSet.get(element);
            int size = attribute_valueSet.size();
            if (size == 0) continue;
            for (String attribute : attribute_valueSet.keySet()) {
                Set<String>[] valueSets = attribute_valueSet.get(attribute);
                for (i = 0; i < 2; ++i) {
                    meta.add(prefix + "valid/attributeValues[@elements=\"" + element + "\"][@attributes=\"" + attribute + "\"]" + (i == 1 ? "[@x=\"true\"]" : ""), Joiner.on(" ").join(valueSets[i]));
                }
            }
        }
        CharSequence[] dayValueOrder = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};
        meta.add(prefix + "valid/attributeValues[@order=\"given\"][@attributes=\"type\"][@elements=\"day\"]", String.join((CharSequence)" ", dayValueOrder));
        meta.add(prefix + "valid/attributeValues[@order=\"given\"][@attributes=\"day\"][@elements=\"firstDay weekendEnd weekendStart\"]", String.join((CharSequence)" ", dayValueOrder));
        CharSequence[] widths = new String[]{"monthWidth", "dayWidth", "quarterWidth"};
        CharSequence[] widthOrder = new String[]{"abbreviated", "narrow", "wide"};
        meta.add(prefix + "valid/attributeValues[@order=\"given\"][@attributes=\"type\"][@elements=\"" + String.join((CharSequence)" ", widths) + "\"]", String.join((CharSequence)" ", widthOrder));
        CharSequence[] formatLengths = new String[]{"dateFormatLength", "timeFormatLength", "dateTimeFormatLength", "decimalFormatLength", "scientificFormatLength", "percentFormatLength", "currencyFormatLength"};
        CharSequence[] lengthOrder = new String[]{"full", "long", "medium", "short"};
        meta.add(prefix + "valid/attributeValues[@order=\"given\"][@attributes=\"type\"][@elements=\"" + String.join((CharSequence)" ", formatLengths) + "\"]", String.join((CharSequence)" ", lengthOrder));
        CharSequence[] dateFieldOrder = new String[]{"era", "year", "month", "week", "day", "weekday", "dayperiod", "hour", "minute", "second", "zone"};
        meta.add(prefix + "valid/attributeValues[@order=\"given\"][@attributes=\"type\"][@elements=\"field\"]", String.join((CharSequence)" ", dateFieldOrder));
        String[][] suppressData = new String[][]{{"ldml", "version", "*"}, {"orientation", "characters", "left-to-right"}, {"orientation", "lines", "top-to-bottom"}, {"weekendStart", "time", "00:00"}, {"weekendEnd", "time", "24:00"}, {"dateFormat", "type", "standard"}, {"timeFormat", "type", "standard"}, {"dateTimeFormat", "type", "standard"}, {"decimalFormat", "type", "standard"}, {"scientificFormat", "type", "standard"}, {"percentFormat", "type", "standard"}, {"currencyFormat", "type", "standard"}, {"pattern", "type", "standard"}, {"currency", "type", "standard"}, {"collation", "type", "standard"}, {"*", "_q", "*"}};
        for (i = 0; i < suppressData.length; ++i) {
            meta.add(prefix + "suppress/attributes[@element=\"" + suppressData[i][0] + "\"][@attribute=\"" + suppressData[i][1] + "\"][@attributeValue=\"" + suppressData[i][2] + "\"]", "");
        }
        PrintWriter out = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY + "meta/", "metaData.xml");
        meta.write(out);
        out.close();
        XMLFileReader xfr = new XMLFileReader().setHandler(new MyHandler());
        xfr.read(CLDRPaths.GEN_DIRECTORY + "meta/metaData.xml", XMLFileReader.CONTENT_HANDLER | XMLFileReader.ERROR_HANDLER, false);
    }

    private static void testXMLFileReader() {
        XMLFileReader xfr = new XMLFileReader().setHandler(new MyHandler());
        xfr.read(CLDRPaths.MAIN_DIRECTORY + "root.xml", -1, true);
    }

    public static void testBreakIterator(String text) {
        System.out.println(text);
        String choice = "Line";
        String BASE_RULES = "'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; ";
        String CONTENT_RULES = "'>' > '&gt;' ;";
        String HTML_RULES = BASE_RULES + CONTENT_RULES + "'\"' > '&quot;' ; ";
        String HTML_RULES_CONTROLS = HTML_RULES + "([[:C:][:Z:][:whitespace:][:Default_Ignorable_Code_Point:][\\u0080-\\U0010FFFF]]) > &hex/xml($1) ; ";
        Transliterator toHTML = Transliterator.createFromRules("any-xml", HTML_RULES_CONTROLS, 0);
        RuleBasedBreakIterator b = choice.equals("Word") ? (RuleBasedBreakIterator)BreakIterator.getWordInstance() : (choice.equals("Line") ? (RuleBasedBreakIterator)BreakIterator.getLineInstance() : (choice.equals("Sentence") ? (RuleBasedBreakIterator)BreakIterator.getSentenceInstance() : (RuleBasedBreakIterator)BreakIterator.getCharacterInstance()));
        Matcher decimalEscapes = PatternCache.get("&#(x?)([0-9]+);").matcher(text);
        int start = 0;
        StringBuffer result2 = new StringBuffer();
        while (decimalEscapes.find(start)) {
            int radix = decimalEscapes.group(2).length() == 0 ? 10 : 16;
            int code = Integer.parseInt(decimalEscapes.group(2), radix);
            result2.append(text.substring(start, decimalEscapes.start()) + UTF16.valueOf(code));
            start = decimalEscapes.end();
        }
        result2.append(text.substring(start));
        text = result2.toString();
        int lastBreak = 0;
        StringBuffer result = new StringBuffer();
        b.setText(text);
        b.first();
        int nextBreak = b.next();
        while (nextBreak != -1) {
            b.getRuleStatus();
            String piece = text.substring(lastBreak, nextBreak);
            piece = toHTML.transliterate(piece);
            piece = piece.replaceAll("&#xA;", "<br>");
            result.append("<span class='break'>").append(piece).append("</span>");
            lastBreak = nextBreak;
            nextBreak = b.next();
        }
        System.out.println(result);
    }

    private static void checkStandardCodes() {
        String oldType;
        Map<String, Map<String, String>> subtagData;
        StandardCodes sc = StandardCodes.make();
        TestUtilities.showCodes(sc, "language");
        TestUtilities.showCodes(sc, "script");
        TestUtilities.showCodes(sc, "territory");
        TestUtilities.showCodes(sc, "tzid");
        TestUtilities.showCodes(sc, "currency");
        Map<String, Map<String, Map<String, String>>> m3 = StandardCodes.getLStreg();
        for (String type : m3.keySet()) {
            subtagData = m3.get(type);
            oldType = type.equals("region") ? "territory" : type;
            Set<String> allCodes = sc.getAvailableCodes(oldType);
            TreeSet<String> temp = new TreeSet<String>(subtagData.keySet());
            temp.removeAll(allCodes);
            System.out.println(type + "\t in new but not old\t" + temp);
            temp = new TreeSet<String>(allCodes);
            temp.removeAll(subtagData.keySet());
            System.out.println(type + "\t in old but not new\t" + temp);
        }
        for (String type : m3.keySet()) {
            subtagData = m3.get(type);
            oldType = type.equals("region") ? "territory" : type;
            Set<String> goodCodes = sc.getGoodAvailableCodes(oldType);
            for (String tag : subtagData.keySet()) {
                boolean newDeprecated;
                boolean deprecated;
                Map<String, String> data = subtagData.get(tag);
                List<String> sdata = sc.getFullData(oldType, tag);
                if (sdata == null) continue;
                String description = sdata.get(0);
                boolean bl = deprecated = !goodCodes.contains(tag);
                if (description.equalsIgnoreCase("PRIVATE USE")) {
                    deprecated = false;
                }
                String newDescription = data.get("Description");
                boolean bl2 = newDeprecated = data.get("Deprecated") != null;
                if (!description.equals(newDescription)) {
                    System.out.println(type + "\t" + tag + "\tDescriptions differ: {" + description + "} ### {" + newDescription + "}");
                }
                if (deprecated == newDeprecated) continue;
                System.out.println(type + "\t" + tag + "\tDeprecated differs: {" + deprecated + "} ### {" + newDeprecated + "}");
            }
        }
        for (String type : m3.keySet()) {
            subtagData = m3.get(type);
            oldType = type.equals("region") ? "territory" : type;
            String aliasType = oldType.equals("legacy") ? "language" : oldType;
            TreeSet<String> allCodes = new TreeSet<String>();
            TreeSet<String> deprecatedCodes = new TreeSet<String>();
            for (String tag : subtagData.keySet()) {
                Map<String, String> data = subtagData.get(tag);
                if (data.get("Deprecated") != null) {
                    String preferred = data.get("Preferred-Value");
                    String cldr = null != data.get("CLDR") ? "CLDR: " : "";
                    System.out.println("\t\t\t<" + aliasType + "Alias type=\"" + tag + "\"" + (String)(preferred == null || preferred.length() == 0 ? "" : " replacement=\"" + preferred + "\"") + "/> <!-- " + cldr + data.get("Description") + " -->");
                    deprecatedCodes.add(tag);
                    continue;
                }
                allCodes.add(tag);
            }
            Set<String> goodCodes = sc.getAvailableCodes(oldType);
            TreeSet<String> oldAndNotNew = new TreeSet<String>(goodCodes);
            oldAndNotNew.removeAll(allCodes);
            oldAndNotNew.removeAll(deprecatedCodes);
            for (String tag : oldAndNotNew) {
                List<String> sdata = sc.getFullData(oldType, tag);
                String preferred = sdata.get(2);
                System.out.println("\t\t\t<" + aliasType + "Alias type=\"" + tag + "\" replacement=\"" + preferred + "\"/> <!-- CLDR:" + sdata.get(0) + " -->");
            }
            String allCodeString = Joiner.on(" ").join(allCodes);
            System.out.println("\t\t\t<variable id=\"$" + oldType + "\" type=\"list\">" + allCodeString + "</variable>");
        }
    }

    private static void showCodes(StandardCodes sc, String type) {
        Set<String> codes = sc.getSurveyToolDisplayCodes(type);
        System.out.println("Survey Tool Codes " + codes.size() + "\t" + type);
        for (String code : codes) {
            System.out.println("\t" + code + "\t" + sc.getFullData(type, code));
        }
    }

    private static void checkLanguages() {
        Factory mainCldrFactory = Factory.make(CLDRPaths.COMMON_DIRECTORY + "main" + File.separator, ".*");
        Set<String> availableLocales = mainCldrFactory.getAvailable();
        TreeSet<String> available = new TreeSet<String>();
        LocaleIDParser lip = new LocaleIDParser();
        Iterator<String> it = availableLocales.iterator();
        while (it.hasNext()) {
            available.add(lip.set(it.next()).getLanguage());
        }
        TreeSet<String> langHack = new TreeSet<String>();
        for (int i = 0; i < language_territory_hack.length; ++i) {
            String lang = language_territory_hack[i][0];
            langHack.add(lang);
        }
        if (langHack.containsAll(available)) {
            System.out.println("All ok");
        } else {
            available.removeAll(langHack);
            for (String item : available) {
                System.out.println("{\"" + item + "\", \"XXX\"},/t//" + ULocale.getDisplayLanguage(item, ULocale.ENGLISH));
            }
        }
    }

    private static void printCountries() throws IOException {
        Factory mainCldrFactory = Factory.make(CLDRPaths.COMMON_DIRECTORY + "main" + File.separator, ".*");
        CLDRFile english = mainCldrFactory.make("en", true);
        PrintWriter out = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, "country_language_names.txt");
        StandardCodes sc = StandardCodes.make();
        for (String code : sc.getGoodAvailableCodes("language")) {
            out.println(code + "\t" + english.getName(0, code));
        }
        out.println("****");
        for (String code : sc.getGoodAvailableCodes("territory")) {
            out.println(code + "\t" + english.getName(2, code));
        }
        out.println("****");
        for (String code : sc.getGoodAvailableCodes("script")) {
            out.println(code + "\t" + english.getName(1, code));
        }
        out.close();
    }

    private static void printCurrencies() {
        StandardCodes sc = StandardCodes.make();
        Set<String> s2 = sc.getAvailableCodes("currency");
        for (String code : s2) {
            String name = sc.getData("currency", code);
            List<String> data = sc.getFullData("currency", code);
            System.out.println(code + "\t" + name + "\t" + data);
        }
    }

    private static void printZoneSamples() throws Exception {
        String[] locales = new String[]{"en", "en_GB", "de", "zh", "hi", "bg", "ru", "ja", "as"};
        String[] zones = new String[]{"America/Los_Angeles", "America/Argentina/Buenos_Aires", "America/Buenos_Aires", "America/Havana", "Australia/ACT", "Australia/Sydney", "Europe/London", "Europe/Moscow", "Etc/GMT+3"};
        String[][] fields = new String[][]{{"2004-01-15T00:00:00Z", "Z", "ZZZZ", "z", "zzzz"}, {"2004-07-15T00:00:00Z", "Z", "ZZZZ", "z", "zzzz", "v", "vvvv"}};
        Factory mainCldrFactory = Factory.make(CLDRPaths.COMMON_DIRECTORY + "main" + File.separator, ".*");
        PrintWriter out = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, "timezone_samples.txt");
        long[] offsetMillis = new long[1];
        ParsePosition parsePosition = new ParsePosition(0);
        for (int i = 0; i < locales.length; ++i) {
            String locale = locales[i];
            TimezoneFormatter tzf = new TimezoneFormatter(mainCldrFactory, locale, false).setSkipDraft(true);
            for (int j = 0; j < zones.length; ++j) {
                String zone = zones[j];
                for (int k = 0; k < fields.length; ++k) {
                    String type = fields[k][0];
                    Date datetime = ICUServiceBuilder.isoDateParse(type);
                    for (int m3 = 1; m3 < fields[k].length; ++m3) {
                        String field = fields[k][m3];
                        String formatted = tzf.getFormattedZone(zone, field, datetime.getTime(), false);
                        parsePosition.setIndex(0);
                        String parsed = tzf.parse(formatted, parsePosition, offsetMillis);
                        if (parsed == null) {
                            parsed = "FAILED PARSE";
                        } else if (parsed.length() == 0) {
                            parsed = TestUtilities.format(offsetMillis[0]);
                        }
                        out.println("{\"" + locale + "\",\t\"" + zone + "\",\t\"" + type + "\",\t\"" + field + "\",\t\"" + formatted + "\",\t\"" + parsed + "\"},");
                    }
                }
                out.println();
            }
            out.println("==========");
            out.println();
        }
        out.close();
    }

    private static String format(long offsetMillis) {
        String sign = "+";
        if ((offsetMillis /= 60000L) < 0L) {
            offsetMillis = -offsetMillis;
            sign = "-";
        }
        return sign + String.valueOf(offsetMillis / 60L) + ":" + String.valueOf(100L + offsetMillis % 60L).substring(1, 3);
    }

    static class MyHandler
    extends XMLFileReader.SimpleHandler {
        MyHandler() {
        }

        @Override
        public void handleAttributeDecl(String eName, String aName, String type, String mode, String value) {
            System.out.println("eName: " + eName + ",\t aName: " + aName + ",\t type: " + type + ",\t mode: " + mode + ",\t value: " + value);
        }

        @Override
        public void handleElementDecl(String name, String model) {
            System.out.println("name: " + name + ",\t model: " + model);
        }

        @Override
        public void handlePathValue(String path, String value) {
            System.out.println("path: " + path + ",\t value: " + value);
        }

        @Override
        public void handleComment(String path, String comment) {
            System.out.println("path: " + path + ",\t comment: " + comment);
        }
    }

    static enum State {
        a,
        b,
        c;

        public static State cc;

        static {
            cc = c;
        }
    }
}

