/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.locale.XCldrStub;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.test.ExampleGenerator;
import org.unicode.cldr.tool.Chart;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.FileCopier;
import org.unicode.cldr.util.GrammarInfo;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.Rational;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.UnitConverter;
import org.unicode.cldr.util.UnitPathType;
import org.unicode.cldr.util.Validity;
import org.unicode.cldr.util.XPathParts;

public class ChartGrammaticalForms
extends Chart {
    private static final String FORMATTED_SAMPLE = "Formatted Sample";
    private static final String INFO_ON_FEATURES = "Current information is only for nominal forms. Where a Usage is present other than \u201cgeneral\u201d, that means that a subset of the grammatical features are relevant to that Usage. For example, Feature=grammaticalGender and Usage=units might omit an \u2018animate\u2019 gender. For the meanings of the values, see <a target='spec' href='https://unicode.org/reports/tr35/tr35-general.html#Grammatical_Features'>LDML Grammatical Features</a>.";
    private static final String MAIN_HEADER = "<h2>Grammatical Forms</h2>";
    private static final boolean DEBUG = false;
    private static final String DIR = CLDRPaths.CHART_DIRECTORY + "grammar/";
    public static final PluralRules ENGLISH_PLURAL_RULES = SDI.getPlurals("en").getPluralRules();
    static final UnitConverter uc = SDI.getUnitConverter();
    static final Map<String, Map<Rational, String>> BASE_TO_FACTOR_TO_UNIT;
    static final Map<String, Pair<String, Double>> BEST_UNIT_CACHE;
    public static RuleBasedCollator RBC;

    public static void main(String[] args) {
        new ChartGrammaticalForms().writeChart(null);
    }

    @Override
    public String getDirectory() {
        return DIR;
    }

    @Override
    public String getTitle() {
        return "Grammatical Forms Charts";
    }

    @Override
    public String getFileName() {
        return "index";
    }

    @Override
    public String getExplanation() {
        return "<h2>Grammatical Forms</h2><p>In this version a preliminary set of languages have additional grammatical information, as listed below.<p>";
    }

    @Override
    public void writeContents(FormattedFileWriter pw) throws IOException {
        FileCopier.ensureDirectoryExists(DIR);
        FileCopier.copy(Chart.class, "index.css", DIR);
        FormattedFileWriter.copyIncludeHtmls(DIR);
        FormattedFileWriter.Anchors anchors = new FormattedFileWriter.Anchors();
        this.writeSubcharts(anchors);
        pw.setIndex("Main Chart Index", "../index.html");
        pw.write(anchors.toString());
        this.showInfo(pw);
    }

    private void showInfo(FormattedFileWriter pw) throws IOException {
        pw.append("<h2>Grammatical Features Info</h2>");
        pw.append("<p>The following lists the available information about grammatical features for locales. Note that only the above locales have localized data, at this time. Current information is only for nominal forms. Where a Usage is present other than \u201cgeneral\u201d, that means that a subset of the grammatical features are relevant to that Usage. For example, Feature=grammaticalGender and Usage=units might omit an \u2018animate\u2019 gender. For the meanings of the values, see <a target='spec' href='https://unicode.org/reports/tr35/tr35-general.html#Grammatical_Features'>LDML Grammatical Features</a>.</p>");
        if (GrammarInfo.GrammaticalTarget.values().length > 1) {
            throw new IllegalArgumentException("Needs adjustment for additional GrammaticalTarget.values()");
        }
        System.out.println(SDI.hasGrammarInfo());
        TablePrinter tablePrinter = this.getFormattedGrammarInfo(SDI.hasGrammarInfo());
        pw.append(tablePrinter.toString());
    }

    private TablePrinter getFormattedGrammarInfo(Set<String> localeIds) {
        TablePrinter tablePrinter = new TablePrinter().addColumn("Locale", "class='source' width='1%'", null, "class='source'", true).setSortPriority(0).setBreakSpans(true).addColumn("ID", "class='source' width='1%'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).setBreakSpans(true).addColumn("Feature", "class='source' width='1%'", null, "class='source'", true).setSortPriority(1).setBreakSpans(true).addColumn("Usage", "class='source'", null, "class='source'", true).addColumn("Values", "class='source'", null, "class='source'", true);
        for (String localeId : localeIds) {
            if (localeId.equals("fi")) {
                boolean bl = false;
            }
            LinkedHashSet<String> failures = new LinkedHashSet<String>();
            GrammarInfo grammarInfo = SDI.getGrammarInfo(localeId, false);
            String localeName = CONFIG.getEnglish().getName(localeId);
            for (GrammarInfo.GrammaticalFeature feature : GrammarInfo.GrammaticalFeature.values()) {
                Map<GrammarInfo.GrammaticalScope, Set<String>> scopeToValues = grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, feature);
                if (scopeToValues.isEmpty()) continue;
                Set<String> values = null;
                boolean multiline = false;
                for (Map.Entry<GrammarInfo.GrammaticalScope, Set<String>> entry : scopeToValues.entrySet()) {
                    if (values == null) {
                        values = entry.getValue();
                        continue;
                    }
                    if (values.equals(entry.getValue())) continue;
                    multiline = true;
                    break;
                }
                TreeSet<String> sortedValues = new TreeSet<String>(feature.getValueComparator());
                if (multiline) {
                    for (GrammarInfo.GrammaticalScope usage : GrammarInfo.GrammaticalScope.values()) {
                        values = scopeToValues.get((Object)usage);
                        if (values.isEmpty()) continue;
                        sortedValues.clear();
                        sortedValues.addAll(values);
                        this.addRow(tablePrinter, localeName, localeId, feature, usage.toString(), Joiner.on(", ").join(sortedValues));
                    }
                    continue;
                }
                try {
                    sortedValues.addAll(values);
                    this.addRow(tablePrinter, localeName, localeId, feature, Joiner.on(", ").join(scopeToValues.keySet()), Joiner.on(", ").join(sortedValues));
                }
                catch (Exception exception) {
                    failures.add(exception.getMessage());
                }
            }
            if (failures.isEmpty()) continue;
            System.out.println("# Failures, " + localeId + "\t" + failures);
        }
        return tablePrinter;
    }

    public void addRow(TablePrinter tablePrinter, String locale, String id, GrammarInfo.GrammaticalFeature feature, String usage, String valueString) {
        tablePrinter.addRow().addCell((Comparable)((Object)locale)).addCell((Comparable)((Object)id)).addCell((Comparable)((Object)feature)).addCell((Comparable)((Object)usage)).addCell((Comparable)((Object)valueString)).finishRow();
    }

    public void writeSubcharts(FormattedFileWriter.Anchors anchors) throws IOException {
        Set<String> locales = GrammarInfo.getGrammarLocales();
        LanguageTagParser ltp = new LanguageTagParser();
        Factory factory = CLDRConfig.getInstance().getCldrFactory();
        Comparator<String> caseOrder = GrammarInfo.CaseValues.COMPARATOR;
        TreeSet<String> sortedCases = new TreeSet<String>(caseOrder);
        Comparator<String> genderOrder = GrammarInfo.GenderValues.COMPARATOR;
        TreeSet<String> sortedGenders = new TreeSet<String>(genderOrder);
        Output<Double> sizeInBaseUnits = new Output<Double>();
        Map<String, BestUnitForGender> unitToBestUnit = new TreeMap();
        Set<String> rawUnitsToAddGrammar = GrammarInfo.getUnitsToAddGrammar();
        for (String longUnit : rawUnitsToAddGrammar) {
            String shortUnit = uc.getShortId(longUnit);
            if (shortUnit.equals("generic")) continue;
            String unitCell = ChartGrammaticalForms.getBestBaseUnit(uc, shortUnit, sizeInBaseUnits);
            String quantity = shortUnit.contentEquals("generic") ? "temperature" : uc.getQuantityFromUnit(shortUnit, false);
            Set<String> systems = uc.getSystems(shortUnit);
            unitToBestUnit.put(shortUnit, new BestUnitForGender(shortUnit, quantity, systems, (Double)sizeInBaseUnits.value));
        }
        unitToBestUnit = XCldrStub.ImmutableMap.copyOf(unitToBestUnit);
        TreeSet sorted2 = new TreeSet(unitToBestUnit.values());
        System.out.println(sorted2);
        UnitConverter.PlaceholderLocation placeholderPosition = UnitConverter.PlaceholderLocation.missing;
        Matcher placeholderMatcher = UnitConverter.PLACEHOLDER.matcher("");
        Output<String> unitPatternOut = new Output<String>();
        for (String locale : locales) {
            Object bestUnit;
            GrammarInfo grammarInfo;
            if (locale.equals("root")) continue;
            ltp.set(locale);
            String region = ltp.getRegion();
            if (!region.isEmpty() || (grammarInfo = SDI.getGrammarInfo(locale, true)) == null || !grammarInfo.hasInfo(GrammarInfo.GrammaticalTarget.nominal)) continue;
            CLDRFile cldrFile = factory.make(locale, true);
            Collection<String> genders = grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, GrammarInfo.GrammaticalFeature.grammaticalGender, GrammarInfo.GrammaticalScope.units);
            sortedGenders.clear();
            sortedGenders.addAll(genders);
            Collection<String> rawCases = grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, GrammarInfo.GrammaticalFeature.grammaticalCase, GrammarInfo.GrammaticalScope.units);
            if (rawCases.isEmpty()) {
                rawCases = ImmutableSet.of(GrammarInfo.GrammaticalFeature.grammaticalCase.getDefault(null));
            }
            sortedCases.clear();
            sortedCases.addAll(rawCases);
            if (sortedCases.size() <= 1 && sortedGenders.size() <= 1) continue;
            SupplementalDataInfo.PluralInfo plurals = SDI.getPlurals(SupplementalDataInfo.PluralType.cardinal, locale);
            if (plurals == null) {
                System.err.println("No " + SupplementalDataInfo.PluralType.cardinal + "  plurals for " + locale);
            }
            Set<SupplementalDataInfo.PluralInfo.Count> adjustedPlurals = plurals.getAdjustedCounts();
            ICUServiceBuilder isb = ICUServiceBuilder.forLocale(CLDRLocale.getInstance(locale));
            DecimalFormat decFormat = isb.getNumberFormat(1);
            LinkedHashMap<String, TablePrinterWithHeader> info = new LinkedHashMap<String, TablePrinterWithHeader>();
            TablePrinter tablePrinter = this.getFormattedGrammarInfo(Collections.singleton(locale));
            info.put("Grammatical Features", new TablePrinterWithHeader("<p>The following lists the available information about grammatical features for this locale. Current information is only for nominal forms. Where a Usage is present other than \u201cgeneral\u201d, that means that a subset of the grammatical features are relevant to that Usage. For example, Feature=grammaticalGender and Usage=units might omit an \u2018animate\u2019 gender. For the meanings of the values, see <a target='spec' href='https://unicode.org/reports/tr35/tr35-general.html#Grammatical_Features'>LDML Grammatical Features</a>.</p>", tablePrinter));
            TreeSet<String> unitsToAddGrammar = new TreeSet<String>(rawUnitsToAddGrammar);
            TreeMap<PathHeader, String> minimalInfo = new TreeMap<PathHeader, String>();
            PathHeader.Factory phf = PathHeader.getFactory();
            for (String path : cldrFile) {
                if (!path.startsWith("//ldml/units/unitLength[@type=\"long\"]/unit")) {
                    if (!path.startsWith("//ldml/numbers/minimalPairs/") || path.contains("ordinal")) continue;
                    minimalInfo.put(phf.fromPath(path), cldrFile.getStringValueWithBailey(path));
                    continue;
                }
                XPathParts parts = XPathParts.getFrozenInstance(path);
                String foundUnit = parts.getAttributeValue(3, "type");
                if (unitsToAddGrammar.contains(foundUnit)) continue;
                switch (parts.getElement(-1)) {
                    case "gender": {
                        unitsToAddGrammar.add(foundUnit);
                        break;
                    }
                    case "unitPattern": {
                        if (parts.getAttributeValue(4, "case") == null) break;
                        unitsToAddGrammar.add(foundUnit);
                    }
                }
            }
            TablePrinter minimalPrinter = new TablePrinter().addColumn("Type", "class='source' width='1%'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).setRepeatHeader(true).addColumn("Size", "class='source' width='1%'", null, "class='source'", true).setSortPriority(0).setHidden(true).setBreakSpans(true).addColumn("Code", "class='source' width='1%'", null, "class='source'", true).addColumn("Pattern", "class='source'", null, "class='target'", true).addColumn(FORMATTED_SAMPLE, "class='source'", null, "class='target'", true);
            int counter = 0;
            ExampleGenerator exampleGenerator = new ExampleGenerator(cldrFile, CONFIG.getEnglish());
            for (Map.Entry entry : minimalInfo.entrySet()) {
                PathHeader pathHeader = (PathHeader)entry.getKey();
                String string = (String)entry.getValue();
                minimalPrinter.addRow().addCell((Comparable)((Object)pathHeader.getHeader())).addCell(Integer.valueOf(counter++)).addCell((Comparable)((Object)pathHeader.getCode())).addCell((Comparable)((Object)string)).addCell((Comparable)((Object)exampleGenerator.getExampleHtml(pathHeader.getOriginalPath(), string)));
                minimalPrinter.finishRow();
            }
            info.put("Minimal Pairs", new TablePrinterWithHeader("<p>This table has the minimal pairs used to test the appropriateness of different values.</p>\n", minimalPrinter));
            PluralRules pluralRules = plurals.getPluralRules();
            TablePrinter tablePrinter2 = new TablePrinter().addColumn("Quantity", "class='source' width='1%'", null, "class='source'", true).setSortPriority(0).setRepeatHeader(true).addColumn("Size", "class='source' width='1%'", null, "class='source'", true).setSortPriority(1).setHidden(true).addColumn("Unit", "class='source' width='1%'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).setSortPriority(2).setBreakSpans(true);
            if (sortedGenders.size() > 1) {
                tablePrinter2.addColumn("Gender", "class='source' width='1%'", null, "class='source'", true).addColumn("Gender MP + unit", "class='target'", null, "class='source'", true);
            }
            if (sortedCases.size() > 1) {
                tablePrinter2.addColumn("Case", "class='source' width='1%'", null, "class='source'", true);
                String widthStringTarget = "class='target'";
                this.addTwoColumns(tablePrinter2, widthStringTarget, adjustedPlurals, pluralRules, true);
            }
            for (String string : unitsToAddGrammar) {
                String shortUnit = uc.getShortId(string);
                String unitCell = ChartGrammaticalForms.getBestBaseUnit(uc, shortUnit, sizeInBaseUnits);
                String quantity = shortUnit.contentEquals("generic") ? "temperature" : uc.getQuantityFromUnit(shortUnit, false);
                String genderFormatted = "n/a";
                String gender = "n/a";
                if (sortedGenders.size() > 1) {
                    gender = UnitPathType.gender.getTrans(cldrFile, "long", shortUnit, null, null, null, null);
                    if (gender == null) {
                        gender = "n/a";
                    } else {
                        String genderMinimalPair = cldrFile.getStringValue("//ldml/numbers/minimalPairs/genderMinimalPairs[@gender=\"" + gender + "\"]");
                        if (genderMinimalPair != null) {
                            SupplementalDataInfo.PluralInfo.Count bestCount = adjustedPlurals.contains((Object)SupplementalDataInfo.PluralInfo.Count.one) ? SupplementalDataInfo.PluralInfo.Count.one : SupplementalDataInfo.PluralInfo.Count.other;
                            String unitPattern = cldrFile.getStringValueWithBailey("//ldml/units/unitLength[@type=\"long\"]/unit[@type=\"" + string + "\"]/unitPattern" + GrammarInfo.getGrammaticalInfoAttributes(grammarInfo, UnitPathType.unit, bestCount.toString(), null, "nominative"));
                            String unit = unitPattern.replace("\u00a0", "").replace("{0}", "").trim();
                            genderFormatted = MessageFormat.format(genderMinimalPair, unit);
                        }
                    }
                }
                if (sortedCases.size() <= 1) {
                    tablePrinter2.addRow().addCell((Comparable)((Object)quantity)).addCell((Comparable)sizeInBaseUnits.value).addCell((Comparable)((Object)unitCell)).addCell((Comparable)((Object)gender)).addCell((Comparable)((Object)genderFormatted));
                    tablePrinter2.finishRow();
                    continue;
                }
                if (unitCell == null || quantity == null || gender == null || sizeInBaseUnits.value == null) {
                    throw new IllegalArgumentException("No best base unit for: " + shortUnit);
                }
                for (String case1 : sortedCases) {
                    tablePrinter2.addRow().addCell((Comparable)((Object)quantity)).addCell((Comparable)sizeInBaseUnits.value).addCell((Comparable)((Object)unitCell));
                    if (sortedGenders.size() > 1) {
                        tablePrinter2.addCell((Comparable)((Object)gender)).addCell((Comparable)((Object)genderFormatted));
                    }
                    tablePrinter2.addCell((Comparable)((Object)case1));
                    for (SupplementalDataInfo.PluralInfo.Count plural : adjustedPlurals) {
                        Double sample = this.getBestSample(pluralRules, plural);
                        String unitPattern = cldrFile.getStringValueWithBailey("//ldml/units/unitLength[@type=\"long\"]/unit[@type=\"" + string + "\"]/unitPattern" + GrammarInfo.getGrammaticalInfoAttributes(grammarInfo, UnitPathType.unit, plural.toString(), null, case1));
                        unitPattern = unitPattern.replace("\u00a0", " ");
                        tablePrinter2.addCell((Comparable)((Object)unitPattern));
                        String numberPlusUnit = MessageFormat.format(unitPattern, decFormat.format(sample));
                        String caseMinimalPair = cldrFile.getStringValue("//ldml/numbers/minimalPairs/caseMinimalPairs[@case=\"" + case1 + "\"]");
                        String withContext = caseMinimalPair == null ? numberPlusUnit : MessageFormat.format(caseMinimalPair, numberPlusUnit);
                        tablePrinter2.addCell((Comparable)((Object)withContext));
                    }
                    tablePrinter2.finishRow();
                }
            }
            info.put("Unit Case and Gender Info", new TablePrinterWithHeader("<p>This table has rows contains unit forms appropriate for different grammatical cases and plural forms. Each plural form has a sample value such as <i>(1.2)</i> or <i>(2)</i>. That value is used with the localized unit pattern to form a formatted measure, such as \u201c2,0 Stunden\u201d. That formatted measure is in turn substituted into a <b><a target='doc-minimal-pairs' href='http://cldr.unicode.org/translation/grammatical-inflection#TOC-Miscellaneous-Minimal-Pairs'>case minimal pair pattern</a> to get the Formatted Sample</b>. The <b>Gender</b> column is informative; it just supplies the supplied gender for the unit.</p>\n<ul><li>For clarity, conversion values are supplied for non-metric units. For more information, see <a target='unit_conversions' href='../supplemental/unit_conversions.html'>Unit Conversions</a>.</li></ul>\n", tablePrinter2));
            TreeMultimap<String, BestUnitForGender> bestUnitForGender = TreeMultimap.create();
            for (String longUnit3 : unitsToAddGrammar) {
                String shortUnit = uc.getShortId(longUnit3);
                String gender = UnitPathType.gender.getTrans(cldrFile, "long", shortUnit, null, null, null, null);
                bestUnit = (BestUnitForGender)unitToBestUnit.get(shortUnit);
                if (gender == null || bestUnit == null) continue;
                bestUnitForGender.put(gender, (BestUnitForGender)bestUnit);
            }
            for (Map.Entry entry : bestUnitForGender.asMap().entrySet()) {
                List items = entry.getValue().stream().map(x -> x.shortUnit).collect(Collectors.toList());
                System.out.println(locale + "\t" + (String)entry.getKey() + "\t" + items);
            }
            TablePrinter tablePrinter3 = new TablePrinter().addColumn("Unit", "class='source' width='1%'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).setSortPriority(2).setRepeatHeader(true).addColumn("Case", "class='source' width='1%'", null, "class='source'", true).addColumn("Gender", "class='source' width='1%'", null, "class='source'", true);
            double width = (double)((int)(99.0 / (double)(adjustedPlurals.size() * 2 + 1) * 1000.0)) / 1000.0;
            String widthStringTarget = "class='target' width='" + width + "%'";
            this.addTwoColumns(tablePrinter3, widthStringTarget, adjustedPlurals, pluralRules, false);
            bestUnit = Arrays.asList("power2", "power3").iterator();
            while (bestUnit.hasNext()) {
                String power;
                String unitCell = power = (String)bestUnit.next();
                for (String gender : sortedGenders) {
                    Collection bestUnits = bestUnitForGender.get(gender);
                    String bestUnit2 = null;
                    if (!bestUnits.isEmpty()) {
                        bestUnit2 = ((BestUnitForGender)bestUnits.iterator().next()).shortUnit;
                    }
                    for (String case1 : sortedCases) {
                        tablePrinter3.addRow().addCell((Comparable)((Object)unitCell)).addCell((Comparable)((Object)case1)).addCell((Comparable)((Object)(gender + (String)(bestUnit2 == null ? "" : "\n(" + bestUnit2 + ")"))));
                        for (SupplementalDataInfo.PluralInfo.Count plural : adjustedPlurals) {
                            String localizedPowerPattern = UnitPathType.power.getTrans(cldrFile, "long", power, plural.toString(), case1, gender, null);
                            localizedPowerPattern = localizedPowerPattern.replace("\u00a0", " ");
                            tablePrinter3.addCell((Comparable)((Object)localizedPowerPattern));
                            if (bestUnit2 == null) {
                                tablePrinter3.addCell((Comparable)((Object)"n/a"));
                                continue;
                            }
                            Double samplePlural = this.getBestSample(pluralRules, plural);
                            String localizedUnitPattern = UnitPathType.unit.getTrans(cldrFile, "long", bestUnit2, plural.toString(), case1, gender, null);
                            placeholderPosition = UnitConverter.extractUnit(placeholderMatcher, localizedUnitPattern, unitPatternOut);
                            if (placeholderPosition != UnitConverter.PlaceholderLocation.middle) {
                                String combined;
                                localizedUnitPattern = (String)unitPatternOut.value;
                                localizedUnitPattern = localizedUnitPattern.replace("\u00a0", " ");
                                String placeholderPattern = placeholderPosition == UnitConverter.PlaceholderLocation.missing ? localizedUnitPattern : placeholderMatcher.group();
                                try {
                                    combined = UnitConverter.combineLowercasing(new ULocale(locale), "long", localizedPowerPattern, localizedUnitPattern);
                                }
                                catch (Exception e) {
                                    throw new IllegalArgumentException(locale + ") Can't combine localizedPowerPattern=\u00ab" + localizedPowerPattern + "\u00bb with localizedUnitPattern=\u00ab" + localizedUnitPattern + "\u00bb");
                                }
                                String combinedWithPlaceholder = UnitConverter.addPlaceholder(combined, placeholderPattern, placeholderPosition);
                                String sample = MessageFormat.format(combinedWithPlaceholder, decFormat.format(samplePlural));
                                String caseMinimalPair = cldrFile.getStringValue("//ldml/numbers/minimalPairs/caseMinimalPairs[@case=\"" + case1 + "\"]");
                                String withContext = caseMinimalPair == null ? sample : MessageFormat.format(caseMinimalPair, sample);
                                tablePrinter3.addCell((Comparable)((Object)withContext));
                                continue;
                            }
                            tablePrinter3.addCell((Comparable)((Object)"n/a"));
                        }
                        tablePrinter3.finishRow();
                    }
                }
            }
            info.put("Unit Power Components", new TablePrinterWithHeader("<p>This table shows the square (power2) and cubic (power3) patterns, which may vary by case, gender, and plural forms. Each gender is illustrated with a unit where possible, such as <i>(second)</i> or <i>(meter)</i>. Each plural category is illustrated with a unit where possible, such as <i>(1)</i> or <i>(1.2)</i>. The patterns are first supplied, and then combined with the samples and <b><a target='doc-minimal-pairs' href='http://cldr.unicode.org/translation/grammatical-inflection#TOC-Miscellaneous-Minimal-Pairs'>case minimal pair patterns</a></b> in the next <b>Formatted Sample</b> column.</p>", tablePrinter3));
            if (info.isEmpty()) continue;
            String name = ENGLISH.getName(locale);
            new Subchart(name + ": Unit Grammar Info", locale, info).writeChart(anchors);
        }
    }

    public void addTwoColumns(TablePrinter caseTablePrinter, String widthStringTarget, Collection<SupplementalDataInfo.PluralInfo.Count> adjustedPlurals, PluralRules pluralRules, boolean spanRows) {
        for (SupplementalDataInfo.PluralInfo.Count plural : adjustedPlurals) {
            Double sample = this.getBestSample(pluralRules, plural);
            caseTablePrinter.addColumn("Pattern for " + plural.toString(), widthStringTarget, null, "class='target'", true).setSpanRows(spanRows);
            caseTablePrinter.addColumn("Case MP + pattern with " + sample, widthStringTarget, null, "class='target'", true);
        }
    }

    public static String getBestBaseUnit(UnitConverter uc, String shortUnit, Output<Double> sizeInBaseUnits) {
        Pair<String, Double> cached = BEST_UNIT_CACHE.get(shortUnit);
        if (cached != null) {
            sizeInBaseUnits.value = cached.getSecond();
            return cached.getFirst();
        }
        if (shortUnit.equals("square-mile")) {
            boolean bl = false;
        }
        Object unitCell = ENGLISH.getStringValue("//ldml/units/unitLength[@type=\"long\"]/unit[@type=\"" + uc.getLongId(shortUnit) + "\"]/displayName");
        Output<String> baseUnit = new Output<String>();
        UnitConverter.ConversionInfo info = uc.parseUnitId(shortUnit, baseUnit, false);
        if (info != null) {
            sizeInBaseUnits.value = info.factor.doubleValue();
            Map<Rational, String> factorToUnit = BASE_TO_FACTOR_TO_UNIT.get(baseUnit.value);
            if (factorToUnit == null) {
                boolean bl = false;
            }
            String bestUnit = null;
            Rational bestFactor = null;
            Rational inputBoundary = Rational.of(2L).multiply(info.factor);
            for (Map.Entry<Rational, String> entry : factorToUnit.entrySet()) {
                Rational currentFactor = entry.getKey();
                if (bestUnit != null && currentFactor.compareTo(inputBoundary) >= 0) break;
                bestFactor = currentFactor;
                bestUnit = entry.getValue();
            }
            if (!(bestFactor = info.factor.divide(bestFactor)).equals(Rational.ONE) || !shortUnit.equals(bestUnit)) {
                UnitConverter.UnitId unitId;
                String string = bestFactor.toString(Rational.FormatStyle.repeating);
                double bestDoubleFactor = bestFactor.doubleValue();
                String pluralCategory = ENGLISH_PLURAL_RULES.select(bestDoubleFactor);
                String unitPath = "//ldml/units/unitLength[@type=\"short\"]/unit[@type=\"" + uc.getLongId(bestUnit) + "\"]/unitPattern[@count=\"" + pluralCategory + "\"]";
                String unitPattern = ENGLISH.getStringValue(unitPath);
                if (unitPattern == null && (unitPattern = (unitId = uc.createUnitId(bestUnit)).toString(ENGLISH, "long", pluralCategory, null, null, false)) == null) {
                    return null;
                }
                String unitMeasure = MessageFormat.format(unitPattern, string.contains("/") ? "~" + bestDoubleFactor : string);
                unitCell = shortUnit + "\n( = " + unitMeasure + ")";
            }
        } else {
            sizeInBaseUnits.value = -1.0;
        }
        BEST_UNIT_CACHE.put(shortUnit, Pair.of(unitCell, (Double)sizeInBaseUnits.value));
        return unitCell;
    }

    private Double getBestSample(PluralRules pluralRules, SupplementalDataInfo.PluralInfo.Count plural) {
        Collection<Double> samples = pluralRules.getSamples(plural.toString());
        if (samples.isEmpty()) {
            samples = pluralRules.getSamples(plural.toString(), PluralRules.SampleType.DECIMAL);
        }
        int size = samples.size();
        switch (size) {
            case 0: {
                throw new IllegalArgumentException("shouldn't happen");
            }
            case 1: {
                return samples.iterator().next();
            }
        }
        return Iterables.skip(samples, 1).iterator().next();
    }

    static {
        TreeMap _BASE_TO_BEST = new TreeMap();
        ImmutableSet<String> skip = ImmutableSet.of("mile-scandinavian", "100-kilometer", "dunam");
        Output<String> baseOut = new Output<String>();
        for (String string : Validity.getInstance().getStatusToCodes(StandardCodes.LstrType.unit).get((Object)Validity.Status.regular)) {
            String old;
            UnitConverter.ConversionInfo info;
            String shortUnit = uc.getShortId(string);
            System.out.println(shortUnit);
            if (skip.contains(shortUnit)) continue;
            if ("mile-per-gallon".equals(shortUnit)) {
                boolean bl = false;
            }
            if ((info = uc.parseUnitId(shortUnit, baseOut, false)) == null) continue;
            TreeMap<Rational, String> factorToUnit = (TreeMap<Rational, String>)_BASE_TO_BEST.get(baseOut.value);
            if (factorToUnit == null) {
                factorToUnit = new TreeMap<Rational, String>();
                _BASE_TO_BEST.put((String)baseOut.value, factorToUnit);
                factorToUnit.put(Rational.ONE, (String)baseOut.value);
            }
            if (!info.factor.isPowerOfTen() || (old = (String)factorToUnit.get(info.factor)) != null && old.length() <= shortUnit.length()) continue;
            factorToUnit.put(info.factor, shortUnit);
        }
        BASE_TO_FACTOR_TO_UNIT = CldrUtility.protectCollection(_BASE_TO_BEST);
        for (Map.Entry entry : BASE_TO_FACTOR_TO_UNIT.entrySet()) {
            System.out.println(entry);
        }
        BEST_UNIT_CACHE = new HashMap<String, Pair<String, Double>>();
        Factory cldrFactory = Factory.make(CLDRPaths.COMMON_DIRECTORY + "collation/", ".*");
        CLDRFile root = cldrFactory.make("root", false);
        String rules = root.getStringValue("//ldml/collations/collation[@type=\"emoji\"][@visibility=\"external\"]/cr");
        try {
            RBC = new RuleBasedCollator(rules);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failure in rules for " + CLDRPaths.COMMON_DIRECTORY + "collation/root", e);
        }
    }

    private class Subchart
    extends Chart {
        private final String title;
        private final String file;
        private final Map<String, TablePrinterWithHeader> tablePrinter;

        @Override
        public boolean getShowDate() {
            return false;
        }

        public Subchart(String title, String file, Map<String, TablePrinterWithHeader> info) {
            this.title = title;
            this.file = file;
            this.tablePrinter = info;
        }

        @Override
        public String getDirectory() {
            return DIR;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public String getFileName() {
            return this.file;
        }

        @Override
        public String getExplanation() {
            return "<h2>Grammatical Forms</h2><p><i>Unit Inflections, Phase 1:</i> The end goal is to add full case and gender support for formatted units. During Phase 1, a limited number of locales and units of measurement are being handled in CLDR v38, so that we can work kinks out of the process before expanding to all units for all locales.</p>\n<p>This chart shows grammatical information available for certain unit and/or power patterns. These patterns are also illustrated with a <b>Formatted Sample</b> that combine the patterns with sample numbers and <b><a target='doc-minimal-pairs' href='http://cldr.unicode.org/translation/grammatical-inflection#TOC-Miscellaneous-Minimal-Pairs'>case minimal pair patterns</a></b>. For example, \u201c\u2026 f\u00fcr {0} \u2026\u201d is a <i>case minimal pair pattern</i> that requires the placeholder {0} to be in the accusative case in German. By inserting into a minimal pair pattern, it is easier to ensure that the original unit and/or power patterns are correctly inflected. </p>\n<p><b>Notes</b><ul><li>We don't have the cross-product of minimal pairs for both case and plural forms, so the <i>case minimal pair pattern</i> might not be correct for the row\u2019s plural category, especially in the nominative.</li><li>Translators often have difficulties with the the minimal pair patterns, since they are <i>transcreations</i> not translations. The Hindi minimal pair patterns for case and gender have been discarded because they were incorrectly translated.</li><li>We don't expect translators to supply minimal pair patterns that are natural for any kind of placeholder: for example, it is probably not typical to use the vocative with 3.2 meters! So look at the <b>Formatted Sample</b> as an aid for helping to see the context for grammatical inflections, but one that has limitations.</li></ul>";
        }

        @Override
        public void writeContents(FormattedFileWriter pw) throws IOException {
            try (PrintWriter tsv = FileUtilities.openUTF8Writer(this.getDirectory() + "tsv/", this.file + ".tsv");){
                if (this.tablePrinter.size() > 1) {
                    pw.write("<h2>Table of Contents</h2>\n");
                    pw.append("<ol>\n");
                    for (String header : this.tablePrinter.keySet()) {
                        pw.write(this.writeTOC(header));
                    }
                    pw.append("</ol>\n");
                }
                String sep = "";
                for (Map.Entry<String, TablePrinterWithHeader> entry : this.tablePrinter.entrySet()) {
                    String header = entry.getKey();
                    this.writeHeader(pw, header);
                    TablePrinterWithHeader explanation = entry.getValue();
                    pw.write(explanation.header);
                    pw.write(explanation.tablePrinter.toTable());
                    tsv.write(sep + "# " + entry.getKey() + "\n");
                    explanation.tablePrinter.toTsv(tsv);
                    sep = "\n";
                }
            }
        }

        private void writeHeader(FormattedFileWriter pw, String header) throws IOException {
            pw.write("<h2><a name='" + FileUtilities.anchorize(header) + "'>" + header + "</a></h2>\n");
        }

        private String writeTOC(String header) {
            return "<li><b><a href='#" + FileUtilities.anchorize(header) + "'>" + header + "</a></b></li>\n";
        }
    }

    public class TablePrinterWithHeader {
        final String header;
        final TablePrinter tablePrinter;

        public TablePrinterWithHeader(String header, TablePrinter tablePrinter) {
            this.header = header;
            this.tablePrinter = tablePrinter;
        }
    }

    class BestUnitForGender
    implements Comparable<BestUnitForGender> {
        final boolean durationOrLength;
        final boolean metric;
        final double distanceFromOne;
        final String quantity;
        final String shortUnit;

        public BestUnitForGender(String shortUnit, String quantity, Collection<String> systems, double baseSize) {
            this.shortUnit = shortUnit;
            this.quantity = quantity;
            this.durationOrLength = quantity.equals("duration") || quantity.equals("length");
            this.metric = systems.contains("metric");
            this.distanceFromOne = Math.abs(Math.log(baseSize));
        }

        @Override
        public int compareTo(BestUnitForGender o) {
            return ComparisonChain.start().compare(o.durationOrLength, this.durationOrLength).compare(o.metric, this.metric).compare((Comparable<?>)((Object)this.quantity), (Comparable<?>)((Object)o.quantity)).compare(this.distanceFromOne, o.distanceFromOne).compare((Comparable<?>)((Object)this.shortUnit), (Comparable<?>)((Object)o.shortUnit)).result();
        }

        public int hashCode() {
            return this.shortUnit.hashCode();
        }

        public boolean equals(Object obj) {
            return this.compareTo((BestUnitForGender)obj) == 0;
        }

        public String toString() {
            return this.shortUnit + "(" + (this.durationOrLength ? "D" : "") + (this.metric ? "M" : "") + ":" + this.quantity + ":" + Math.round(this.distanceFromOne * 10.0) + ")";
        }
    }
}

