/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.dev.tool.UOption;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.ULocale;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.PrettyPath;

public class CompareData {
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int SOURCEDIR = 2;
    private static final int DESTDIR = 3;
    private static final int MATCH = 4;
    private static final UOption[] options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.SOURCEDIR().setDefault(CLDRPaths.BASE_DIRECTORY), UOption.DESTDIR().setDefault(CLDRPaths.BASE_DIRECTORY + "../cldr-last/"), UOption.create("match", 'm', 1).setDefault(".*")};
    String[] directoryList = new String[]{"main", "collation", "segmentations"};
    static RuleBasedCollator uca = (RuleBasedCollator)Collator.getInstance(ULocale.ROOT);
    static PrettyPath prettyPathMaker = new PrettyPath();
    static CLDRFile english;
    static Set<String> locales;
    static Factory cldrFactory;

    public CompareData() {
        uca.setNumericCollation(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        double deltaTime = System.currentTimeMillis();
        try {
            UOption.parseArgs(args, options);
            String sourceDir = CompareData.options[2].value + "common/main/";
            System.out.println(PathUtilities.getNormalizedPathString(sourceDir, new String[0]));
            String compareDir = CompareData.options[3].value + "common/main/";
            System.out.println(PathUtilities.getNormalizedPathString(compareDir, new String[0]));
            cldrFactory = Factory.make(sourceDir, CompareData.options[4].value);
            Factory oldFactory = Factory.make(compareDir, CompareData.options[4].value);
            locales = new TreeSet<String>(cldrFactory.getAvailable());
            new CldrUtility.MatcherFilter(CompareData.options[4].value).retainAll(locales);
            HashSet<String> pathsSeen = new HashSet<String>();
            int newItemsTotal = 0;
            int replacementItemsTotal = 0;
            int deletedItemsTotal = 0;
            int sameItemsTotal = 0;
            Iterator<String> it = locales.iterator();
            while (it.hasNext()) {
                int newItems = 0;
                int replacementItems = 0;
                int deletedItems = 0;
                int sameItems = 0;
                String locale = it.next();
                if (locale.startsWith("supplem") || locale.startsWith("character")) continue;
                CLDRFile file = cldrFactory.make(locale, false);
                try {
                    CLDRFile oldFile = oldFactory.make(locale, false);
                    pathsSeen.clear();
                    for (String path : file) {
                        String value = file.getStringValue(path);
                        String oldValue = oldFile.getStringValue(path);
                        if (oldValue == null) {
                            ++newItems;
                        } else if (!value.equals(oldValue)) {
                            ++replacementItems;
                        } else {
                            ++sameItems;
                        }
                        pathsSeen.add(path);
                    }
                    for (String path : oldFile) {
                        if (pathsSeen.contains(path)) continue;
                        ++deletedItems;
                    }
                }
                catch (Exception e) {
                    newItems = CompareData.size(file.iterator());
                }
                String langScript = new LocaleIDParser().set(file.getLocaleID()).getLanguageScript();
                System.out.println(langScript + "\t" + file.getLocaleID() + "\t" + sameItems + "\t" + newItems + "\t" + replacementItems + "\t" + deletedItems);
                newItemsTotal += newItems;
                replacementItemsTotal += replacementItems;
                deletedItemsTotal += deletedItems;
                sameItemsTotal += sameItems;
            }
            System.out.println("TOTAL\t\t" + sameItemsTotal + "\t" + newItemsTotal + "\t" + replacementItemsTotal + "\t" + deletedItemsTotal);
        }
        finally {
            deltaTime = (double)System.currentTimeMillis() - deltaTime;
            System.out.println("Elapsed: " + deltaTime / 1000.0 + " seconds");
            System.out.println("Done");
        }
    }

    private static int size(Iterator iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }
}

