/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Map;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.GenerateMaximalLocales;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.SupplementalDataInfo;

public class GenerateLikelySubtagTests {
    private static final String SEPARATOR = "\n";
    private static final GenerateMaximalLocales.OutputStyle OUTPUT_STYLE = GenerateMaximalLocales.OutputStyle.XML;
    private static PrintWriter out;
    private static final String VERSION = "43.1";

    public static void main(String[] args) throws IOException {
        out = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, "test/supplemental/likelySubtagTests" + (OUTPUT_STYLE == GenerateMaximalLocales.OutputStyle.XML ? ".xml" : ".txt"));
        if (OUTPUT_STYLE == GenerateMaximalLocales.OutputStyle.C) {
            out.println("// START");
        } else {
            out.println("<?xml version='1.0' encoding='UTF-8' ?>\n<!DOCTYPE cldrTest SYSTEM '../../common/dtd/cldrTest.dtd'>\n<!-- For information, see readme.html -->\n<cldrTest version='43.1' base='aa'>\n  <likelySubtags>");
        }
        SupplementalDataInfo supplementalData = SupplementalDataInfo.getInstance(CLDRPaths.SUPPLEMENTAL_DIRECTORY);
        Map<String, String> likelySubtags = supplementalData.getLikelySubtags();
        if (OUTPUT_STYLE == GenerateMaximalLocales.OutputStyle.C) {
            GenerateLikelySubtagTests.writeTestLine2("FROM", "ADD-LIKELY", "REMOVE-LIKELY");
        }
        HashSet<String> testedAlready = new HashSet<String>();
        for (String from : likelySubtags.keySet()) {
            String max;
            String to = likelySubtags.get(from);
            if (!to.equals(max = GenerateLikelySubtagTests.writeTestLine(from, likelySubtags))) {
                throw new IllegalArgumentException();
            }
            testedAlready.add(to);
        }
        LanguageTagParser ltp = new LanguageTagParser();
        for (String lang : new String[]{"und", "es", "zh", "art"}) {
            ltp.setLanguage(lang);
            for (String script : new String[]{"", "Zzzz", "Latn", "Hans", "Hant", "Moon"}) {
                ltp.setScript(script);
                for (String region : new String[]{"", "ZZ", "CN", "TW", "HK", "AQ"}) {
                    ltp.setRegion(region);
                    String tag = ltp.toString();
                    if (testedAlready.contains(tag)) continue;
                    GenerateLikelySubtagTests.writeTestLine(tag, likelySubtags);
                    testedAlready.add(tag);
                }
            }
        }
        if (OUTPUT_STYLE == GenerateMaximalLocales.OutputStyle.C) {
            out.println("\n// END");
        } else {
            out.println("  </likelySubtags>\n</cldrTest>");
        }
        out.close();
    }

    private static String writeTestLine(String from, Map<String, String> likelySubtags) {
        String maxFrom = LikelySubtags.maximize(from, likelySubtags);
        String minFrom = LikelySubtags.minimize(from, likelySubtags, true);
        GenerateLikelySubtagTests.writeTestLine2(from, maxFrom, minFrom);
        return maxFrom;
    }

    private static void writeTestLine2(String from, String maxFrom, String minFrom) {
        if (OUTPUT_STYLE == GenerateMaximalLocales.OutputStyle.C) {
            out.print("  {\n    " + GenerateLikelySubtagTests.getItem(from) + ",\n    " + GenerateLikelySubtagTests.getItem(maxFrom) + ",\n    " + GenerateLikelySubtagTests.getItem(minFrom) + "\n  },");
        } else {
            out.println("    <!-- " + GenerateLikelySubtagTests.printNameOrError(from) + " \u2192 " + GenerateLikelySubtagTests.printNameOrError(maxFrom) + " \u2192 " + GenerateLikelySubtagTests.printNameOrError(minFrom) + " -->");
            out.println("    <result input='" + GenerateLikelySubtagTests.getNameOrError(from) + "' add='" + GenerateLikelySubtagTests.getNameOrError(maxFrom) + "' remove='" + GenerateLikelySubtagTests.getNameOrError(minFrom) + "'/>");
        }
    }

    private static String printNameOrError(String maxFrom) {
        String result = GenerateMaximalLocales.printingName(maxFrom, "");
        if (result == null) {
            return "ERROR";
        }
        return result;
    }

    private static String getNameOrError(String from) {
        String result = GenerateMaximalLocales.toAlt(from, true);
        if (result == null) {
            return "ERROR";
        }
        return result;
    }

    private static String getItem(String from) {
        String toAlt = GenerateLikelySubtagTests.getNameOrError(from);
        if (toAlt == null) {
            return null;
        }
        return "\"" + toAlt + "\"";
    }
}

