/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.Multimaps;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.personname.PersonNameFormatter;
import org.unicode.cldr.util.personname.SimpleNameObject;

public class GeneratePersonNameTestData {
    private static final Joiner COMMA_JOINER = Joiner.on(", ");
    private static final CLDRConfig CLDR_CONFIG = CLDRConfig.getInstance();
    private static final CLDRFile ENGLISH = CLDR_CONFIG.getEnglish();
    static final Comparator<String> LENGTH_FIRST = Comparator.comparingInt(String::length).reversed().thenComparing(Collator.getInstance(Locale.ROOT));

    public static void main(String[] args) {
        File dir = new File(CLDRPaths.TEST_DATA, "personNameTest");
        Factory factory = CLDR_CONFIG.getCldrFactory();
        Matcher localeMatcher = Pattern.compile(".").matcher("");
        ULocale undLocale = new ULocale("und");
        for (String locale : factory.getAvailable()) {
            if (!localeMatcher.reset(locale).lookingAt()) continue;
            try {
                Object tryLocale2;
                PersonNameFormatter formatter;
                Map<PersonNameFormatter.SampleType, SimpleNameObject> names;
                String surnameOrder;
                CLDRFile cldrFile = factory.make(locale, true);
                CLDRFile unresolved = cldrFile.getUnresolved();
                String givenOrder = unresolved.getStringValue("//ldml/personNames/nameOrderLocales[@order=\"givenFirst\"]");
                if (givenOrder == null || (surnameOrder = unresolved.getStringValue("//ldml/personNames/nameOrderLocales[@order=\"surnameFirst\"]")) == null) continue;
                try {
                    names = PersonNameFormatter.loadSampleNames(cldrFile);
                    formatter = new PersonNameFormatter(cldrFile);
                }
                catch (Exception e) {
                    continue;
                }
                if (names.isEmpty()) continue;
                ULocale myLocale = new ULocale(locale);
                PersonNameFormatter.Order myOrder = formatter.getOrderFromLocale(myLocale);
                if (myOrder == null) {
                    formatter.getOrderFromLocale(myLocale);
                    throw new IllegalArgumentException("Missing order for: " + locale);
                }
                PersonNameFormatter.Order otherOrder = myOrder == PersonNameFormatter.Order.givenFirst ? PersonNameFormatter.Order.surnameFirst : PersonNameFormatter.Order.givenFirst;
                Map<ULocale, PersonNameFormatter.Order> localeToOrder = formatter.getNamePatternData().getLocaleToOrder();
                TreeMultimap orderToLocale = Multimaps.invertFrom(Multimaps.forMap(localeToOrder), TreeMultimap.create());
                ULocale otherLocale = null;
                for (Object tryLocale2 : orderToLocale.get(otherOrder)) {
                    if (undLocale.equals(tryLocale2)) continue;
                    otherLocale = tryLocale2;
                    break;
                }
                if (otherLocale == null) {
                    otherLocale = myLocale.equals(ULocale.FRENCH) ? ULocale.GERMAN : ULocale.FRENCH;
                }
                myLocale = GeneratePersonNameTestData.addRegionIfMissing(myLocale, "AQ");
                otherLocale = GeneratePersonNameTestData.addRegionIfMissing(otherLocale, "AQ");
                StringWriter output = new StringWriter();
                output.write("\n");
                GeneratePersonNameTestData.writeChoices("field", PersonNameFormatter.Field.ALL, output);
                GeneratePersonNameTestData.writeChoices("modifiers", PersonNameFormatter.Modifier.ALL, output);
                GeneratePersonNameTestData.writeChoices("options", Arrays.asList(Options.values()), output);
                GeneratePersonNameTestData.writeChoices("length", PersonNameFormatter.Length.ALL, output);
                GeneratePersonNameTestData.writeChoices("usage", PersonNameFormatter.Usage.ALL, output);
                GeneratePersonNameTestData.writeChoices("formality", PersonNameFormatter.Formality.ALL, output);
                tryLocale2 = names.entrySet().iterator();
                while (tryLocale2.hasNext()) {
                    PersonNameFormatter.Order nameOrder;
                    Map.Entry entry = (Map.Entry)tryLocale2.next();
                    PersonNameFormatter.SampleType sampleType = (PersonNameFormatter.SampleType)((Object)entry.getKey());
                    output.write("\n");
                    for (Map.Entry x2 : ((SimpleNameObject)entry.getValue()).getModifiedFieldToValue().entrySet()) {
                        output.write("name ; " + x2.getKey() + "; " + (String)x2.getValue() + "\n");
                    }
                    if (sampleType.isNative()) {
                        output.write("name ; locale; " + myLocale + "\n");
                        nameOrder = myOrder;
                    } else {
                        if (otherLocale == null) continue;
                        output.write("name ; locale; " + otherLocale + "\n");
                        nameOrder = otherOrder;
                    }
                    TreeMultimap valueToSource = TreeMultimap.create(LENGTH_FIRST, Comparator.naturalOrder());
                    for (PersonNameFormatter.FormatParameters parameters : PersonNameFormatter.FormatParameters.allCldr()) {
                        Options options;
                        PersonNameFormatter.Order order = parameters.getOrder();
                        if (order == nameOrder) {
                            options = Options.none;
                        } else {
                            if (order != PersonNameFormatter.Order.sorting || nameOrder != myOrder) continue;
                            options = Options.sorting;
                        }
                        String formatted = formatter.format((PersonNameFormatter.NameObject)entry.getValue(), parameters);
                        if (formatted.isEmpty()) continue;
                        valueToSource.put(formatted, options.name() + "; " + parameters.getLength() + "; " + parameters.getUsage() + "; " + parameters.getFormality());
                    }
                    for (Map.Entry entry2 : valueToSource.asMap().entrySet()) {
                        output.write("\nexpectedResult; " + (String)entry2.getKey() + "\n\n");
                        entry2.getValue().forEach(x -> output.write("parameters; " + x + "\n"));
                    }
                    output.write("\nendName\n");
                }
                PrintWriter output2 = FileUtilities.openUTF8Writer(dir, locale + ".txt");
                try {
                    output2.write("# CLDR person name formatting test data for: " + locale + "\n#\n# Test lines have the following structure:\n#\n# enum ; <type> ; <value>(', ' <value)\n#   For all the elements in <\u2026> below, the possible choices that could appear in the file.\n#   For example, <field> could be any of title, given, \u2026 credentials.\n#   Verify that all of these values work with the implementation.\n#\n# name ; <field>('-'<modifier>) ; <value>\n#   A sequence of these is to be used to build a person name object with the given field values.\n#   If the <field> is 'locale', then the value is the locale of the name.\n#     That will always be the last field in the name.\n#     NOTE: the locale for the name (where different than the test file's locale) will generally not match the text.\n#     It is chosen to exercise the person name formatting, by having a different given-surname order than the file's locale.\n#\n# expectedResult; <value>\n#   This line follows a sequence of name lines, and indicates the that all the following parameter lines have this expected value.\n#\n# parameters; <options>; <length>; <usage>; <formality>\n#   Each of these parameter lines should be tested to see that when formatting the current name with these parameters, \n#   the expected value is produced.\n#\n# endName\n#   Indicates the end of the values to be tested with the current name.\n#\n# =====\n# Example:\n#     enum ; field ; title, given, given2, surname, surname2, generation, credentials\n#     \u2026\n#\n#     name ; given; Iris\n#     name ; surname; Falke\n#     name ; locale; de\n#\n#     expectedResult; Falke, Iris\n#\n#     parameters; sorting; long; referring; formal\n#     parameters; sorting; medium; referring; informal\n#\n#     endName\n#\n#     name ; given; Max\n#     name ; given2; Ben\n#     name ; surname; Mustermann\n#     \u2026\n# =====\n");
                    output2.write(output.toString());
                }
                finally {
                    if (output2 == null) continue;
                    output2.close();
                }
            }
            catch (Exception e) {
                System.out.println("Skipping " + locale);
                e.printStackTrace();
            }
        }
    }

    public static ULocale addRegionIfMissing(ULocale myLocale, String region) {
        return !myLocale.getCountry().isEmpty() ? myLocale : new ULocale.Builder().setLocale(myLocale).setRegion(region).build();
    }

    public static <T> void writeChoices(String kind, Collection<T> choices, StringWriter output) {
        output.write("enum ; " + kind + " ; " + COMMA_JOINER.join(choices) + "\n");
    }

    static enum Options {
        none,
        sorting;

    }
}

