/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.dev.tool.UOption;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.GenerateAttributeList;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Iso3166Data;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleXMLSource;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.TimezoneFormatter;
import org.unicode.cldr.util.TransliteratorUtilities;
import org.unicode.cldr.util.XPathParts;
import org.unicode.cldr.util.ZoneParser;

public class Misc {
    static Factory cldrFactory;
    static CLDRFile english;
    static CLDRFile resolvedRoot;
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int SOURCEDIR = 2;
    private static final int DESTDIR = 3;
    private static final int MATCH = 4;
    private static final int TO_LOCALIZE = 5;
    private static final int CURRENT = 6;
    private static final int WINDOWS = 7;
    private static final int OBSOLETES = 8;
    private static final int ALIASES = 9;
    private static final int INFO = 10;
    private static final int ZONES = 11;
    private static final int LANGUAGE_TAGS = 12;
    private static final int FUNCTION = 13;
    private static final UOption[] options;
    private static final String HELP_TEXT;
    static Set<String> priorities;
    static long JAN152006;
    static long JUNE152006;
    static NumberFormat hours;
    static String[] ZONE_MAP;
    static CldrUtility.VariableReplacer langTag;
    static String langTagPattern;
    static String cleanedLangTagPattern;
    static Matcher regexLanguageTagOld;
    static String[] levelNames;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            Misc.showLanguageTagCount();
            UOption.parseArgs(args, options);
            if (Misc.options[0].doesOccur || Misc.options[0].doesOccur) {
                System.out.println(HELP_TEXT);
                CldrUtility.showMethods(Misc.class);
                return;
            }
            cldrFactory = Factory.make(Misc.options[2].value + "/main/", Misc.options[4].value);
            english = cldrFactory.make("en", false);
            resolvedRoot = cldrFactory.make("root", true);
            if (Misc.options[4].value.equals("group1")) {
                Misc.options[4].value = "(en|fr|de|it|es|pt|ja|ko|zh)";
            }
            TreeSet<String> languages = new TreeSet<String>(cldrFactory.getAvailableLanguages());
            if (Misc.options[6].doesOccur) {
                Misc.printCurrentTimezoneLocalizations(languages);
            }
            if (Misc.options[11].doesOccur) {
                Misc.printAllZoneLocalizations();
            }
            if (Misc.options[5].doesOccur) {
                for (String language : languages) {
                    Misc.printSupplementalData(language);
                }
            }
            if (Misc.options[7].doesOccur) {
                Misc.printWindowsZones();
            }
            if (Misc.options[10].doesOccur) {
                PrintWriter pw = FileUtilities.openUTF8Writer(CLDRPaths.TMP_DIRECTORY + "logs/", "attributesAndValues.html");
                new GenerateAttributeList(cldrFactory).show(pw);
                pw.close();
            }
            if (Misc.options[8].doesOccur) {
                Misc.listObsoletes();
            }
            if (Misc.options[9].doesOccur) {
                Misc.printZoneAliases();
            }
            if (Misc.options[13].doesOccur) {
                String function = Misc.options[13].value;
                CldrUtility.callMethod(function, Misc.class);
            }
        }
        finally {
            System.out.println("DONE");
        }
    }

    private static void showLanguageTagCount() {
        StandardCodes sc = StandardCodes.make();
        int languageCount = sc.getGoodAvailableCodes("language").size();
        int scriptCount = sc.getGoodAvailableCodes("script").size();
        int countryCount = sc.getGoodAvailableCodes("territory").size();
        System.out.println("language subtags:\t" + languageCount);
        System.out.println("script subtags:\t" + scriptCount);
        System.out.println("region subtags:\t" + countryCount);
        System.out.println();
    }

    private static void listObsoletes() {
        StandardCodes sc = StandardCodes.make();
        for (String type : sc.getAvailableTypes()) {
            System.out.println(type);
            for (String code : sc.getAvailableCodes(type)) {
                String replacementCode;
                List<String> list = sc.getFullData(type, code);
                if (list.size() < 3 || (replacementCode = list.get(2)).length() == 0) continue;
                System.out.println(code + " => " + replacementCode + "; " + english.getName(type, replacementCode));
            }
        }
    }

    private static void printAllZoneLocalizations() throws IOException {
        StandardCodes sc = StandardCodes.make();
        Set<String> zones = sc.getAvailableCodes("tzid");
        TreeMap offset_zone_locale_name = new TreeMap();
        for (String locale : priorities) {
            System.out.println(locale);
            try {
                TimezoneFormatter tzf = new TimezoneFormatter(cldrFactory, locale, true);
                for (String zone : zones) {
                    TreeMap<String, CallSite> locale_name;
                    TimeZone tzone = TimeZone.getTimeZone(zone);
                    int stdOffset = tzone.getRawOffset();
                    Integer standardOffset = new Integer(-stdOffset);
                    String name = tzf.getFormattedZone(zone, "vvvv", false, stdOffset, false);
                    String gmt = tzf.getFormattedZone(zone, "ZZZZ", false, stdOffset, false);
                    String fullName = "(" + gmt + ") " + (zone.startsWith("Etc") ? "" : name);
                    TreeMap<String, TreeMap<String, CallSite>> zone_locale_name = (TreeMap<String, TreeMap<String, CallSite>>)offset_zone_locale_name.get(standardOffset);
                    if (zone_locale_name == null) {
                        zone_locale_name = new TreeMap<String, TreeMap<String, CallSite>>();
                        offset_zone_locale_name.put(standardOffset, zone_locale_name);
                    }
                    if ((locale_name = (TreeMap<String, CallSite>)zone_locale_name.get(zone)) == null) {
                        locale_name = new TreeMap<String, CallSite>();
                        zone_locale_name.put(zone, locale_name);
                    }
                    locale_name.put(locale, (CallSite)((Object)fullName));
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        PrintWriter out = FileUtilities.openUTF8Writer("c:/", "zone_localizations.html");
        out.println("<html><head>");
        out.println("<meta http-equiv='Content-Type' content='text/html; charset=utf-8'>");
        out.println("<title>Zone Localizations</title>");
        out.println("<style>");
        out.println("th,td { text-align: left; vertical-align: top }");
        out.println("th { background-color: gray }");
        out.println("</style>");
        out.println("</head>");
        out.println("<body>");
        out.println("<table cellspacing='0' cellpadding='2' border='1'>");
        out.println("<tr><th></th><th>No</th><th>Country</th><th>Offset(s)</th>");
        for (String locale : priorities) {
            String englishLocaleName = english.getName(locale);
            out.println("<th>" + locale + " (" + englishLocaleName + ")</th>");
        }
        out.println("</tr>");
        Map<String, String> zone_country = sc.getZoneToCounty();
        int count = 0;
        for (Integer offset : offset_zone_locale_name.keySet()) {
            Map zone_locale_name = (Map)offset_zone_locale_name.get(offset);
            for (String zone : zone_locale_name.keySet()) {
                out.println("<tr>");
                out.println("<th>" + ++count + "</th>");
                out.println("<th>" + zone + "</th>");
                String country = zone_country.get(zone);
                String countryName = english.getName(2, country);
                out.println("<td>" + country + " (" + countryName + ")</td>");
                TimeZone tzone = TimeZone.getTimeZone(zone);
                out.println("<td>" + Misc.offsetString(tzone) + "</td>");
                Map locale_name = (Map)zone_locale_name.get(zone);
                for (String locale : priorities) {
                    String name = (String)locale_name.get(locale);
                    out.println("<td>");
                    if (name == null) {
                        out.println("&nbsp;");
                    } else {
                        out.println(TransliteratorUtilities.toHTML.transliterate(name));
                    }
                    out.println("</td>");
                }
                out.println("</tr>");
            }
        }
        out.println("</table>");
        out.println(CldrUtility.ANALYTICS);
        out.println("</body></html>");
        out.close();
    }

    private static String offsetString(TimeZone tzone) {
        int janOffset = tzone.getOffset(JAN152006);
        int juneOffset = tzone.getOffset(JUNE152006);
        Object result = hours.format((double)janOffset / 3600000.0);
        if (juneOffset != janOffset) {
            result = (String)result + " / " + hours.format((double)juneOffset / 3600000.0);
        }
        return result;
    }

    private static long getDateTimeinMillis(int year, int month, int date, int hourOfDay, int minute, int second) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, date, hourOfDay, minute, second);
        return cal.getTimeInMillis();
    }

    private static void printCurrentTimezoneLocalizations(Set<String> languages) throws IOException {
        TreeSet<String> rtlLanguages = new TreeSet<String>();
        for (String language : languages) {
            CLDRFile desiredLocaleFile = cldrFactory.make(language, true);
            String orientation = desiredLocaleFile.getStringValue("//ldml/layout/orientation/characterOrder");
            boolean rtl = orientation == null ? false : orientation.equals("right-to-left");
            PrintWriter log = FileUtilities.openUTF8Writer(Misc.options[3].value, language + "_timezones.html");
            log.println("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
            log.println("<style type=\"text/css\"><!--");
            log.println("td { text-align: center; vertical-align:top }");
            log.println("th { vertical-align:top }");
            if (rtl) {
                rtlLanguages.add(language);
                log.println("body { direction:rtl }");
                log.println(".ID {background-color: silver; text-align:right;}");
                log.println(".T {text-align:right; color: green}");
            } else {
                log.println(".ID {background-color: silver; text-align:left;}");
                log.println(".T {text-align:left; color: green}");
            }
            log.println(".I {color: blue}");
            log.println(".A {color: red}");
            log.println("--></style>");
            log.println("<title>Time Zone Localizations for " + language + "</title><head><body>");
            log.println("<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse: collapse\">");
            Misc.printCurrentTimezoneLocalizations(log, language);
            log.println("</table>");
            log.println(CldrUtility.ANALYTICS);
            log.println("</body></html>");
            log.close();
        }
        System.out.println("RTL languages: " + rtlLanguages);
    }

    static void printZoneAliases() {
        RuleBasedCollator col = (RuleBasedCollator)Collator.getInstance(ULocale.ENGLISH);
        col.setNumericCollation(true);
        StandardCodes sc = StandardCodes.make();
        Map<String, String> zone_countries = sc.getZoneToCounty();
        Map<String, String> old_new = sc.getZoneLinkold_new();
        TreeMap<Object, TreeSet<Object>> new_old = new TreeMap<Object, TreeSet<Object>>(col);
        TreeMap<Object, TreeSet<Object>> country_zones = new TreeMap<Object, TreeSet<Object>>(col);
        for (String zone : zone_countries.keySet()) {
            new_old.put(zone, new TreeSet<Object>(col));
            String country = zone_countries.get(zone);
            String name = english.getName("territory", country) + " (" + country + ")";
            TreeSet<Object> oldSet = (TreeSet<Object>)country_zones.get(name);
            if (oldSet == null) {
                oldSet = new TreeSet<Object>(col);
                country_zones.put(name, oldSet);
            }
            oldSet.add(zone);
        }
        for (String oldOne : old_new.keySet()) {
            String newOne = old_new.get(oldOne);
            Set oldSet = (Set)new_old.get(newOne);
            oldSet.add(oldOne);
        }
        for (String country : country_zones.keySet()) {
            System.out.println(country);
            Set zones = (Set)country_zones.get(country);
            for (String newOne : zones) {
                System.out.println("    tzid:\t" + newOne);
                Set oldSet = (Set)new_old.get(newOne);
                for (String oldOne : oldSet) {
                    System.out.println("        alias:\t" + oldOne);
                }
            }
        }
    }

    static void printWindowsZones() {
        int i;
        System.out.println("\t<timezoneData>");
        System.out.println("\t\t<mapTimezones type=\"windows\">");
        for (i = 0; i < ZONE_MAP.length; i += 3) {
            System.out.println("\t\t\t<mapZone other=\"" + ZONE_MAP[i + 1] + "\" type=\"" + ZONE_MAP[i] + "\"/> <!-- " + ZONE_MAP[i + 2] + "-->");
        }
        System.out.println("\t\t</mapTimezones>");
        System.out.println("\t</timezoneData>");
        for (i = 0; i < ZONE_MAP.length; i += 3) {
            int p1 = ZONE_MAP[i + 2].indexOf(40);
            int p2 = ZONE_MAP[i + 2].indexOf(41);
            System.out.println(ZONE_MAP[i] + "\t" + ZONE_MAP[i + 1] + "\t" + ZONE_MAP[i + 2].substring(0, p1) + "\t" + ZONE_MAP[i + 2].substring(p1 + 1, p2) + "\t" + ZONE_MAP[i + 2].substring(p2 + 1));
        }
    }

    private static void printCurrentTimezoneLocalizations(PrintWriter log, String locale) throws IOException {
        StandardCodes sc = StandardCodes.make();
        Map<String, Set<String>> linkNew_Old = sc.getZoneLinkNew_OldSet();
        TimezoneFormatter tzf = new TimezoneFormatter(cldrFactory, locale, true);
        RuleBasedCollator col = (RuleBasedCollator)Collator.getInstance(new ULocale(locale));
        col.setNumericCollation(true);
        TreeSet<Object> orderedAliases = new TreeSet<Object>(col);
        Map<String, String> zone_countries = StandardCodes.make().getZoneToCounty();
        TreeMap<Object, String> reordered = new TreeMap<Object, String>(col);
        CLDRFile desiredLocaleFile = cldrFactory.make(locale, true);
        for (String zoneID : zone_countries.keySet()) {
            String country = zone_countries.get(zoneID);
            Object countryName = desiredLocaleFile.getName(2, country);
            if (countryName == null) {
                countryName = UTF16.valueOf(1114109) + country;
            }
            reordered.put((String)countryName + "0" + zoneID, zoneID);
        }
        String[] field = new String[TimezoneFormatter.TYPE_LIMIT];
        boolean first = true;
        int count = 0;
        for (String key : reordered.keySet()) {
            String zoneID = (String)reordered.get(key);
            String country = zone_countries.get(zoneID);
            String countryName = desiredLocaleFile.getName(2, country);
            if (countryName == null) {
                countryName = country;
            }
            log.println("<tr><th class='ID' colspan=\"4\"><table><tr><th class='I'>" + ++count + "</th><th class='T'>" + TransliteratorUtilities.toHTML.transliterate(countryName) + "</th><th class='I'>\u200e" + TransliteratorUtilities.toHTML.transliterate(zoneID));
            Set<String> s2 = linkNew_Old.get(zoneID);
            if (s2 != null) {
                log.println("\u200e</th><td class='A'>\u200e");
                orderedAliases.clear();
                orderedAliases.addAll(s2);
                boolean first2 = true;
                for (String alias : s2) {
                    if (first2) {
                        first2 = false;
                    } else {
                        log.println("; ");
                    }
                    log.print(TransliteratorUtilities.toHTML.transliterate(alias));
                }
            }
            log.print("\u200e</td></tr></table></th></tr>");
            if (first) {
                first = false;
                log.println("<tr><th width=\"25%\">&nbsp;</th><th width=\"25%\">generic</th><th width=\"25%\">standard</th><th width=\"25%\">daylight</th></tr>");
            } else {
                log.println("<tr><th>&nbsp;</th><th>generic</th><th>standard</th><th>daylight</th></tr>");
            }
            for (int i = 0; i < TimezoneFormatter.LENGTH_LIMIT; ++i) {
                int j;
                log.println("<tr><th>" + TimezoneFormatter.LENGTH.get(i) + "</th>");
                for (j = 0; j < TimezoneFormatter.TYPE_LIMIT; ++j) {
                    field[j] = TransliteratorUtilities.toHTML.transliterate(tzf.getFormattedZone(zoneID, i, j, 0, false));
                }
                if (field[0].equals(field[1]) && field[1].equals(field[2])) {
                    log.println("<td colspan=\"3\">" + field[0] + "</td>");
                } else {
                    for (j = 0; j < TimezoneFormatter.TYPE_LIMIT; ++j) {
                        log.println("<td>" + field[j] + "</td>");
                    }
                }
                log.println("</tr>");
            }
        }
    }

    void showOrderedTimezones() {
        StandardCodes.make();
    }

    public static void getZoneData() {
        StandardCodes sc = StandardCodes.make();
        System.out.println("Links: Old->New");
        Map<String, String> m3 = sc.getZoneLinkold_new();
        int count = 0;
        for (String key : m3.keySet()) {
            String newOne = m3.get(key);
            System.out.println(++count + "\t" + key + " => " + newOne);
        }
        count = 0;
        System.out.println();
        System.out.println("Links: Old->New, not final");
        Set<String> oldIDs = m3.keySet();
        Iterator<String> it = oldIDs.iterator();
        while (it.hasNext()) {
            String temp;
            ++count;
            String key = it.next();
            String newOne = m3.get(key);
            String further = m3.get(newOne);
            if (further == null) continue;
            while ((temp = m3.get(further)) != null) {
                further = temp;
            }
            System.out.println(count + "\t" + key + " => " + newOne + " # NOT FINAL => " + further);
        }
        Map<String, List<ZoneParser.ZoneLine>> m22 = sc.getZone_rules();
        System.out.println();
        System.out.println("Zones with old IDs");
        for (String key : m22.keySet()) {
            if (!oldIDs.contains(key)) continue;
            System.out.println(key);
        }
        Set<String> modernIDs = sc.getZoneData().keySet();
        System.out.println();
        System.out.println("Zones without countries");
        TreeSet<String> temp = new TreeSet<String>(m22.keySet());
        temp.removeAll(modernIDs);
        System.out.println(temp);
        Set<String> countries = sc.getAvailableCodes("territory");
        System.out.println();
        System.out.println("Countries without zones");
        temp.clear();
        temp.addAll(countries);
        temp.removeAll(Iso3166Data.getOld3166());
        Iterator<Object> it2 = sc.getZoneData().values().iterator();
        while (it2.hasNext()) {
            List<String> x;
            List<String> list = x = it2.next();
            temp.remove(list.get(2));
        }
        it2 = temp.iterator();
        while (it2.hasNext()) {
            String item = (String)it2.next();
            if (!UCharacter.isDigit(item.charAt(0))) continue;
            it2.remove();
        }
        System.out.println(temp);
        System.out.println();
        System.out.println("Zone->RulesIDs");
        m22 = sc.getZone_rules();
        for (String key : m22.keySet()) {
            System.out.println(key + " => \n\t" + Misc.getSeparated((Collection)m22.get(key), "\n\t"));
        }
        System.out.println();
        System.out.println("RulesID->Rules");
        m22 = sc.getZoneRuleID_rules();
        for (String key : m22.keySet()) {
            System.out.println(key + " => \n\t" + Misc.getSeparated((Collection)m22.get(key), "\n\t"));
        }
        System.out.println();
        System.out.println("ZoneIDs->Abbreviations");
        Map ruleID_Rules = sc.getZoneRuleID_rules();
        TreeMap<String, TreeSet<String>> abb_zones = new TreeMap<String, TreeSet<String>>();
        m22 = sc.getZone_rules();
        for (String key : m22.keySet()) {
            TreeSet<String> abbreviations = new TreeSet<String>();
            ZoneParser.ZoneLine lastZoneLine = null;
            for (ZoneParser.ZoneLine zoneLine : m22.get(key)) {
                Iterator<String> it3;
                Collection<String> abb;
                String format = zoneLine.format;
                if (format.indexOf(47) >= 0) {
                    abb = Arrays.asList(format.split("/"));
                    it3 = abb.iterator();
                    while (it3.hasNext()) {
                        Misc.add(abbreviations, format.replaceAll("%s", it3.next()), key, lastZoneLine, zoneLine);
                    }
                } else if (format.indexOf(37) >= 0) {
                    abb = Misc.getAbbreviations(ruleID_Rules, lastZoneLine, zoneLine);
                    if (abb.size() == 0) {
                        System.out.println("??? Didn't find %s values for " + format + " under " + key + ";\n\tLast:" + lastZoneLine + ";\n\tCurrent: " + zoneLine);
                        abb = Misc.getAbbreviations(ruleID_Rules, lastZoneLine, zoneLine);
                    }
                    if (abb == null) {
                        System.out.println("??? " + zoneLine.rulesSave);
                        Misc.add(abbreviations, format, key, lastZoneLine, zoneLine);
                    } else {
                        it3 = abb.iterator();
                        while (it3.hasNext()) {
                            Misc.add(abbreviations, format.replaceAll("%s", it3.next()), key, lastZoneLine, zoneLine);
                        }
                    }
                } else {
                    Misc.add(abbreviations, format, key, lastZoneLine, zoneLine);
                }
                lastZoneLine = zoneLine;
            }
            Iterator it3 = abbreviations.iterator();
            while (it3.hasNext()) {
                String abb = (String)it3.next();
                if (abb.equals("")) {
                    it3.remove();
                    continue;
                }
                TreeSet<String> zones = (TreeSet<String>)abb_zones.get(abb);
                if (zones == null) {
                    zones = new TreeSet<String>();
                    abb_zones.put(abb, zones);
                }
                zones.add(key);
            }
            System.out.println(key + " => \n\t" + Misc.getSeparated(abbreviations, "\n\t"));
        }
        System.out.println();
        System.out.println("Abbreviations->ZoneIDs");
        for (String key : abb_zones.keySet()) {
            System.out.println(key + " => \n\t" + Misc.getSeparated((Collection)abb_zones.get(key), "\n\t"));
        }
        System.out.println("Types: " + ZoneParser.RuleLine.types);
        System.out.println("Saves: " + ZoneParser.RuleLine.days);
        System.out.println("untilDays: " + ZoneParser.ZoneLine.untilDays);
        System.out.println("rulesSaves: " + ZoneParser.ZoneLine.rulesSaves);
    }

    private static void add(Set<String> abbreviations, String format, String zone, ZoneParser.ZoneLine lastZoneLine, ZoneParser.ZoneLine zoneLine) {
        if (format.length() < 3) {
            System.out.println("??? Format too short: '" + format + "' under " + zone + ";\n\tLast:" + lastZoneLine + ";\n\tCurrent: " + zoneLine);
            return;
        }
        abbreviations.add(format);
    }

    private static Set<String> getAbbreviations(Map<String, List<ZoneParser.RuleLine>> rules, ZoneParser.ZoneLine lastZoneLine, ZoneParser.ZoneLine zoneLine) {
        TreeSet<String> result = new TreeSet<String>();
        List<ZoneParser.RuleLine> ruleList = rules.get(zoneLine.rulesSave);
        for (ZoneParser.RuleLine ruleLine : ruleList) {
            int from = ruleLine.fromYear;
            int to = ruleLine.toYear;
            if (zoneLine.untilYear < from || lastZoneLine != null && lastZoneLine.untilYear > to) continue;
            result.add(ruleLine.letter == null ? "?!?" : ruleLine.letter);
        }
        return result;
    }

    private static String getSeparated(Collection c, String separator) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                result.append(separator);
            }
            result.append(it.next());
        }
        return result.toString();
    }

    private static void getCities() throws IOException {
        StandardCodes sc = StandardCodes.make();
        Set<String> territories = sc.getAvailableCodes("territory");
        Map<String, List<String>> zoneData = sc.getZoneData();
        TreeSet<String> s2 = new TreeSet<String>(sc.getTZIDComparator());
        s2.addAll(sc.getZoneData().keySet());
        int counter = 0;
        for (String key : s2) {
            System.out.println(++counter + "\t" + key + "\t" + zoneData.get(key));
        }
        TreeSet<String> missing2 = new TreeSet<String>(sc.getZoneData().keySet());
        missing2.removeAll(sc.getZoneToCounty().keySet());
        System.out.println(missing2);
        missing2.clear();
        missing2.addAll(sc.getZoneToCounty().keySet());
        missing2.removeAll(sc.getZoneData().keySet());
        System.out.println(missing2);
    }

    private static void printSupplementalData(String locale) throws IOException {
        PrintWriter log = null;
        CLDRFile desiredLocaleFile = cldrFactory.make(locale, true).cloneAsThawed();
        desiredLocaleFile.removeDuplicates(resolvedRoot, false, null, null);
        CLDRFile english = cldrFactory.make("en", true);
        Collator col = Collator.getInstance(new ULocale(locale));
        CLDRFile supp = cldrFactory.make("supplementalData", false);
        for (String path : supp) {
            XPathParts parts = XPathParts.getFrozenInstance(supp.getFullXPath(path));
            Map<String, String> map = parts.findAttributes("language");
        }
        TreeMap<String, Collection<String>> groups = new TreeMap<String, Collection<String>>();
        for (String path : supp) {
            XPathParts parts = XPathParts.getFrozenInstance(supp.getFullXPath(path));
            Map<String, String> m3 = parts.findAttributes("territoryContainment");
            if (m3 == null) continue;
            Map<String, String> attributes = parts.getAttributes(2);
            String type = attributes.get("type");
            List<String> contents = CldrUtility.splitList(attributes.get("contains"), ' ', true, new ArrayList<String>());
            groups.put(type, contents);
        }
        TreeSet<String> seen = new TreeSet<String>();
        Misc.printTimezonesToLocalize(log, desiredLocaleFile, groups, seen, col, false, english);
        StandardCodes sc = StandardCodes.make();
        Set<String> codes = sc.getAvailableCodes("territory");
        TreeSet<String> missing = new TreeSet<String>(codes);
        missing.removeAll(seen);
        if (log != null) {
            log.close();
        }
    }

    private static void printTimezonesToLocalize(PrintWriter log, CLDRFile localization, Map<String, Collection<String>> groups, Set<String> seen, Collator col, boolean showCode, CLDRFile english) throws IOException {
        Set[] missing = new Set[]{new TreeSet(), new TreeSet<String>(StandardCodes.make().getTZIDComparator())};
        Misc.printWorldTimezoneCategorization(log, localization, groups, "001", 0, seen, col, showCode, Misc.zones_countrySet(), missing);
        if (missing[0].size() == 0 && missing[1].size() == 0) {
            return;
        }
        PrintWriter log2 = FileUtilities.openUTF8Writer(Misc.options[3].value, localization.getLocaleID() + "_to_localize.xml");
        log2.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        log2.println("<!DOCTYPE ldml SYSTEM \"../../common/dtd/ldml.dtd\">");
        log2.println("<ldml><identity><version number=\"43.1\"/><generation date=\"2005-01-01\"/><language type=\"" + TransliteratorUtilities.toXML.transliterate(localization.getLocaleID()) + "\"/></identity>");
        log2.println("<!-- The following are strings that are not found in the locale (currently), but need valid translations for localizing timezones. -->");
        if (missing[0].size() != 0) {
            log2.println("<localeDisplayNames><territories>");
            for (String key : missing[0]) {
                log2.println("\t<territory type=\"" + key + "\" draft=\"unconfirmed\">" + TransliteratorUtilities.toXML.transliterate("TODO " + english.getName(2, key)) + "</territory>");
            }
            log2.println("</territories></localeDisplayNames>");
        }
        String lastCountry = "";
        log2.println("<dates><timeZoneNames>");
        log2.println("\t<hourFormat>TODO +HHmm;-HHmm</hourFormat>");
        log2.println("\t<hoursFormat>TODO {0}/{1}</hoursFormat>");
        log2.println("\t<gmtFormat>TODO GMT{0}</gmtFormat>");
        log2.println("\t<regionFormat>TODO {0}</regionFormat>");
        log2.println("\t<fallbackFormat>TODO {0} ({1})</fallbackFormat>");
        for (String key : missing[1]) {
            List<String> data = StandardCodes.make().getZoneData().get(key);
            String countryCode = data.get(2);
            String country = english.getName(2, countryCode);
            if (!country.equals(lastCountry)) {
                lastCountry = country;
                log2.println("\t<!-- " + country + "-->");
            }
            log2.println("\t<zone type=\"" + key + "\"><exemplarCity draft=\"unconfirmed\">" + TransliteratorUtilities.toXML.transliterate("TODO " + Misc.getName(english, key, null)) + "</exemplarCity></zone>");
        }
        log2.println("</timeZoneNames></dates>");
        log2.println("</ldml>");
        log2.close();
    }

    private static void printWorldTimezoneCategorization(PrintWriter log, CLDRFile localization, Map<String, Collection<String>> groups, String key2, int indent, Set<String> seen, Collator col, boolean showCode, Map<String, Set<String>> zone_countrySet, Set<String>[] missing) {
        String value;
        seen.add(key2);
        String name = Misc.getName(localization, key2, missing);
        Collection s2 = groups.get(key2);
        String element = levelNames[indent];
        if (log != null) {
            log.print(Utility.repeat("\t", indent) + "<" + element + " n=\"" + name + (String)(showCode ? " (" + key2 + ")" : "") + "\"");
        }
        if (s2 == null && ((s2 = (Collection)zone_countrySet.get(key2)) == null || s2.size() == 1)) {
            s2 = null;
        }
        if (s2 == null) {
            if (log != null) {
                log.println("/>");
            }
            return;
        }
        if (log != null) {
            log.println(">");
        }
        TreeMap<Object, String> reorder = new TreeMap<Object, String>(col);
        for (String key2 : s2) {
            value = Misc.getName(localization, key2, missing);
            if (value == null) {
                System.out.println("Missing value for: " + key2);
                value = key2;
            }
            reorder.put(value, key2);
        }
        for (String key2 : reorder.keySet()) {
            value = (String)reorder.get(key2);
            Misc.printWorldTimezoneCategorization(log, localization, groups, value, indent + 1, seen, col, showCode, zone_countrySet, missing);
        }
        if (log != null) {
            log.println(Utility.repeat("\t", indent) + "</" + element + ">");
        }
    }

    private static String getName(CLDRFile localization, String key, Set<String>[] missing) {
        String name;
        int pos = key.lastIndexOf(47);
        if (pos >= 0) {
            String v = localization.getStringValue("//ldml/dates/timeZoneNames/zone[@type=\"" + key + "\"]/exemplarCity");
            if (v != null) {
                name = v;
            } else {
                if (missing != null) {
                    missing[1].add(key);
                }
                name = key.substring(pos + 1);
                name = name.replace('_', ' ');
            }
        } else {
            name = localization.getName(2, key);
            if (name == null) {
                if (missing != null) {
                    missing[0].add(key);
                }
                name = key;
            }
        }
        return name;
    }

    static Map<String, Set<String>> zones_countrySet() {
        Map<String, List<String>> m3 = StandardCodes.make().getZoneData();
        TreeMap<String, Set<String>> result = new TreeMap<String, Set<String>>();
        for (String tzid : m3.keySet()) {
            List<String> list = m3.get(tzid);
            String country = list.get(2);
            TreeSet<String> zones = (TreeSet<String>)result.get(country);
            if (zones == null) {
                zones = new TreeSet<String>();
                result.put(country, zones);
            }
            zones.add(tzid);
        }
        return result;
    }

    private static String fixNumericKey(String key) {
        char c = key.charAt(0);
        if (c > '9') {
            return key;
        }
        String fixedKey = key.length() == 3 ? key : (key.length() == 2 ? "0" + key : "00" + key);
        return fixedKey;
    }

    private static void compareLists() throws IOException {
        String line;
        BufferedReader in = FileUtilities.openUTF8Reader("", "language_list.txt");
        Factory cldrFactory = Factory.make(Misc.options[2].value + "main\\", ".*");
        Set<String> locales = cldrFactory.getAvailable();
        TreeSet<String> cldr = new TreeSet<String>();
        LanguageTagParser parser = new LanguageTagParser();
        for (String locale : locales) {
            parser.set(locale);
            if (parser.getScript().length() == 0 && parser.getRegion().length() == 0 || parser.getVariants().size() > 0) continue;
            cldr.add(locale.replace('_', '-'));
        }
        TreeSet<String> tex = new TreeSet<String>();
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).length() == 0) continue;
            int p = line.indexOf(32);
            tex.add(line.substring(0, p));
        }
        TreeSet inCldrButNotTex = new TreeSet(cldr);
        inCldrButNotTex.removeAll(tex);
        System.out.println(" inCldrButNotTex " + inCldrButNotTex);
        TreeSet inTexButNotCLDR = new TreeSet(tex);
        inTexButNotCLDR.removeAll(cldr);
        System.out.println(" inTexButNotCLDR " + inTexButNotCLDR);
    }

    void generateTransliterators() throws IOException {
        File translitSource = new File("C:\\ICU\\icu\\source\\data\\translit");
        Matcher m3 = PatternCache.get(".*Hebrew.*").matcher("");
        File[] list = translitSource.listFiles();
        for (int i = 0; i < list.length; ++i) {
            String line;
            File file = list[i];
            String name = file.getName();
            if (!m3.reset(name).matches() || !name.endsWith(".txt")) continue;
            String fixedName = name.substring(name.length() - 4);
            BufferedReader input = FileUtilities.openUTF8Reader(file.getParent() + File.pathSeparator, name);
            SimpleXMLSource source = new SimpleXMLSource(null);
            CLDRFile outFile = new CLDRFile(source);
            int count = 0;
            while ((line = input.readLine()) != null) {
                if (line.length() == 0) continue;
                outFile.add("//supplementalData/transforms/transform/line[@_q=\"" + ++count + "\"]", line);
            }
            PrintWriter pw = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY + "/translit/", fixedName + ".xml");
            outFile.write(pw);
            pw.close();
        }
    }

    static {
        options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.SOURCEDIR().setDefault(CLDRPaths.COMMON_DIRECTORY), UOption.DESTDIR().setDefault(CLDRPaths.GEN_DIRECTORY + "timezones/"), UOption.create("match", 'm', 1).setDefault(".*"), UOption.create("to_localize", 't', 0), UOption.create("current", 'c', 0), UOption.create("windows", 'w', 0), UOption.create("obsoletes", 'o', 0), UOption.create("aliases", 'a', 0), UOption.create("info", 'i', 0), UOption.create("zones", 'z', 0), UOption.create("langauge-tags", 'l', 0), UOption.create("function", 'f', 1)};
        HELP_TEXT = "Use the following options\n-h or -?\tfor this message\n-" + Misc.options[2].shortName + "\tsource directory. Default = " + CldrUtility.getCanonicalName(CLDRPaths.MAIN_DIRECTORY) + "\n-" + Misc.options[3].shortName + "\tdestination directory. Default = " + CldrUtility.getCanonicalName(CLDRPaths.GEN_DIRECTORY + "main/") + "\n-m<regex>\tto restrict the locales to what matches <regex>\n-t\tgenerates files that contain items missing localizations\n-c\tgenerates missing timezone localizations\n-w\tgenerates Windows timezone IDs\n-o\tlist display codes that are obsolete\n-o\tshows timezone aliases-i\tgets element/attribute/value information-z\tcollected timezone localizations";
        priorities = new TreeSet<String>(Arrays.asList("en", "zh_Hans", "zh_Hant", "da", "nl", "fi", "fr", "de", "it", "ja", "ko", "no", "pt_BR", "ru", "es", "sv", "ar", "bg", "ca", "hr", "cs", "et", "el", "he", "hi", "hu", "is", "id", "lv", "lt", "pl", "ro", "sr", "sk", "sl", "tl", "th", "tr", "uk", "ur", "vi"));
        JAN152006 = Misc.getDateTimeinMillis(2006, 1, 15, 0, 0, 0);
        JUNE152006 = Misc.getDateTimeinMillis(2006, 6, 15, 0, 0, 0);
        hours = new DecimalFormat("0.##");
        ZONE_MAP = new String[]{"Etc/GMT+12", "Dateline", "S (GMT-12:00) International Date Line West", "Pacific/Apia", "Samoa", "S (GMT-11:00) Midway Island, Samoa", "Pacific/Honolulu", "Hawaiian", "S (GMT-10:00) Hawaii", "America/Anchorage", "Alaskan", "D (GMT-09:00) Alaska", "America/Los_Angeles", "Pacific", "D (GMT-08:00) Pacific Time (US & Canada); Tijuana", "America/Phoenix", "US Mountain", "S (GMT-07:00) Arizona", "America/Denver", "Mountain", "D (GMT-07:00) Mountain Time (US & Canada)", "America/Chihuahua", "Mexico Standard Time 2", "D (GMT-07:00) Chihuahua, La Paz, Mazatlan", "America/Managua", "Central America", "S (GMT-06:00) Central America", "America/Regina", "Canada Central", "S (GMT-06:00) Saskatchewan", "America/Mexico_City", "Mexico", "D (GMT-06:00) Guadalajara, Mexico City, Monterrey", "America/Chicago", "Central", "D (GMT-06:00) Central Time (US & Canada)", "America/Indianapolis", "US Eastern", "S (GMT-05:00) Indiana (East)", "America/Bogota", "SA Pacific", "S (GMT-05:00) Bogota, Lima, Quito", "America/New_York", "Eastern", "D (GMT-05:00) Eastern Time (US & Canada)", "America/Caracas", "SA Western", "S (GMT-04:00) Caracas, La Paz", "America/Santiago", "Pacific SA", "D (GMT-04:00) Santiago", "America/Halifax", "Atlantic", "D (GMT-04:00) Atlantic Time (Canada)", "America/St_Johns", "Newfoundland", "D (GMT-03:30) Newfoundland", "America/Buenos_Aires", "SA Eastern", "S (GMT-03:00) Buenos Aires, Georgetown", "America/Godthab", "Greenland", "D (GMT-03:00) Greenland", "America/Sao_Paulo", "E. South America", "D (GMT-03:00) Brasilia", "America/Noronha", "Mid-Atlantic", "D (GMT-02:00) Mid-Atlantic", "Atlantic/Cape_Verde", "Cape Verde", "S (GMT-01:00) Cape Verde Is.", "Atlantic/Azores", "Azores", "D (GMT-01:00) Azores", "Africa/Casablanca", "Greenwich", "S (GMT) Casablanca, Monrovia", "Europe/London", "GMT", "D (GMT) Greenwich Mean Time : Dublin, Edinburgh, Lisbon, London", "Africa/Lagos", "W. Central Africa", "S (GMT+01:00) West Central Africa", "Europe/Berlin", "W. Europe", "D (GMT+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna", "Europe/Paris", "Romance", "D (GMT+01:00) Brussels, Copenhagen, Madrid, Paris", "Europe/Sarajevo", "Central European", "D (GMT+01:00) Sarajevo, Skopje, Warsaw, Zagreb", "Europe/Belgrade", "Central Europe", "D (GMT+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague", "Africa/Johannesburg", "South Africa", "S (GMT+02:00) Harare, Pretoria", "Asia/Jerusalem", "Israel", "S (GMT+02:00) Jerusalem", "Europe/Istanbul", "GTB", "D (GMT+02:00) Athens, Istanbul, Minsk", "Europe/Helsinki", "FLE", "D (GMT+02:00) Helsinki, Kyiv, Riga, Sofia, Tallinn, Vilnius", "Africa/Cairo", "Egypt", "D (GMT+02:00) Cairo", "Europe/Bucharest", "E. Europe", "D (GMT+02:00) Bucharest", "Africa/Nairobi", "E. Africa", "S (GMT+03:00) Nairobi", "Asia/Riyadh", "Arab", "S (GMT+03:00) Kuwait, Riyadh", "Europe/Moscow", "Russian", "D (GMT+03:00) Moscow, St. Petersburg, Volgograd", "Asia/Baghdad", "Arabic", "D (GMT+03:00) Baghdad", "Asia/Tehran", "Iran", "D (GMT+03:30) Tehran", "Asia/Muscat", "Arabian", "S (GMT+04:00) Abu Dhabi, Muscat", "Asia/Tbilisi", "Caucasus", "D (GMT+04:00) Baku, Tbilisi, Yerevan", "Asia/Kabul", "Afghanistan", "S (GMT+04:30) Kabul", "Asia/Karachi", "West Asia", "S (GMT+05:00) Islamabad, Karachi, Tashkent", "Asia/Yekaterinburg", "Ekaterinburg", "D (GMT+05:00) Ekaterinburg", "Asia/Calcutta", "India", "S (GMT+05:30) Chennai, Kolkata, Mumbai, New Delhi", "Asia/Katmandu", "Nepal", "S (GMT+05:45) Kathmandu", "Asia/Colombo", "Sri Lanka", "S (GMT+06:00) Sri Jayawardenepura", "Asia/Dhaka", "Central Asia", "S (GMT+06:00) Astana, Dhaka", "Asia/Novosibirsk", "N. Central Asia", "D (GMT+06:00) Almaty, Novosibirsk", "Asia/Rangoon", "Myanmar", "S (GMT+06:30) Rangoon", "Asia/Bangkok", "SE Asia", "S (GMT+07:00) Bangkok, Hanoi, Jakarta", "Asia/Krasnoyarsk", "North Asia", "D (GMT+07:00) Krasnoyarsk", "Australia/Perth", "W. Australia", "S (GMT+08:00) Perth", "Asia/Taipei", "Taipei", "S (GMT+08:00) Taipei", "Asia/Singapore", "Singapore", "S (GMT+08:00) Kuala Lumpur, Singapore", "Asia/Hong_Kong", "China", "S (GMT+08:00) Beijing, Chongqing, Hong Kong, Urumqi", "Asia/Irkutsk", "North Asia East", "D (GMT+08:00) Irkutsk, Ulaan Bataar", "Asia/Tokyo", "Tokyo", "S (GMT+09:00) Osaka, Sapporo, Tokyo", "Asia/Seoul", "Korea", "S (GMT+09:00) Seoul", "Asia/Yakutsk", "Yakutsk", "D (GMT+09:00) Yakutsk", "Australia/Darwin", "AUS Central", "S (GMT+09:30) Darwin", "Australia/Adelaide", "Cen. Australia", "D (GMT+09:30) Adelaide", "Pacific/Guam", "West Pacific", "S (GMT+10:00) Guam, Port Moresby", "Australia/Brisbane", "E. Australia", "S (GMT+10:00) Brisbane", "Asia/Vladivostok", "Vladivostok", "D (GMT+10:00) Vladivostok", "Australia/Hobart", "Tasmania", "D (GMT+10:00) Hobart", "Australia/Sydney", "AUS Eastern", "D (GMT+10:00) Canberra, Melbourne, Sydney", "Asia/Magadan", "Central Pacific", "S (GMT+11:00) Magadan, Solomon Is., New Caledonia", "Pacific/Fiji", "Fiji", "S (GMT+12:00) Fiji, Kamchatka, Marshall Is.", "Pacific/Auckland", "New Zealand", "D (GMT+12:00) Auckland, Wellington", "Pacific/Tongatapu", "Tonga", "S (GMT+13:00) Nuku'alofa"};
        langTag = new CldrUtility.VariableReplacer().add("$alpha", "[a-zA-Z]").add("$digit", "[0-9]").add("$alphanum", "[a-zA-Z0-9]").add("$x", "[xX]").add("$grandfathered", "en-GB-oed|i-(?:ami|bnn|default|enochian|hak|klingon|lux|mingo|navajo|pwn|tao|tay|tsu)|no-(?:bok|nyn)|sgn-(?:BE-(?:fr|nl)|CH-de)|zh-(?:gan|min(?:-nan)?|wuu|yue)").add("$lang", "$alpha{2,8}").add("$extlang", "(?:-$alpha{3})").add("$script", "(?:-$alpha{4})").add("$region", "(?:-$alpha{2}|-$digit{3})").add("$variant", "(?:-$digit$alphanum{3}|-$alphanum{5,8})").add("$extension", "(?:-[$alphanum&&[^xX]](?:-$alphanum{2,8})+)").add("$privateuse", "(?:$x(?:-$alphanum{1,8})+)").add("$privateuse2", "(?:-$privateuse)");
        langTagPattern = langTag.replace("($lang)\n\t($extlang{0,3})\n\t($script?)\n\t($region?)\n\t($variant*)\n\t($extension*)\n\t($privateuse2?)\n|($grandfathered)\n|($privateuse)");
        cleanedLangTagPattern = langTagPattern.replaceAll("[\\r\\t\\n\\s]", "");
        regexLanguageTagOld = PatternCache.get(cleanedLangTagPattern).matcher("");
        levelNames = new String[]{"world", "continent", "subcontinent", "country", "subzone"};
    }
}

