/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.HashBiMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.XMLFileReader;

public class RemoveEmptyCLDR {
    static final boolean PREFLIGHT = false;

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            args = new String[]{"annotations", "annotationsDerived"};
        }
        HashSet<String> nonEmpty = new HashSet<String>();
        HashBiMap<String, File> toDelete = HashBiMap.create();
        int counter = 0;
        for (String string : Arrays.asList(CLDRPaths.SEED_DIRECTORY1, CLDRPaths.COMMON_DIRECTORY)) {
            System.out.println("Checking: " + string);
            for (String dir : args) {
                File dirFile = new File(string + dir);
                if (!dirFile.exists()) continue;
                block2: for (File f : dirFile.listFiles()) {
                    ArrayList<Pair<String, String>> data = new ArrayList<Pair<String, String>>();
                    String normalizedPath = PathUtilities.getNormalizedPathString(f);
                    if (!normalizedPath.endsWith(".xml") || normalizedPath.endsWith("root.xml")) continue;
                    String name = f.getName();
                    name = name.substring(0, name.length() - 4);
                    XMLFileReader.loadPathValues(normalizedPath, data, false);
                    for (Pair pair : data) {
                        if (((String)pair.getFirst()).contains("/identity")) continue;
                        System.out.println(++counter + ") NOT-EMPTY: " + normalizedPath);
                        RemoveEmptyCLDR.addNameAndParents(nonEmpty, name);
                        continue block2;
                    }
                    toDelete.put(name, f);
                }
            }
        }
        counter = 0;
        for (Map.Entry entry : toDelete.entrySet()) {
            String name = (String)entry.getKey();
            if (nonEmpty.contains(name)) continue;
            File file = (File)entry.getValue();
            System.out.println(++counter + ") Deleting: " + PathUtilities.getNormalizedPathString(file));
            file.delete();
        }
    }

    private static void addNameAndParents(Set<String> nonEmpty, String name) {
        nonEmpty.add(name);
        String parent = LocaleIDParser.getParent(name);
        if (!"root".equals(parent)) {
            RemoveEmptyCLDR.addNameAndParents(nonEmpty, parent);
        }
    }
}

