/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.draft.Keyboard;
import org.unicode.cldr.draft.KeyboardModifierSet;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.tool.ShowData;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.FileCopier;
import org.unicode.cldr.util.LanguageTagCanonicalizer;
import org.unicode.cldr.util.Log;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.TransliteratorUtilities;
import org.unicode.cldr.util.UnicodeSetPrettyPrinter;

@CLDRTool(alias="showkeyboards", description="Generate keyboard charts")
public class ShowKeyboards {
    private static final String ABOUT_KEYBOARD_CHARTS = "<p>For more information, see <a target='ABOUT_KB' href='http://cldr.unicode.org/index/charts/keyboards'>About Keyboard Charts</a>.</p>";
    private static String keyboardChartDir;
    private static String keyboardChartLayoutsDir;
    static final CLDRConfig testInfo;
    static final Factory factory;
    static final boolean SHOW_BACKGROUND = false;
    static final Option.Options myOptions;
    static SupplementalDataInfo supplementalDataInfo;
    static Transliterator TO_SAFE_HTML;
    static UnicodeSet INVISIBLE;
    static UnicodeSet FAILING_INVISIBLE;
    static UnicodeSetPrettyPrinter prettyPrinter;
    static final UnicodeSet SKIP_LOG;
    static Relation<Row.R2<String, UnicodeSet>, Id> logInfo;

    public static void main(String[] args) throws IOException {
        myOptions.parse(MyOptions.idFilter, args, true);
        String idPattern = MyOptions.idFilter.option.getValue();
        keyboardChartDir = MyOptions.targetDirectory.option.getValue();
        keyboardChartLayoutsDir = keyboardChartDir + "/layouts/";
        FileCopier.ensureDirectoryExists(keyboardChartDir);
        FileCopier.copy(ShowKeyboards.class, "keyboards-index.html", keyboardChartDir, "index.html");
        Matcher idMatcher = PatternCache.get(idPattern).matcher("");
        try {
            Log.setLog(CLDRPaths.LOG_DIRECTORY + "keyboard-log.txt");
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
        boolean layoutsOnly = MyOptions.layouts.option.doesOccur();
        boolean repertoireOnly = MyOptions.repertoire.option.doesOccur();
        if (!repertoireOnly) {
            ShowKeyboards.showHtml(idMatcher);
        }
        if (!layoutsOnly) {
            ShowKeyboards.showRepertoire(idMatcher);
        }
    }

    public static void showRepertoire(Matcher idMatcher) {
        LinkedHashSet<IllegalArgumentException> totalErrors = new LinkedHashSet<IllegalArgumentException>();
        LinkedHashSet<Exception> errors = new LinkedHashSet<Exception>();
        UnicodeSet controls = new UnicodeSet("[:Cc:]").freeze();
        TreeMap<Id, UnicodeSet> id2unicodeset = new TreeMap<Id, UnicodeSet>();
        LinkedHashSet<String> totalModifiers = new LinkedHashSet<String>();
        Relation<String, Id> locale2ids = Relation.of(new TreeMap(), TreeSet.class);
        LanguageTagCanonicalizer canonicalizer = new LanguageTagCanonicalizer();
        IdInfo idInfo = new IdInfo();
        for (String string : Keyboard.getPlatformIDs()) {
            for (String keyboardId : Keyboard.getKeyboardIDs(string)) {
                if (!idMatcher.reset(keyboardId).matches()) continue;
                Keyboard keyboard = Keyboard.getKeyboard(string, keyboardId, errors);
                for (Exception error : errors) {
                    totalErrors.add(new IllegalArgumentException(keyboardId, error));
                }
                UnicodeSet unicodeSet = keyboard.getPossibleResults().removeAll(controls);
                Id id = new Id(keyboardId, keyboard.getPlatformVersion());
                idInfo.add(id, unicodeSet);
                String canonicalLocale = canonicalizer.transform(id.locale).replace('_', '-');
                if (!id.locale.equals(canonicalLocale)) {
                    totalErrors.add(new IllegalArgumentException("Non-canonical id: " + id.locale + "\t=>\t" + canonicalLocale));
                }
                id2unicodeset.put(id, unicodeSet.freeze());
                locale2ids.put(id.locale, id);
                System.out.println(id.toString().replace('/', '\t') + "\t" + keyboard.getNames());
                for (Keyboard.KeyMap keymap : keyboard.getKeyMaps()) {
                    totalModifiers.add(keymap.getModifiers().toString());
                }
            }
        }
        if (totalErrors.size() != 0) {
            System.out.println("Errors\t" + Joiner.on(System.lineSeparator() + "\t").join(totalErrors));
        }
        for (String string : totalModifiers) {
            System.out.println(string);
        }
        try {
            FileCopier.copy(ShowKeyboards.class, "keyboards.css", keyboardChartDir, "index.css");
            FormattedFileWriter.copyIncludeHtmls(keyboardChartDir);
            PrintWriter out = FileUtilities.openUTF8Writer(keyboardChartDir, "chars2keyboards.html");
            String[] stringArray = new String[2];
            ShowData.getChartTemplate("Characters \u2192 Keyboards", ToolConstants.CHART_DISPLAY_VERSION, "", stringArray, null, false);
            out.println(stringArray[0] + ABOUT_KEYBOARD_CHARTS);
            idInfo.print(out);
            out.println(stringArray[1]);
            out.close();
            out = FileUtilities.openUTF8Writer(keyboardChartDir, "keyboards2chars.html");
            ShowData.getChartTemplate("Keyboards \u2192 Characters", ToolConstants.CHART_DISPLAY_VERSION, "", stringArray, null, false);
            out.println(stringArray[0] + ABOUT_KEYBOARD_CHARTS);
            ShowKeyboards.showLocaleToCharacters(out, id2unicodeset, locale2ids);
            out.println(stringArray[1]);
            out.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        for (Map.Entry entry : logInfo.keyValuesSet()) {
            IdSet idSet = new IdSet();
            idSet.addAll((Collection)entry.getValue());
            Log.logln((String)((Row.R2)entry.getKey()).get0() + "\t" + ((UnicodeSet)((Row.R2)entry.getKey()).get1()).toPattern(false) + "\t" + idSet.toString(idInfo.allIds));
        }
        Log.close();
    }

    private static void showHtml(Matcher idMatcher) throws IOException {
        LinkedHashSet<Exception> errors = new LinkedHashSet<Exception>();
        Relation<String, Row.R3<String, String, String>> locale2keyboards = Relation.of(new TreeMap(), TreeSet.class);
        TreeMap<String, String> localeIndex = new TreeMap<String, String>();
        for (String platformId : Keyboard.getPlatformIDs()) {
            for (String string : Keyboard.getKeyboardIDs(platformId)) {
                if (!idMatcher.reset(string).matches()) continue;
                String baseLocale = string.substring(0, string.indexOf(45));
                String locale = string.substring(0, string.indexOf("-t-"));
                locale2keyboards.put(baseLocale, Row.of(platformId, locale, string));
                String localeName = testInfo.getEnglish().getName(baseLocale, true);
                localeIndex.put(localeName, baseLocale);
            }
        }
        FileCopier.ensureDirectoryExists(keyboardChartLayoutsDir);
        FileCopier.copy(ShowKeyboards.class, "keyboards.css", keyboardChartLayoutsDir, "index.css");
        FormattedFileWriter.copyIncludeHtmls(keyboardChartLayoutsDir);
        PrintWriter index = FileUtilities.openUTF8Writer(keyboardChartLayoutsDir, "index.html");
        String[] headerAndFooter = new String[2];
        ShowData.getChartTemplate("Keyboard Layout Index", ToolConstants.CHART_DISPLAY_VERSION, "", headerAndFooter, "Keyboard Index", false);
        index.println(headerAndFooter[0] + ABOUT_KEYBOARD_CHARTS);
        index.println("<ol>");
        for (Map.Entry entry : localeIndex.entrySet()) {
            index.println("<li><a href='" + (String)entry.getValue() + ".html'>" + (String)entry.getKey() + "</a> [" + (String)entry.getValue() + "]</li>");
        }
        index.println("</ol>");
        index.println(headerAndFooter[1]);
        index.close();
        for (Map.Entry entry : locale2keyboards.keyValuesSet()) {
            String locale = (String)entry.getKey();
            String localeName = testInfo.getEnglish().getName(locale);
            PrintWriter out = FileUtilities.openUTF8Writer(keyboardChartLayoutsDir, locale + ".html");
            ShowData.getChartTemplate("Layouts: " + localeName + " (" + locale + ")", ToolConstants.CHART_DISPLAY_VERSION, "", headerAndFooter, null, false);
            out.println(headerAndFooter[0] + ABOUT_KEYBOARD_CHARTS);
            Set keyboards = (Set)entry.getValue();
            for (Row.R3 platformKeyboard : keyboards) {
                String platformId = (String)platformKeyboard.get0();
                String keyboardId = (String)platformKeyboard.get2();
                Keyboard keyboard = Keyboard.getKeyboard(platformId, keyboardId, errors);
                ShowKeyboards.showErrors(errors);
                Set<String> names = keyboard.getNames();
                String platformFromKeyboardId = Keyboard.getPlatformId(keyboardId);
                Object printId = platformId.equals(platformFromKeyboardId) ? keyboardId : keyboardId + "/und";
                out.println("<h2>" + CldrUtility.getDoubleLinkedText((String)printId, (String)printId) + (String)(names.size() == 0 ? "" : " " + names) + "</h2>");
                Keyboard.Transforms transforms = keyboard.getTransforms().get((Object)Keyboard.TransformType.SIMPLE);
                out.println("<table class='keyboards'><tr>");
                for (Keyboard.KeyMap map : keyboard.getKeyMaps()) {
                    KeyboardModifierSet mods = map.getModifiers();
                    out.println("<td class='keyboardTD'><table class='keyboard'>");
                    Map<Keyboard.Iso, Keyboard.Output> isoMap = map.getIso2Output();
                    for (Keyboard.IsoRow row : Keyboard.IsoRow.values()) {
                        out.println("<tr>");
                        for (Keyboard.Iso isoValue : Keyboard.Iso.values()) {
                            Map<Keyboard.Gesture, List<String>> gestures;
                            if (isoValue.isoRow != row) continue;
                            Keyboard.Output output = isoMap.get((Object)isoValue);
                            if (output == null) {
                                out.println("<td class='x'>&nbsp;</td>");
                                continue;
                            }
                            String chars = output.getOutput();
                            Keyboard.TransformStatus transformStatus = output.getTransformStatus();
                            StringBuilder hover = new StringBuilder();
                            if (transformStatus == Keyboard.TransformStatus.DEFAULT && transforms != null) {
                                Map<String, String> map2 = transforms.getMatch(chars);
                                ShowKeyboards.add(map2, hover);
                            }
                            if (!(gestures = output.getGestures()).isEmpty()) {
                                ShowKeyboards.add(gestures, hover);
                            }
                            Object longPress = hover.length() == 0 ? "" : " title='" + hover + "'";
                            out.println("<td class='" + (hover.length() == 0 ? (char)'m' : 'h') + "'" + (String)longPress + ">" + ShowKeyboards.toSafeHtml(chars) + "</td>");
                        }
                        out.println("</tr>");
                    }
                    Object modsString = mods.getShortInput();
                    if (((String)modsString).isEmpty()) {
                        modsString = "\u00a0";
                    } else if (((String)modsString).length() > 20) {
                        modsString = ((String)modsString).substring(0, 20) + "\u2026";
                    }
                    out.println("</table><span class='modifiers'>" + TransliteratorUtilities.toHTML.transform((String)modsString) + "</span></td>");
                }
                out.println("</tr></table>");
            }
            index.println(headerAndFooter[1]);
            out.close();
        }
        System.out.println("Failing Invisibles: " + FAILING_INVISIBLE.retainAll(INVISIBLE));
    }

    private static void showErrors(Set<Exception> errors) {
        for (Exception error : errors) {
            String title = error.getMessage().contains("No minimal data for") ? "Warning" : "Error";
            System.out.println("\t*" + title + ":\t" + error);
        }
    }

    public static void addRule(String fromItem, String toItem, StringBuilder rules) {
        rules.append("'" + fromItem + "'>'<span class=\"cc\">" + toItem + "</span>';" + System.lineSeparator());
    }

    public static String toSafeHtml(Object hover) {
        String result = TO_SAFE_HTML.transform(hover.toString());
        if (INVISIBLE.containsSome(result)) {
            FAILING_INVISIBLE.addAll(result);
        }
        return result;
    }

    private static <K, V> void add(Map<K, V> map2, StringBuilder hover) {
        if (!map2.isEmpty()) {
            for (Map.Entry<K, V> entry : map2.entrySet()) {
                K key;
                if (hover.length() != 0) {
                    hover.append("; ");
                }
                String keyString = (key = entry.getKey()) == Keyboard.Gesture.LONGPRESS ? "LP" : key.toString();
                V value = entry.getValue();
                String valueString = value instanceof Collection ? Joiner.on(" ").join((Collection)value) : value.toString();
                hover.append(TransliteratorUtilities.toHTML.transform(keyString)).append("\u2192").append(TransliteratorUtilities.toHTML.transform(valueString));
            }
        }
    }

    public static void showLocaleToCharacters(PrintWriter out, Map<Id, UnicodeSet> id2unicodeset, Relation<String, Id> locale2ids) {
        TablePrinter t = new TablePrinter().addColumn("Name").setSpanRows(true).setBreakSpans(true).setSortPriority(0).setCellAttributes("class='cell'").addColumn("Locale").setSpanRows(true).setBreakSpans(true).setCellAttributes("class='cell'").addColumn("Platform").setSpanRows(true).setCellAttributes("class='cell'").addColumn("Variant").setCellAttributes("class='cell'").addColumn("Script").setCellAttributes("class='cell'").addColumn("Statistics").setCellAttributes("class='cell'").addColumn("Characters").setSpanRows(true).setCellAttributes("class='cell'");
        HashMap<String, UnicodeSet> commonSets = new HashMap<String, UnicodeSet>();
        Counter<String> commonCount = new Counter<String>();
        HashSet<String> commonDone = new HashSet<String>();
        for (Map.Entry<String, Set<Id>> localeAndIds : locale2ids.keyValuesSet()) {
            String key = localeAndIds.getKey();
            Set<Id> keyboardIds = localeAndIds.getValue();
            String localeName = testInfo.getEnglish().getName(key, true);
            String linkedLocaleName = CldrUtility.getDoubleLinkedText(key, localeName);
            ULocale uLocale = ULocale.forLanguageTag(key);
            String script = uLocale.getScript();
            String writtenLanguage = uLocale.getLanguage() + (String)(script.isEmpty() ? "" : "_" + script);
            CLDRFile cldrFile = null;
            try {
                cldrFile = factory.make(writtenLanguage, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            UnicodeSet common = UnicodeSet.EMPTY;
            String likelyScript = ULocale.addLikelySubtags(uLocale).getScript();
            commonCount.clear();
            for (String platform : Keyboard.getPlatformIDs()) {
                commonSets.put(platform, UnicodeSet.EMPTY);
            }
            if (keyboardIds.size() > 1) {
                common = UnicodeSet.EMPTY;
                for (Id keyboardId : keyboardIds) {
                    UnicodeSet keyboardSet = id2unicodeset.get(keyboardId);
                    if (common == UnicodeSet.EMPTY) {
                        common = new UnicodeSet(keyboardSet);
                    } else {
                        common.retainAll(keyboardSet);
                    }
                    UnicodeSet platformCommon = (UnicodeSet)commonSets.get(keyboardId.platform);
                    commonCount.add(keyboardId.platform, 1L);
                    if (platformCommon == UnicodeSet.EMPTY) {
                        commonSets.put(keyboardId.platform, new UnicodeSet(keyboardSet));
                        continue;
                    }
                    platformCommon.retainAll(keyboardSet);
                }
                common.freeze();
                t.addRow().addCell((Comparable)((Object)linkedLocaleName)).addCell((Comparable)((Object)key)).addCell((Comparable)((Object)"ALL")).addCell((Comparable)((Object)"COMMON")).addCell((Comparable)((Object)likelyScript)).addCell((Comparable)((Object)ShowKeyboards.getInfo(null, common, cldrFile))).addCell((Comparable)((Object)ShowKeyboards.safeUnicodeSet(common))).finishRow();
            }
            commonDone.clear();
            for (Id keyboardId : keyboardIds) {
                UnicodeSet platformCommon = (UnicodeSet)commonSets.get(keyboardId.platform);
                if (!commonDone.contains(keyboardId.platform)) {
                    commonDone.add(keyboardId.platform);
                    if (commonCount.get(keyboardId.platform) <= 1L) {
                        platformCommon = UnicodeSet.EMPTY;
                        commonSets.put(keyboardId.platform, platformCommon);
                    } else if (platformCommon.size() > 0) {
                        String stats = ShowKeyboards.getInfo(null, platformCommon, cldrFile);
                        platformCommon.removeAll(common).freeze();
                        commonSets.put(keyboardId.platform, platformCommon);
                        t.addRow().addCell((Comparable)((Object)linkedLocaleName)).addCell((Comparable)((Object)key)).addCell((Comparable)((Object)keyboardId.platform)).addCell((Comparable)((Object)"COMMON")).addCell((Comparable)((Object)likelyScript)).addCell((Comparable)((Object)stats)).addCell((Comparable)((Object)ShowKeyboards.safeUnicodeSet(platformCommon))).finishRow();
                    }
                }
                UnicodeSet current2 = id2unicodeset.get(keyboardId);
                UnicodeSet remainder = new UnicodeSet(current2).removeAll(common).removeAll(platformCommon);
                t.addRow().addCell((Comparable)((Object)linkedLocaleName)).addCell((Comparable)((Object)key)).addCell((Comparable)((Object)keyboardId.platform)).addCell((Comparable)((Object)keyboardId.variant)).addCell((Comparable)((Object)likelyScript)).addCell((Comparable)((Object)ShowKeyboards.getInfo(keyboardId, current2, cldrFile))).addCell((Comparable)((Object)ShowKeyboards.safeUnicodeSet(remainder))).finishRow();
            }
        }
        out.println(t.toTable());
    }

    public static String safeUnicodeSet(UnicodeSet unicodeSet) {
        return TransliteratorUtilities.toHTML.transform(prettyPrinter.format(unicodeSet));
    }

    private static String getInfo(Id keyboardId, UnicodeSet common, CLDRFile cldrFile) {
        Counter<String> results = new Counter<String>();
        for (String s2 : common) {
            int first = s2.codePointAt(0);
            results.add(UScript.getShortName(UScript.getScript(first)), 1L);
        }
        results.remove("Zyyy");
        results.remove("Zinh");
        results.remove("Zzzz");
        if (cldrFile != null) {
            UnicodeSet punctuationExemplars;
            UnicodeSet exemplars = new UnicodeSet(cldrFile.getExemplarSet("", CLDRFile.WinningChoice.WINNING));
            UnicodeSet auxExemplars = cldrFile.getExemplarSet("auxiliary", CLDRFile.WinningChoice.WINNING);
            if (auxExemplars != null) {
                exemplars.addAll(auxExemplars);
            }
            if ((punctuationExemplars = cldrFile.getExemplarSet("punctuation", CLDRFile.WinningChoice.WINNING)) != null) {
                exemplars.addAll(punctuationExemplars);
            }
            exemplars.addAll(ShowKeyboards.getNumericExemplars(cldrFile));
            exemplars.addAll(ShowKeyboards.getQuotationMarks(cldrFile));
            exemplars.add(" ");
            ShowKeyboards.addComparison(keyboardId, common, exemplars, results);
        }
        StringBuilder b = new StringBuilder();
        for (String entry : results.keySet()) {
            if (b.length() != 0) {
                b.append(", ");
            }
            b.append(entry).append(":").append(results.get(entry));
        }
        return b.toString();
    }

    private static void addComparison(Id keyboardId, UnicodeSet keyboard, UnicodeSet exemplars, Counter<String> results) {
        UnicodeSet common = new UnicodeSet(keyboard).retainAll(exemplars);
        if (common.size() != 0) {
            results.add("k\u2229cldr", common.size());
        }
        if ((common = new UnicodeSet(keyboard).removeAll(exemplars)).size() != 0) {
            results.add("k\u2011cldr", common.size());
            if (keyboardId != null) {
                common.remove(0, 127);
                logInfo.put(Row.of("k-cldr\t" + keyboardId.getBaseLanguage(), common), keyboardId);
            }
        }
        if ((common = new UnicodeSet(exemplars).removeAll(keyboard).remove("ss")).size() != 0) {
            results.add("cldr\u2011k", common.size());
            if (keyboardId != null && SKIP_LOG.containsNone(common)) {
                logInfo.put(Row.of("cldr\u2011k\t" + keyboardId.getBaseLanguage(), common), keyboardId);
            }
        }
    }

    static UnicodeSet getQuotationMarks(CLDRFile file) {
        UnicodeSet results = new UnicodeSet();
        results.add(file.getStringValue("//ldml/delimiters/quotationEnd"));
        results.add(file.getStringValue("//ldml/delimiters/quotationStart"));
        results.add(file.getStringValue("//ldml/delimiters/alternateQuotationEnd"));
        results.add(file.getStringValue("//ldml/delimiters/alternateQuotationStart"));
        return results;
    }

    static UnicodeSet getNumericExemplars(CLDRFile file) {
        UnicodeSet results = new UnicodeSet();
        String defaultNumberingSystem = file.getStringValue("//ldml/numbers/defaultNumberingSystem");
        String nativeNumberingSystem = file.getStringValue("//ldml/numbers/otherNumberingSystems/native");
        ShowKeyboards.addNumberingSystem(file, results, "latn");
        if (!defaultNumberingSystem.equals("latn")) {
            ShowKeyboards.addNumberingSystem(file, results, defaultNumberingSystem);
        }
        if (!nativeNumberingSystem.equals("latn") && !nativeNumberingSystem.equals(defaultNumberingSystem)) {
            ShowKeyboards.addNumberingSystem(file, results, nativeNumberingSystem);
        }
        return results;
    }

    public static void addNumberingSystem(CLDRFile file, UnicodeSet results, String numberingSystem) {
        String digits = supplementalDataInfo.getDigits(numberingSystem);
        results.addAll(digits);
        ShowKeyboards.addSymbol(file, numberingSystem, "decimal", results);
        ShowKeyboards.addSymbol(file, numberingSystem, "group", results);
        ShowKeyboards.addSymbol(file, numberingSystem, "minusSign", results);
        ShowKeyboards.addSymbol(file, numberingSystem, "percentSign", results);
        ShowKeyboards.addSymbol(file, numberingSystem, "plusSign", results);
    }

    public static void addSymbol(CLDRFile file, String numberingSystem, String key, UnicodeSet results) {
        String symbol = file.getStringValue("//ldml/numbers/symbols[@numberSystem=\"" + numberingSystem + "\"]/" + key);
        results.add(symbol);
    }

    static {
        String[][] map;
        testInfo = ToolConfig.getToolInstance();
        factory = testInfo.getCldrFactory();
        myOptions = new Option.Options();
        supplementalDataInfo = SupplementalDataInfo.getInstance();
        StringBuilder rules = new StringBuilder(TransliteratorUtilities.toHTML.toRules(false));
        for (char i = '\u0000'; i < ' '; i = (char)(i + '\u0001')) {
            ShowKeyboards.addRule(String.valueOf(i), "^" + String.valueOf((char)(i + 64)), rules);
        }
        for (String[] items : map = new String[][]{{"\u007f", "del"}, {"\u00a0", "nbsp"}, {"\u00ad", "shy"}, {"\u200b", "zwsp"}, {"\u200c", "zwnj"}, {"\u200d", "zwj"}, {"\u200e", "lrm"}, {"\u200f", "rlm"}, {"\u202f", "nnbs"}, {"\ufeff", "bom"}, {"\u180b", "mvs1"}, {"\u180c", "mvs2"}, {"\u180d", "mvs3"}, {"\u180e", "mvs"}}) {
            String fromItem = items[0];
            String toItem = items[1];
            ShowKeyboards.addRule(fromItem, toItem, rules);
        }
        TO_SAFE_HTML = Transliterator.createFromRules("none", rules.toString(), 0);
        INVISIBLE = new UnicodeSet("[[:C:][:Z:][:whitespace:][:Default_Ignorable_Code_Point:]-[\\u0020]]").freeze();
        FAILING_INVISIBLE = new UnicodeSet();
        prettyPrinter = new UnicodeSetPrettyPrinter().setOrdering(Collator.getInstance(ULocale.ROOT)).setSpaceComparator(Collator.getInstance(ULocale.ROOT).setStrength2(0));
        SKIP_LOG = new UnicodeSet("[\uac00\u4e00]").freeze();
        logInfo = Relation.of(new TreeMap(), TreeSet.class);
    }

    static class IdSet {
        Map<String, Relation<String, String>> data = new TreeMap<String, Relation<String, String>>();

        IdSet() {
        }

        public void add(Id id) {
            Relation<String, String> platform2variant = this.data.get(id.platform);
            if (platform2variant == null) {
                platform2variant = Relation.of(new TreeMap(), TreeSet.class);
                this.data.put(id.platform, platform2variant);
            }
            platform2variant.put(id.locale, id.variant);
        }

        public void addAll(Collection<Id> idSet) {
            for (Id id : idSet) {
                this.add(id);
            }
        }

        public String toString(IdSet allIds) {
            if (this.equals(allIds)) {
                return "*";
            }
            StringBuilder b = new StringBuilder();
            Set<Map.Entry<String, Relation<String, String>>> entrySet = this.data.entrySet();
            boolean first = true;
            for (Map.Entry<String, Relation<String, String>> entry : entrySet) {
                if (first) {
                    first = false;
                } else {
                    b.append(" ");
                }
                String key = entry.getKey();
                Set<Map.Entry<String, Set<String>>> valueSet = entry.getValue().keyValuesSet();
                b.append(key).append(":");
                this.appendLocaleAndVariants(b, valueSet, allIds.data.get(key));
            }
            return b.toString();
        }

        private void appendLocaleAndVariants(StringBuilder b, Set<Map.Entry<String, Set<String>>> set, Relation<String, String> relation) {
            boolean isSingle;
            if (set.equals(relation.keyValuesSet())) {
                b.append("*");
                return;
            }
            int setSize = set.size();
            if (setSize > 9) {
                b.append(setSize).append("/").append(relation.size());
                return;
            }
            boolean bl = isSingle = setSize == 1;
            if (!isSingle) {
                b.append("(");
            }
            boolean first = true;
            for (Map.Entry<String, Set<String>> item : set) {
                String firstOne;
                if (first) {
                    first = false;
                } else {
                    b.append("|");
                }
                String key = item.getKey();
                b.append(key);
                Set<String> variants = item.getValue();
                int size = variants.size();
                if (size == 0 || size == 1 && (firstOne = variants.iterator().next()).isEmpty()) continue;
                b.append("/");
                this.appendVariant(b, variants, relation.get(key));
            }
            if (!isSingle) {
                b.append(")");
            }
        }

        private void appendVariant(StringBuilder b, Set<String> set, Set<String> set2) {
            boolean isSingle;
            if (set.equals(set2)) {
                b.append("*");
                return;
            }
            boolean bl = isSingle = set.size() == 1;
            if (!isSingle) {
                b.append("(");
            }
            boolean first = true;
            for (String item : set) {
                if (first) {
                    first = false;
                } else {
                    b.append("|");
                }
                b.append(item.isEmpty() ? "\u2205" : item);
            }
            if (!isSingle) {
                b.append(")");
            }
        }

        public boolean isEquals(Object other) {
            return this.data.equals(((IdSet)other).data);
        }

        public int hashCode() {
            return this.data.hashCode();
        }
    }

    static class Id
    implements Comparable<Id> {
        final String locale;
        final String platform;
        final String variant;
        final String platformVersion;

        Id(String input, String platformVersion) {
            int pos = input.indexOf("-t-k0-");
            String localeTemp = input.substring(0, pos);
            this.locale = ULocale.minimizeSubtags(ULocale.forLanguageTag(localeTemp)).toLanguageTag();
            int pos2 = input.indexOf(45, pos += 6);
            if (pos2 > 0) {
                this.platform = input.substring(pos, pos2);
                this.variant = input.substring(pos2 + 1);
            } else {
                this.platform = input.substring(pos);
                this.variant = "";
            }
            this.platformVersion = platformVersion;
        }

        @Override
        public int compareTo(Id other) {
            int result = this.locale.compareTo(other.locale);
            if (0 != result) {
                return result;
            }
            result = this.platform.compareTo(other.platform);
            if (0 != result) {
                return result;
            }
            result = this.variant.compareTo(other.variant);
            if (0 != result) {
                return result;
            }
            return 0;
        }

        public String toString() {
            return this.locale + "/" + this.platform + "/" + this.variant;
        }

        public String getBaseLanguage() {
            int pos = this.locale.indexOf(45);
            return pos < 0 ? this.locale : this.locale.substring(0, pos);
        }
    }

    static class IdInfo {
        final Collator collator = Collator.getInstance(ULocale.ENGLISH);
        BitSet bitset = new BitSet();
        BitSet bitset2 = new BitSet();
        TreeMap<String, IdSet>[] charToKeyboards = new TreeMap[200];
        IdSet allIds;

        IdInfo() {
            this.collator.setStrength(15);
            for (int i = 0; i < this.charToKeyboards.length; ++i) {
                this.charToKeyboards[i] = new TreeMap(this.collator);
            }
            this.allIds = new IdSet();
        }

        public void add(Id id, UnicodeSet unicodeSet) {
            this.allIds.add(id);
            for (String s2 : unicodeSet) {
                int script = this.getScriptExtensions(s2, this.bitset);
                if (script >= 0) {
                    this.addToScript(script, id, s2);
                    continue;
                }
                int script2 = this.bitset.nextSetBit(0);
                while (script2 >= 0) {
                    this.addToScript(script2, id, s2);
                    script2 = this.bitset.nextSetBit(script2 + 1);
                }
            }
        }

        public int getScriptExtensions(String s2, BitSet outputBitset) {
            int ch;
            int firstCodePoint = s2.codePointAt(0);
            int result = UScript.getScriptExtensions(firstCodePoint, outputBitset);
            int firstCodePointCount = Character.charCount(firstCodePoint);
            if (s2.length() == firstCodePointCount) {
                return result;
            }
            for (int i = firstCodePointCount; i < s2.length(); i += Character.charCount(ch)) {
                ch = s2.codePointAt(i);
                UScript.getScriptExtensions(ch, this.bitset2);
                outputBitset.or(this.bitset2);
            }
            int cardinality = outputBitset.cardinality();
            if (cardinality > 1) {
                if (outputBitset.get(1)) {
                    outputBitset.clear(1);
                    --cardinality;
                }
                if (cardinality > 1 && outputBitset.get(0)) {
                    outputBitset.clear(0);
                    --cardinality;
                }
            }
            if (cardinality == 1) {
                return outputBitset.nextSetBit(0);
            }
            return -cardinality;
        }

        public void addToScript(int script, Id id, String s2) {
            TreeMap<String, IdSet> charToKeyboard = this.charToKeyboards[script];
            IdSet idSet = charToKeyboard.get(s2);
            if (idSet == null) {
                idSet = new IdSet();
                charToKeyboard.put(s2, idSet);
            }
            idSet.add(id);
        }

        public void print(PrintWriter pw) {
            TablePrinter t = new TablePrinter().addColumn("Script").setSpanRows(true).setCellAttributes("class='s'").addColumn("Char").setCellAttributes("class='ch'").addColumn("Code").setCellAttributes("class='c'").addColumn("Name").setCellAttributes("class='n'").addColumn("Keyboards").setSpanRows(true).setCellAttributes("class='k'");
            TreeSet<String> missingScripts = new TreeSet<String>();
            UnicodeSet notNFKC = new UnicodeSet("[:nfkcqc=n:]");
            UnicodeSet COMMONINHERITED = new UnicodeSet("[[:sc=common:][:sc=inherited:]]");
            for (int script = 0; script < this.charToKeyboards.length; ++script) {
                String linkedScriptName;
                TreeMap<String, IdSet> charToKeyboard;
                UnicodeSet inScript;
                block8: {
                    inScript = new UnicodeSet().applyIntPropertyValue(4106, script).removeAll(notNFKC);
                    if (inScript.size() == 0) continue;
                    charToKeyboard = this.charToKeyboards[script];
                    String scriptName = UScript.getName(script);
                    linkedScriptName = CldrUtility.getDoubleLinkedText(UScript.getShortName(script), scriptName);
                    if (charToKeyboard.size() == 0) {
                        missingScripts.add(scriptName);
                        continue;
                    }
                    if (script != 0 && script != 1) {
                        for (String s2 : charToKeyboard.keySet()) {
                            if (COMMONINHERITED.containsAll(s2)) continue;
                            break block8;
                        }
                        missingScripts.add(scriptName);
                        continue;
                    }
                }
                String last = "";
                for (Map.Entry<String, IdSet> entry : charToKeyboard.entrySet()) {
                    String s3 = entry.getKey();
                    IdSet value = entry.getValue();
                    String keyboardsString = value.toString(this.allIds);
                    if (!s3.equalsIgnoreCase(last)) {
                        String name;
                        if (s3.equals("\u094d\u200c")) {
                            s3 = "\u094d";
                        }
                        if ((name = UCharacter.getName(s3, " + ")) == null) {
                            name = "[no name]";
                        }
                        String ch = s3.equals("\u0f39") ? "\ufffd" : s3;
                        t.addRow().addCell((Comparable)((Object)linkedScriptName)).addCell((Comparable)((Object)TransliteratorUtilities.toHTML.transform(ch))).addCell((Comparable)((Object)Utility.hex(s3, 4, " + "))).addCell((Comparable)((Object)name)).addCell((Comparable)((Object)keyboardsString)).finishRow();
                    }
                    inScript.remove(s3);
                    last = s3;
                }
                if (inScript.size() == 0 || script == 103) continue;
                t.addRow().addCell((Comparable)((Object)linkedScriptName)).addCell((Comparable)((Object)"")).addCell((Comparable)((Object)String.valueOf(inScript.size()))).addCell((Comparable)((Object)"missing (NFKC)!")).addCell((Comparable)((Object)ShowKeyboards.safeUnicodeSet(inScript))).finishRow();
            }
            t.addRow().addCell((Comparable)((Object)"")).addCell((Comparable)((Object)"")).addCell((Comparable)((Object)String.valueOf(missingScripts.size()))).addCell((Comparable)((Object)"missing scripts!")).addCell((Comparable)((Object)((Object)missingScripts).toString())).finishRow();
            pw.println(t.toTable());
        }
    }

    static enum MyOptions {
        idFilter(".+", ".*", "Filter the information based on id, using a regex argument."),
        sourceDirectory(".+", CLDRPaths.BASE_DIRECTORY + "keyboards/", "The source directory. CURRENTLY CAN\u2019T BE CHANGED!!"),
        targetDirectory(".+", CLDRPaths.CHART_DIRECTORY + "keyboards/", "The target directory."),
        layouts(null, null, "Only create html files for keyboard layouts"),
        repertoire(null, null, "Only create html files for repertoire");

        final Option option;

        private MyOptions(String argumentPattern, String defaultArgument, String helpText) {
            this.option = myOptions.add(this, (Object)argumentPattern, defaultArgument, helpText);
        }
    }
}

