/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.ibm.icu.impl.Row;
import com.ibm.icu.text.UnicodeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

public class LanguageTagParser {
    private static final Joiner HYPHEN_JOINER = Joiner.on('-');
    private static final Comparator<? super String> EXTENSION_ORDER = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            int diff = this.getBucket(o1) - this.getBucket(o2);
            if (diff != 0) {
                return diff;
            }
            return o1.compareTo(o2);
        }

        private int getBucket(String o1) {
            switch (o1.length()) {
                case 1: {
                    return o1.charAt(0) == 't' ? 0 : 2;
                }
                case 2: {
                    return o1.charAt(1) <= '9' ? 1 : 3;
                }
            }
            throw new IllegalArgumentException();
        }
    };
    private String original;
    private boolean legacy = false;
    private String language;
    private String script;
    private String region;
    private Set<String> variants = new TreeSet<String>();
    private Map<String, List<String>> extensions = new TreeMap<String, List<String>>();
    private Map<String, List<String>> localeExtensions = new TreeMap<String, List<String>>(EXTENSION_ORDER);
    private static final UnicodeSet ALPHA = new UnicodeSet("[a-zA-Z]").freeze();
    private static final UnicodeSet DIGIT = new UnicodeSet("[0-9]").freeze();
    private static final UnicodeSet ALPHANUM = new UnicodeSet("[0-9a-zA-Z]").freeze();
    private static final UnicodeSet EXTENSION_VALUE = new UnicodeSet("[0-9a-zA-Z/_]").freeze();
    private static final UnicodeSet X = new UnicodeSet("[xX]").freeze();
    private static final UnicodeSet ALPHA_MINUS_X = new UnicodeSet(ALPHA).removeAll(X).freeze();
    private static StandardCodes standardCodes = StandardCodes.make();
    private static final Set<String> legacyCodes = standardCodes.getAvailableCodes("legacy");
    private static final String separator = "-_";
    private static final UnicodeSet SEPARATORS = new UnicodeSet().addAll("-_").freeze();
    private static final Splitter SPLIT_BAR = Splitter.on(CharMatcher.anyOf("-_"));
    private static final Splitter SPLIT_COLON = Splitter.on(';');
    private static final Splitter SPLIT_EQUAL = Splitter.on('=');
    private static SupplementalDataInfo SDI = null;
    public static Set<Fields> LANGUAGE_SCRIPT = Collections.unmodifiableSet(EnumSet.of(Fields.LANGUAGE, Fields.SCRIPT));
    public static Set<Fields> LANGUAGE_REGION = Collections.unmodifiableSet(EnumSet.of(Fields.LANGUAGE, Fields.REGION));
    public static Set<Fields> LANGUAGE_SCRIPT_REGION = Collections.unmodifiableSet(EnumSet.of(Fields.LANGUAGE, Fields.SCRIPT, Fields.REGION));
    static final Pattern EXTENSION_PATTERN = PatternCache.get("([0-9a-zA-Z]{2,8}(-[0-9a-zA-Z]{2,8})*)?");

    public String getLanguage() {
        return this.language;
    }

    public String getScript() {
        return this.script;
    }

    public String getRegion() {
        return this.region;
    }

    public List<String> getVariants() {
        return ImmutableList.copyOf(this.variants);
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    @Deprecated
    public Map<String, String> getExtensions() {
        return OutputOption.ICU.convert(this.extensions);
    }

    @Deprecated
    public Map<String, String> getLocaleExtensions() {
        return OutputOption.ICU.convert(this.localeExtensions);
    }

    public Map<String, List<String>> getExtensionsDetailed() {
        return ImmutableMap.copyOf(this.extensions);
    }

    public Map<String, List<String>> getLocaleExtensionsDetailed() {
        return ImmutableMap.copyOf(this.localeExtensions);
    }

    public String getOriginal() {
        return this.original;
    }

    public String getLanguageScript() {
        if (this.script.length() != 0) {
            return this.language + "_" + this.script;
        }
        return this.language;
    }

    public static Set<String> getLanguageScript(Collection<String> in) {
        return LanguageTagParser.getLanguageAndScript(in, null);
    }

    public static Set<String> getLanguageAndScript(Collection<String> in, Set<String> output) {
        if (output == null) {
            output = new TreeSet<String>();
        }
        LanguageTagParser lparser = new LanguageTagParser();
        Iterator<String> it = in.iterator();
        while (it.hasNext()) {
            output.add(lparser.set(it.next()).getLanguageScript());
        }
        return output;
    }

    public LanguageTagParser set(String languageTag) {
        String subtag;
        if (((String)languageTag).length() == 0 || ((String)languageTag).equals("root")) {
            languageTag = "und";
        } else if (((String)languageTag).startsWith("_") || ((String)languageTag).startsWith("-")) {
            languageTag = "und" + (String)languageTag;
        }
        languageTag = ((String)languageTag).toLowerCase(Locale.ROOT);
        this.script = "";
        this.region = "";
        this.language = "";
        this.legacy = false;
        this.variants.clear();
        this.extensions.clear();
        this.localeExtensions.clear();
        this.original = languageTag;
        int atPosition = ((String)languageTag).indexOf(64);
        if (atPosition >= 0) {
            String extensionsString = ((String)languageTag).substring(atPosition + 1).toLowerCase(Locale.ROOT);
            block8: for (String keyValue : SPLIT_COLON.split(extensionsString)) {
                Iterator<String> keyValuePair = SPLIT_EQUAL.split(keyValue).iterator();
                String key = keyValuePair.next();
                String value = keyValuePair.next();
                if (keyValuePair.hasNext() || !ALPHANUM.containsAll(key) || !EXTENSION_VALUE.containsAll(value)) {
                    this.throwError(keyValue, "Invalid key/value pair");
                }
                List<String> valueList = SPLIT_BAR.splitToList(value);
                switch (key.length()) {
                    case 1: {
                        this.extensions.put(key, valueList);
                        continue block8;
                    }
                    case 2: {
                        this.localeExtensions.put(key, valueList);
                        continue block8;
                    }
                }
                this.throwError(keyValue, "Invalid key/value pair");
            }
            languageTag = ((String)languageTag).substring(0, atPosition);
        }
        if (legacyCodes.contains(languageTag)) {
            this.language = languageTag;
            this.legacy = true;
            return this;
        }
        StringTokenizer st = new StringTokenizer((String)languageTag, separator);
        try {
            subtag = this.getSubtag(st);
        }
        catch (Exception e1) {
            throw new IllegalArgumentException("Illegal language tag: " + (String)languageTag, e1);
        }
        if (subtag.equalsIgnoreCase("x")) {
            this.getExtension(subtag, st, 1);
            return this;
        }
        if (!ALPHA.containsAll(subtag) || subtag.length() < 2) {
            this.throwError(subtag, "Invalid language subtag");
        }
        try {
            this.language = subtag;
            subtag = this.getSubtag(st);
            if (subtag.length() == 4 && ALPHA.containsAll(subtag)) {
                this.script = subtag;
                this.script = this.script.substring(0, 1).toUpperCase(Locale.ROOT) + this.script.substring(1);
                subtag = this.getSubtag(st);
            }
            if (subtag.length() == 2 && ALPHA.containsAll(subtag) || subtag.length() == 3 && DIGIT.containsAll(subtag)) {
                this.region = subtag.toUpperCase(Locale.ENGLISH);
                subtag = this.getSubtag(st);
            }
            while (this.isValidVariant(subtag)) {
                this.variants.add(subtag);
                subtag = this.getSubtag(st);
            }
            while (subtag.length() == 1 && ALPHA_MINUS_X.contains(subtag)) {
                if ((subtag = this.getExtension(subtag, st, 2)) != null) continue;
                return this;
            }
            if (subtag.equalsIgnoreCase("x")) {
                this.getExtension(subtag, st, 1);
                return this;
            }
            this.throwError(subtag, "Illegal subtag");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    private boolean isValidVariant(String subtag) {
        return subtag != null && ALPHANUM.containsAll(subtag) && (subtag.length() > 4 || subtag.length() == 4 && DIGIT.contains(subtag.charAt(0)));
    }

    public boolean isValid() {
        if (this.legacy) {
            return true;
        }
        if (!this.validates(this.language, "language")) {
            return false;
        }
        if (!this.validates(this.script, "script")) {
            return false;
        }
        if (!this.validates(this.region, "territory")) {
            return false;
        }
        Iterator<String> it = this.variants.iterator();
        while (it.hasNext()) {
            if (this.validates(it.next(), "variant")) continue;
            return false;
        }
        return true;
    }

    public Status getStatus(Set<String> errors) {
        String scope;
        Map<String, String> lstrInfo;
        errors.clear();
        if (!this.isValid()) {
            return Status.WELL_FORMED;
        }
        if (SDI == null) {
            SDI = SupplementalDataInfo.getInstance();
        }
        Map<String, Map<String, Row.R2<List<String>, String>>> aliasInfo = SDI.getLocaleAliasInfo();
        Map<String, Map<String, String>> languageInfo = StandardCodes.getLStreg().get("language");
        if (aliasInfo.get("language").containsKey(this.language)) {
            errors.add("Non-canonical language: " + this.language);
        }
        if ((lstrInfo = languageInfo.get(this.language)) != null && "collection".equals(scope = lstrInfo.get("Scope"))) {
            errors.add("Collection language: " + this.language);
        }
        if (aliasInfo.get("script").containsKey(this.script)) {
            errors.add("Non-canonical script: " + this.script);
        }
        if (aliasInfo.get("territory").containsKey(this.region)) {
            errors.add("Non-canonical region: " + this.region);
        }
        if (!errors.isEmpty()) {
            return Status.VALID;
        }
        String tag = this.language + (String)(this.script.isEmpty() ? "" : "_" + this.script) + (String)(this.region.isEmpty() ? "" : "_" + this.region);
        String minimized = LikelySubtags.minimize(tag, SDI.getLikelySubtags(), false);
        if (minimized == null) {
            errors.add("No minimal data for:" + tag);
            if (this.script.isEmpty() && this.region.isEmpty()) {
                return Status.MINIMAL;
            }
            return Status.CANONICAL;
        }
        if (!tag.equals(minimized)) {
            errors.add("Not minimal:" + tag + "-->" + minimized);
            return Status.CANONICAL;
        }
        return Status.MINIMAL;
    }

    private boolean validates(String subtag, String type) {
        return subtag.length() == 0 || standardCodes.getAvailableCodes(type).contains(subtag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExtension(String subtag, StringTokenizer st, int minLength) {
        String base = subtag;
        char extension = subtag.charAt(0);
        if (this.extensions.containsKey(subtag)) {
            this.throwError(subtag, "Can't have two extensions with the same key");
        }
        if (!st.hasMoreElements()) {
            this.throwError(subtag, "Private Use / Extension requires subsequent subtag");
        }
        boolean takesSubkeys = extension == 'u' || extension == 't';
        boolean firstT = extension == 't';
        boolean haveContents = false;
        ArrayList<String> result = new ArrayList<String>();
        try {
            while (st.hasMoreElements()) {
                subtag = this.getSubtag(st);
                if (subtag.length() < minLength) {
                    String string = subtag;
                    return string;
                }
                if (takesSubkeys && subtag.length() == 2 && (!firstT || LanguageTagParser.isTKey(subtag))) {
                    if (!result.isEmpty() || base.length() != 1) {
                        this.localeExtensions.put(base, ImmutableList.copyOf(result));
                        haveContents = true;
                        result.clear();
                    }
                    base = subtag;
                    continue;
                }
                firstT = false;
                result.add(subtag);
            }
            String string = null;
            return string;
        }
        finally {
            if (takesSubkeys) {
                if (!result.isEmpty() || base.length() != 1) {
                    this.localeExtensions.put(base, ImmutableList.copyOf(result));
                    haveContents = true;
                }
                if (!haveContents) {
                    throw new IllegalArgumentException("extension must not be empty: " + base);
                }
            } else {
                if (result.isEmpty()) {
                    throw new IllegalArgumentException("extension must not be empty: " + base);
                }
                this.extensions.put(base, ImmutableList.copyOf(result));
            }
        }
    }

    private String getSubtag(StringTokenizer st) {
        String result = st.nextToken();
        if (result.length() < 1 || result.length() > 8) {
            this.throwError(result, "Illegal length (must be 1..8)");
        }
        if (!ALPHANUM.containsAll(result)) {
            this.throwError(result, "Illegal characters (" + new UnicodeSet().addAll(result).removeAll(ALPHANUM) + ")");
        }
        return result;
    }

    private void throwError(String subtag, String errorText) {
        throw new IllegalArgumentException(errorText + ": " + subtag + " in " + this.original);
    }

    public LanguageTagParser setRegion(String region) {
        this.region = region;
        return this;
    }

    public LanguageTagParser setScript(String script) {
        this.script = script;
        return this;
    }

    public String toString() {
        return this.toString(OutputOption.ICU);
    }

    public String toString(OutputOption oo) {
        String value;
        StringBuilder result = new StringBuilder(this.language);
        if (this.script.length() != 0) {
            result.append(oo.separator).append(this.script);
        }
        if (this.region.length() != 0) {
            result.append(oo.separator).append(this.region);
        }
        if (this.variants.size() != 0) {
            for (String variant : this.variants) {
                result.append(oo.separator).append(oo != OutputOption.ICU ? variant : variant.toUpperCase(Locale.ROOT));
            }
        }
        boolean haveAt = false;
        boolean needSep = false;
        StringBuilder extensionsAfterU = null;
        StringBuilder extensionX = null;
        if (this.extensions.size() != 0) {
            StringBuilder target = result;
            for (Map.Entry<String, List<String>> extension : this.extensions.entrySet()) {
                String string = extension.getKey();
                value = oo.joiner.join((Iterable<? extends Object>)extension.getValue());
                switch (string) {
                    case "v": 
                    case "w": 
                    case "y": 
                    case "z": {
                        if (extensionsAfterU == null) {
                            extensionsAfterU = new StringBuilder();
                        }
                        target = extensionsAfterU;
                        break;
                    }
                    case "x": {
                        if (extensionX == null) {
                            extensionX = new StringBuilder();
                        }
                        target = extensionX;
                        break;
                    }
                }
                if (oo == OutputOption.BCP47) {
                    target.append(oo.separator).append(string).append(oo.separator).append(value);
                    continue;
                }
                if (!haveAt) {
                    target.append('@');
                    haveAt = true;
                }
                if (needSep) {
                    target.append(";");
                } else {
                    needSep = true;
                }
                target.append(string).append('=').append(value);
            }
        }
        if (this.localeExtensions.size() != 0) {
            if (oo == OutputOption.BCP47) {
                List<String> tValue = this.localeExtensions.get("t");
                if (tValue != null) {
                    result.append(oo.separator).append('t').append(oo.separator).append(oo.joiner.join(tValue));
                    for (Map.Entry<String, List<String>> extension : this.localeExtensions.entrySet()) {
                        String string = extension.getKey();
                        if (!LanguageTagParser.isTKey(string)) continue;
                        value = oo.joiner.join((Iterable<? extends Object>)extension.getValue());
                        result.append(oo.separator).append(string).append(oo.separator).append(value);
                    }
                }
                boolean haveU = false;
                for (Map.Entry entry : this.localeExtensions.entrySet()) {
                    String key2;
                    if (!haveU) {
                        List<String> uValue = this.localeExtensions.get("u");
                        result.append(oo.separator).append('u');
                        if (uValue != null) {
                            result.append(oo.separator).append(oo.joiner.join(uValue));
                        }
                        haveU = true;
                    }
                    if ((key2 = (String)entry.getKey()).length() != 2 || key2.charAt(1) < 'a') continue;
                    String value2 = oo.joiner.join((Iterable)entry.getValue());
                    result.append(oo.separator).append(key2).append(oo.separator).append(value2);
                }
            } else {
                if (!haveAt) {
                    result.append('@');
                }
                for (Map.Entry<String, List<String>> extension : this.localeExtensions.entrySet()) {
                    if (needSep) {
                        result.append(";");
                    } else {
                        needSep = true;
                    }
                    String key3 = extension.getKey();
                    String string = oo.joiner.join((Iterable<? extends Object>)extension.getValue());
                    result.append(key3.toUpperCase(Locale.ROOT)).append('=').append(string.toUpperCase(Locale.ROOT));
                }
            }
        }
        if (extensionsAfterU != null) {
            result.append((CharSequence)extensionsAfterU);
        }
        if (extensionX != null) {
            result.append((CharSequence)extensionX);
        }
        return result.toString();
    }

    public static boolean isTKey(String key) {
        return key.length() == 2 && key.charAt(1) < 'a';
    }

    public boolean hasT() {
        for (String key : this.localeExtensions.keySet()) {
            if (!key.equals("t") && !LanguageTagParser.isTKey(key)) continue;
            return true;
        }
        return false;
    }

    public String toLSR() {
        Object result = this.language;
        if (this.script.length() != 0) {
            result = (String)result + "_" + this.script;
        }
        if (this.region.length() != 0) {
            result = (String)result + "_" + this.region;
        }
        return result;
    }

    public String toString(Set<Fields> selection) {
        Object result = this.language;
        if (selection.contains((Object)Fields.SCRIPT) && this.script.length() != 0) {
            result = (String)result + "_" + this.script;
        }
        if (selection.contains((Object)Fields.REGION) && this.region.length() != 0) {
            result = (String)result + "_" + this.region;
        }
        if (selection.contains((Object)Fields.VARIANTS) && this.variants.size() != 0) {
            for (String variant : this.variants) {
                result = (String)result + "_" + variant;
            }
        }
        return result;
    }

    public LanguageTagParser setLanguage(String language) {
        if (SEPARATORS.containsSome(language)) {
            String oldScript = this.script;
            String oldRegion = this.region;
            Set<String> oldVariants = this.variants;
            this.set(language);
            if (this.script.length() == 0) {
                this.script = oldScript;
            }
            if (this.region.length() == 0) {
                this.region = oldRegion;
            }
            if (oldVariants.size() != 0) {
                this.variants = oldVariants;
            }
        } else {
            this.language = language;
        }
        return this;
    }

    public LanguageTagParser setLocaleExtensions(Map<String, String> localeExtensions) {
        this.localeExtensions = this.expandMap(localeExtensions, 1, Integer.MAX_VALUE);
        return this;
    }

    public LanguageTagParser setVariants(Collection<String> newVariants) {
        for (String variant : newVariants) {
            if (this.isValidVariant(variant)) continue;
            throw new IllegalArgumentException("Illegal variant: " + variant);
        }
        this.variants.clear();
        this.variants.addAll(newVariants);
        return this;
    }

    public LanguageTagParser setExtensions(Map<String, String> newExtensions) {
        this.extensions = this.expandMap(newExtensions, 2, 8);
        return this;
    }

    public static String getSimpleParent(String s2) {
        int lastBar = s2.lastIndexOf(95);
        return lastBar >= 0 ? s2.substring(0, lastBar) : "";
    }

    private Map<String, List<String>> expandMap(Map<String, String> newLocaleExtensions, int minLength, int maxLength) {
        if (newLocaleExtensions.isEmpty()) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder<String, List<String>> result = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : newLocaleExtensions.entrySet()) {
            result.put(entry.getKey(), this.split(entry.getValue(), minLength, maxLength));
        }
        return result.build();
    }

    private List<String> split(String value, int minLength, int maxLength) {
        List<String> values = SPLIT_BAR.splitToList(value);
        for (String s2 : values) {
            if (s2.length() < minLength || s2.length() > maxLength) {
                throw new IllegalArgumentException("Illegal subtag length for: " + s2);
            }
            if (ALPHANUM.containsAll(s2)) continue;
            throw new IllegalArgumentException("Illegal locale character in: " + s2);
        }
        return values;
    }

    public String toString(Format format) {
        StringBuilder result = new StringBuilder();
        if (format == Format.structure) {
            result.append("[");
        }
        this.appendField(format, result, "language", this.language);
        this.appendField(format, result, "script", this.script);
        this.appendField(format, result, "region", this.region);
        this.appendField(format, result, "variants", this.variants);
        this.appendField(format, result, "extensions", this.extensions, new UnicodeSet(97, 115));
        this.appendField(format, result, "localeX", this.localeExtensions, null);
        this.appendField(format, result, "extensions", this.extensions, new UnicodeSet(118, 119, 121, 122));
        this.appendField(format, result, "extensions", this.extensions, new UnicodeSet(120, 120));
        if (format == Format.structure) {
            result.append("]");
        }
        return result.toString();
    }

    private void appendField(Format format, StringBuilder result, String fieldName, String fieldValue) {
        if (!fieldValue.isEmpty()) {
            if (result.length() > 1) {
                result.append(format.separator);
            }
            if (format == Format.structure) {
                result.append(fieldName).append("=");
            }
            result.append(fieldValue);
        }
    }

    private void appendFieldKey(Format format, StringBuilder result, String fieldName, String fieldValue) {
        result.append(format.separator).append(fieldName).append(format.separator2).append(fieldValue);
    }

    private void appendField(Format format, StringBuilder result, String fieldName, Collection<String> fieldValues) {
        if (!fieldValues.isEmpty()) {
            this.appendField(format, result, fieldName, Joiner.on(",").join(fieldValues));
        }
    }

    private void appendField(Format format, StringBuilder result, String fieldName, Map<String, List<String>> fieldValues, UnicodeSet match) {
        if (match == null && format != Format.structure) {
            List<String> tLang = fieldValues.get("t");
            List<String> uSpecial = fieldValues.get("u");
            boolean haveTLang = tLang != null;
            boolean haveUSpecial = uSpecial != null;
            boolean haveT = false;
            boolean haveU = false;
            StringBuilder result2 = new StringBuilder();
            for (Map.Entry<String, List<String>> entry : fieldValues.entrySet()) {
                String key = entry.getKey();
                if (key.length() < 2) continue;
                int lastChar = key.codePointBefore(key.length());
                if (lastChar < 97) {
                    if (!haveT) {
                        result.append(format.separator).append('t');
                        if (haveTLang) {
                            result.append(format.separator).append(Joiner.on(format.separator).join(tLang));
                            haveTLang = false;
                        }
                        haveT = true;
                    }
                    this.appendFieldKey(format, result, entry.getKey(), Joiner.on(format.separator).join((Iterable<? extends Object>)entry.getValue()));
                    continue;
                }
                if (!haveU) {
                    result2.append(format.separator).append('u');
                    if (haveUSpecial) {
                        result2.append(format.separator).append(Joiner.on(format.separator).join(uSpecial));
                        haveUSpecial = false;
                    }
                    haveU = true;
                }
                this.appendFieldKey(format, result2, entry.getKey(), Joiner.on(format.separator).join((Iterable<? extends Object>)entry.getValue()));
            }
            if (haveTLang) {
                result.append(format.separator).append('t').append(format.separator).append(Joiner.on(format.separator).join(tLang));
            }
            if (haveUSpecial) {
                result2.append(format.separator).append('u').append(format.separator).append(Joiner.on(format.separator).join(uSpecial));
            }
            result.append((CharSequence)result2);
        } else {
            for (Map.Entry<String, List<String>> entry : fieldValues.entrySet()) {
                if (match != null && !match.contains(entry.getKey())) continue;
                this.appendFieldKey(format, result, entry.getKey(), Joiner.on(format.separator).join((Iterable<? extends Object>)entry.getValue()));
            }
        }
    }

    public static enum Format {
        icu("_", "_"),
        bcp47("-", "-"),
        structure("; ", "=");

        public final String separator;
        public final String separator2;

        private Format(String separator, String separator2) {
            this.separator = separator;
            this.separator2 = separator2;
        }
    }

    public static enum Fields {
        LANGUAGE,
        SCRIPT,
        REGION,
        VARIANTS;

    }

    public static enum OutputOption {
        ICU('_'),
        ICU_LCVARIANT('_'),
        BCP47('-');

        final char separator;
        final Joiner joiner;

        private OutputOption(char separator) {
            this.separator = separator;
            this.joiner = Joiner.on(separator);
        }

        public Map<String, String> convert(Map<String, List<String>> mapToList) {
            if (mapToList.isEmpty()) {
                return Collections.emptyMap();
            }
            ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
            for (Map.Entry<String, List<String>> entry : mapToList.entrySet()) {
                builder.put(entry.getKey(), this.joiner.join((Iterable<? extends Object>)entry.getValue()));
            }
            return builder.build();
        }
    }

    public static enum Status {
        WELL_FORMED,
        VALID,
        CANONICAL,
        MINIMAL;

    }
}

