/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.Transliterator;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.BufferedReader;
import java.io.IOException;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CldrUtility;

public class TransliteratorUtilities {
    public static boolean DEBUG = false;
    private static final String BASE_RULES = ":: (hex-any/xml);:: (hex-any/xml10);'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; ";
    private static final String CONTENT_RULES = "'>' > '&gt;' ;";
    private static final String HTML_RULES = ":: (hex-any/xml);:: (hex-any/xml10);'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; '>' > '&gt;' ;'\"' > '&quot;' ; ";
    private static final String HTML_RULES_CONTROLS = ":: (hex-any/xml);:: (hex-any/xml10);'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; '>' > '&gt;' ;'\"' > '&quot;' ; :: [[:C:][:Z:][:whitespace:][:Default_Ignorable_Code_Point:]] hex/unicode ; ";
    private static final String HTML_RULES_ASCII = ":: (hex-any/xml);:: (hex-any/xml10);'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; '>' > '&gt;' ;'\"' > '&quot;' ; :: [[:C:][:^ASCII:]] any-hex/xml ; ";
    private static final String XML_RULES = ":: (hex-any/xml);:: (hex-any/xml10);'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; '>' > '&gt;' ;'\"' > '&quot;' ; '' > '&apos;' ; ";
    public static final Transliterator toXML = Transliterator.createFromRules("any-xml", ":: (hex-any/xml);:: (hex-any/xml10);'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; '>' > '&gt;' ;'\"' > '&quot;' ; '' > '&apos;' ; ", 0);
    public static final Transliterator fromXML = Transliterator.createFromRules("xml-any", ":: (hex-any/xml);:: (hex-any/xml10);'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; '>' > '&gt;' ;'\"' > '&quot;' ; '' > '&apos;' ; ", 1);
    public static final Transliterator toHTML = Transliterator.createFromRules("any-html", ":: (hex-any/xml);:: (hex-any/xml10);'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; '>' > '&gt;' ;'\"' > '&quot;' ; ", 0);
    public static final Transliterator toHTMLControl = Transliterator.createFromRules("any-html", ":: (hex-any/xml);:: (hex-any/xml10);'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; '>' > '&gt;' ;'\"' > '&quot;' ; :: [[:C:][:Z:][:whitespace:][:Default_Ignorable_Code_Point:]] hex/unicode ; ", 0);
    public static final Transliterator toHTMLAscii = Transliterator.createFromRules("any-html", ":: (hex-any/xml);:: (hex-any/xml10);'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; '>' > '&gt;' ;'\"' > '&quot;' ; :: [[:C:][:^ASCII:]] any-hex/xml ; ", 0);
    public static final Transliterator fromHTML = Transliterator.createFromRules("html-any", ":: (hex-any/xml);:: (hex-any/xml10);'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; '>' > '&gt;' ;'\"' > '&quot;' ; ", 1);

    public static void registerTransliteratorFromFile(String dir, String id) {
        try {
            String rid;
            String filename = ((String)id).replace('-', '_') + ".txt";
            String rules = TransliteratorUtilities.getFileContents(dir, filename);
            int pos = ((String)id).indexOf(45);
            if (pos < 0) {
                rid = (String)id + "-Any";
                id = "Any-" + (String)id;
            } else {
                rid = ((String)id).substring(pos + 1) + "-" + ((String)id).substring(0, pos);
            }
            Transliterator t = Transliterator.createFromRules((String)id, rules, 0);
            Transliterator.unregister((String)id);
            Transliterator.registerInstance(t);
            t = Transliterator.createFromRules(rid, rules, 1);
            Transliterator.unregister(rid);
            Transliterator.registerInstance(t);
            if (DEBUG) {
                System.out.println("Registered new Transliterator: " + (String)id + ", " + rid);
            }
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException("Can't open " + dir + ", " + (String)id, e);
        }
    }

    public static String getFileContents(String dir, String filename) throws IOException {
        String line;
        BufferedReader br = FileUtilities.openUTF8Reader(dir, filename);
        StringBuffer buffer = new StringBuffer();
        while ((line = br.readLine()) != null) {
            if (line.length() > 0 && line.charAt(0) == '\ufeff') {
                line = line.substring(1);
            }
            buffer.append(line).append("\r\n");
        }
        br.close();
        return buffer.toString();
    }

    public static Transliterator getTransliteratorFromFile(String ID, String file) {
        return TransliteratorUtilities.getTransliteratorFromFile(ID, file, 0);
    }

    public static Transliterator getTransliteratorFromFile(String ID, String file, int direction) {
        try {
            String line;
            BufferedReader br = CldrUtility.getUTF8Data(file);
            StringBuilder input = new StringBuilder();
            while ((line = br.readLine()) != null) {
                if (line.startsWith("\ufeff")) {
                    line = line.substring(1);
                }
                input.append(line);
                input.append('\n');
            }
            return Transliterator.createFromRules(ID, input.toString(), direction);
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException("Can't open transliterator file " + file, e);
        }
    }
}

