/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.test.SubmissionLocales;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.VoteResolver;

public abstract class VoterReportStatus<T> {
    public abstract ReportStatus getReportStatus(T var1, CLDRLocale var2);

    public Map<ReportAcceptability, Set<Integer>> updateResolver(CLDRLocale l, ReportId r, Set<T> userList, VoteResolver<ReportAcceptability> res) {
        HashMap<ReportAcceptability, Set<Integer>> statistics = new HashMap<ReportAcceptability, Set<Integer>>();
        res.clear();
        res.setBaileyValue(null);
        userList.forEach(id -> {
            ReportStatus rs = this.getReportStatus(id, l);
            ReportAcceptability acc = rs.getAcceptability(r);
            if (acc != null) {
                res.add(acc, (Integer)id, null, rs.getDate());
                statistics.computeIfAbsent(acc, k -> new HashSet()).add((Integer)id);
            }
        });
        return statistics;
    }

    public static class ReportStatus {
        public EnumSet<ReportId> completed = EnumSet.noneOf(ReportId.class);
        public EnumSet<ReportId> acceptable = EnumSet.noneOf(ReportId.class);
        public Date date = null;

        public ReportStatus mark(ReportId r, boolean asComplete, boolean asAcceptable) {
            return this.mark(r, asComplete, asAcceptable, null);
        }

        public ReportStatus mark(ReportId r, boolean asComplete, boolean asAcceptable, Date date) {
            if (!asComplete && asAcceptable) {
                throw new IllegalArgumentException("Cannot be !complete&&acceptable");
            }
            if (asComplete) {
                this.completed.add(r);
            } else {
                this.completed.remove((Object)r);
            }
            if (asAcceptable) {
                this.acceptable.add(r);
            } else {
                this.acceptable.remove((Object)r);
            }
            this.date = date;
            return this;
        }

        public Date getDate() {
            return this.date;
        }

        public ReportAcceptability getAcceptability(ReportId r) {
            return ReportAcceptability.fromPair(this.completed.contains((Object)r), this.acceptable.contains((Object)r));
        }
    }

    public static enum ReportAcceptability {
        notAcceptable,
        acceptable;


        boolean isAcceptable() {
            return this == acceptable;
        }

        static ReportAcceptability fromPair(boolean isComplete, boolean isAcceptable) {
            if (isAcceptable) {
                return acceptable;
            }
            if (isComplete) {
                return notAcceptable;
            }
            return null;
        }
    }

    public static enum ReportId {
        datetime,
        zones,
        compact,
        personnames;


        public boolean isAvailable() {
            return SubmissionLocales.getReportsAvailableInLimited().contains((Object)this);
        }

        public static Set<ReportId> getReportsAvailable() {
            return SubmissionLocales.getReportsAvailableInLimited();
        }
    }
}

