/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import org.unicode.cldr.draft.keyboard.ModifierKey;
import org.unicode.cldr.draft.keyboard.ModifierKeySimplifier;

public final class ModifierKeyCombination
implements Comparable<ModifierKeyCombination> {
    public static final ModifierKeyCombination BASE = ModifierKeyCombination.ofOnKeys(ImmutableSet.of());
    private final ImmutableSet<ModifierKey> onKeys;
    private final ImmutableSet<ModifierKey> offKeys;

    private ModifierKeyCombination(ImmutableSet<ModifierKey> onKeys, ImmutableSet<ModifierKey> offKeys) {
        this.onKeys = Preconditions.checkNotNull(onKeys);
        this.offKeys = Preconditions.checkNotNull(offKeys);
    }

    public static ModifierKeyCombination ofOnKeys(Set<ModifierKey> onKeys) {
        return ModifierKeyCombination.ofOnAndDontCareKeys(ImmutableSet.copyOf(onKeys), ImmutableSet.of());
    }

    public static ModifierKeyCombination ofOnAndDontCareKeys(Set<ModifierKey> onKeys, Set<ModifierKey> dontCareKeys) {
        Preconditions.checkArgument(Sets.intersection(onKeys, dontCareKeys).size() == 0, "On keys and don't care keys must be disjoint");
        return ModifierKeySimplifier.simplifyInput(ImmutableSet.copyOf(onKeys), ImmutableSet.copyOf(dontCareKeys));
    }

    static ModifierKeyCombination of(ImmutableSet<ModifierKey> onKeys, ImmutableSet<ModifierKey> offKeys) {
        return new ModifierKeyCombination(onKeys, offKeys);
    }

    public ImmutableSet<ModifierKey> onKeys() {
        return this.onKeys;
    }

    public ImmutableSet<ModifierKey> offKeys() {
        return this.offKeys;
    }

    public boolean isBase() {
        return this.onKeys.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ModifierKeyCombination) {
            ModifierKeyCombination other = (ModifierKeyCombination)o;
            return this.onKeys.equals(other.onKeys) && this.offKeys.equals(other.offKeys);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.onKeys, this.offKeys);
    }

    public String toString() {
        return ModifierKeySimplifier.simplifyToString(this);
    }

    @Override
    public int compareTo(ModifierKeyCombination o) {
        ImmutableSortedSet<ModifierKey> sortedOnKeys2;
        ImmutableSortedSet<ModifierKey> sortedOnKeys1 = ImmutableSortedSet.copyOf(this.onKeys);
        int result = ModifierKeyCombination.compareSetsDescending(sortedOnKeys1, sortedOnKeys2 = ImmutableSortedSet.copyOf(o.onKeys));
        if (result == 0) {
            ImmutableSortedSet<ModifierKey> sortedOffKeys1 = ImmutableSortedSet.copyOf(this.offKeys);
            ImmutableSortedSet<ModifierKey> sortedOffKeys2 = ImmutableSortedSet.copyOf(o.offKeys);
            return -1 * ModifierKeyCombination.compareSetsDescending(sortedOffKeys1, sortedOffKeys2);
        }
        return result;
    }

    private static int compareSetsDescending(ImmutableSortedSet<ModifierKey> set1, ImmutableSortedSet<ModifierKey> set2) {
        Iterator iterator1 = set1.iterator();
        Iterator iterator2 = set2.iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            ModifierKey modifierKey2;
            ModifierKey modifierKey1 = (ModifierKey)((Object)iterator1.next());
            if (modifierKey1.compareTo(modifierKey2 = (ModifierKey)((Object)iterator2.next())) < 0) {
                return 1;
            }
            if (modifierKey1.compareTo(modifierKey2) <= 0) continue;
            return -1;
        }
        return set1.size() - set2.size();
    }
}

