/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard.out;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Writer;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

final class XmlWriter {
    private final XMLStreamWriter writer;
    private int depth = 0;

    private XmlWriter(XMLStreamWriter writer) {
        this.writer = Preconditions.checkNotNull(writer);
    }

    static XmlWriter newXmlWriter(Writer writer) {
        XMLStreamWriter xmlStreamWriter;
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        try {
            xmlStreamWriter = outputFactory.createXMLStreamWriter(writer);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return new XmlWriter(xmlStreamWriter);
    }

    XmlWriter startDocument(String doctype, String dtdLocation) {
        try {
            this.writer.writeStartDocument("UTF-8", "1.0");
            this.writer.writeCharacters("\n");
            this.writer.writeDTD("<!DOCTYPE " + doctype + " SYSTEM \"" + dtdLocation + "\">");
            this.writer.writeCharacters("\n");
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    XmlWriter endDocument() {
        Preconditions.checkState(this.depth == 0, "Cannot close document with unclosed elements");
        try {
            this.writer.writeEndDocument();
            this.writer.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    XmlWriter startElement(String name) {
        return this.startElement(name, ImmutableMap.of());
    }

    XmlWriter startElement(String name, Map<String, ?> attributeToValue) {
        this.addIndent();
        try {
            this.writer.writeStartElement(name);
            for (Map.Entry<String, ?> entry : attributeToValue.entrySet()) {
                this.writer.writeAttribute(entry.getKey(), "" + entry.getValue());
            }
            this.writer.writeCharacters("\n");
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        ++this.depth;
        return this;
    }

    XmlWriter endElement() {
        --this.depth;
        this.addIndent();
        try {
            this.writer.writeEndElement();
            this.writer.writeCharacters("\n");
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    XmlWriter addElement(String name, Map<String, ?> attributeToValue) {
        return this.addElement(name, attributeToValue, "");
    }

    XmlWriter addElement(String name, Map<String, ?> attributeToValue, String comment) {
        this.addIndent();
        try {
            this.writer.writeEmptyElement(name);
            for (Map.Entry<String, ?> entry : attributeToValue.entrySet()) {
                this.writer.writeAttribute(entry.getKey(), "" + entry.getValue());
            }
            if (!comment.isEmpty()) {
                this.writer.writeCharacters(" ");
                this.writer.writeComment(" " + comment + " ");
            }
            this.writer.writeCharacters("\n");
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    private void addIndent() {
        for (int i = 0; i < this.depth; ++i) {
            try {
                this.writer.writeCharacters("\t");
                continue;
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

