/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu;

import com.ibm.icu.dev.tool.UOption;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.unicode.cldr.util.LDMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class FixEras {
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int DESTDIR = 2;
    private static final int SOURCEDIR = 3;
    private static final UOption[] options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.DESTDIR(), UOption.SOURCEDIR()};
    private String destdir = null;
    private String sourcedir = null;

    public static void main(String[] args) {
        FixEras cnv = new FixEras();
        cnv.processArgs(args);
    }

    private void usage() {
        System.out.println("\nUsage: FixEras [OPTIONS] [XPATH1] [XPATH2]\n\nThis program is used to extract nodes from extract LDML file and merge \nthe extracted nodes with the main LDML file\nPlease refer to the following options. Options are not case sensitive.\nOptions:\n-s or --sourcedir          source directory followed by the path.\n-d or --destination        destination directory, followed by the path, default is current directory.\n-h or -? or --help         this usage text.\nexample: com.ibm.icu.dev.tool.cldr.FixErs ar.xml\n");
        System.exit(-1);
    }

    private void processArgs(String[] args) {
        int remainingArgc = 0;
        try {
            remainingArgc = UOption.parseArgs(args, options);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.toString());
            e.printStackTrace();
            this.usage();
        }
        if (args.length == 0 || FixEras.options[0].doesOccur || FixEras.options[1].doesOccur) {
            this.usage();
        }
        if (FixEras.options[2].doesOccur) {
            this.destdir = FixEras.options[2].value;
        }
        if (FixEras.options[3].doesOccur) {
            this.sourcedir = FixEras.options[3].value;
        }
        if (this.destdir == null) {
            throw new RuntimeException("Destination not specified");
        }
        if (remainingArgc < 1) {
            this.usage();
            System.exit(-1);
        }
        for (int i = 0; i < remainingArgc; ++i) {
            try {
                Object sourcefile = null;
                String file = args[i];
                sourcefile = this.sourcedir != null ? this.sourcedir + "/" + file : file;
                Document maindoc = LDMLUtilities.parse((String)sourcefile, false);
                System.out.println("INFO: Fixing eras of " + file);
                this.fixEras(maindoc);
                maindoc.normalize();
                String destfile = this.destdir + "/" + file;
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(destfile), "UTF-8");
                PrintWriter pw = new PrintWriter(writer);
                LDMLUtilities.printDOMTree(maindoc, pw, "http://www.unicode.org/cldr/dtd/1.3/ldml.dtd", null);
                writer.flush();
                writer.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }

    private void fixEras(Document doc) {
        Node[] nodes = LDMLUtilities.getElementsByTagName(doc, "era");
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                NamedNodeMap attr = nodes[i].getAttributes();
                Node type = attr.getNamedItem("type");
                if (type == null) continue;
                String val = type.getNodeValue();
                int j = Integer.parseInt(val);
                if (j > 0) {
                    --j;
                }
                type.setNodeValue(Integer.toString(j));
            }
        }
    }
}

