/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.UnicodeSet;
import java.util.ArrayList;
import java.util.List;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.XPathParts;
import org.unicode.cldr.util.personname.PersonNameFormatter;

public class CheckPersonNames
extends CheckCLDR {
    static final String MISSING = CldrUtility.NO_INHERITANCE_MARKER;
    boolean isRoot = false;
    boolean hasRootParent = false;
    String initialSeparator = " ";
    private UnicodeSet allowedCharacters;
    private boolean spacesNeededInNames;
    static final UnicodeSet BASE_ALLOWED = new UnicodeSet("[\\p{sc=Common}\\p{sc=Inherited}-\\p{N}-[\u276e\u276f\u2205<>\u22050]]").freeze();
    static final UnicodeSet HANI = new UnicodeSet("[\\p{sc=Hani}]").freeze();
    static final UnicodeSet KORE = new UnicodeSet("[\\p{sc=Hang}]").addAll(HANI).freeze();
    static final UnicodeSet JPAN = new UnicodeSet("[\\p{sc=Kana}\\p{sc=Hira}]").addAll(HANI).freeze();

    @Override
    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        String localeId = cldrFileToCheck.getLocaleID();
        this.isRoot = localeId.equals("root");
        this.hasRootParent = "root".equals(LocaleIDParser.getParent(localeId));
        String script = new LikelySubtags().getLikelyScript(localeId);
        this.allowedCharacters = new UnicodeSet(BASE_ALLOWED).addAll(this.getUnicodeSetForScript(script)).freeze();
        this.spacesNeededInNames = !PersonNameFormatter.LocaleSpacingData.getInstance().getScriptsNotNeedingSpacesInNames().contains(script);
        String initialPatternSequence = cldrFileToCheck.getStringValue("//ldml/personNames/initialPattern[@type=\"initialSequence\"]");
        this.initialSeparator = MessageFormat.format(initialPatternSequence, "", "");
        return super.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
    }

    public UnicodeSet getUnicodeSetForScript(String script) {
        switch (script) {
            case "Jpan": {
                return JPAN;
            }
            case "Kore": {
                return KORE;
            }
            case "Hant": 
            case "Hans": {
                return HANI;
            }
        }
        return new UnicodeSet("[\\p{sc=" + script + "}]");
    }

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (this.isRoot || !path.startsWith("//ldml/personNames/")) {
            return this;
        }
        XPathParts parts = XPathParts.getFrozenInstance(path);
        switch (parts.getElement(2)) {
            case "personName": {
                PersonNameFormatter.NamePattern namePattern = PersonNameFormatter.NamePattern.from(0, value);
                ArrayList<List<String>> failures = namePattern.findInitialFailures(this.initialSeparator);
                for (List<String> row : failures) {
                    String previousField = row.get(0);
                    String intermediateLiteral = row.get(1);
                    String followingField = row.get(1);
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalCharactersInPattern).setMessage("The gap between {0} and {2} must be the same as the pattern-initialSequence, =\u201c{1}\u201d", previousField, intermediateLiteral, followingField));
                }
                break;
            }
            case "foreignSpaceReplacement": {
                if (!this.spacesNeededInNames || " ".equals(value)) break;
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalCharactersInPattern).setMessage("ForeignSpaceReplacement must be space if script requires spaces."));
                break;
            }
            case "sampleName": {
                if (value == null) break;
                if (!this.allowedCharacters.containsAll(value) && !value.equals(CldrUtility.NO_INHERITANCE_MARKER)) {
                    UnicodeSet bad = new UnicodeSet().addAll(value).removeAll(this.allowedCharacters);
                    CheckCLDR.CheckStatus.Type mainType = this.getPhase() != CheckCLDR.Phase.BUILD ? CheckCLDR.CheckStatus.errorType : CheckCLDR.CheckStatus.warningType;
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(mainType).setSubtype(CheckCLDR.CheckStatus.Subtype.badSamplePersonName).setMessage("Illegal characters in sample name: " + bad.toPattern(false)));
                    break;
                }
                if (this.getCldrFileToCheck().getUnresolved().getStringValue(path) == null) break;
                String message = null;
                PersonNameFormatter.SampleType sampleType = PersonNameFormatter.SampleType.valueOf(parts.getAttributeValue(2, "item"));
                String modifiedField = parts.getAttributeValue(3, "type");
                boolean isMissingInUnresolved = value.equals(MISSING) || value.equals(CldrUtility.INHERITANCE_MARKER);
                PersonNameFormatter.Optionality optionality = sampleType.getOptionality(modifiedField);
                if (isMissingInUnresolved) {
                    if (optionality == PersonNameFormatter.Optionality.required) {
                        message = "This value must not be empty (" + MISSING + ")";
                    }
                } else if (optionality == PersonNameFormatter.Optionality.disallowed) {
                    message = "This value must be empty (" + MISSING + ")";
                } else if (modifiedField.equals("surname2")) {
                    String surname = this.getCldrFileToCheck().getStringValue(path).replace("surname2", "surname");
                    String surnameCore = this.getCldrFileToCheck().getStringValue(path).replace("surname2", "surname-core");
                    if (surname.equals(MISSING) && surnameCore.equals(MISSING)) {
                        message = "The value for '" + modifiedField + "' must not be empty (" + MISSING + ") unless 'surname2' is.";
                    }
                }
                if (message == null) break;
                this.getPhase();
                CheckCLDR.CheckStatus.Type mainType = this.getPhase() != CheckCLDR.Phase.BUILD ? CheckCLDR.CheckStatus.errorType : CheckCLDR.CheckStatus.warningType;
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(mainType).setSubtype(CheckCLDR.CheckStatus.Subtype.badSamplePersonName).setMessage(message));
            }
        }
        return this;
    }
}

