/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CoverageLevel2;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.VoterReportStatus;

public final class SubmissionLocales {
    public static final Set<String> CLDR_LOCALES = StandardCodes.make().getLocaleToLevel(Organization.cldr).keySet();
    public static final Set<String> SPECIAL_ORG_LOCALES = StandardCodes.make().getLocaleToLevel(Organization.special).keySet();
    public static Set<String> HIGH_LEVEL_LOCALES = ImmutableSet.of("chr", "gd", "fo", "kok", "pcm", "ha", new String[]{"hsb", "dsb", "yue_Hans", "to"});
    public static final Set<String> CLDR_OR_HIGH_LEVEL_LOCALES = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(CLDR_LOCALES)).addAll(HIGH_LEVEL_LOCALES)).build();
    private static final Set<VoterReportStatus.ReportId> LIMITED_SUBMISSION_REPORTS = Collections.unmodifiableSet(EnumSet.of(VoterReportStatus.ReportId.personnames));
    public static final Set<String> TC_ORG_LOCALES;
    public static final boolean ONLY_GRAMMAR_LOCALES = false;
    public static final Set<String> LOCALES_FOR_LIMITED;
    public static Set<String> ALLOW_ALL_PATHS_BASIC;
    public static Set<String> LOCALES_ALLOWED_IN_LIMITED;
    public static final Pattern PATHS_ALLOWED_IN_LIMITED;
    private static final boolean DEBUG_REGEX = false;

    public static boolean allowEvenIfLimited(String localeString, String path, boolean isError, boolean isMissing) {
        if (isError) {
            return true;
        }
        if (ALLOW_ALL_PATHS_BASIC.contains(localeString) && SubmissionLocales.isPathBasicOrLess(localeString, path)) {
            return true;
        }
        if (!LOCALES_ALLOWED_IN_LIMITED.contains(localeString)) {
            return false;
        }
        if (isMissing && TC_ORG_LOCALES.contains(localeString)) {
            return true;
        }
        return SubmissionLocales.pathAllowedInLimitedSubmission(path);
    }

    private static boolean isPathBasicOrLess(String localeString, String path) {
        return SubmissionLocalesCache.getCoverageLevel(localeString, path).compareTo(Level.BASIC) <= 0;
    }

    public static boolean pathAllowedInLimitedSubmission(String path) {
        if (PATHS_ALLOWED_IN_LIMITED == null) {
            return false;
        }
        Matcher matcher = PATHS_ALLOWED_IN_LIMITED.matcher(path);
        boolean result = matcher.lookingAt();
        return result;
    }

    public static Set<VoterReportStatus.ReportId> getReportsAvailableInLimited() {
        return LIMITED_SUBMISSION_REPORTS;
    }

    static {
        HashSet<String> temp = new HashSet<String>(CLDR_OR_HIGH_LEVEL_LOCALES);
        LOCALES_FOR_LIMITED = ImmutableSortedSet.copyOf(temp);
        HashSet<String> temp2 = new HashSet<String>(CLDR_LOCALES);
        temp2.removeAll(SPECIAL_ORG_LOCALES);
        TC_ORG_LOCALES = ImmutableSortedSet.copyOf(temp2);
        ALLOW_ALL_PATHS_BASIC = ImmutableSet.of("apc", "lmo", "pap", "rif");
        LOCALES_ALLOWED_IN_LIMITED = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(LOCALES_FOR_LIMITED)).addAll(ALLOW_ALL_PATHS_BASIC)).build();
        PATHS_ALLOWED_IN_LIMITED = Pattern.compile("//ldml/(personNames/.*|localeDisplayNames/territories/territory\\[@type=\"TR\"\\].*|dates/timeZoneNames/zone[@type=\"America/Ciudad_Juarez\"]/exemplarCity)");
    }

    private static final class SubmissionLocalesCache {
        public static SubmissionLocalesCache INSTANCE = new SubmissionLocalesCache();
        private LoadingCache<String, CoverageLevel2> covs = CacheBuilder.newBuilder().build(new CacheLoader<String, CoverageLevel2>(){

            @Override
            public CoverageLevel2 load(String key) throws Exception {
                return CoverageLevel2.getInstance(SupplementalDataInfo.getInstance(), key);
            }
        });

        SubmissionLocalesCache() {
        }

        public static Enum<Level> getCoverageLevel(String localeString, String path) {
            try {
                return SubmissionLocalesCache.INSTANCE.covs.get(localeString).getLevel(path);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(String.format("Could not fetch coverage for %s:%s", localeString, path), e);
            }
        }
    }
}

