/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.text.ListFormatter;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.unicode.cldr.tool.ChartPersonName;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.tool.ToolUtilities;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.VoterReportStatus;

public abstract class Chart {
    public static final CLDRConfig CONFIG = CLDRConfig.getInstance();
    public static final SupplementalDataInfo SDI = CONFIG.getSupplementalDataInfo();
    public static final CLDRFile ENGLISH = CONFIG.getEnglish();
    public static final String LS = System.lineSeparator();
    public static final String PREV_CHART_VERSION_DIRECTORY = ToolConstants.getBaseDirectory(ToolConstants.PREV_CHART_VERSION);
    public static final String CHART_VERSION_DIRECTORY = ToolConstants.getBaseDirectory(ToolConstants.CHART_VERSION);
    public static final String GITHUB_ROOT = "https://github.com/unicode-org/cldr/blob/main/";
    public static final String LDML_SPEC = "https://unicode.org/reports/tr35/";

    public static String dataScrapeMessage(String specPart, String testFile, String ... dataFiles) {
        String dataFileList = dataFiles.length == 0 ? null : ListFormatter.getInstance(ULocale.ENGLISH).format(Arrays.asList(dataFiles).stream().map(dataFile -> Chart.dataFileLink(dataFile)).collect(Collectors.toSet()));
        return "<p><b>Warning:</b> Do not scrape this chart for production data.\nInstead, for the meaning of the fields and data consult the " + Chart.ldmlSpecLink(specPart) + (String)(dataFileList == null ? "" : ", and for machine-readable source data, access " + dataFileList) + (String)(testFile == null ? "" : ", and for test data, access " + Chart.dataFileLink(testFile)) + ".</p>\n";
    }

    private static String dataFileLink(String dataFile) {
        return "<a href='https://github.com/unicode-org/cldr/blob/main/" + dataFile + "' target='" + dataFile + "'>" + dataFile + "</a>";
    }

    public static String ldmlSpecLink(String specPart) {
        return "<a href='https://unicode.org/reports/tr35/" + (specPart == null ? "" : specPart) + "' target='units.xml'>LDML specification</a>";
    }

    public String getFileName() {
        return null;
    }

    public String getExplanation() {
        return null;
    }

    public boolean getShowDate() {
        return true;
    }

    public abstract String getDirectory();

    public abstract String getTitle();

    public void writeContents(FormattedFileWriter pw) throws IOException {
        this.writeContents(pw.getStringWriter());
    }

    public void writeContents(Writer pw) throws IOException {
        this.writeContents(pw, CLDRConfig.getInstance().getCldrFactory());
    }

    public void writeContents(OutputStream output, Factory factory) throws IOException {
        try (OutputStreamWriter w = new OutputStreamWriter(output);){
            this.writeContents(w, factory);
        }
    }

    public void writeContents(Writer pw, Factory factory) throws IOException {
        throw new IllegalArgumentException("Not implemented yet");
    }

    public final void writeChart(FormattedFileWriter.Anchors anchors) {
        try (FormattedFileWriter x = new FormattedFileWriter(this.getFileName(), this.getTitle(), this.getExplanation(), anchors);){
            x.setDirectory(this.getDirectory());
            x.setShowDate(this.getShowDate());
            this.writeContents(x);
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    public static String getTsvDir(String targetDir, String topicName) {
        String target = targetDir.replaceAll(topicName, "tsv");
        if (target.equals(targetDir)) {
            throw new IllegalArgumentException("Can't make TSV directory from " + targetDir);
        }
        return target;
    }

    public String getFixLinkFromPath(CLDRFile cldrFile, String path) {
        String result = PathHeader.getLinkedView(CLDRConfig.getInstance().urls(), cldrFile, path);
        return result == null ? "" : result;
    }

    public static Chart forReport(VoterReportStatus.ReportId report, String locale) {
        switch (report) {
            case personnames: {
                return new ChartPersonName(locale);
            }
        }
        return null;
    }

    public static enum AnalyticsID {
        CLDR("G-BPN1D3SEJM"),
        ICU("G-06PL1DM20S"),
        ICU_GUIDE("UA-7670256-1"),
        UNICODE("G-GC4HXC4GVQ"),
        UNICODE_UTILITY("G-0M7Q5QLZPV");

        public final String id;

        private AnalyticsID(String id) {
            this.id = id;
        }

        public String getScript() {
            return AnalyticsHelper.INSTANCE.str.replaceAll("TAG_ID", this.id);
        }
    }

    private static final class AnalyticsHelper {
        private static final AnalyticsHelper INSTANCE = new AnalyticsHelper();
        public final String str = ToolUtilities.getUTF8Data("analytics.html").lines().collect(Collectors.joining("\n"));

        AnalyticsHelper() {
        }
    }
}

