/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.unicode.cldr.util.CLDRTool;

@CLDRTool(alias="main", description="The 'main' class invoked when java -jar or double-clicking the jar.", hidden="Hidden so as not to list itself", url="http://cldr.unicode.org/tools/")
class Main {
    private static final String CLASS_SUFFIX = ".class";
    private static final String MAIN = "main";
    private static final boolean DEBUG = false;

    Main() {
    }

    public static void main(String[] args) throws Throwable {
        if (args.length == 0) {
            Main.printUsage();
            Main.listClasses(false);
        } else if (args.length == 1 && args[0].equals("-l")) {
            Main.listClasses(true);
        } else {
            String mainClass = args[0];
            String[] args2 = new String[args.length - 1];
            System.arraycopy(args, 1, args2, 0, args2.length);
            Class<?> c = Main.findMainClass(mainClass);
            if (c == Main.class) {
                throw new IllegalArgumentException("Main doesn\u2019t need to invoke Main.");
            }
            System.err.println(">> " + c.getName());
            Main.tryCurrentDirAsCldrDir();
            Main.invoke(c, args2);
        }
    }

    public static void invoke(Class<?> c, String[] args2) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method main = Main.getStaticMain(c);
        if (main == null) {
            throw new NullPointerException("No static main() found in " + c.getSimpleName());
        }
        main.invoke(null, new Object[]{args2});
    }

    public static Class<?> findMainClass(String mainClass) throws IllegalArgumentException, IOException {
        Class<?> c = null;
        try {
            c = Class.forName(mainClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (c == null) {
            c = Main.findMainClass(mainClass, Main.getMainClassList());
        }
        if (c == null) {
            throw new IllegalArgumentException("Class not found and not an alias: " + mainClass);
        }
        return c;
    }

    public static void tryCurrentDirAsCldrDir() {
        try {
            if (System.getProperty("CLDR_DIR") == null && new File("./common/main/root.xml").exists()) {
                System.err.println("Note: CLDR_DIR was unset but you seem to be in a CLDR directory. Setting -DCLDR_DIR=.");
                System.setProperty("CLDR_DIR", ".");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static void printUsage() {
        System.out.println("Usage:  [ -l | [class|alias] args ...]");
        System.out.println("Example usage:");
        System.out.println(" (java -jar cldr-code.jar ) -l          -- prints a list of ALL tool/util/test classes with a 'main()' function.");
        System.out.println(" (java -jar cldr-code.jar ) org.unicode.cldr.util.XMLValidator  somefile.xml ...");
        System.out.println(" (java -jar cldr-code.jar ) validate  somefile.xml ...");
        System.out.println("For more info: http://cldr.unicode.org/tools/");
        System.out.println("CLDRFile.GEN_VERSION=43");
        System.out.println("(Use the -l option to list hidden/undocumented tools)");
        System.out.println();
    }

    private static void listClasses(boolean includeHidden) throws IOException {
        for (ClassEntry e : Main.getMainClassList()) {
            if (!includeHidden && e.isHidden()) continue;
            CLDRTool annotation = e.getAnnotation();
            if (annotation != null) {
                System.out.println(e.alias() + " - " + annotation.description());
                if (annotation.url().length() > 0) {
                    System.out.println("   <" + annotation.url() + ">");
                } else {
                    System.out.println("   <http://cldr.unicode.org/tools/" + annotation.alias() + ">");
                }
                if (e.isHidden()) {
                    System.out.println("   HIDDEN: " + annotation.hidden());
                }
            } else {
                System.out.println(e.name() + " - (no @CLDRTool annotation)");
            }
            System.out.println(" = " + e.fullName());
        }
    }

    private static Class<?> findMainClass(String mainClass, Set<ClassEntry> mainClassList) {
        for (ClassEntry e : mainClassList) {
            if (!mainClass.equalsIgnoreCase(e.name()) && !mainClass.equalsIgnoreCase(e.alias())) continue;
            return e.theClass;
        }
        return null;
    }

    public static Set<ClassEntry> getMainClassList() throws IOException, FileNotFoundException {
        JarEntry je;
        TreeSet<ClassEntry> theList = new TreeSet<ClassEntry>();
        JarInputStream jis = Main.getJarInputStream();
        ClassLoader classLoader = Main.class.getClassLoader();
        if (jis == null) {
            throw new NullPointerException("could not get Jar InputStream");
        }
        while ((je = jis.getNextJarEntry()) != null) {
            String className;
            String name = je.getName();
            if (!Main.inOuterClass(name) || !Main.isCldrClassName(className = Main.filenameToClassName(name))) continue;
            try {
                Class<?> c = Class.forName(className, false, classLoader);
                if (Main.getStaticMain(c) == null) continue;
                theList.add(new ClassEntry(c));
            }
            catch (ClassNotFoundException | NoClassDefFoundError | NoSuchMethodException throwable) {}
        }
        return theList;
    }

    public static boolean isCldrClassName(String className) {
        return className.startsWith("org.unicode.cldr");
    }

    public static Method getStaticMain(Class<?> c) throws NoSuchMethodException {
        return c.getMethod(MAIN, String[].class);
    }

    public static String filenameToClassName(String name) {
        return name.substring(0, name.length() - CLASS_SUFFIX.length()).replaceAll("/", ".");
    }

    public static boolean inOuterClass(String name) {
        return name.endsWith(CLASS_SUFFIX) && !name.contains("$");
    }

    public static JarInputStream getJarInputStream() throws IOException, FileNotFoundException {
        URL url = Main.class.getProtectionDomain().getCodeSource().getLocation();
        if (!url.getPath().endsWith(".jar")) {
            System.out.println("(Not inside a .jar file - no listing available.)");
            return null;
        }
        JarInputStream jis = new JarInputStream(new FileInputStream(url.getPath()));
        Object je = null;
        return jis;
    }

    public static class ClassEntry
    implements Comparable<ClassEntry> {
        public Class<?> theClass;
        public CLDRTool annotation;

        @Override
        public int compareTo(ClassEntry o) {
            return this.theClass.getSimpleName().compareTo(o.theClass.getSimpleName());
        }

        public ClassEntry(Class<?> c) {
            this.theClass = c;
            this.annotation = c.getAnnotation(CLDRTool.class);
        }

        public CLDRTool getAnnotation() {
            return this.annotation;
        }

        public boolean isHidden() {
            return this.annotation == null || !this.annotation.hidden().isEmpty();
        }

        public String name() {
            return this.theClass.getSimpleName();
        }

        String alias() {
            if (this.annotation != null) {
                return this.annotation.alias();
            }
            return "";
        }

        private String fullName() {
            return this.theClass.getName();
        }
    }
}

