/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.Row;
import com.ibm.icu.text.StringTransform;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

public class LanguageTagCanonicalizer
implements StringTransform {
    private static final SupplementalDataInfo info = SupplementalDataInfo.getInstance();
    private static final LikelySubtags LIKELY_FAVOR_SCRIPT = new LikelySubtags(info.getLikelySubtags());
    private static final LikelySubtags LIKELY_FAVOR_REGION = new LikelySubtags(info.getLikelySubtags()).setFavorRegion(true);
    private static final Map<String, Map<String, Row.R2<List<String>, String>>> ALIASES = info.getLocaleAliasInfo();
    private final LikelySubtags likely;
    private final LanguageTagParser ltp1 = new LanguageTagParser();
    private final LanguageTagParser ltp2 = new LanguageTagParser();

    public LanguageTagCanonicalizer() {
        this(StandardCodes.LstrType.script);
    }

    public LanguageTagCanonicalizer(boolean favorRegion) {
        this(favorRegion ? StandardCodes.LstrType.region : StandardCodes.LstrType.script);
    }

    public LanguageTagCanonicalizer(StandardCodes.LstrType lstrType) {
        switch (lstrType) {
            case region: {
                this.likely = LIKELY_FAVOR_REGION;
                break;
            }
            case script: {
                this.likely = LIKELY_FAVOR_SCRIPT;
                break;
            }
            default: {
                this.likely = null;
            }
        }
    }

    @Override
    public synchronized String transform(String locale) {
        return this.transform(locale, LanguageTagParser.OutputOption.ICU_LCVARIANT);
    }

    public synchronized String transform(String locale, LanguageTagParser.OutputOption oo) {
        this.ltp1.set(locale);
        this.copyFields2(LanguageTagField.language, this.getReplacement(LanguageTagField.language, LanguageTagField.language.get(this.ltp1), locale));
        this.copyFields2(LanguageTagField.script, this.getReplacement(LanguageTagField.script, LanguageTagField.script.get(this.ltp1), locale));
        this.copyFields2(LanguageTagField.region, this.getReplacement(LanguageTagField.region, LanguageTagField.region.get(this.ltp1), locale));
        List<String> originalVariants = this.ltp1.getVariants();
        if (originalVariants.size() != 0) {
            TreeSet<String> newVariants = new TreeSet<String>();
            for (String item : originalVariants) {
                String replacement = this.getReplacement(LanguageTagField.variant, item, locale);
                if (replacement == null) {
                    newVariants.add(item);
                    continue;
                }
                this.copyFields2(LanguageTagField.variant, replacement);
                List<String> otherVariants = this.ltp2.getVariants();
                newVariants.addAll(otherVariants);
            }
            this.ltp1.setVariants(newVariants);
        }
        String result = this.ltp1.toString(oo);
        if ("und".equals(this.ltp1.getLanguage())) {
            return result;
        }
        if (this.likely == null) {
            return result;
        }
        String likelyMin = this.likely.minimize(result, oo);
        return likelyMin == null ? result : likelyMin;
    }

    private String getReplacement(LanguageTagField tagField, String field, String languageTag) {
        String newField = null;
        List<String> list = tagField.getReplacements(field);
        if (list.size() != 0) {
            String max;
            LanguageTagParser x;
            String region;
            newField = list.get(0);
            if (list.size() > 1 && tagField == LanguageTagField.region && list.contains(region = (x = new LanguageTagParser().set(languageTag).setRegion("")).set(max = LIKELY_FAVOR_REGION.maximize(x.toString())).getRegion())) {
                newField = region;
            }
        }
        return newField;
    }

    private void copyFields2(LanguageTagField mainField, String otherField) {
        if (otherField == null) {
            return;
        }
        this.ltp2.set((String)(mainField == LanguageTagField.language ? otherField : "und-" + otherField));
        if (mainField == LanguageTagField.language || this.ltp1.getLanguage().length() == 0) {
            this.ltp1.setLanguage(this.ltp2.getLanguage());
        }
        if (mainField == LanguageTagField.script || this.ltp1.getScript().length() == 0) {
            this.ltp1.setScript(this.ltp2.getScript());
        }
        if (mainField == LanguageTagField.region || this.ltp1.getRegion().length() == 0) {
            this.ltp1.setRegion(this.ltp2.getRegion());
        }
    }

    @Override
    public void transform(LanguageTagParser ltp1) {
        String locale = ltp1.toString(LanguageTagParser.OutputOption.BCP47);
        this.copyFields2(LanguageTagField.language, this.getReplacement(LanguageTagField.language, LanguageTagField.language.get(ltp1), locale));
        this.copyFields2(LanguageTagField.script, this.getReplacement(LanguageTagField.script, LanguageTagField.script.get(ltp1), locale));
        this.copyFields2(LanguageTagField.region, this.getReplacement(LanguageTagField.region, LanguageTagField.region.get(ltp1), locale));
        List<String> originalVariants = ltp1.getVariants();
        if (originalVariants.size() != 0) {
            TreeSet<String> newVariants = new TreeSet<String>();
            for (String item : originalVariants) {
                String replacement = this.getReplacement(LanguageTagField.variant, item, locale);
                if (replacement == null) {
                    newVariants.add(item);
                    continue;
                }
                this.copyFields2(LanguageTagField.variant, replacement);
                List<String> otherVariants = this.ltp2.getVariants();
                newVariants.addAll(otherVariants);
            }
            ltp1.setVariants(newVariants);
        }
    }

    private static enum LanguageTagField {
        language("language"),
        script("script"),
        region("territory"),
        variant("variant");

        private final Map<String, Row.R2<List<String>, String>> replacements;

        private LanguageTagField(String replacementName) {
            this.replacements = ALIASES.get(replacementName);
        }

        private String get(LanguageTagParser parser) {
            switch (this) {
                case language: {
                    return parser.getLanguage();
                }
                case script: {
                    return parser.getScript();
                }
                case region: {
                    return parser.getRegion();
                }
            }
            throw new UnsupportedOperationException();
        }

        private List<String> getReplacements(String field) {
            Row.R2<List<String>, String> data = this.replacements.get(this == variant ? field.toUpperCase(Locale.ROOT) : field);
            return data == null ? Collections.emptyList() : (List)data.get0();
        }
    }
}

