/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.OlsonTimeZone;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DateFormatSymbols;
import com.ibm.icu.text.DateTimePatternGenerator;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.SimpleTimeZone;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.TimeZoneTransition;
import com.ibm.icu.util.ULocale;
import java.text.ParsePosition;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CharSource;
import org.unicode.cldr.util.CharUtilities;
import org.unicode.cldr.util.Dictionary;
import org.unicode.cldr.util.IntMap;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.StateDictionaryBuilder;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.Utf8StringByteConverter;

public class LenientDateParser {
    public static boolean DEBUG = false;
    private static final int SECOND = 1000;
    private static final int MINUTE = 60000;
    private static final int HOUR = 3600000;
    static final long startDate;
    static final long endDate;
    static final SimpleDateFormat neutralFormat;
    static final DecimalFormat threeDigits;
    static final DecimalFormat twoDigits;
    public static final Set<Integer> allOffsets;
    private static final UnicodeSet disallowedInSeparator;
    private static final UnicodeSet IGNORABLE;
    private static final EnumSet<Token.Type> dateTypes;
    private static final EnumSet<Token.Type> timeTypes;
    private static final EnumSet<Token.Type> integerTimeTypes;
    static final int thisYear;
    static final Date june15;
    static final Date january15;
    private final Dictionary.Matcher<Token> matcher;
    private final BreakIterator breakIterator;
    private final DateOrdering dateOrdering;
    static final Pattern GMT_ZONE_MATCHER;
    static final IntMap<String> ZONE_INT_MAP;
    static final Map<String, Integer> ZONE_VALUE_MAP;
    static final SupplementalDataInfo supplementalData;
    private static final boolean SHOW_ZONE_INFO = false;
    private static final UnicodeSet DIGITS;

    static String toShortString(Set<Token.Type> set) {
        StringBuilder result = new StringBuilder();
        for (Token.Type t : Token.Type.values()) {
            if (set.contains((Object)t)) {
                result.append(t.toString().charAt(0));
                continue;
            }
            result.append("-");
        }
        return result.toString();
    }

    public LenientDateParser(Dictionary.Matcher<Token> matcher, BreakIterator iterator, DateOrdering dateOrdering) {
        this.matcher = matcher;
        this.breakIterator = iterator;
        this.dateOrdering = dateOrdering;
    }

    public static LenientDateParser getInstance(ULocale locale) {
        DateOrdering dateOrdering = new DateOrdering();
        TreeMap<CharSequence, Token> map = DEBUG ? new TreeMap() : new HashMap();
        DateFormatSymbols symbols = new DateFormatSymbols(locale);
        LenientDateParser.loadArray(map, symbols.getAmPmStrings(), Token.Type.AMPM);
        LenientDateParser.loadArray(map, symbols.getEraNames(), Token.Type.ERA);
        LenientDateParser.loadArray(map, symbols.getEras(), Token.Type.ERA);
        for (int context = 0; context < 3; ++context) {
            for (int width = 0; width < 4; ++width) {
                LenientDateParser.loadArray(map, symbols.getMonths(context, width), Token.Type.MONTH);
                LenientDateParser.loadArray(map, symbols.getWeekdays(context, width), Token.Type.WEEKDAY);
            }
        }
        Calendar temp = Calendar.getInstance();
        String[] zoneFormats = new String[]{"z", "zzzz", "Z", "ZZZZ", "v", "vvvv", "V", "VVVV"};
        ArrayList<SimpleDateFormat> zoneFormatList = new ArrayList<SimpleDateFormat>();
        for (String zoneFormat : zoneFormats) {
            zoneFormatList.add(new SimpleDateFormat(zoneFormat, locale));
        }
        BestTimeZone bestTimeZone = new BestTimeZone(locale);
        Relation<String, String> stringToZones = Relation.of(new TreeMap(), TreeSet.class, bestTimeZone);
        for (String timezone : ZONE_VALUE_MAP.keySet()) {
            TimeZone currentTimeZone = LenientDateParser.getTimeZone(timezone);
            for (SimpleDateFormat format : zoneFormatList) {
                format.setTimeZone(currentTimeZone);
                stringToZones.put(format.format(january15), timezone);
                stringToZones.put(format.format(june15), timezone);
            }
        }
        for (String formatted : stringToZones.keySet()) {
            Set<String> possibilities = stringToZones.getAll(formatted);
            String status = LenientDateParser.uniquenessStatus(possibilities);
            if (!status.startsWith("OK")) {
                if (formatted.equals("Australie (Darwin)")) {
                    String last = null;
                    for (String string : possibilities) {
                        if (last != null) {
                            bestTimeZone.compare(last, string);
                        }
                        last = string;
                    }
                }
                System.out.println("Parsing \t\"" + formatted + "\"\t gets \t" + status + "\t" + LenientDateParser.show(possibilities));
            }
            String bestValue = possibilities.iterator().next();
            LenientDateParser.loadItem(map, formatted, ZONE_VALUE_MAP.get(bestValue), Token.Type.TIMEZONE);
        }
        DateTimePatternGenerator.FormatParser formatParser = new DateTimePatternGenerator.FormatParser();
        HashMap<String, EnumSet<Token.Type>> beforeTypes = new HashMap<String, EnumSet<Token.Type>>();
        HashMap<String, EnumSet<Token.Type>> afterTypes = new HashMap<String, EnumSet<Token.Type>>();
        EnumSet<Token.Type> nonDateTypes = EnumSet.allOf(Token.Type.class);
        nonDateTypes.removeAll(dateTypes);
        EnumSet<Token.Type> nonTimeTypes = EnumSet.allOf(Token.Type.class);
        nonTimeTypes.removeAll(timeTypes);
        for (int style = 0; style < 4; ++style) {
            LenientDateParser.addSeparatorInfo((SimpleDateFormat)DateFormat.getDateInstance(style, locale), formatParser, beforeTypes, afterTypes, nonDateTypes, dateOrdering);
            LenientDateParser.addSeparatorInfo((SimpleDateFormat)DateFormat.getTimeInstance(style, locale), formatParser, beforeTypes, afterTypes, nonTimeTypes, dateOrdering);
        }
        LenientDateParser.add(beforeTypes, " ", dateTypes);
        LenientDateParser.add(afterTypes, " ", dateTypes);
        LenientDateParser.add(beforeTypes, " ", timeTypes);
        LenientDateParser.add(afterTypes, " ", timeTypes);
        HashSet allSeparators = new HashSet(beforeTypes.keySet());
        allSeparators.addAll(afterTypes.keySet());
        for (String item : allSeparators) {
            LenientDateParser.loadItem(map, item, (EnumSet)beforeTypes.get(item), (EnumSet)afterTypes.get(item));
        }
        if (dateOrdering.yd.size() == 0) {
            dateOrdering.yd.addAll(dateOrdering.ymd);
        }
        StateDictionaryBuilder<Token> stateDictionaryBuilder = new StateDictionaryBuilder().setByteConverter(new Utf8StringByteConverter());
        if (DEBUG) {
            System.out.println(map);
        }
        Dictionary<Token> dict = stateDictionaryBuilder.make(map);
        LenientDateParser result = new LenientDateParser(dict.getMatcher(), BreakIterator.getWordInstance(locale), dateOrdering);
        return result;
    }

    private static TimeZone getTimeZone(String timezone) {
        Matcher matcher;
        if (timezone.startsWith("Etc/GMT") && (matcher = GMT_ZONE_MATCHER.matcher(timezone)).matches()) {
            int offset = Integer.parseInt(matcher.group(2)) * 3600000;
            if (matcher.group(3) != null) {
                offset += Integer.parseInt(matcher.group(3)) * 60000;
                if (matcher.group(4) != null) {
                    offset += Integer.parseInt(matcher.group(3)) * 1000;
                }
            }
            if (matcher.group(1).equals("+")) {
                offset = -offset;
            }
            return new SimpleTimeZone(offset, timezone);
        }
        return TimeZone.getTimeZone(timezone);
    }

    private static String show(Set<String> zones) {
        StringBuilder result = new StringBuilder();
        result.append("{");
        for (String zone : zones) {
            if (result.length() > 1) {
                result.append(", ");
            }
            result.append(LenientDateParser.getCountry(zone)).append(":").append(zone);
        }
        result.append("}");
        return result.toString();
    }

    private static String uniquenessStatus(Set<String> possibilities) {
        int count = 0;
        for (String zone : possibilities) {
            if (!supplementalData.isCanonicalZone(zone)) continue;
            ++count;
        }
        return count == 0 ? "ZERO!!" : (count == 1 ? "OK" : "AMBIGUOUS:" + count);
    }

    private static Set<String> getFirstMinusSecond(Set<String> first, Set<String> second) {
        TreeSet<String> difference = new TreeSet<String>(first);
        difference.removeAll(second);
        return difference;
    }

    private static LinkedHashSet<String> getIcuEquivalentZones(String zoneID) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        int count = TimeZone.countEquivalentIDs(zoneID);
        for (int i = 0; i < count; ++i) {
            result.add(TimeZone.getEquivalentID(zoneID, i));
        }
        return result;
    }

    private static void addSeparatorInfo(SimpleDateFormat d, DateTimePatternGenerator.FormatParser formatParser, Map<String, EnumSet<Token.Type>> beforeTypes, Map<String, EnumSet<Token.Type>> afterTypes, EnumSet<Token.Type> allowedContext, DateOrdering dateOrdering) {
        String pattern = d.toPattern();
        if (DEBUG) {
            System.out.println("Adding Pattern:\t" + pattern);
        }
        formatParser.set(pattern);
        List<Object> list = formatParser.getItems();
        ArrayList<Token.Type> temp = new ArrayList<Token.Type>();
        block4: for (int i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            if (item instanceof String) {
                String sItem = LenientDateParser.trim((String)item);
                if (i == 0) {
                    LenientDateParser.add(beforeTypes, sItem, allowedContext);
                } else {
                    LenientDateParser.add(beforeTypes, sItem, Token.Type.getType(list.get(i - 1)));
                    LenientDateParser.add(beforeTypes, sItem, Token.Type.INTEGER);
                }
                if (i >= list.size() - 1) {
                    LenientDateParser.add(afterTypes, sItem, allowedContext);
                    continue;
                }
                LenientDateParser.add(afterTypes, sItem, Token.Type.getType(list.get(i + 1)));
                LenientDateParser.add(afterTypes, sItem, Token.Type.INTEGER);
                continue;
            }
            String var = item.toString();
            Token.Type type = Token.Type.getType(var);
            switch (type) {
                case MONTH: {
                    if (var.length() >= 3) continue block4;
                    temp.add(type);
                    continue block4;
                }
                case YEAR: 
                case DAY: {
                    temp.add(type);
                    continue block4;
                }
            }
        }
        if (temp.contains((Object)Token.Type.MONTH)) {
            dateOrdering.ymd.addAll(temp);
        } else if (temp.size() != 0) {
            dateOrdering.yd.addAll(temp);
        }
    }

    private static void add(Map<String, EnumSet<Token.Type>> stringToTypes, String item, Token.Type type) {
        Set set = stringToTypes.get(item);
        if (set == null) {
            stringToTypes.put(item, EnumSet.of(type));
        } else {
            set.add(type);
        }
    }

    private static void add(Map<String, EnumSet<Token.Type>> stringToTypes, String item, EnumSet<Token.Type> types) {
        Set set = stringToTypes.get(item);
        if (set == null) {
            stringToTypes.put(item, EnumSet.copyOf(types));
        } else {
            set.addAll(types);
        }
    }

    static String trim(String source) {
        int end;
        int start;
        if (source.length() == 0) {
            return source;
        }
        for (start = 0; start < source.length() && IGNORABLE.contains(source.charAt(start)); ++start) {
        }
        for (end = source.length(); end > start && IGNORABLE.contains(source.charAt(end - 1)); --end) {
        }
        if ((source = source.substring(start, end)).length() == 0) {
            source = " ";
        }
        return source;
    }

    private static void loadItem(Map<CharSequence, Token> map, String item, EnumSet<Token.Type> before, EnumSet<Token.Type> after) {
        map.put(item, new SeparatorToken(before, after, -1, Token.Type.SEPARATOR));
    }

    private static void loadArray(Map<CharSequence, Token> map, String[] array, Token.Type type) {
        int i = type == Token.Type.MONTH ? 1 : 0;
        for (String item : array) {
            if (item == null || item.length() == 0 || DIGITS.containsSome(item)) continue;
            LenientDateParser.loadItem(map, item, i++, type);
        }
    }

    private static void loadItem(Map<CharSequence, Token> map, String item, int i, Token.Type type) {
        map.put(item, new Token(i, type));
    }

    public Parser getParser() {
        return new Parser((BreakIterator)this.breakIterator.clone());
    }

    public static String getCountry(String zone) {
        return supplementalData.getZone_territory(zone);
    }

    public static Set<String> getAllGmtZones() {
        TreeSet<Integer> offsets = new TreeSet<Integer>();
        for (String tzid : supplementalData.getCanonicalZones()) {
            TimeZone zone = TimeZone.getTimeZone(tzid);
            long date = startDate;
            while (date < endDate) {
                offsets.add(zone.getOffset(date));
                date = LenientDateParser.getTransitionAfter(zone, date);
            }
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Iterator iterator = offsets.iterator();
        while (iterator.hasNext()) {
            int offset = (Integer)iterator.next();
            Object zone = "Etc/GMT";
            if (offset == 0) continue;
            if (offset < 0) {
                zone = (String)zone + "+";
                offset = -offset;
            } else {
                zone = (String)zone + "-";
            }
            int hours = offset / 3600000;
            zone = (String)zone + hours;
            if ((offset %= 3600000) > 0) {
                int minutes = offset / 60000;
                zone = (String)zone + ":" + twoDigits.format(minutes);
            }
            result.add((String)zone);
        }
        return result;
    }

    public static long getTransitionAfter(TimeZone zone, long date) {
        TimeZoneTransition transition = ((OlsonTimeZone)zone).getNextTransition(date, false);
        if (transition == null) {
            return Long.MAX_VALUE;
        }
        date = transition.getTime();
        return date;
    }

    static {
        neutralFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", ULocale.ENGLISH);
        threeDigits = new DecimalFormat("000");
        twoDigits = new DecimalFormat("00");
        allOffsets = new TreeSet<Integer>();
        TimeZone GMT = TimeZone.getTimeZone("Etc/GMT");
        neutralFormat.setTimeZone(GMT);
        Calendar cal = Calendar.getInstance(GMT, ULocale.US);
        int year = cal.get(1);
        cal.clear();
        cal.set(1970, 0, 1, 0, 0, 0);
        startDate = cal.getTimeInMillis();
        cal.set(year + 5, 0, 1, 0, 0, 0);
        endDate = cal.getTimeInMillis();
        if (startDate != 0L) {
            throw new IllegalArgumentException();
        }
        disallowedInSeparator = new UnicodeSet("[:alphabetic:]").freeze();
        IGNORABLE = new UnicodeSet("[,[:whitespace:]]").freeze();
        dateTypes = EnumSet.of(Token.Type.DAY, Token.Type.MONTH, Token.Type.YEAR, Token.Type.WEEKDAY, Token.Type.ERA);
        timeTypes = EnumSet.of(Token.Type.HOUR, Token.Type.MINUTE, Token.Type.SECOND, Token.Type.AMPM, Token.Type.TIMEZONE);
        integerTimeTypes = EnumSet.of(Token.Type.HOUR, Token.Type.MINUTE, Token.Type.SECOND);
        thisYear = new Date().getYear();
        june15 = new Date(thisYear, 5, 15, 0, 0, 0);
        january15 = new Date(thisYear, 0, 15, 0, 0, 0);
        GMT_ZONE_MATCHER = PatternCache.get("Etc/GMT([-+])([0-9]{1,2})(?::([0-9]{2}))(?::([0-9]{2}))?");
        supplementalData = SupplementalDataInfo.getInstance("C:/cvsdata/unicode/cldr/common/supplemental/");
        Set<String> canonicalZones = supplementalData.getCanonicalZones();
        TreeSet<String> allCLDRZones = new TreeSet<String>(canonicalZones);
        for (String string : canonicalZones) {
            allCLDRZones.addAll(supplementalData.getZone_aliases(string));
        }
        TreeSet<String> allIcuZones = new TreeSet<String>();
        for (String canonicalZone : TimeZone.getAvailableIDs()) {
            allIcuZones.add(canonicalZone);
            for (int i = 0; i < TimeZone.countEquivalentIDs(canonicalZone); ++i) {
                allIcuZones.add(TimeZone.getEquivalentID(canonicalZone, i));
            }
        }
        Set<String> set = LenientDateParser.getFirstMinusSecond(allIcuZones, allCLDRZones);
        for (String canonicalZone : canonicalZones) {
            Set<String> aliases = supplementalData.getZone_aliases(canonicalZone);
            LinkedHashSet<String> icuAliases = LenientDateParser.getIcuEquivalentZones(canonicalZone);
            icuAliases.remove(canonicalZone);
            icuAliases.removeAll(set);
        }
        canonicalZones = new TreeSet<String>(supplementalData.getCanonicalZones());
        Set<String> zones = LenientDateParser.getAllGmtZones();
        zones.removeAll(canonicalZones);
        System.out.println("Missing GMT Zones: " + zones);
        canonicalZones.addAll(zones);
        canonicalZones = Collections.unmodifiableSet(canonicalZones);
        ArrayList<String> values = new ArrayList<String>();
        for (String id : canonicalZones) {
            values.add(id);
        }
        ZONE_INT_MAP = new IntMap.BasicIntMapFactory().make(values);
        ZONE_VALUE_MAP = Collections.unmodifiableMap(ZONE_INT_MAP.getValueMap());
        DIGITS = new UnicodeSet("[:nd:]").freeze();
    }

    static class DateOrdering {
        LinkedHashSet ymd = new LinkedHashSet();
        LinkedHashSet yd = new LinkedHashSet();

        DateOrdering() {
        }
    }

    static class BestTimeZone
    implements Comparator<String> {
        Map<String, Integer> regionToRank = new TreeMap<String, Integer>();
        Map<String, Map<String, Integer>> regionToZoneToRank = new TreeMap<String, Map<String, Integer>>();

        public BestTimeZone(ULocale locale) {
            Map<String, String> regionToZone;
            int count = 0;
            String region = locale.getCountry();
            if (region.length() != 0) {
                this.regionToRank.put(region, count++);
            }
            String language = locale.getLanguage();
            String script = locale.getScript();
            if (script.length() != 0) {
                count = this.add(language + "_" + script, count);
            }
            count = this.add(language, count);
            Map<String, Map<String, String>> map = supplementalData.getMetazoneToRegionToZone();
            for (String mzone : map.keySet()) {
                String region3;
                regionToZone = map.get(mzone);
                String zone = regionToZone.get("001");
                if (zone == null || (region3 = supplementalData.getZone_territory(zone)) == null) continue;
                this.addRank(region3, zone);
            }
            for (String mzone : map.keySet()) {
                regionToZone = map.get(mzone);
                for (String region2 : regionToZone.keySet()) {
                    String zone = regionToZone.get(region2);
                    this.addRank(region2, zone);
                    String region3 = supplementalData.getZone_territory(zone);
                    if (region3 == null || region3.equals(region2)) continue;
                    this.addRank(region3, zone);
                }
            }
            System.out.println(this.regionToZoneToRank);
        }

        private void addRank(String region2, String zone) {
            Map<String, Integer> zoneToRank = this.regionToZoneToRank.get(region2);
            if (zoneToRank == null) {
                zoneToRank = new TreeMap<String, Integer>();
                this.regionToZoneToRank.put(region2, zoneToRank);
            }
            if (!zoneToRank.containsKey(zone)) {
                zoneToRank.put(zone, zoneToRank.size());
            }
        }

        private int add(String language, int count) {
            Set<String> data = supplementalData.getTerritoriesForPopulationData(language);
            if (data != null) {
                System.out.println("???" + language + "\t" + data);
                for (String region : data) {
                    this.regionToRank.put(region, count++);
                }
            } else {
                String languageSeparator = language + "_";
                for (String language2 : supplementalData.getLanguagesForTerritoriesPopulationData()) {
                    if (!language2.startsWith(languageSeparator)) continue;
                    data = supplementalData.getTerritoriesForPopulationData(language2);
                    System.out.println("???" + language2 + "\t" + data);
                    for (String region : data) {
                        this.regionToRank.put(region, count++);
                    }
                }
            }
            return count;
        }

        @Override
        public int compare(String z1, String z2) {
            String region2;
            String region1;
            boolean c2;
            boolean c1;
            if (z1.startsWith("Etc/GMT")) {
                if (!z2.startsWith("Etc/GMT")) {
                    return -1;
                }
            } else if (z2.startsWith("Etc/GMT")) {
                return 1;
            }
            if ((c1 = supplementalData.isCanonicalZone(z1)) != (c2 = supplementalData.isCanonicalZone(z2))) {
                return c1 ? -1 : 1;
            }
            String zone1 = supplementalData.getZoneFromAlias(z1);
            String zone2 = supplementalData.getZoneFromAlias(z2);
            if (zone1 == null) {
                zone1 = z1;
            }
            if (zone2 == null) {
                zone2 = z2;
            }
            if ((region1 = supplementalData.getZone_territory(zone1)) == (region2 = supplementalData.getZone_territory(zone2)) || region1 != null && region1.equals(region2)) {
                int comparison;
                Map<String, Integer> rankInRegion;
                if (region1 != null && (rankInRegion = this.regionToZoneToRank.get(region1)) != null && (comparison = this.getRank(rankInRegion, zone1, zone2)) != 0) {
                    return comparison;
                }
            } else {
                if (region1 == null) {
                    return 1;
                }
                if (region2 == null) {
                    return -1;
                }
                int comparison = this.getRank(this.regionToRank, region1, region2);
                if (comparison != 0) {
                    return comparison;
                }
                return region1.compareTo(region2);
            }
            return zone1.compareTo(zone2);
        }

        private int getRank(Map<String, Integer> map, String region1, String region2) {
            Integer w1 = map.get(region1);
            Integer w2 = map.get(region2);
            if (w1 == null) {
                w1 = 9999;
            }
            if (w2 == null) {
                w2 = 9999;
            }
            int comparison = w1.compareTo(w2);
            return comparison;
        }
    }

    static class IntegerToken
    extends Token {
        public Token.Type revisedType = null;
        EnumSet<Token.Type> allowsAt;

        public IntegerToken(int value) {
            super(value, Token.Type.INTEGER);
            this.allowsAt = value == 0 ? EnumSet.of(Token.Type.HOUR, Token.Type.MINUTE, Token.Type.SECOND) : (value < 12 ? EnumSet.of(Token.Type.YEAR, new Token.Type[]{Token.Type.MONTH, Token.Type.DAY, Token.Type.HOUR, Token.Type.MINUTE, Token.Type.SECOND}) : (value < 25 ? EnumSet.of(Token.Type.YEAR, Token.Type.DAY, Token.Type.HOUR, Token.Type.MINUTE, Token.Type.SECOND) : (value < 32 ? EnumSet.of(Token.Type.YEAR, Token.Type.DAY, Token.Type.MINUTE, Token.Type.SECOND) : (value < 60 ? EnumSet.of(Token.Type.YEAR, Token.Type.MINUTE, Token.Type.SECOND) : EnumSet.of(Token.Type.YEAR)))));
        }

        public boolean restrictAndSetCalendarFieldIfPossible(EnumSet<Token.Type> allowable, SoFar haveSoFar, Collection<Token> tokensToFix) {
            if (this.getType() != Token.Type.INTEGER) {
                throw new IllegalArgumentException();
            }
            Object ok = this.allowsAt.clone();
            ((AbstractSet)ok).removeAll(haveSoFar.haveSoFarSet);
            if (allowable != null) {
                ((AbstractCollection)ok).retainAll(allowable);
            }
            if (((AbstractCollection)ok).size() == 0) {
                if (DEBUG) {
                    System.out.println("No possibilities for " + this + ": " + allowable + "\t" + haveSoFar);
                }
                return false;
            }
            this.allowsAt = ok;
            if (((AbstractCollection)ok).size() == 1) {
                this.revisedType = (Token.Type)((Object)((AbstractCollection)ok).iterator().next());
                haveSoFar.add(this);
                if (this.revisedType == Token.Type.INTEGER) {
                    throw new IllegalArgumentException();
                }
                for (Token token : tokensToFix) {
                    IntegerToken other;
                    if (token == this || token.getType() != Token.Type.INTEGER || (other = (IntegerToken)token).restrictAndSetCalendarFieldIfPossible(EnumSet.complementOf(ok), haveSoFar, tokensToFix)) continue;
                    return false;
                }
                return true;
            }
            return true;
        }

        @Override
        public Token.Type getType() {
            return this.revisedType == null ? super.getType() : this.revisedType;
        }

        public Set<Token.Type> getAllowsAt() {
            return this.allowsAt;
        }

        @Override
        public String toString() {
            return "{" + this.getType() + ":" + this.getIntValue() + "/" + LenientDateParser.toShortString(this.allowsAt) + "}";
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            IntegerToken other = (IntegerToken)obj;
            return this.allowsAt.equals(other.allowsAt);
        }
    }

    static class SeparatorToken
    extends Token {
        final EnumSet<Token.Type> allowsBefore;
        final EnumSet<Token.Type> allowsAfter;

        public SeparatorToken(EnumSet<Token.Type> before, EnumSet<Token.Type> after, int value) {
            this(before, after, value, Token.Type.SEPARATOR);
        }

        protected SeparatorToken(EnumSet<Token.Type> before, EnumSet<Token.Type> after, int value, Token.Type type) {
            super(value, type);
            this.allowsBefore = before.clone();
            this.allowsAfter = after.clone();
        }

        public EnumSet<Token.Type> getAllowsAfter() {
            return this.allowsAfter;
        }

        public EnumSet<Token.Type> getAllowsBefore() {
            return this.allowsBefore;
        }

        @Override
        public String toString() {
            return "{" + this.getType() + ":" + this.getIntValue() + "/" + LenientDateParser.toShortString(this.allowsBefore) + "/" + LenientDateParser.toShortString(this.allowsAfter) + "}";
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            SeparatorToken other = (SeparatorToken)obj;
            return this.allowsBefore.equals(other.allowsBefore) && this.allowsAfter.equals(other.allowsAfter);
        }
    }

    static class Token {
        private final int value;
        private final Type type;

        public Type getType() {
            return this.type;
        }

        public boolean checkAllowableTypes(Token previous, SoFar haveSoFar, Collection<Token> tokensToFix) {
            if (haveSoFar.contains((Object)this.getType())) {
                if (DEBUG) {
                    System.out.println("Have " + this + ", but already had " + haveSoFar);
                }
                return false;
            }
            EnumSet<Type> allowable = null;
            if (previous != null && previous.getType() == Type.SEPARATOR && !(allowable = ((SeparatorToken)previous).getAllowsAfter()).contains((Object)this.getType())) {
                if (DEBUG) {
                    System.out.println("Have " + this + ", while previous token is " + previous);
                }
                return false;
            }
            switch (this.getType()) {
                case INTEGER: {
                    IntegerToken integerToken = (IntegerToken)this;
                    return integerToken.restrictAndSetCalendarFieldIfPossible(allowable, haveSoFar, tokensToFix);
                }
                case SEPARATOR: {
                    return true;
                }
            }
            return haveSoFar == null ? true : haveSoFar.add(this);
        }

        public int getIntValue() {
            return this.value;
        }

        public Token(int value, Type type) {
            this.value = value;
            this.type = type;
        }

        public int get() {
            return this.value;
        }

        public String toString() {
            return "{" + this.getType() + ":" + this.value + (String)(this.getType() == Type.TIMEZONE ? "/" + ZONE_INT_MAP.get(this.value) : "") + "}";
        }

        public boolean equals(Object obj) {
            Token other = (Token)obj;
            return this.getType() == other.getType() && this.value == other.value;
        }

        public int hashCode() {
            return this.getType().hashCode() ^ this.value;
        }

        static enum Type {
            ERA,
            YEAR,
            MONTH,
            WEEKDAY,
            DAY,
            HOUR,
            MINUTE,
            SECOND,
            AMPM,
            TIMEZONE,
            INTEGER,
            SEPARATOR,
            UNKNOWN;


            static Type getType(Object field) {
                char ch = field.toString().charAt(0);
                switch (ch) {
                    case 'G': {
                        return ERA;
                    }
                    case 'Y': 
                    case 'u': 
                    case 'y': {
                        return YEAR;
                    }
                    case 'L': 
                    case 'M': {
                        return MONTH;
                    }
                    case 'E': 
                    case 'c': 
                    case 'e': {
                        return WEEKDAY;
                    }
                    case 'D': 
                    case 'F': 
                    case 'd': 
                    case 'g': {
                        return DAY;
                    }
                    case 'a': {
                        return AMPM;
                    }
                    case 'H': 
                    case 'K': 
                    case 'h': 
                    case 'k': {
                        return HOUR;
                    }
                    case 'm': {
                        return MINUTE;
                    }
                    case 'A': 
                    case 'S': 
                    case 's': {
                        return SECOND;
                    }
                    case 'V': 
                    case 'Z': 
                    case 'v': 
                    case 'z': {
                        return TIMEZONE;
                    }
                }
                return UNKNOWN;
            }
        }
    }

    static class SoFar {
        final EnumSet<Token.Type> haveSoFarSet = EnumSet.noneOf(Token.Type.class);
        Token.Type firstType;

        SoFar() {
        }

        public void clear() {
            this.haveSoFarSet.clear();
            this.firstType = null;
        }

        public String toString() {
            return "{" + this.firstType + ", " + this.haveSoFarSet + "}";
        }

        public void setFirstType(EnumSet<Token.Type> set) {
            if (this.firstType == null) {
                boolean hasTime;
                boolean hasDate = !Collections.disjoint(dateTypes, set);
                boolean bl = hasTime = !Collections.disjoint(timeTypes, set);
                if (hasDate != hasTime) {
                    this.firstType = hasDate ? Token.Type.YEAR : Token.Type.HOUR;
                }
            }
        }

        public boolean add(Token token) {
            Token.Type o = token.getType();
            this.setFirstType(o);
            return this.haveSoFarSet.add(o);
        }

        private void setFirstType(Token.Type o) {
            if (this.firstType == null) {
                if (dateTypes.contains((Object)o)) {
                    this.firstType = Token.Type.YEAR;
                } else if (timeTypes.contains((Object)o)) {
                    this.firstType = Token.Type.HOUR;
                }
            }
        }

        public boolean contains(Object o) {
            return this.haveSoFarSet.contains(o);
        }
    }

    public class Parser {
        final List<Token> tokens = new ArrayList<Token>();
        final SoFar haveSoFar = new SoFar();
        Token previous;
        final BreakIterator breakIterator;
        Calendar calendar;
        private int twoDigitYearOffset;

        Parser(BreakIterator breakIterator) {
            this.set2DigitYearStart(new Date(new Date().getYear() - 80, 1, 1));
            this.breakIterator = breakIterator;
        }

        public void parse(String text, Calendar cal, ParsePosition parsePosition) {
            this.calendar = cal;
            this.parse(new CharUtilities.CharSourceWrapper<String>(text), parsePosition);
        }

        private boolean addSeparator(StringBuilder separatorBuffer) {
            return false;
        }

        boolean addToken(Token token) {
            if (this.haveSoFar.contains((Object)token.getType())) {
                if (DEBUG) {
                    System.out.println("Already have: " + token.getType());
                }
                return false;
            }
            switch (token.getType()) {
                case ERA: 
                case MONTH: 
                case WEEKDAY: 
                case TIMEZONE: 
                case AMPM: {
                    if (token.checkAllowableTypes(this.previous, this.haveSoFar, this.tokens)) break;
                    return false;
                }
                case INTEGER: {
                    if (token.checkAllowableTypes(this.previous, this.haveSoFar, this.tokens)) break;
                    return false;
                }
                case SEPARATOR: {
                    IntegerToken integerToken;
                    EnumSet<Token.Type> beforeTypes = ((SeparatorToken)token).getAllowsBefore();
                    if (this.tokens.size() > 0 && !beforeTypes.contains((Object)this.previous.getType())) {
                        if (DEBUG) {
                            System.out.println("Have " + token + ", while previous token is  " + this.previous);
                        }
                        return false;
                    }
                    if (this.previous != null && this.previous.getType() == Token.Type.INTEGER && !(integerToken = (IntegerToken)this.previous).restrictAndSetCalendarFieldIfPossible(beforeTypes, this.haveSoFar, this.tokens)) {
                        return false;
                    }
                    this.haveSoFar.setFirstType(beforeTypes);
                    EnumSet<Token.Type> afterTypes = ((SeparatorToken)token).getAllowsAfter();
                    this.haveSoFar.setFirstType(afterTypes);
                    break;
                }
            }
            this.tokens.add(token);
            this.previous = token;
            return true;
        }

        private boolean checkPreviousType(Token token) {
            EnumSet<Token.Type> allowable;
            Token previous;
            if (this.tokens.size() > 0 && (previous = this.tokens.get(this.tokens.size() - 1)).getType() == Token.Type.SEPARATOR && !(allowable = ((SeparatorToken)previous).getAllowsBefore()).contains((Object)token.getType())) {
                if (DEBUG) {
                    System.out.println("Have " + token + ", while previous token is " + previous);
                }
                return false;
            }
            return true;
        }

        public Date parse(CharSource charlist, ParsePosition parsePosition) {
            this.calendar.clear();
            this.tokens.clear();
            this.previous = null;
            this.haveSoFar.clear();
            parsePosition.setErrorIndex(-1);
            StringBuilder separatorBuffer = new StringBuilder();
            LenientDateParser.this.matcher.setText(charlist);
            this.breakIterator.setText(charlist.toString());
            boolean haveStringMonth = false;
            int i = charlist.fromSourceOffset(parsePosition.getIndex());
            while (charlist.hasCharAt(i)) {
                Dictionary.Matcher.Status status;
                if (DEBUG) {
                    System.out.println(charlist.subSequence(0, i) + "|" + charlist.charAt(i) + "\t\t" + this.tokens);
                }
                if ((status = LenientDateParser.this.matcher.setOffset(i).next(Dictionary.Matcher.Filter.LONGEST_UNIQUE)) != Dictionary.Matcher.Status.NONE) {
                    this.addSeparator(separatorBuffer);
                    if (!this.breakIterator.isBoundary(i)) {
                        parsePosition.setErrorIndex(i);
                        return null;
                    }
                    Token matchValue = LenientDateParser.this.matcher.getMatchValue();
                    if (matchValue.getType() == Token.Type.MONTH) {
                        haveStringMonth = true;
                    }
                    if (!this.addToken(matchValue)) break;
                    i = LenientDateParser.this.matcher.getMatchEnd();
                    continue;
                }
                char ch = charlist.charAt(i);
                if (UCharacter.isDigit(ch)) {
                    this.addSeparator(separatorBuffer);
                    int result = (int)UCharacter.getUnicodeNumericValue(ch);
                    int j = i;
                    while (charlist.hasCharAt(++j) && UCharacter.isDigit(ch = charlist.charAt(j))) {
                        result *= 10;
                        result += (int)UCharacter.getUnicodeNumericValue(ch);
                    }
                    if (!this.addToken(new IntegerToken(result))) break;
                    i = j;
                    continue;
                }
                if (IGNORABLE.contains(ch)) {
                    ++i;
                    continue;
                }
                if (disallowedInSeparator.contains(ch)) break;
            }
            if (DEBUG) {
                System.out.println(charlist.subSequence(0, i) + "|\t\t" + this.tokens);
            }
            parsePosition.setIndex(charlist.toSourceOffset(i));
            LinkedHashSet<Token.Type> ordering = new LinkedHashSet<Token.Type>();
            ordering.addAll(haveStringMonth ? LenientDateParser.this.dateOrdering.yd : LenientDateParser.this.dateOrdering.ymd);
            ordering.addAll(integerTimeTypes);
            block13: for (Token token : this.tokens) {
                if (token.getType() != Token.Type.INTEGER) continue;
                IntegerToken integerToken = (IntegerToken)token;
                EnumSet<Token.Type> possible = integerToken.allowsAt;
                for (Token.Type item : ordering) {
                    if (this.haveSoFar.contains((Object)item) || !possible.contains((Object)item)) continue;
                    integerToken.restrictAndSetCalendarFieldIfPossible(EnumSet.of(item), this.haveSoFar, this.tokens);
                    continue block13;
                }
                if (DEBUG) {
                    System.out.println("failed to find option for " + token + " in " + possible);
                }
                return null;
            }
            for (Token token : this.tokens) {
                int value = token.getIntValue();
                switch (token.getType()) {
                    case ERA: {
                        this.calendar.set(0, value);
                        break;
                    }
                    case YEAR: {
                        if (value < 100 && (value = this.twoDigitYearOffset / 100 * 100 + value) < this.twoDigitYearOffset) {
                            value += 100;
                        }
                        this.calendar.set(1, value);
                        break;
                    }
                    case DAY: {
                        this.calendar.set(5, value);
                        break;
                    }
                    case MONTH: {
                        this.calendar.set(2, value - 1);
                        break;
                    }
                    case HOUR: {
                        this.calendar.set(10, value);
                        break;
                    }
                    case MINUTE: {
                        this.calendar.set(12, value);
                        break;
                    }
                    case SECOND: {
                        this.calendar.set(13, value);
                        break;
                    }
                    case AMPM: {
                        this.calendar.set(9, value);
                        break;
                    }
                    case TIMEZONE: {
                        this.calendar.setTimeZone(LenientDateParser.getTimeZone(ZONE_INT_MAP.get(value)));
                        break;
                    }
                }
            }
            return this.calendar.getTime();
        }

        public String toString() {
            return this.tokens.toString();
        }

        public String debugShow() {
            return LenientDateParser.this.matcher.getDictionary().toString();
        }

        public String debugShow2() {
            return Dictionary.load(LenientDateParser.this.matcher.getDictionary().getMapping(), new TreeMap()).toString();
        }

        public void set2DigitYearStart(Date startDate) {
            this.twoDigitYearOffset = startDate.getYear() + 1900;
        }
    }
}

