/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Splitter;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.StringRange;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class Validity {
    private static final ConcurrentHashMap<String, Validity> cache = new ConcurrentHashMap();
    private final Map<StandardCodes.LstrType, Map<Status, Set<String>>> typeToStatusToCodes;
    private final Map<StandardCodes.LstrType, Map<String, Status>> typeToCodeToStatus;

    public static Validity getInstance() {
        return Validity.getInstance(CLDRPaths.VALIDITY_DIRECTORY);
    }

    public static Validity getInstance(String validityDirectory) {
        Validity value;
        Validity result = cache.get(validityDirectory);
        if (result == null && (result = cache.putIfAbsent(validityDirectory, value = new Validity(validityDirectory))) == null) {
            result = value;
        }
        return result;
    }

    private Validity(String validityDirectory) {
        Splitter space = Splitter.on(PatternCache.get("\\s+")).trimResults().omitEmptyStrings();
        EnumMap data = new EnumMap(StandardCodes.LstrType.class);
        EnumMap codeToStatus = new EnumMap(StandardCodes.LstrType.class);
        String basePath = validityDirectory;
        File validityDir = new File(basePath);
        if (!validityDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + validityDir.getAbsolutePath());
        }
        for (String file : validityDir.list()) {
            TreeMap<String, Status> subCodeToStatus;
            if (!file.endsWith(".xml")) continue;
            StandardCodes.LstrType type = null;
            try {
                type = StandardCodes.LstrType.fromString(file.substring(0, file.length() - 4));
            }
            catch (Exception e) {
                continue;
            }
            ArrayList<Pair<String, String>> lineData = new ArrayList<Pair<String, String>>();
            EnumMap<Status, LinkedHashSet<String>> submap = (EnumMap<Status, LinkedHashSet<String>>)data.get((Object)type);
            if (submap == null) {
                submap = new EnumMap<Status, LinkedHashSet<String>>(Status.class);
                data.put(type, submap);
            }
            if ((subCodeToStatus = (TreeMap<String, Status>)codeToStatus.get((Object)type)) == null) {
                subCodeToStatus = new TreeMap<String, Status>();
                codeToStatus.put(type, subCodeToStatus);
            }
            XMLFileReader.loadPathValues(basePath + file, lineData, true);
            for (Pair pair : lineData) {
                XPathParts parts = XPathParts.getFrozenInstance((String)pair.getFirst());
                if (!"id".equals(parts.getElement(-1))) continue;
                StandardCodes.LstrType typeAttr = StandardCodes.LstrType.fromString(parts.getAttributeValue(-1, "type"));
                if (typeAttr != type) {
                    throw new IllegalArgumentException("Corrupt value for " + type);
                }
                Status subtypeAttr = Status.valueOf(parts.getAttributeValue(-1, "idStatus"));
                LinkedHashSet<String> set = (LinkedHashSet<String>)submap.get((Object)subtypeAttr);
                if (set == null) {
                    set = new LinkedHashSet<String>();
                    submap.put(subtypeAttr, set);
                }
                for (String value : space.split((CharSequence)pair.getSecond())) {
                    int dashPos;
                    if (type == StandardCodes.LstrType.subdivision) {
                        value = value.toLowerCase(Locale.ROOT).replace("-", "");
                    }
                    if ((dashPos = value.indexOf(126)) < 0) {
                        set.add(value);
                        continue;
                    }
                    StringRange.expand(value.substring(0, dashPos), value.substring(dashPos + 1), set);
                }
                for (String code : set) {
                    subCodeToStatus.put(code, subtypeAttr);
                }
            }
        }
        if (data.keySet().size() < 5) {
            throw new IllegalArgumentException("Bad directory for validity files: " + validityDir.getAbsolutePath());
        }
        this.typeToStatusToCodes = CldrUtility.protectCollectionX(data);
        this.typeToCodeToStatus = CldrUtility.protectCollectionX(codeToStatus);
    }

    @Deprecated
    public Map<StandardCodes.LstrType, Map<Status, Set<String>>> getData() {
        return this.typeToStatusToCodes;
    }

    public Map<Status, Set<String>> getStatusToCodes(StandardCodes.LstrType type) {
        return this.typeToStatusToCodes.get((Object)type);
    }

    public Map<String, Status> getCodeToStatus(StandardCodes.LstrType type) {
        return this.typeToCodeToStatus.get((Object)type);
    }

    public static enum Status {
        regular,
        special,
        macroregion,
        deprecated,
        reserved,
        private_use,
        unknown,
        invalid;

    }
}

