/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu;

import com.ibm.icu.dev.tool.shared.UOption;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.Date;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CldrUtility;

public class RBNFWriter {
    private static final int SOURCEDIR = 2;
    private static final int DESTDIR = 3;
    private static final int FROMFILE = 4;
    private static final int TOFILE = 5;
    private static final int SPEC = 6;
    private static final int COPYRIGHT = 7;
    private static final UOption[] options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.create("sourcedir", 's', 1).setDefault("."), UOption.create("destdir", 'd', 1).setDefault("."), UOption.create("fromfile", 'f', 1).setDefault("root.txt"), UOption.create("tofile", 't', 1).setDefault("root.xml"), UOption.create("spec", 'x', 1).setDefault("false"), UOption.create("copyright", 'c', 1).setDefault("true")};

    public static void main(String[] args) throws IOException {
        UOption.parseArgs(args, options);
        String fromfile = RBNFWriter.options[4].value;
        String tofile = RBNFWriter.options[5].value;
        int dot = fromfile.indexOf(46);
        String localeSpec = dot > 0 ? fromfile.substring(0, dot) : fromfile;
        String[] pieces = localeSpec.split("_");
        String language = pieces[0];
        Date now = Calendar.getInstance().getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        System.out.println(tofile);
        PrintWriter out = FileUtilities.openUTF8Writer(RBNFWriter.options[3].value + File.separator, tofile);
        FileInputStream inFileStream = new FileInputStream(RBNFWriter.options[2].value + File.separator + fromfile);
        InputStreamReader inFileReader = new InputStreamReader((InputStream)inFileStream, "UTF-8");
        BufferedReader in = new BufferedReader(inFileReader);
        String line = in.readLine();
        boolean firstRuleset = true;
        BigInteger currentRuleValue = BigInteger.ZERO;
        char LARROW = '\u2190';
        char RARROW = '\u2192';
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        out.println("<!DOCTYPE ldml SYSTEM \"../../common/dtd/ldml.dtd\">");
        if (RBNFWriter.options[7].value.equals("true")) {
            sdf.applyPattern("yyyy");
            out.println("<!--");
            out.println(CldrUtility.getCopyrightString());
            out.println("-->");
            sdf.applyPattern("yyyy/MM/dd HH:mm:ss");
        }
        out.println("<ldml>");
        out.println("    <identity>");
        out.println("        <version number=\"$Revision$\"/>");
        out.println("        <language type=\"" + language + "\"/>");
        if (pieces.length > 1) {
            if (pieces[1].length() == 2) {
                out.println("        <territory type=\"" + pieces[1] + "\"/>");
            } else {
                out.println("        <script type=\"" + pieces[1] + "\"/>");
            }
        }
        out.println("    </identity>");
        if (RBNFWriter.options[6].value.equals("true")) {
            out.println("</ldml>");
            out.close();
            in.close();
            return;
        }
        out.println("    <rbnf>");
        out.println("        <rulesetGrouping type=\"SpelloutRules\">");
        while (line != null) {
            String workingLine = Utility.unescape(line).trim();
            boolean printRule = true;
            if (!workingLine.startsWith("//")) {
                String ruleText = workingLine;
                if (workingLine.startsWith("\"")) {
                    ruleText = workingLine.substring(1, workingLine.indexOf("\"", 1));
                }
                String numberString = null;
                String radixString = null;
                String ruleString = null;
                if (ruleText.contains(":")) {
                    String[] parts = ruleText.split(":");
                    if (parts[0].startsWith("%")) {
                        if (!firstRuleset) {
                            out.println("            </ruleset>");
                        }
                        int idStart = parts[0].lastIndexOf("%") + 1;
                        String tag = parts[0].substring(idStart);
                        out.print("            <ruleset type=\"" + tag + "\"");
                        if (idStart == 2) {
                            out.println(" access=\"private\">");
                        } else {
                            out.println(">");
                        }
                        firstRuleset = false;
                        printRule = false;
                        currentRuleValue = BigInteger.ZERO;
                        if (parts.length > 1 && parts[1].trim().length() > 0) {
                            printRule = true;
                            ruleString = parts[1].trim();
                            numberString = currentRuleValue.toString();
                        }
                    } else {
                        numberString = parts[0];
                        ruleString = parts[1];
                        if (numberString.contains("x") || numberString.contains(">") || numberString.equals("Inf") || numberString.equals("NaN")) {
                            currentRuleValue = new BigInteger("-1");
                            numberString = numberString.replace('>', RARROW).replaceAll(",", "");
                        } else {
                            if (numberString.contains("/")) {
                                String[] numparts = numberString.split("/");
                                numberString = numparts[0];
                                radixString = numparts[1];
                            }
                            try {
                                currentRuleValue = new BigInteger(numberString.replaceAll(",", ""));
                            }
                            catch (NumberFormatException ex) {
                                currentRuleValue = new BigInteger("-1");
                            }
                            numberString = currentRuleValue.toString();
                        }
                    }
                } else {
                    ruleString = ruleText;
                    numberString = currentRuleValue.toString();
                }
                if (printRule) {
                    if (firstRuleset) {
                        out.println("            <ruleset type=\"spellout\">");
                        firstRuleset = false;
                    }
                    if (radixString != null) {
                        out.println("                <rbnfrule value=\"" + numberString + "\" radix=\"" + radixString + "\">" + ruleString.trim().replace('<', LARROW).replace('>', RARROW) + "</rbnfrule>");
                    } else {
                        out.println("                <rbnfrule value=\"" + numberString + "\">" + ruleString.trim().replace('<', LARROW).replace('>', RARROW) + "</rbnfrule>");
                    }
                    int i = ruleString.indexOf(";");
                    while (i != -1) {
                        i = ruleString.indexOf(";", i + 1);
                        currentRuleValue = currentRuleValue.add(BigInteger.ONE);
                    }
                }
            }
            line = in.readLine();
        }
        in.close();
        out.println("            </ruleset>");
        out.println("        </rulesetGrouping>");
        out.println("    </rbnf>");
        out.println("</ldml>");
        out.close();
    }
}

