/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.PatternCache;

public class CheckAnnotations
extends CheckCLDR {
    private static final Pattern ANNOTATION_PATH = Pattern.compile("//ldml/annotations/.*");
    static final Pattern HAS_ANNOTATION_ECODE = PatternCache.get("E[0-9]{1,3}(?:[-\u2013:\u2014.][0-9]{1,3}){0,2}");

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (value == null) {
            return this;
        }
        if (!ANNOTATION_PATH.matcher(path).matches() || !this.getCldrFileToCheck().isNotRoot(path)) {
            return this;
        }
        String ecode = CheckAnnotations.hasAnnotationECode(value);
        if (ecode != null) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalAnnotationCode).setMessage("The annotation must be a translation and not contain the E\u2026 code from root, or anything like it. ({0})", ecode));
        }
        return this;
    }

    static String hasAnnotationECode(String value) {
        Matcher m4 = HAS_ANNOTATION_ECODE.matcher(value);
        if (m4.find()) {
            return m4.group();
        }
        return null;
    }
}

